/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ENTES {
    public static byte[] readTotalCounter(String gateway, int unitid, String subaddress) {
        ByteBuffer bb = ByteBuffer.allocate(14);
        byte[] data = null;
        try {
            int port = Integer.parseInt(subaddress.substring(2));
            data = user.modbusReadHoldingRegisters(gateway, unitid, 4 * (port - 1), 4);
            bb.put(data, 2, 8);
            data = user.modbusReadHoldingRegisters(gateway, unitid, 32775 + port - 1, 1);
            bb.put(data, 2, 2);
            data = user.modbusReadHoldingRegisters(gateway, unitid, 32787 + port - 1, 1);
            bb.put(data, 2, 2);
            data = user.modbusReadHoldingRegisters(gateway, unitid, 32799 + port - 1, 1);
            return bb.put(data, 2, 2).array();
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static Hashtable<String, Long> decodeTotalEnergyCounter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int multiplier = ENTES.toInteger(data, 8, false);
            int denominator = ENTES.toInteger(data, 10, false);
            int unit = ENTES.toInteger(data, 12, false);
            switch (unit) {
                case 1: {
                    values.put("Ea", (long)(ENTES.toVeryLong(data, 0, false) * (double)multiplier / (double)denominator));
                    break;
                }
                case 4: {
                    values.put("Ea", (long)(ENTES.toVeryLong(data, 0, false) * 1000.0 * (double)multiplier / (double)denominator));
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalEnergyCounter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = ENTES.decodeTotalEnergyCounter(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    public static Hashtable<String, Long> decodeTotalM3Counter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int multiplier = ENTES.toInteger(data, 8, false);
            int denominator = ENTES.toInteger(data, 10, false);
            int unit = ENTES.toInteger(data, 12, false);
            switch (unit) {
                case 23: {
                    values.put("Ea", (long)(ENTES.toVeryLong(data, 0, false) * 1000.0 * (double)multiplier / (double)denominator));
                    break;
                }
                default: {
                    return new Hashtable<String, Long>();
                }
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalM3Counter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        Long value = ENTES.decodeTotalM3Counter(data).get("Ea");
        if (value != null) {
            values.put("Ea", Long.toString(value));
        }
        return values;
    }

    public static byte[] readVIFMPR46S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(44);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 0, 26);
        bb.put(data, 2, 12);
        bb.put(data, 30, 12);
        bb.put(data, 46, 4);
        bb.put(data, 18, 12);
        bb.put(data, 50, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIFMPR46S(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", ENTES.toLong(data, 0, false));
            values.put("V2", ENTES.toLong(data, 4, false));
            values.put("V3", ENTES.toLong(data, 8, false));
            values.put("I1", ENTES.toLong(data, 12, false));
            values.put("I2", ENTES.toLong(data, 16, false));
            values.put("I3", ENTES.toLong(data, 20, false));
            values.put("In", ENTES.toLong(data, 24, false));
            values.put("U12", ENTES.toLong(data, 28, false));
            values.put("U23", ENTES.toLong(data, 32, false));
            values.put("U31", ENTES.toLong(data, 36, false));
            values.put("F", ENTES.toLong(data, 40, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIFMPR46S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", ENTES.toLongString(data, 0, 4, 1, false));
            values.put("V2", ENTES.toLongString(data, 4, 4, 1, false));
            values.put("V3", ENTES.toLongString(data, 8, 4, 1, false));
            values.put("I1", ENTES.toLongString(data, 12, 4, 3, false));
            values.put("I2", ENTES.toLongString(data, 16, 4, 3, false));
            values.put("I3", ENTES.toLongString(data, 20, 4, 3, false));
            values.put("In", ENTES.toLongString(data, 24, 4, 3, false));
            values.put("U12", ENTES.toLongString(data, 28, 4, 1, false));
            values.put("U23", ENTES.toLongString(data, 32, 4, 1, false));
            values.put("U31", ENTES.toLongString(data, 36, 4, 1, false));
            values.put("F", ENTES.toLongString(data, 40, 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPowerMPR46S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(52);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 26, 6);
        bb.put(data, 2, 12);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 38, 8);
        bb.put(data, 2, 16);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 56, 8);
        bb.put(data, 2, 16);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 70, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 80, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Float> decodePowerMPR46S(byte[] data) {
        Hashtable<String, Float> values = new Hashtable<String, Float>();
        try {
            values.put("P1", ENTES.decodeFloat(data, 0));
            values.put("P2", ENTES.decodeFloat(data, 4));
            values.put("P3", ENTES.decodeFloat(data, 8));
            values.put("P", ENTES.decodeFloat(data, 12));
            values.put("Q1", ENTES.decodeFloat(data, 16));
            values.put("Q2", ENTES.decodeFloat(data, 20));
            values.put("Q3", ENTES.decodeFloat(data, 24));
            values.put("Q", ENTES.decodeFloat(data, 28));
            values.put("S1", ENTES.decodeFloat(data, 32));
            values.put("S2", ENTES.decodeFloat(data, 36));
            values.put("S3", ENTES.decodeFloat(data, 40));
            values.put("S", ENTES.decodeFloat(data, 44));
            values.put("PF", Float.valueOf(ENTES.toLong(data, 48, true)));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Float>();
        }
    }

    public static Hashtable<String, String> displayPowerMPR46S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("P1", ENTES.toFloatString(data, 0, 4, 3));
            values.put("P2", ENTES.toFloatString(data, 4, 4, 3));
            values.put("P3", ENTES.toFloatString(data, 8, 4, 3));
            values.put("P", ENTES.toFloatString(data, 12, 4, 3));
            values.put("Q1", ENTES.toFloatString(data, 16, 4, 3));
            values.put("Q2", ENTES.toFloatString(data, 20, 4, 3));
            values.put("Q3", ENTES.toFloatString(data, 24, 4, 3));
            values.put("Q", ENTES.toFloatString(data, 28, 4, 3));
            values.put("S1", ENTES.toFloatString(data, 32, 4, 3));
            values.put("S2", ENTES.toFloatString(data, 36, 4, 3));
            values.put("S3", ENTES.toFloatString(data, 40, 4, 3));
            values.put("S", ENTES.toFloatString(data, 44, 4, 3));
            values.put("PF", ENTES.toLongString(data, 48, 4, 3, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHDMPR46S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(40);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 2000, 24);
        bb.put(data, 2, 24);
        bb.put(data, 30, 12);
        bb.put(data, 46, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeTHDMPR46S(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("THDU12", ENTES.toLong(data, 0, false));
            values.put("THDU23", ENTES.toLong(data, 4, false));
            values.put("THDU31", ENTES.toLong(data, 8, false));
            values.put("THDV1", ENTES.toLong(data, 12, false));
            values.put("THDV2", ENTES.toLong(data, 16, false));
            values.put("THDV3", ENTES.toLong(data, 20, false));
            values.put("THDI1", ENTES.toLong(data, 24, false));
            values.put("THDI2", ENTES.toLong(data, 28, false));
            values.put("THDI3", ENTES.toLong(data, 32, false));
            values.put("THDIn", ENTES.toLong(data, 36, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHDMPR46S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("THDU12", ENTES.toLongString(data, 0, 3, 1, false));
            values.put("THDU23", ENTES.toLongString(data, 4, 3, 1, false));
            values.put("THDU31", ENTES.toLongString(data, 8, 3, 1, false));
            values.put("THDV1", ENTES.toLongString(data, 12, 3, 1, false));
            values.put("THDV2", ENTES.toLongString(data, 16, 3, 1, false));
            values.put("THDV3", ENTES.toLongString(data, 20, 3, 1, false));
            values.put("THDI1", ENTES.toLongString(data, 24, 3, 1, false));
            values.put("THDI2", ENTES.toLongString(data, 28, 3, 1, false));
            values.put("THDI3", ENTES.toLongString(data, 32, 3, 1, false));
            values.put("THDIn", ENTES.toLongString(data, 36, 3, 1, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static boolean chechTHDMPR46S(byte[] data) {
        try {
            return ENTES.toLong(data, 0, false) >= 80 || ENTES.toLong(data, 4, false) >= 80 || ENTES.toLong(data, 8, false) >= 80;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static byte[] readEnergyPosMPR46S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 216, 4);
        bb.put(data, 2, 8);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 296, 4);
        bb.put(data, 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyPosMPR46S(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea", Math.round(ENTES.toVeryLong(data, 0, false)));
            values.put("Er", Math.round(ENTES.toVeryLong(data, 8, false)));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyPosMPR46S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("Ea", Long.toString(Math.round(ENTES.toVeryLong(data, 0, false))));
            values.put("Er", Long.toString(Math.round(ENTES.toVeryLong(data, 8, false))));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readEnergyNegMPR46S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(24);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 236, 4);
        bb.put(data, 2, 8);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 336, 4);
        bb.put(data, 2, 8);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 256, 4);
        bb.put(data, 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Long> decodeEnergyNegMPR46S(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea-", Math.round(ENTES.toVeryLong(data, 0, false)));
            values.put("Er-", Math.round(ENTES.toVeryLong(data, 8, false)));
            values.put("Es", Math.round(ENTES.toVeryLong(data, 16, false)));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayEnergyNegMPR46S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("Ea-", Long.toString(Math.round(ENTES.toVeryLong(data, 0, false))));
            values.put("Er-", Long.toString(Math.round(ENTES.toVeryLong(data, 8, false))));
            values.put("Es", Long.toString(Math.round(ENTES.toVeryLong(data, 16, false))));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxBaseMPR46S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(32);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 828, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 832, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 836, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 844, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 864, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 868, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 908, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 936, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeMaxBaseMPR46S(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("maxI1", ENTES.toLong(data, 0, false));
            values.put("maxI2", ENTES.toLong(data, 4, false));
            values.put("maxI3", ENTES.toLong(data, 8, false));
            values.put("maxIn", ENTES.toLong(data, 12, false));
            values.put("maxP+", Math.round(ENTES.decodeFloat(data, 16).floatValue()));
            values.put("maxP-", Math.round(ENTES.decodeFloat(data, 20).floatValue()));
            values.put("maxQ+", Math.round(ENTES.decodeFloat(data, 24).floatValue()));
            values.put("maxS", Math.round(ENTES.decodeFloat(data, 28).floatValue()));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxBaseMPR46S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("maxI1", ENTES.toLongString(data, 0, 4, 3, false));
            values.put("maxI2", ENTES.toLongString(data, 4, 4, 3, false));
            values.put("maxI3", ENTES.toLongString(data, 8, 4, 3, false));
            values.put("maxIn", ENTES.toLongString(data, 12, 4, 3, false));
            values.put("maxP+", ENTES.toFloatString(data, 16, 4, 3));
            values.put("maxP-", ENTES.toFloatString(data, 20, 4, 3));
            values.put("maxQ+", ENTES.toFloatString(data, 24, 4, 3));
            values.put("maxS", ENTES.toFloatString(data, 28, 4, 3));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxExtMPR46S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(28);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 816, 10);
        bb.put(data, 2, 4);
        bb.put(data, 10, 4);
        bb.put(data, 18, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 800, 10);
        bb.put(data, 2, 4);
        bb.put(data, 10, 4);
        bb.put(data, 18, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 25034, 2);
        bb.put(data, 2, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeMaxExtMPR46S(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("maxU12", ENTES.toLong(data, 0, false));
            values.put("maxU23", ENTES.toLong(data, 4, false));
            values.put("maxU31", ENTES.toLong(data, 8, false));
            values.put("maxV1", ENTES.toLong(data, 12, false));
            values.put("maxV2", ENTES.toLong(data, 16, false));
            values.put("maxV3", ENTES.toLong(data, 20, false));
            values.put("maxF", ENTES.toLong(data, 24, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxExtMPR46S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("maxU12", ENTES.toLongString(data, 0, 4, 3, false));
            values.put("maxU23", ENTES.toLongString(data, 4, 4, 3, false));
            values.put("maxU31", ENTES.toLongString(data, 8, 4, 3, false));
            values.put("maxV1", ENTES.toLongString(data, 12, 4, 3, false));
            values.put("maxV2", ENTES.toLongString(data, 16, 4, 3, false));
            values.put("maxV3", ENTES.toLongString(data, 20, 4, 3, false));
            values.put("maxF", ENTES.toLongString(data, 24, 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readAvgExtMPR46S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(64);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 25004, 14);
        bb.put(data, 18, 12);
        bb.put(data, 2, 12);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 25018, 2);
        bb.put(data, 2, 4);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 24004, 8);
        bb.put(data, 2, 16);
        data = user.modbusReadHoldingRegisters(gateway, unitid, 26004, 14);
        bb.put(data, 2, 12);
        bb.put(data, 18, 4);
        bb.put(data, 26, 4);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeAvgExtMPR46S(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("avgU12", ENTES.toLong(data, 0, false));
            values.put("avgU23", ENTES.toLong(data, 4, false));
            values.put("avgU31", ENTES.toLong(data, 8, false));
            values.put("avgV1", ENTES.toLong(data, 12, false));
            values.put("avgV2", ENTES.toLong(data, 16, false));
            values.put("avgV3", ENTES.toLong(data, 20, false));
            values.put("avgF", ENTES.toLong(data, 24, false));
            values.put("avgI1", ENTES.toLong(data, 28, false));
            values.put("avgI2", ENTES.toLong(data, 32, false));
            values.put("avgI3", ENTES.toLong(data, 36, false));
            values.put("avgIn", ENTES.toLong(data, 40, false));
            values.put("avgP+", Math.round(ENTES.decodeFloat(data, 44).floatValue()));
            values.put("avgP-", Math.round(ENTES.decodeFloat(data, 48).floatValue()));
            values.put("avgQ+", Math.round(ENTES.decodeFloat(data, 52).floatValue()));
            values.put("avgQ-", Math.round(ENTES.decodeFloat(data, 56).floatValue()));
            values.put("avgS", Math.round(ENTES.decodeFloat(data, 60).floatValue()));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayAvgExtMPR46S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("avgU12", ENTES.toLongString(data, 0, 4, 1, false));
            values.put("avgU23", ENTES.toLongString(data, 4, 4, 1, false));
            values.put("avgU31", ENTES.toLongString(data, 8, 4, 1, false));
            values.put("avgV1", ENTES.toLongString(data, 12, 4, 1, false));
            values.put("avgV2", ENTES.toLongString(data, 16, 4, 1, false));
            values.put("avgV3", ENTES.toLongString(data, 20, 4, 1, false));
            values.put("avgF", ENTES.toLongString(data, 24, 4, 2, false));
            values.put("avgI1", ENTES.toLongString(data, 28, 4, 3, false));
            values.put("avgI2", ENTES.toLongString(data, 32, 4, 3, false));
            values.put("avgI3", ENTES.toLongString(data, 36, 4, 3, false));
            values.put("avgIn", ENTES.toLongString(data, 40, 4, 3, false));
            values.put("avgP+", ENTES.toFloatString(data, 44, 4, 3));
            values.put("avgP-", ENTES.toFloatString(data, 48, 4, 3));
            values.put("avgQ+", ENTES.toFloatString(data, 52, 4, 3));
            values.put("avgQ-", ENTES.toFloatString(data, 56, 4, 3));
            values.put("avgS", ENTES.toFloatString(data, 60, 4, 3));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicIMPR47S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(96);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 3006, 115);
        int i2 = 0;
        while (i2 < 12) {
            bb.put(data, 2 + i2 * 20, 2);
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            bb.put(data, 4 + i2 * 20, 2);
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            bb.put(data, 6 + i2 * 20, 2);
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            bb.put(data, 10 + i2 * 20, 2);
            ++i2;
        }
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeHarmonicIMPR47S(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "I1", ENTES.toInteger(data, 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "I2", ENTES.toInteger(data, 24 + 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "I3", ENTES.toInteger(data, 48 + 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "In", ENTES.toInteger(data, 72 + 2 * i2, false));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicIMPR47S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        StringBuffer sbn = new StringBuffer("[");
        try {
            sb1.append(ENTES.toIntegerString(data, 0, 3, 1, false));
            sb2.append(ENTES.toIntegerString(data, 24, 3, 1, false));
            sb3.append(ENTES.toIntegerString(data, 48, 3, 1, false));
            sbn.append(ENTES.toIntegerString(data, 72, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(ENTES.toIntegerString(data, 2 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(ENTES.toIntegerString(data, 24 + 2 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(ENTES.toIntegerString(data, 48 + 2 * i2, 3, 1, false));
                sbn.append(',');
                sbn.append(ENTES.toIntegerString(data, 72 + 2 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            sbn.append(']');
            values.put("HI1", sb1.toString());
            values.put("HI2", sb2.toString());
            values.put("HI3", sb3.toString());
            values.put("HIn", sbn.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicVMPR47S(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(72);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 4005, 91);
        int i2 = 0;
        while (i2 < 12) {
            bb.put(data, 2 + i2 * 16, 2);
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            bb.put(data, 4 + i2 * 16, 2);
            ++i2;
        }
        i2 = 0;
        while (i2 < 12) {
            bb.put(data, 6 + i2 * 16, 2);
            ++i2;
        }
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeHarmonicVMPR47S(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "V1", ENTES.toInteger(data, 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "V2", ENTES.toInteger(data, 24 + 2 * i2, false));
                values.put("H" + (2 * i2 + 3) + "V3", ENTES.toInteger(data, 48 + 2 * i2, false));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicVMPR47S(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            sb1.append(ENTES.toIntegerString(data, 0, 3, 1, false));
            sb2.append(ENTES.toIntegerString(data, 24, 3, 1, false));
            sb3.append(ENTES.toIntegerString(data, 48, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(ENTES.toIntegerString(data, 2 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(ENTES.toIntegerString(data, 24 + 2 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(ENTES.toIntegerString(data, 48 + 2 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HV1", sb1.toString());
            values.put("HV2", sb2.toString());
            values.put("HV3", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static int toInteger(byte[] data, int index, boolean signed) {
        return ENTES.decodeInteger(data, index, 2, signed).intValue();
    }

    private static String toIntegerString(byte[] data, int index, int digits, int decimals, boolean signed) {
        int val = ENTES.decodeInteger(data, index, 2, signed).intValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    public static int toLong(byte[] data, int index, boolean signed) {
        return ENTES.decodeInteger(data, index, 4, signed).intValue();
    }

    public static String toLongString(byte[] data, int index, boolean signed) {
        long val = ENTES.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "";
        }
        return Long.toString(val);
    }

    private static String toLongString(byte[] data, int index, int digits, int decimals, boolean signed) {
        long val = ENTES.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0L) {
            return "0";
        }
        if (val > 0L) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    public static double toVeryLong(byte[] data, int index, boolean signed) {
        return ENTES.decodeInteger(data, index, 8, signed).doubleValue();
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static Float decodeFloat(byte[] data, int index) {
        try {
            return Float.valueOf(Float.intBitsToFloat((data[3 + index] & 0xFF) + ((data[2 + index] & 0xFF) << 8) + ((data[1 + index] & 0xFF) << 16) + ((data[index] & 0xFF) << 24)));
        }
        catch (Exception e2) {
            return null;
        }
    }

    public static String toFloatString(byte[] data, int index) {
        return Long.toString(ENTES.decodeFloat(data, index).longValue());
    }

    private static String toFloatString(byte[] data, int index, int digits, int decimals) {
        long val = ENTES.decodeFloat(data, index).longValue();
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0L) {
            return "0";
        }
        if (val > 0L) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }
}

