/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EMDX3 {
    public static final int[] EN50160LIMITS = new int[]{50, 60, 50, 15, 35, 30, 5, 20, 15, 5, 15, 15};

    public static byte[] readVIF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(44);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 50514, 22);
        return bb.put(data, 2, 44).array();
    }

    public static Hashtable<String, Integer> decodeVIF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("U12", EMDX3.toLong(data, 0));
            values.put("U23", EMDX3.toLong(data, 4));
            values.put("U31", EMDX3.toLong(data, 8));
            values.put("V1", EMDX3.toLong(data, 12));
            values.put("V2", EMDX3.toLong(data, 16));
            values.put("V3", EMDX3.toLong(data, 20));
            values.put("F", EMDX3.toLong(data, 24));
            values.put("I1", EMDX3.toLong(data, 28));
            values.put("I2", EMDX3.toLong(data, 32));
            values.put("I3", EMDX3.toLong(data, 36));
            values.put("In", EMDX3.toLong(data, 40));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("U12", EMDX3.toLongString(data, 0, 4, 2, false));
            values.put("U23", EMDX3.toLongString(data, 4, 4, 2, false));
            values.put("U31", EMDX3.toLongString(data, 8, 4, 2, false));
            values.put("V1", EMDX3.toLongString(data, 12, 4, 2, false));
            values.put("V2", EMDX3.toLongString(data, 16, 4, 2, false));
            values.put("V3", EMDX3.toLongString(data, 20, 4, 2, false));
            values.put("F", EMDX3.toLongString(data, 24, 4, 2, false));
            values.put("I1", EMDX3.toLongString(data, 28, 4, 3, false));
            values.put("I2", EMDX3.toLongString(data, 32, 4, 3, false));
            values.put("I3", EMDX3.toLongString(data, 36, 4, 3, false));
            values.put("In", EMDX3.toLongString(data, 40, 4, 3, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(64);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 50536, 32);
        return bb.put(data, 2, 64).array();
    }

    public static Hashtable<String, Integer> decodePower(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("P", EMDX3.toLong(data, 0));
            values.put("Q", EMDX3.toLong(data, 4));
            values.put("S", EMDX3.toLong(data, 8));
            values.put("PF", EMDX3.toLong(data, 12));
            values.put("P1", EMDX3.toLong(data, 16));
            values.put("P2", EMDX3.toLong(data, 20));
            values.put("P3", EMDX3.toLong(data, 24));
            values.put("Q1", EMDX3.toLong(data, 28));
            values.put("Q2", EMDX3.toLong(data, 32));
            values.put("Q3", EMDX3.toLong(data, 36));
            values.put("S1", EMDX3.toLong(data, 40));
            values.put("S2", EMDX3.toLong(data, 44));
            values.put("S3", EMDX3.toLong(data, 48));
            values.put("PF1", EMDX3.toLong(data, 52));
            values.put("PF2", EMDX3.toLong(data, 56));
            values.put("PF3", EMDX3.toLong(data, 60));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("P", EMDX3.toLongString(data, 0, 4, 2, true));
            values.put("Q", EMDX3.toLongString(data, 4, 4, 2, true));
            values.put("S", EMDX3.toLongString(data, 8, 4, 2, false));
            values.put("PF", EMDX3.toLongString(data, 12, 4, 3, true));
            values.put("P1", EMDX3.toLongString(data, 16, 4, 2, true));
            values.put("P2", EMDX3.toLongString(data, 20, 4, 2, true));
            values.put("P3", EMDX3.toLongString(data, 24, 4, 2, true));
            values.put("Q1", EMDX3.toLongString(data, 28, 4, 2, true));
            values.put("Q2", EMDX3.toLongString(data, 32, 4, 2, true));
            values.put("Q3", EMDX3.toLongString(data, 36, 4, 2, true));
            values.put("S1", EMDX3.toLongString(data, 40, 4, 2, false));
            values.put("S2", EMDX3.toLongString(data, 44, 4, 2, false));
            values.put("S3", EMDX3.toLongString(data, 48, 4, 2, false));
            values.put("PF1", EMDX3.toLongString(data, 52, 4, 3, true));
            values.put("PF2", EMDX3.toLongString(data, 56, 4, 3, true));
            values.put("PF3", EMDX3.toLongString(data, 60, 4, 3, true));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHD(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(20);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 51536, 10);
        return bb.put(data, 2, 20).array();
    }

    public static Hashtable<String, Integer> decodeTHD(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("THDU12", EMDX3.toInteger(data, 0));
            values.put("THDU23", EMDX3.toInteger(data, 2));
            values.put("THDU31", EMDX3.toInteger(data, 4));
            values.put("THDV1", EMDX3.toInteger(data, 6));
            values.put("THDV2", EMDX3.toInteger(data, 8));
            values.put("THDV3", EMDX3.toInteger(data, 10));
            values.put("THDI1", EMDX3.toInteger(data, 12));
            values.put("THDI2", EMDX3.toInteger(data, 14));
            values.put("THDI3", EMDX3.toInteger(data, 16));
            values.put("THDIn", EMDX3.toInteger(data, 18));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHD(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("THDU12", EMDX3.toIntegerString(data, 0, 3, 1, false));
            values.put("THDU23", EMDX3.toIntegerString(data, 2, 3, 1, false));
            values.put("THDU31", EMDX3.toIntegerString(data, 4, 3, 1, false));
            values.put("THDV1", EMDX3.toIntegerString(data, 6, 3, 1, false));
            values.put("THDV2", EMDX3.toIntegerString(data, 8, 3, 1, false));
            values.put("THDV3", EMDX3.toIntegerString(data, 10, 3, 1, false));
            values.put("THDI1", EMDX3.toIntegerString(data, 12, 3, 1, false));
            values.put("THDI2", EMDX3.toIntegerString(data, 14, 3, 1, false));
            values.put("THDI3", EMDX3.toIntegerString(data, 16, 3, 1, false));
            values.put("THDIn", EMDX3.toIntegerString(data, 18, 3, 1, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static boolean chechTHD(byte[] data) {
        try {
            return EMDX3.toInteger(data, 0) >= 80 || EMDX3.toInteger(data, 2) >= 80 || EMDX3.toInteger(data, 4) >= 80;
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static byte[] readTHDStat(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 51088, 6);
        return bb.put(data, 2, 12).array();
    }

    public static Hashtable<String, Integer> decodeTHDStat(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("THDminI", EMDX3.toInteger(data, 0));
            values.put("THDminIn", EMDX3.toInteger(data, 2));
            values.put("THDminU", EMDX3.toInteger(data, 4));
            values.put("THDmaxI", EMDX3.toInteger(data, 6));
            values.put("THDmaxIn", EMDX3.toInteger(data, 8));
            values.put("THDmaxU", EMDX3.toInteger(data, 10));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHDStat(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("THDminI", EMDX3.toIntegerString(data, 0, 3, 1, false));
            values.put("THDminIn", EMDX3.toIntegerString(data, 2, 3, 1, false));
            values.put("THDminU", EMDX3.toIntegerString(data, 4, 3, 1, false));
            values.put("THDmaxI", EMDX3.toIntegerString(data, 6, 3, 1, false));
            values.put("THDmaxIn", EMDX3.toIntegerString(data, 8, 3, 1, false));
            values.put("THDmaxU", EMDX3.toIntegerString(data, 10, 3, 1, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPartialEnergyPos(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(8);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 50780, 4);
        return bb.put(data, 2, 8).array();
    }

    public static Hashtable<String, Long> decodePartialEnergyPos(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea", (long)EMDX3.toLong(data, 0) * 1000L);
            values.put("Er", (long)EMDX3.toLong(data, 4) * 1000L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayPartialEnergyPos(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("Ea", Long.toString((long)EMDX3.toLong(data, 0) * 1000L));
            values.put("Er", Long.toString((long)EMDX3.toLong(data, 4) * 1000L));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTotalEnergyCounter(String gateway, int unitid, String subaddress) {
        int port;
        ByteBuffer bb = ByteBuffer.allocate(16);
        byte[] data = null;
        try {
            port = Integer.parseInt(subaddress.substring(2));
        }
        catch (Exception e2) {
            return data;
        }
        data = user.modbusReadHoldingRegisters(gateway, unitid, 36866 + 14 * (port - 1), 8);
        return bb.put(data, 2, 16).array();
    }

    public static Hashtable<String, Long> decodeTotalEnergyCounter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int unit;
            byte mode = data[1];
            switch (data[3]) {
                case 0: {
                    unit = 1;
                    break;
                }
                case 10: {
                    unit = 1000;
                    break;
                }
                case 20: {
                    unit = 1000000;
                    break;
                }
                default: {
                    unit = 0;
                }
            }
            int weight = EMDX3.toLong(data, 4);
            if (mode != 1 || unit == 0) {
                return new Hashtable<String, Long>();
            }
            values.put("Ea", (long)(EMDX3.toVeryLong(data, 8) * (double)unit * ((double)weight / 10.0)));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalEnergyCounter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            int unit;
            byte mode = data[1];
            switch (data[3]) {
                case 0: {
                    unit = 1;
                    break;
                }
                case 10: {
                    unit = 1000;
                    break;
                }
                case 20: {
                    unit = 1000000;
                    break;
                }
                default: {
                    unit = 0;
                }
            }
            int weight = EMDX3.toLong(data, 4);
            if (mode != 1 || unit == 0) {
                return new Hashtable<String, String>();
            }
            values.put("Ea", Long.toString((long)(EMDX3.toVeryLong(data, 8) * (double)unit * ((double)weight / 10.0))));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTotalM3Counter(String gateway, int unitid, String subaddress) {
        int port;
        ByteBuffer bb = ByteBuffer.allocate(16);
        byte[] data = null;
        try {
            port = Integer.parseInt(subaddress.substring(2));
        }
        catch (Exception e2) {
            return data;
        }
        data = user.modbusReadHoldingRegisters(gateway, unitid, 36866 + 14 * (port - 1), 8);
        return bb.put(data, 2, 16).array();
    }

    public static Hashtable<String, Long> decodeTotalM3Counter(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            int unit;
            byte mode = data[1];
            switch (data[3]) {
                case 3: {
                    unit = 1;
                    break;
                }
                case 13: {
                    unit = 1000;
                    break;
                }
                case 23: {
                    unit = 1000000;
                    break;
                }
                default: {
                    unit = 0;
                }
            }
            int weight = EMDX3.toLong(data, 4);
            if (mode != 1 || unit == 0) {
                return new Hashtable<String, Long>();
            }
            values.put("Ea", (long)(EMDX3.toVeryLong(data, 8) * (double)unit * 1000.0 * ((double)weight / 10.0)));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayTotalM3Counter(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            int unit;
            byte mode = data[1];
            switch (data[3]) {
                case 3: {
                    unit = 1;
                    break;
                }
                case 13: {
                    unit = 1000;
                    break;
                }
                case 23: {
                    unit = 1000000;
                    break;
                }
                default: {
                    unit = 0;
                }
            }
            int weight = EMDX3.toLong(data, 4);
            if (mode != 1 || unit == 0) {
                return new Hashtable<String, String>();
            }
            values.put("Ea", Long.toString((long)(EMDX3.toVeryLong(data, 8) * (double)unit * 1000.0 * ((double)weight / 10.0))));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPartialEnergyNeg(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(12);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 50784, 6);
        return bb.put(data, 2, 12).array();
    }

    public static Hashtable<String, Long> decodePartialEnergyNeg(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Es", (long)EMDX3.toLong(data, 0) * 1000L);
            values.put("Ea-", (long)EMDX3.toLong(data, 4) * 1000L);
            values.put("Er-", (long)EMDX3.toLong(data, 8) * 1000L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayPartialEnergyNeg(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("Es", Long.toString((long)EMDX3.toLong(data, 0) * 1000L));
            values.put("Ea-", Long.toString((long)EMDX3.toLong(data, 4) * 1000L));
            values.put("Er-", Long.toString((long)EMDX3.toLong(data, 8) * 1000L));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readAvgExt(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(64);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 51024, 32);
        return bb.put(data, 2, 64).array();
    }

    public static Hashtable<String, Integer> decodeAvgExt(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("avgU12", EMDX3.toLong(data, 0));
            values.put("avgU23", EMDX3.toLong(data, 4));
            values.put("avgU31", EMDX3.toLong(data, 8));
            values.put("avgV1", EMDX3.toLong(data, 12));
            values.put("avgV2", EMDX3.toLong(data, 16));
            values.put("avgV3", EMDX3.toLong(data, 20));
            values.put("avgF", EMDX3.toLong(data, 24));
            values.put("avgI1", EMDX3.toLong(data, 28));
            values.put("avgI2", EMDX3.toLong(data, 32));
            values.put("avgI3", EMDX3.toLong(data, 36));
            values.put("avgIn", EMDX3.toLong(data, 40));
            values.put("avgP+", EMDX3.toLong(data, 44));
            values.put("avgP-", EMDX3.toLong(data, 48));
            values.put("avgQ+", EMDX3.toLong(data, 52));
            values.put("avgQ-", EMDX3.toLong(data, 56));
            values.put("avgS", EMDX3.toLong(data, 60));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayAvgExt(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("avgU12", EMDX3.toLongString(data, 0, 4, 2, false));
            values.put("avgU23", EMDX3.toLongString(data, 4, 4, 2, false));
            values.put("avgU31", EMDX3.toLongString(data, 8, 4, 2, false));
            values.put("avgV1", EMDX3.toLongString(data, 12, 4, 2, false));
            values.put("avgV2", EMDX3.toLongString(data, 16, 4, 2, false));
            values.put("avgV3", EMDX3.toLongString(data, 20, 4, 2, false));
            values.put("avgF", EMDX3.toLongString(data, 24, 4, 2, false));
            values.put("avgI1", EMDX3.toLongString(data, 28, 4, 3, false));
            values.put("avgI2", EMDX3.toLongString(data, 32, 4, 3, false));
            values.put("avgI3", EMDX3.toLongString(data, 36, 4, 3, false));
            values.put("avgIn", EMDX3.toLongString(data, 40, 4, 3, false));
            values.put("avgP+", EMDX3.toLongString(data, 44, 4, 2, true));
            values.put("avgP-", EMDX3.toLongString(data, 48, 4, 2, true));
            values.put("avgQ+", EMDX3.toLongString(data, 52, 4, 2, true));
            values.put("avgQ-", EMDX3.toLongString(data, 56, 4, 2, true));
            values.put("avgS", EMDX3.toLongString(data, 60, 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxExt(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(28);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 51056, 14);
        return bb.put(data, 2, 28).array();
    }

    public static Hashtable<String, Integer> decodeMaxExt(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("maxU12", EMDX3.toLong(data, 0));
            values.put("maxU23", EMDX3.toLong(data, 4));
            values.put("maxU31", EMDX3.toLong(data, 8));
            values.put("maxV1", EMDX3.toLong(data, 12));
            values.put("maxV2", EMDX3.toLong(data, 16));
            values.put("maxV3", EMDX3.toLong(data, 20));
            values.put("maxF", EMDX3.toLong(data, 24));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxExt(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("maxU12", EMDX3.toLongString(data, 0, 4, 2, false));
            values.put("maxU23", EMDX3.toLongString(data, 4, 4, 2, false));
            values.put("maxU31", EMDX3.toLongString(data, 8, 4, 2, false));
            values.put("maxV1", EMDX3.toLongString(data, 12, 4, 2, false));
            values.put("maxV2", EMDX3.toLongString(data, 16, 4, 2, false));
            values.put("maxV3", EMDX3.toLongString(data, 20, 4, 2, false));
            values.put("maxF", EMDX3.toLongString(data, 24, 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxBase(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(36);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 51070, 18);
        return bb.put(data, 2, 36).array();
    }

    public static Hashtable<String, Integer> decodeMaxBase(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("maxI1", EMDX3.toLong(data, 0));
            values.put("maxI2", EMDX3.toLong(data, 4));
            values.put("maxI3", EMDX3.toLong(data, 8));
            values.put("maxIn", EMDX3.toLong(data, 12));
            values.put("maxP+", EMDX3.toLong(data, 16));
            values.put("maxP-", EMDX3.toLong(data, 20));
            values.put("maxQ+", EMDX3.toLong(data, 24));
            values.put("maxQ-", EMDX3.toLong(data, 28));
            values.put("maxS", EMDX3.toLong(data, 32));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxBase(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("maxI1", EMDX3.toLongString(data, 0, 4, 3, false));
            values.put("maxI2", EMDX3.toLongString(data, 4, 4, 3, false));
            values.put("maxI3", EMDX3.toLongString(data, 8, 4, 3, false));
            values.put("maxIn", EMDX3.toLongString(data, 12, 4, 3, false));
            values.put("maxP+", EMDX3.toLongString(data, 16, 4, 2, true));
            values.put("maxP-", EMDX3.toLongString(data, 20, 4, 2, true));
            values.put("maxQ+", EMDX3.toLongString(data, 24, 4, 2, true));
            values.put("maxQ-", EMDX3.toLongString(data, 28, 4, 2, true));
            values.put("maxS", EMDX3.toLongString(data, 32, 4, 2, false));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicI(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(96);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 51547, 48);
        return bb.put(data, 2, 96).array();
    }

    public static Hashtable<String, Integer> decodeHarmonicI(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "I1", EMDX3.toInteger(data, 8 * i2));
                values.put("H" + (2 * i2 + 3) + "I2", EMDX3.toInteger(data, 2 + 8 * i2));
                values.put("H" + (2 * i2 + 3) + "I3", EMDX3.toInteger(data, 4 + 8 * i2));
                values.put("H" + (2 * i2 + 3) + "In", EMDX3.toInteger(data, 6 + 8 * i2));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicI(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        StringBuffer sbn = new StringBuffer("[");
        try {
            sb1.append(EMDX3.toIntegerString(data, 0, 3, 1, false));
            sb2.append(EMDX3.toIntegerString(data, 2, 3, 1, false));
            sb3.append(EMDX3.toIntegerString(data, 4, 3, 1, false));
            sbn.append(EMDX3.toIntegerString(data, 6, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(EMDX3.toIntegerString(data, 8 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(EMDX3.toIntegerString(data, 2 + 8 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(EMDX3.toIntegerString(data, 4 + 8 * i2, 3, 1, false));
                sbn.append(',');
                sbn.append(EMDX3.toIntegerString(data, 6 + 8 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            sbn.append(']');
            values.put("HI1", sb1.toString());
            values.put("HI2", sb2.toString());
            values.put("HI3", sb3.toString());
            values.put("HIn", sbn.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readHarmonicU(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(72);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 51672, 36);
        return bb.put(data, 2, 72).array();
    }

    public static Hashtable<String, Integer> decodeHarmonicU(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "U12", EMDX3.toInteger(data, 6 * i2));
                values.put("H" + (2 * i2 + 3) + "U23", EMDX3.toInteger(data, 2 + 6 * i2));
                values.put("H" + (2 * i2 + 3) + "U31", EMDX3.toInteger(data, 4 + 6 * i2));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicU(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            sb1.append(EMDX3.toIntegerString(data, 0, 3, 1, false));
            sb2.append(EMDX3.toIntegerString(data, 2, 3, 1, false));
            sb3.append(EMDX3.toIntegerString(data, 4, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(EMDX3.toIntegerString(data, 6 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(EMDX3.toIntegerString(data, 2 + 6 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(EMDX3.toIntegerString(data, 4 + 6 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HU12", sb1.toString());
            values.put("HU23", sb2.toString());
            values.put("HU31", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean checkHarmonicU(byte[] data) {
        try {
            int i2 = 0;
            while (true) {
                if (i2 >= 12) {
                    return false;
                }
                if (EMDX3.toInteger(data, 6 * i2) >= EN50160LIMITS[i2] || EMDX3.toInteger(data, 2 + 6 * i2) >= EN50160LIMITS[i2] || EMDX3.toInteger(data, 4 + 6 * i2) >= EN50160LIMITS[i2]) {
                    return true;
                }
                ++i2;
            }
        }
        catch (Exception e2) {
            return false;
        }
    }

    public static byte[] readHarmonicV(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(72);
        byte[] data = user.modbusReadHoldingRegisters(gateway, unitid, 51766, 36);
        return bb.put(data, 2, 72).array();
    }

    public static Hashtable<String, Integer> decodeHarmonicV(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            int i2 = 0;
            while (i2 < 12) {
                values.put("H" + (2 * i2 + 3) + "V1", EMDX3.toInteger(data, 6 * i2));
                values.put("H" + (2 * i2 + 3) + "V2", EMDX3.toInteger(data, 2 + 6 * i2));
                values.put("H" + (2 * i2 + 3) + "V3", EMDX3.toInteger(data, 4 + 6 * i2));
                ++i2;
            }
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayHarmonicV(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        StringBuffer sb1 = new StringBuffer("[");
        StringBuffer sb2 = new StringBuffer("[");
        StringBuffer sb3 = new StringBuffer("[");
        try {
            sb1.append(EMDX3.toIntegerString(data, 0, 3, 1, false));
            sb2.append(EMDX3.toIntegerString(data, 2, 3, 1, false));
            sb3.append(EMDX3.toIntegerString(data, 4, 3, 1, false));
            int i2 = 1;
            while (i2 < 12) {
                sb1.append(',');
                sb1.append(EMDX3.toIntegerString(data, 6 * i2, 3, 1, false));
                sb2.append(',');
                sb2.append(EMDX3.toIntegerString(data, 2 + 6 * i2, 3, 1, false));
                sb3.append(',');
                sb3.append(EMDX3.toIntegerString(data, 4 + 6 * i2, 3, 1, false));
                ++i2;
            }
            sb1.append(']');
            sb2.append(']');
            sb3.append(']');
            values.put("HV1", sb1.toString());
            values.put("HV2", sb2.toString());
            values.put("HV3", sb3.toString());
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static int toLong(byte[] data, int index) {
        return EMDX3.decodeInteger(data, index, 4, true).intValue();
    }

    public static double toVeryLong(byte[] data, int index) {
        return EMDX3.decodeInteger(data, index, 8, false).doubleValue();
    }

    public static int toInteger(byte[] data, int index) {
        return EMDX3.decodeInteger(data, index, 2, false).intValue();
    }

    public static String toLongString(byte[] data, int index, boolean signed) {
        long val = EMDX3.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "";
        }
        return Long.toString(val);
    }

    private static String toLongString(byte[] data, int index, int digits, int decimals, boolean signed) {
        long val = EMDX3.decodeInteger(data, index, 4, signed).longValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1 && data[index + 2] == -1 && data[index + 3] == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0L) {
            return "0";
        }
        if (val > 0L) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    public static String toIntegerString(byte[] data, int index, boolean signed) {
        int val = EMDX3.decodeInteger(data, index, 2, signed).intValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1) {
            return "";
        }
        return Integer.toString(val);
    }

    private static String toIntegerString(byte[] data, int index, int digits, int decimals, boolean signed) {
        int val = EMDX3.decodeInteger(data, index, 2, signed).intValue();
        if (data[index] == (signed ? (byte)127 : -1) && data[index + 1] == -1) {
            return "-";
        }
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

