/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Vector;
import plugins.wsmeasure.DataProcessor;
import plugins.wsmeasure.Schedule;
import plugins.wsmeasure.user;

public class CostRates {
    private static final int COST_CACHE_BOUNDARY_DAYS = 3;
    private static File schedulerFile = new File("scheduler.ini");
    private static Vector<Schedule> schedulesListElectricity = new Vector();
    private static Vector<Schedule> schedulesListWater = new Vector();
    private static Vector<Schedule> schedulesListGas = new Vector();
    private static int[][] costArrayElectricity = null;
    private static int[][] costArrayWater = null;
    private static int[][] costArrayGas = null;
    private static HashMap<Integer, Integer> costCacheElectricity = new HashMap();
    private static HashMap<Integer, Integer> costCacheWater = new HashMap();
    private static HashMap<Integer, Integer> costCacheGas = new HashMap();
    static long costCacheBeginMillis;
    static long costCacheEndMillis;
    private static long schedulerFileTime;

    static {
        schedulerFileTime = -1L;
    }

    public static void init() {
        CostRates.createDefaults();
        CostRates.loadRates();
        user.schedulerRegister("costrates", "load", 2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int match(int type, int rateid, int year, int month, int day, int hour) {
        HashMap<Integer, Integer> costCache;
        switch (type) {
            case 2: {
                costCache = costCacheElectricity;
                break;
            }
            case 3: {
                costCache = costCacheWater;
                break;
            }
            case 4: {
                costCache = costCacheGas;
                break;
            }
            default: {
                return -1;
            }
        }
        int[][] nArray = costArrayElectricity;
        synchronized (costArrayElectricity) {
            Integer cacheData = costCache.get(year * 1000000 + month * 10000 + day * 100 + hour);
            // ** MonitorExit[var8_7] (shouldn't be in output)
            if (cacheData != null && cacheData >= 0 && (rateid == -1 || rateid == cacheData % 10)) {
                return cacheData / 10;
            }
            return -1;
        }
    }

    static void cache(int type, int year, int month, int day, int hour) {
        HashMap<Integer, Integer> costCache;
        Vector<Schedule> schedulesList;
        switch (type) {
            case 2: {
                schedulesList = schedulesListElectricity;
                costCache = costCacheElectricity;
                break;
            }
            case 3: {
                schedulesList = schedulesListWater;
                costCache = costCacheWater;
                break;
            }
            case 4: {
                schedulesList = schedulesListGas;
                costCache = costCacheGas;
                break;
            }
            default: {
                return;
            }
        }
        int i2 = 0;
        while (i2 < schedulesList.size()) {
            Schedule schedule = schedulesList.elementAt(i2);
            if (schedule != null && schedule.enabled && schedule.match(CostRates.toCalendar(year, month, day, hour))) {
                int rateid = schedule.description.charAt(0) - 48;
                int cost = CostRates.getCost(type, rateid, year, month, day, hour);
                costCache.put(year * 1000000 + month * 10000 + day * 100 + hour, cost == -1 ? -1 : cost * 10 + rateid);
                return;
            }
            ++i2;
        }
        costCache.put(year * 1000000 + month * 10000 + day * 100 + hour, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void loadCache() {
        long now = System.currentTimeMillis();
        if (costCacheBeginMillis != 0L && costCacheEndMillis >= now + 129600000L) return;
        int[][] nArray = costArrayElectricity;
        synchronized (costArrayElectricity) {
            costCacheEndMillis = 0L;
            costCacheElectricity.clear();
            CostRates.loadCache(2);
            costCacheWater.clear();
            CostRates.loadCache(3);
            costCacheGas.clear();
            CostRates.loadCache(4);
            user.messageLog("PROFILING: COSTRATES/CACHE/LOAD [" + (System.currentTimeMillis() - now) + "]");
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return;
        }
    }

    static void loadCache(int type) {
        GregorianCalendar cal = new GregorianCalendar();
        GregorianCalendar begincal = new GregorianCalendar();
        GregorianCalendar endcal = new GregorianCalendar();
        begincal.setTimeInMillis(System.currentTimeMillis() - DataProcessor.T2 - 259200000L);
        begincal.set(11, 0);
        begincal.set(12, 0);
        begincal.set(13, 0);
        endcal.setTimeInMillis(System.currentTimeMillis() + 259200000L);
        endcal.set(11, 0);
        endcal.set(12, 0);
        endcal.set(13, 0);
        cal.setTimeInMillis(begincal.getTimeInMillis());
        while (cal.compareTo(endcal) <= 0) {
            CostRates.cache(type, cal.get(1), cal.get(2) + 1, cal.get(5), cal.get(11));
            cal.add(11, 1);
        }
        costCacheBeginMillis = begincal.getTimeInMillis();
        costCacheEndMillis = endcal.getTimeInMillis();
    }

    static void loadRates() {
        CostRates.loadRates(2);
        CostRates.loadRates(3);
        CostRates.loadRates(4);
        costCacheEndMillis = 0L;
        costCacheBeginMillis = 0L;
    }

    static void loadRates(int type) {
        switch (type) {
            case 2: {
                costArrayElectricity = new int[5][10];
                int[][] costArray = costArrayElectricity;
                break;
            }
            case 3: {
                costArrayWater = new int[5][10];
                int[][] costArray = costArrayWater;
                break;
            }
            case 4: {
                costArrayGas = new int[5][10];
                int[][] costArray = costArrayGas;
                break;
            }
            default: {
                int[][] costArray = null;
            }
        }
        try {
            PreparedStatement pstmt = user.databaseConnection.prepareStatement("select rateid, name, color, cost1, validity1, cost2, validity2, cost3, validity3, cost4, validity4, cost5, validity5 from rates where rateid >= ? and rateid <= ? order by rateid");
            pstmt.setInt(1, type * 10);
            pstmt.setInt(2, type * 10 + 4);
            ResultSet rs = pstmt.executeQuery();
            int r = 0;
            while (rs.next()) {
                int i2 = 0;
                while (i2 < 10) {
                    costArray[r][i2] = rs.getInt(4 + i2);
                    ++i2;
                }
                ++r;
            }
            rs.close();
        }
        catch (Exception e2) {
            user.errorLog("WSMEASURE: Error loading cost rates");
        }
    }

    static void loadScheduler() {
        block30: {
            String name = null;
            String description = null;
            boolean daily_mode = false;
            String date_from = null;
            String date_to = null;
            String time_from = null;
            String time_to = null;
            String dow = null;
            int repeat_on = 0;
            int repeat_off = 0;
            boolean lock = false;
            boolean enabled = true;
            try {
                long t = schedulerFile.lastModified();
                if (t == schedulerFileTime) break block30;
                schedulesListElectricity.removeAllElements();
                schedulesListWater.removeAllElements();
                schedulesListGas.removeAllElements();
                if (t > 0L) {
                    String fl;
                    BufferedReader fis = new BufferedReader(new FileReader(schedulerFile));
                    while ((fl = fis.readLine()) != null) {
                        boolean skipthisline = false;
                        if ((fl = CostRates.trimComments(fl)).length() > 0) {
                            String[] sa = fl.split(";");
                            if (sa.length != 12) {
                                skipthisline = true;
                            } else {
                                name = sa[0].trim().toLowerCase();
                                if (name.length() == 0 || name.indexOf(32) != -1) {
                                    skipthisline = true;
                                }
                                description = sa[1].trim().toLowerCase();
                                try {
                                    daily_mode = Boolean.parseBoolean(sa[2].trim());
                                }
                                catch (Exception e2) {
                                    skipthisline = true;
                                }
                                date_from = sa[3].trim();
                                if (!date_from.equals("*") && !CostRates.isValidDate(date_from)) {
                                    skipthisline = true;
                                }
                                if (!(time_from = sa[4].trim()).equals("*") && !CostRates.isValidTime(time_from)) {
                                    skipthisline = true;
                                }
                                if (!(date_to = sa[5].trim()).equals("*") && !CostRates.isValidDate(date_to)) {
                                    skipthisline = true;
                                }
                                if (!((time_to = sa[6].trim()).equals("*") || time_to.equals("-") || CostRates.isValidTime(time_to))) {
                                    skipthisline = true;
                                }
                                if (!(dow = sa[7].trim()).equals("*") && !CostRates.isValidDow(dow)) {
                                    skipthisline = true;
                                }
                                try {
                                    repeat_on = Integer.parseInt(sa[8].trim());
                                    if (repeat_on < 0) {
                                        skipthisline = true;
                                    }
                                }
                                catch (Exception e3) {
                                    skipthisline = true;
                                }
                                try {
                                    repeat_off = Integer.parseInt(sa[9].trim());
                                    if (repeat_off < 0) {
                                        skipthisline = true;
                                    }
                                }
                                catch (Exception e4) {
                                    skipthisline = true;
                                }
                                try {
                                    lock = Boolean.parseBoolean(sa[10].trim());
                                }
                                catch (Exception e5) {
                                    skipthisline = true;
                                }
                                try {
                                    enabled = Boolean.parseBoolean(sa[11].trim());
                                }
                                catch (Exception e6) {
                                    skipthisline = true;
                                }
                            }
                        }
                        if (skipthisline) continue;
                        try {
                            if (name.equals("wsm_electricity")) {
                                schedulesListElectricity.add(new Schedule(name, description, daily_mode, date_from, date_to, time_from, time_to, dow, repeat_on, repeat_off, lock, enabled));
                                continue;
                            }
                            if (name.equals("wsm_water")) {
                                schedulesListWater.add(new Schedule(name, description, daily_mode, date_from, date_to, time_from, time_to, dow, repeat_on, repeat_off, lock, enabled));
                                continue;
                            }
                            if (!name.equals("wsm_gas")) continue;
                            schedulesListGas.add(new Schedule(name, description, daily_mode, date_from, date_to, time_from, time_to, dow, repeat_on, repeat_off, lock, enabled));
                        }
                        catch (Exception e7) {
                            skipthisline = true;
                        }
                    }
                    schedulerFileTime = t;
                    fis.close();
                    user.messageLog("WSMEASURE: scheduler.ini file reloaded");
                } else {
                    schedulerFileTime = 0L;
                    user.messageLog("WSMEASURE: scheduler.ini file not found");
                }
                costCacheEndMillis = 0L;
                costCacheBeginMillis = 0L;
            }
            catch (Exception e8) {
                schedulerFileTime = -1L;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int getCost(int type, int rate, int year, int month, int day, int hour) {
        try {
            int[] costArray;
            switch (type) {
                case 2: {
                    costArray = costArrayElectricity[rate];
                    break;
                }
                case 3: {
                    costArray = costArrayWater[rate];
                    break;
                }
                case 4: {
                    costArray = costArrayGas[rate];
                    break;
                }
                default: {
                    return -1;
                }
            }
            int dateint = year * 10000 + month * 100 + day;
            int i2 = 1;
            while (true) {
                if (i2 >= costArray.length) {
                    return -1;
                }
                int v = costArray[i2];
                int c2 = costArray[i2 - 1];
                if (v == -1) {
                    if (c2 == -1) return -1;
                    return c2;
                }
                if (dateint >= v) {
                    return c2;
                }
                i2 += 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    private static void createDefaults() {
        PreparedStatement pstmt;
        String ecs = user.varGet("energycost!");
        String gcs = user.varGet("gascost!");
        String wcs = user.varGet("watercost!");
        int ec = 0;
        int gc = 0;
        int wc = 0;
        if (ecs != null) {
            if (ecs.equals("0")) {
                user.varSet("energycost!", "");
            } else if (ecs.length() > 0) {
                try {
                    ec = Integer.parseInt(ecs);
                    pstmt = user.databaseConnection.prepareStatement("update rates set name = 'DEFAULT', color = 1, cost1 = ?, validity1 = -1, cost2 = -1, validity2 = -1, cost3 = -1, validity3 = -1, cost4 = -1, validity4 = -1, cost5 = -1, validity5 = -1 where rateid = 20");
                    pstmt.setInt(1, ec);
                    pstmt.execute();
                    user.varSet("energycost!", "");
                }
                catch (Exception e2) {
                    user.varSet("energycost!", "");
                }
            }
        }
        if (wcs != null) {
            if (wcs.equals("0")) {
                user.varSet("watercost!", "");
            } else if (wcs.length() > 0) {
                try {
                    wc = Integer.parseInt(wcs);
                    pstmt = user.databaseConnection.prepareStatement("update rates set name = 'DEFAULT', color = 1, cost1 = ?, validity1 = -1, cost2 = -1, validity2 = -1, cost3 = -1, validity3 = -1, cost4 = -1, validity4 = -1, cost5 = -1, validity5 = -1 where rateid = 30");
                    pstmt.setInt(1, wc);
                    pstmt.execute();
                    user.varSet("watercost!", "");
                }
                catch (Exception e3) {
                    user.varSet("watercost!", "");
                }
            }
        }
        if (gcs != null) {
            if (gcs.equals("0")) {
                user.varSet("gascost!", "");
            } else if (gcs.length() > 0) {
                try {
                    gc = Integer.parseInt(gcs);
                    pstmt = user.databaseConnection.prepareStatement("update rates set name = 'DEFAULT', color = 1, cost1 = ?, validity1 = -1, cost2 = -1, validity2 = -1, cost3 = -1, validity3 = -1, cost4 = -1, validity4 = -1, cost5 = -1, validity5 = -1 where rateid = 40");
                    pstmt.setInt(1, gc);
                    pstmt.execute();
                    user.varSet("gascost!", "");
                }
                catch (Exception e4) {
                    user.varSet("gascost!", "");
                }
            }
        }
        try {
            if (ec != 0 || wc != 0 || gc != 0) {
                PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(schedulerFile, true)));
                if (ec != 0) {
                    out.println("wsm_electricity;0;true;*;*;*;*;*;0;0;false;true");
                }
                if (wc != 0) {
                    out.println("wsm_water;0;true;*;*;*;*;*;0;0;false;true");
                }
                if (gc != 0) {
                    out.println("wsm_gas;0;true;*;*;*;*;*;0;0;false;true");
                }
                out.flush();
                out.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static boolean isValidDate(String date) {
        try {
            GregorianCalendar cal = new GregorianCalendar();
            cal.setLenient(false);
            if (date.startsWith("*")) {
                cal.set(1, Integer.parseInt(date.substring(1, 5)));
                cal.set(2, Integer.parseInt(date.substring(5, 7)) - 1);
                cal.set(5, Integer.parseInt(date.substring(7)));
            } else {
                cal.set(1, Integer.parseInt(date.substring(0, 4)));
                cal.set(2, Integer.parseInt(date.substring(4, 6)) - 1);
                cal.set(5, Integer.parseInt(date.substring(6)));
            }
            cal.getTimeInMillis();
            return true;
        }
        catch (Exception e2) {
            return false;
        }
    }

    static boolean isValidTime(String time) {
        try {
            int hour = Integer.parseInt(time.substring(0, 2));
            int minute = Integer.parseInt(time.substring(2));
            return hour >= 0 && hour <= 23 && minute >= 0 && minute <= 59;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    static boolean isValidDow(String dow) {
        try {
            int l2 = dow.length();
            if (l2 > 0 && l2 < 8) {
                int i2 = 0;
                while (i2 < l2) {
                    char c2 = dow.charAt(i2);
                    if (c2 < '1' || c2 > '7') {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    static Calendar getBeginDate() {
        Calendar c2 = Calendar.getInstance();
        c2.setTimeInMillis(System.currentTimeMillis() - DataProcessor.T2);
        return c2;
    }

    private static String trimComments(String line) {
        String tline = line.trim();
        StringBuffer sb = new StringBuffer();
        int state = 0;
        boolean trim = false;
        int i2 = 0;
        while (i2 < tline.length() && !trim) {
            char c2 = tline.charAt(i2);
            switch (c2) {
                case '\"': {
                    sb.append(c2);
                    state = state == 0 ? 2 : 0;
                    break;
                }
                case '#': {
                    if (state == 2) {
                        sb.append(c2);
                        break;
                    }
                    trim = true;
                    break;
                }
                default: {
                    sb.append(c2);
                }
            }
            ++i2;
        }
        return sb.toString().trim();
    }

    private static Calendar toCalendar(int year, int month, int day, int hour) {
        GregorianCalendar cal = new GregorianCalendar();
        try {
            cal.setLenient(false);
            cal.set(1, year);
            cal.set(2, month - 1);
            cal.set(5, day);
            cal.set(11, hour);
            cal.set(12, 0);
            cal.set(13, 0);
            return cal;
        }
        catch (Exception e2) {
            return null;
        }
    }
}

