/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import plugins.wsmeasure.CONTREL;
import plugins.wsmeasure.CS;
import plugins.wsmeasure.Charge;
import plugins.wsmeasure.DMX3;
import plugins.wsmeasure.DPX3;
import plugins.wsmeasure.DX3;
import plugins.wsmeasure.EMDX3;
import plugins.wsmeasure.EMS;
import plugins.wsmeasure.ENTES;
import plugins.wsmeasure.F4;
import plugins.wsmeasure.GatewayCache;
import plugins.wsmeasure.IME;
import plugins.wsmeasure.Polling;
import plugins.wsmeasure.SensorCache;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChargeController {
    public static int[] iload;
    public static int[] imode;
    public static Hashtable<Integer, Charge> chargeCache;
    public static int EQChargeId;
    private static int clockSyncHour;
    private static PreparedStatement cschargesinsertstmt;
    private static PreparedStatement csstatinsertstmt;
    private static PreparedStatement csstateinsertstmt;

    static {
        imode = new int[4];
        chargeCache = new Hashtable();
        EQChargeId = -1;
        clockSyncHour = -1;
    }

    public static void init() {
        try {
            cschargesinsertstmt = user.databaseConnection.prepareStatement("insert into cscharges (time, sensorid, side, plug, chargeid, userid, intime, outtime, avgcurrent, peakcurrent, chgtime, waittime, p3p, pmpf, phwer, phwenr, pevle, pevde, pevce, pevcpe, pevo, pdle, pdce, pdo, poe) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            csstatinsertstmt = user.databaseConnection.prepareStatement("insert into csstat (time, sensorid, totnumcharges, totavgcurrent, totpeakcurrent, totchgtime, totwaittime) values (?, ?, ?, ?, ?, ?, ?)");
            csstateinsertstmt = user.databaseConnection.prepareStatement("insert into csstate (time, sensorid, plug, state, userid, \"CURRENT\", avgcurrent, peakcurrent, chgtime, waittime, p3p, pmpf, phwer, phwenr, pevle, pevde, pevce, pevcpe, pevo, pdle, pdce, pdo, poe) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        }
        catch (Exception e2) {
            user.errorLog("CHARGECONTROLLER: INITIALIZATION ERROR - SYSTEM RESTARTING NOW");
            user.sleep(5000L);
            System.exit(2);
        }
        user.schedulerRegister("charge_controller", "controller", 10000);
        user.schedulerRegister("charge_controller", "logger", 900000);
        user.schedulerRegister("charge_controller", "eqlogger", 10000);
    }

    public static void controller() {
        int imaxchg;
        int imax;
        int commerrorlimit = 3;
        int commerrorskipseconds = 900;
        long now = System.currentTimeMillis();
        if (user.greenUpControl) {
            imax = user.greenUpCurrentMaxAvailable;
            imaxchg = user.greenUpCurrentMaxAvailableCharging;
        } else {
            imax = Integer.MAX_VALUE;
            imaxchg = Integer.MAX_VALUE;
        }
        int ihyst = user.greenUpCurrentHysteresis;
        int mgcq = user.greenUpChargeQuantityMinimum;
        int mwt = user.greenUpHoldTimeMinimum;
        int reduction1 = user.greenUpCurrentFirstReduction;
        int reduction2 = user.greenUpCurrentSecondReduction;
        try {
            commerrorlimit = Integer.parseInt(user.varGet("greenupcontrolcommerrorlimit"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            commerrorskipseconds = Integer.parseInt(user.varGet("greenupcontrolcommerrorskipseconds"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        int hour = Calendar.getInstance().get(11);
        if (hour != clockSyncHour) {
            clockSyncHour = hour;
            ChargeController.syncClocks();
        }
        iload = ChargeController.readLoad();
        ChargeController.imode[0] = 0;
        int i2 = 1;
        while (i2 < 4) {
            ChargeController.imode[i2] = (double)iload[i2 - 1] * (1.0 + (double)ihyst / 200.0) <= (double)imaxchg ? 0 : ((double)iload[i2 - 1] * (1.0 - (double)ihyst / 200.0) <= (double)imax ? 1 : 2);
            if (imode[0] < imode[i2]) {
                ChargeController.imode[0] = imode[i2];
            }
            ++i2;
        }
        StringBuffer statusmessage = new StringBuffer("CHARGECONTROLLER: MODES: [");
        statusmessage.append(imode[0]);
        statusmessage.append(",");
        statusmessage.append(imode[1]);
        statusmessage.append(",");
        statusmessage.append(imode[2]);
        statusmessage.append(",");
        statusmessage.append(imode[3]);
        statusmessage.append("] - LOADS: [");
        statusmessage.append(iload[0]);
        statusmessage.append(",");
        statusmessage.append(iload[1]);
        statusmessage.append(",");
        statusmessage.append(iload[2]);
        statusmessage.append("]");
        if (!user.greenUpLogic) {
            statusmessage.append(" SKIP");
        }
        user.messageLog(statusmessage.toString());
        try {
            Charge charge;
            Enumeration<Integer> ge = Polling.gatewayCache.keys();
            while (ge.hasMoreElements()) {
                GatewayCache gw = Polling.gatewayCache.get(ge.nextElement());
                if (!gw.enabled) continue;
                int i3 = 0;
                while (i3 < gw.sensors.length) {
                    block143: {
                        SensorCache sensor = gw.sensors[i3];
                        if (sensor != null && sensor.enabled && user.isGreenUpModel(sensor.modelid) && ((charge = chargeCache.get(sensor.sensorid)) == null || now > charge.errorskiptime)) {
                            try {
                                Hashtable<String, String> stationState;
                                if (charge == null) {
                                    charge = new Charge(sensor.sensorid);
                                    chargeCache.put(sensor.sensorid, charge);
                                    charge.setPriority(sensor.priority);
                                    charge.chargeid = CS.readChargeHistId(sensor);
                                }
                                int n2 = charge.phase = sensor.loadid == -1 ? 0 : sensor.loadid;
                                if (charge.chargeid != CS.readChargeHistId(sensor)) {
                                    Hashtable<String, String> chargeHistData = CS.readChargeHistData(sensor);
                                    ChargeController.cschargesSave(sensor, chargeHistData);
                                    charge.chargeid = Long.parseLong(chargeHistData.get("chargeid"));
                                }
                                if ("1".equals((stationState = CS.readStationState(sensor)).get("power"))) {
                                    int level;
                                    String errorstate;
                                    Hashtable<String, String> stationCharge;
                                    String chargestate;
                                    if ("1".equals(stationState.get("mode"))) {
                                        charge.managed = true;
                                        if (charge.ichg[0] == 0) {
                                            charge.ichg[0] = CS.readRatedCurrent(sensor) / 1000;
                                            charge.ichg[1] = (int)((float)charge.ichg[0] * ((float)reduction1 / 100.0f));
                                            charge.ichg[2] = (int)((float)charge.ichg[0] * ((float)reduction2 / 100.0f));
                                        }
                                        if (!(chargestate = (stationCharge = CS.readStationCharge(sensor, false)).get("status")).equals(charge.state)) {
                                            charge.setState(chargestate);
                                        }
                                        if (!(errorstate = stationCharge.get("errors")).equals(charge.erorrs)) {
                                            charge.setStateErrors("1".equals(errorstate));
                                        }
                                        if ("true".equals(stationCharge.get("chgreq"))) {
                                            charge.chargeskiptime = 0L;
                                            charge.chargeauthorizationtime = 0L;
                                            charge.chargeqtime = 0L;
                                            charge.chargeq = 0L;
                                            charge.setPriority(sensor.priority);
                                            if (!CS.writeMode(sensor, charge.priority)) {
                                                user.errorLog("CHARGECONTROLLER: PRIORITY WRITE ERROR [" + sensor.sensorid + "]");
                                            }
                                            if (!CS.writeCurrentLevels(sensor, reduction1, reduction2)) {
                                                user.errorLog("CHARGECONTROLLER: CURRENT LEVELS WRITE ERROR [" + sensor.sensorid + "]");
                                            } else if ("ev".equals(stationCharge.get("plug"))) {
                                                charge.plug = 0;
                                                if (user.greenUpLogic) {
                                                    user.messageLog("CHARGECONTROLLER: DENY EV/DOM CHARGE AUTHORIZATION [0001] [" + sensor.sensorid + "]");
                                                    if (!CS.writeChargeAuthorization(sensor, true, false)) {
                                                        user.errorLog("CHARGECONTROLLER: DENY EV CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                                                    }
                                                    if (!CS.writeChargeAuthorization(sensor, false, false)) {
                                                        user.errorLog("CHARGECONTROLLER: DENY DOM CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                                                    }
                                                }
                                            } else if ("dom".equals(stationCharge.get("plug"))) {
                                                charge.plug = 1;
                                                charge.throttle = 0;
                                                if (user.greenUpLogic) {
                                                    user.messageLog("CHARGECONTROLLER: DENY EV/DOM CHARGE AUTHORIZATION [0002] [" + sensor.sensorid + "]");
                                                    if (!CS.writeChargeAuthorization(sensor, true, false)) {
                                                        user.errorLog("CHARGECONTROLLER: DENY EV CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                                                    }
                                                    if (!CS.writeChargeAuthorization(sensor, false, false)) {
                                                        user.errorLog("CHARGECONTROLLER: DENY DOM CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                                                    }
                                                }
                                            }
                                        } else if ("wait".equals(chargestate)) {
                                            charge.chargeqtime = 0L;
                                            charge.chargeq = 0L;
                                            if (charge.chargeauthorizationtime != 0L && now - charge.chargeauthorizationtime > (long)(user.greenUpMaxWaitingTimeSeconds * 1000)) {
                                                charge.chargeskiptime = now + (long)(user.greenUpChargeSkipOnWaitTimeSeconds * 1000);
                                                if ("ev".equals(stationCharge.get("plug"))) {
                                                    charge.plug = 0;
                                                    if (user.greenUpLogic) {
                                                        user.messageLog("CHARGECONTROLLER: DENY EV/DOM CHARGE AUTHORIZATION [0021] [" + sensor.sensorid + "]");
                                                        if (CS.writeChargeAuthorization(sensor, true, false)) {
                                                            charge.chargeauthorizationtime = 0L;
                                                        } else {
                                                            user.errorLog("CHARGECONTROLLER: DENY EV CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                                                        }
                                                        if (CS.writeChargeAuthorization(sensor, false, false)) {
                                                            charge.chargeauthorizationtime = 0L;
                                                        } else {
                                                            user.errorLog("CHARGECONTROLLER: DENY DOM CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                                                        }
                                                    }
                                                } else if ("dom".equals(stationCharge.get("plug"))) {
                                                    charge.plug = 1;
                                                    charge.throttle = 0;
                                                    if (user.greenUpLogic) {
                                                        user.messageLog("CHARGECONTROLLER: DENY EV/DOM CHARGE AUTHORIZATION [0022] [" + sensor.sensorid + "]");
                                                        if (CS.writeChargeAuthorization(sensor, true, false)) {
                                                            charge.chargeauthorizationtime = 0L;
                                                        } else {
                                                            user.errorLog("CHARGECONTROLLER: DENY EV CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                                                        }
                                                        if (CS.writeChargeAuthorization(sensor, false, false)) {
                                                            charge.chargeauthorizationtime = 0L;
                                                        } else {
                                                            user.errorLog("CHARGECONTROLLER: DENY DOM CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                                                        }
                                                    }
                                                }
                                            }
                                        } else if ("charge".equals(chargestate)) {
                                            charge.chargeq = charge.chargeqtime != 0L ? (charge.chargeq += (long)charge.ichg[charge.throttle] * (now - charge.chargeqtime) / 1000L) : 0L;
                                            charge.chargeqtime = now;
                                            charge.chargeskiptime = 0L;
                                            charge.chargeauthorizationtime = 0L;
                                            if (charge.plug == 0 && (level = CS.readChargeLevel(sensor)) != charge.throttle) {
                                                charge.throttle = level;
                                                charge.throttletime = System.currentTimeMillis();
                                            }
                                        } else if ("available".equals(chargestate)) {
                                            charge.chargeskiptime = 0L;
                                            charge.chargeauthorizationtime = 0L;
                                            charge.setPriority(sensor.priority);
                                        }
                                    } else {
                                        charge.managed = false;
                                        if (charge.ichg[0] == 0) {
                                            charge.ichg[0] = CS.readRatedCurrent(sensor) / 1000;
                                            charge.ichg[1] = (int)((float)charge.ichg[0] * ((float)reduction1 / 100.0f));
                                            charge.ichg[2] = (int)((float)charge.ichg[0] * ((float)reduction2 / 100.0f));
                                        }
                                        if (!(chargestate = (stationCharge = CS.readStationCharge(sensor, false)).get("status")).equals(charge.state)) {
                                            charge.setState(chargestate);
                                        }
                                        if (!(errorstate = stationCharge.get("errors")).equals(charge.erorrs)) {
                                            charge.setStateErrors("1".equals(errorstate));
                                        }
                                        if ("true".equals(stationCharge.get("chgreq"))) {
                                            charge.chargeqtime = 0L;
                                            charge.chargeq = 0L;
                                            charge.setPriority(sensor.priority);
                                            if ("ev".equals(stationCharge.get("plug"))) {
                                                charge.plug = 0;
                                            } else if ("dom".equals(stationCharge.get("plug"))) {
                                                charge.plug = 1;
                                                charge.throttle = 0;
                                            }
                                        } else if ("charge".equals(chargestate)) {
                                            charge.chargeq = charge.chargeqtime != 0L ? (charge.chargeq += (long)charge.ichg[charge.throttle] * (now - charge.chargeqtime) / 1000L) : 0L;
                                            charge.chargeqtime = now;
                                            if (charge.plug == 0 && (level = CS.readChargeLevel(sensor)) != charge.throttle) {
                                                charge.throttle = level;
                                                charge.throttletime = System.currentTimeMillis();
                                            }
                                        } else if ("wait".equals(chargestate)) {
                                            charge.chargeqtime = 0L;
                                            charge.chargeq = 0L;
                                        } else if ("available".equals(chargestate)) {
                                            charge.setPriority(sensor.priority);
                                        }
                                    }
                                }
                                Polling.sensorErrorFlag(sensor, false);
                                if (charge.errorcounter != 0) {
                                    charge.errorcounter = 0;
                                    user.messageLog("CHARGECONTROLLER: COMMUNICATION RESTORED [" + sensor.sensorid + "]");
                                }
                            }
                            catch (Exception e2) {
                                user.errorLog("CHARGECONTROLLER: COMMUNICATION ERROR [" + sensor.sensorid + "]");
                                Polling.sensorErrorFlag(sensor, true);
                                ++charge.errorcounter;
                                if (charge.errorcounter < commerrorlimit) break block143;
                                charge.errorskiptime = now + (long)(commerrorskipseconds * 1000);
                            }
                        }
                    }
                    ++i3;
                }
            }
            boolean[] priorityChargeQueue = new boolean[4];
            boolean[] normalChargeQueue = new boolean[4];
            int p = 0;
            while (p <= 3) {
                if (imode[p] == 0 || imode[p] == 1) {
                    long firstwaittime = Long.MAX_VALUE;
                    Charge firstwaitcharge = null;
                    boolean prioritywaitcharge = false;
                    Enumeration<Charge> e3 = chargeCache.elements();
                    while (e3.hasMoreElements()) {
                        charge = e3.nextElement();
                        SensorCache sensor = Polling.sensorCache.get(charge.sensorid);
                        GatewayCache gateway = Polling.gatewayCache.get(sensor.gatewayid);
                        if (!sensor.enabled || !gateway.enabled) {
                            user.varSet("$chargecontroller." + charge.sensorid + ".state", "disabled");
                            continue;
                        }
                        user.varSet("$chargecontroller." + charge.sensorid + ".state", charge.state);
                        user.varSet("$chargecontroller." + charge.sensorid + ".chargeauthorizationtime", Long.toString(charge.chargeauthorizationtime));
                        user.varSet("$chargecontroller." + charge.sensorid + ".chargeskiptime", Long.toString(charge.chargeskiptime));
                        if (!charge.managed || now <= charge.chargeskiptime || now <= charge.errorskiptime || (normalChargeQueue[0] || priorityChargeQueue[0]) && !charge.priority && charge.phase != 0 || charge.phase != p || !"wait".equals(charge.state) || charge.chargesteps != 0 && now - charge.statetime <= (long)(mwt * 1000)) continue;
                        if (prioritywaitcharge == charge.priority) {
                            if (charge.statetime >= firstwaittime) continue;
                            firstwaittime = charge.statetime;
                            firstwaitcharge = charge;
                            continue;
                        }
                        if (prioritywaitcharge || !charge.priority) continue;
                        firstwaittime = charge.statetime;
                        firstwaitcharge = charge;
                        prioritywaitcharge = true;
                    }
                    if (firstwaitcharge != null) {
                        SensorCache sensor;
                        if (firstwaitcharge.plug == 0) {
                            if (imode[p] == 0 && ChargeController.checkCurrentLimit(p, firstwaitcharge.ichg[0], imax)) {
                                sensor = Polling.sensorCache.get(firstwaitcharge.sensorid);
                                if (user.greenUpLogic) {
                                    CS.writeChargeLevel(sensor, 0);
                                    user.messageLog("CHARGECONTROLLER: GRANT EV CHARGE AUTHORIZATION [0003] [" + sensor.sensorid + "]");
                                    CS.writeChargeAuthorization(sensor, true, true);
                                    if (firstwaitcharge.chargeauthorizationtime == 0L) {
                                        firstwaitcharge.chargeauthorizationtime = now;
                                        firstwaitcharge.chargeskiptime = 0L;
                                    }
                                }
                                ChargeController.sensorStateGUIRefresh(sensor);
                                return;
                            }
                            if (imode[p] == 0 && ChargeController.checkCurrentLimit(p, firstwaitcharge.ichg[1], imax)) {
                                sensor = Polling.sensorCache.get(firstwaitcharge.sensorid);
                                if (user.greenUpLogic) {
                                    CS.writeChargeLevel(sensor, 1);
                                    user.messageLog("CHARGECONTROLLER: GRANT EV CHARGE AUTHORIZATION [0004] [" + sensor.sensorid + "]");
                                    CS.writeChargeAuthorization(sensor, true, true);
                                    if (firstwaitcharge.chargeauthorizationtime == 0L) {
                                        firstwaitcharge.chargeauthorizationtime = now;
                                        firstwaitcharge.chargeskiptime = 0L;
                                    }
                                }
                                ChargeController.sensorStateGUIRefresh(sensor);
                                return;
                            }
                            if (imode[p] == 0 && ChargeController.checkCurrentLimit(p, firstwaitcharge.ichg[2], imax)) {
                                sensor = Polling.sensorCache.get(firstwaitcharge.sensorid);
                                if (user.greenUpLogic) {
                                    CS.writeChargeLevel(sensor, 2);
                                    user.messageLog("CHARGECONTROLLER: GRANT EV CHARGE AUTHORIZATION [0005] [" + sensor.sensorid + "]");
                                    CS.writeChargeAuthorization(sensor, true, true);
                                    if (firstwaitcharge.chargeauthorizationtime == 0L) {
                                        firstwaitcharge.chargeauthorizationtime = now;
                                        firstwaitcharge.chargeskiptime = 0L;
                                    }
                                }
                                ChargeController.sensorStateGUIRefresh(sensor);
                                return;
                            }
                            if (prioritywaitcharge) {
                                priorityChargeQueue[p] = true;
                                if (p == 0) {
                                    priorityChargeQueue[0] = true;
                                }
                            } else {
                                normalChargeQueue[p] = true;
                                if (p == 0) {
                                    normalChargeQueue[0] = true;
                                }
                            }
                        } else {
                            if (imode[p] == 0 && ChargeController.checkCurrentLimit(p, 16, imax)) {
                                sensor = Polling.sensorCache.get(firstwaitcharge.sensorid);
                                if (user.greenUpLogic) {
                                    CS.writeChargeLevel(sensor, 0);
                                    user.messageLog("CHARGECONTROLLER: GRANT DOM CHARGE AUTHORIZATION [0006] [" + sensor.sensorid + "]");
                                    CS.writeChargeAuthorization(sensor, false, true);
                                    if (firstwaitcharge.chargeauthorizationtime == 0L) {
                                        firstwaitcharge.chargeauthorizationtime = now;
                                        firstwaitcharge.chargeskiptime = 0L;
                                    }
                                }
                                ChargeController.sensorStateGUIRefresh(sensor);
                                return;
                            }
                            if (prioritywaitcharge) {
                                priorityChargeQueue[p] = true;
                                if (p == 0) {
                                    priorityChargeQueue[0] = true;
                                }
                            } else {
                                normalChargeQueue[p] = true;
                                if (p == 0) {
                                    normalChargeQueue[0] = true;
                                }
                            }
                        }
                    } else if (imode[p] == 0) {
                        long firstthrottletime = Long.MAX_VALUE;
                        Charge firstthrottlecharge = null;
                        boolean prioritythrottlecharge = false;
                        Enumeration<Charge> e4 = chargeCache.elements();
                        while (e4.hasMoreElements()) {
                            charge = e4.nextElement();
                            if (!charge.managed || now <= charge.errorskiptime || (normalChargeQueue[0] || priorityChargeQueue[0]) && !charge.priority && charge.phase != 0 || charge.phase != p || charge.plug != 0 || !"charge".equals(charge.state) || charge.throttle <= 0) continue;
                            if (!(prioritythrottlecharge ^ charge.priority)) {
                                if (charge.statetime >= firstthrottletime) continue;
                                firstthrottletime = charge.throttletime;
                                firstthrottlecharge = charge;
                                continue;
                            }
                            if (prioritythrottlecharge || !charge.priority) continue;
                            firstthrottletime = charge.throttletime;
                            firstthrottlecharge = charge;
                            prioritythrottlecharge = true;
                        }
                        if (firstthrottlecharge != null) {
                            int iup;
                            switch (firstthrottlecharge.throttle) {
                                case 1: {
                                    iup = firstthrottlecharge.ichg[0] - firstthrottlecharge.ichg[1];
                                    break;
                                }
                                case 2: {
                                    iup = firstthrottlecharge.ichg[1] - firstthrottlecharge.ichg[2];
                                    break;
                                }
                                default: {
                                    iup = 0;
                                }
                            }
                            if (ChargeController.checkCurrentLimit(p, iup, imax)) {
                                SensorCache sensor = Polling.sensorCache.get(firstthrottlecharge.sensorid);
                                if (user.greenUpLogic) {
                                    user.messageLog("CHARGECONTROLLER: THROTTLE UP LEVEL " + (firstthrottlecharge.throttle - 1) + " [0011] [" + sensor.sensorid + "]");
                                    CS.writeChargeLevel(sensor, firstthrottlecharge.throttle - 1);
                                }
                                ChargeController.sensorStateGUIRefresh(sensor);
                                return;
                            }
                        }
                    }
                }
                ++p;
            }
            p = 3;
            while (p >= 0) {
                SensorCache sensor;
                Charge[] redcharges = new Charge[6];
                long[] redtimes = new long[]{Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE, Long.MAX_VALUE};
                Enumeration<Charge> e5 = chargeCache.elements();
                while (e5.hasMoreElements()) {
                    charge = e5.nextElement();
                    if (!charge.managed || now <= charge.errorskiptime) continue;
                    SensorCache sensor2 = Polling.sensorCache.get(charge.sensorid);
                    GatewayCache gateway = Polling.gatewayCache.get(sensor2.gatewayid);
                    if (!sensor2.enabled || !gateway.enabled || !priorityChargeQueue[0] && !normalChargeQueue[0] && !priorityChargeQueue[p] && !normalChargeQueue[p] && imode[charge.phase] != 2 || charge.phase != 0 && charge.priority && (priorityChargeQueue[0] || normalChargeQueue[0]) || charge.phase != p || !"charge".equals(charge.state)) continue;
                    if (charge.priority) {
                        if (charge.plug == 0 && charge.throttle < 2) {
                            if (charge.throttletime >= redtimes[3]) continue;
                            redtimes[3] = charge.throttletime;
                            redcharges[3] = charge;
                            continue;
                        }
                        if (charge.chargeq > (long)(mgcq * 3600)) {
                            if (charge.statetime >= redtimes[4]) continue;
                            redtimes[4] = charge.statetime;
                            redcharges[4] = charge;
                            continue;
                        }
                        if (charge.statetime >= redtimes[5]) continue;
                        redtimes[5] = charge.statetime;
                        redcharges[5] = charge;
                        continue;
                    }
                    if (charge.plug == 0 && charge.throttle < 2) {
                        if (charge.throttletime >= redtimes[0]) continue;
                        redtimes[0] = charge.throttletime;
                        redcharges[0] = charge;
                        continue;
                    }
                    if (charge.chargeq > (long)(mgcq * 3600)) {
                        if (charge.statetime >= redtimes[1]) continue;
                        redtimes[1] = charge.statetime;
                        redcharges[1] = charge;
                        continue;
                    }
                    if (charge.statetime >= redtimes[2]) continue;
                    redtimes[2] = charge.statetime;
                    redcharges[2] = charge;
                }
                if (redcharges[0] != null) {
                    sensor = Polling.sensorCache.get(redcharges[0].sensorid);
                    if (user.greenUpLogic) {
                        user.messageLog("CHARGECONTROLLER: THROTTLE DOWN LEVEL " + (redcharges[0].throttle + 1) + " [0012] [" + sensor.sensorid + "]");
                        if (!CS.writeChargeLevel(sensor, redcharges[0].throttle + 1)) {
                            user.errorLog("CHARGECONTROLLER: THROTTLE WRITE ERROR [" + sensor.sensorid + "]");
                        }
                    }
                    ChargeController.sensorStateGUIRefresh(sensor);
                    return;
                }
                if (redcharges[1] != null) {
                    sensor = Polling.sensorCache.get(redcharges[1].sensorid);
                    if (user.greenUpLogic) {
                        boolean ev = redcharges[1].plug == 0;
                        user.messageLog("CHARGECONTROLLER: DENY " + (ev ? "EV" : "DOM") + " CHARGE AUTHORIZATION [0007] [" + sensor.sensorid + "]");
                        if (CS.writeChargeAuthorization(Polling.sensorCache.get(redcharges[1].sensorid), ev, false)) {
                            redcharges[1].chargeauthorizationtime = 0L;
                        } else {
                            user.errorLog("CHARGECONTROLLER: DENY EV CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                        }
                    }
                    ChargeController.sensorStateGUIRefresh(sensor);
                    return;
                }
                if (redcharges[2] != null && (priorityChargeQueue[p] || imode[p] == 2)) {
                    sensor = Polling.sensorCache.get(redcharges[2].sensorid);
                    if (user.greenUpLogic) {
                        boolean ev = redcharges[2].plug == 0;
                        user.messageLog("CHARGECONTROLLER: DENY " + (ev ? "EV" : "DOM") + " CHARGE AUTHORIZATION [0008] [" + sensor.sensorid + "]");
                        if (CS.writeChargeAuthorization(Polling.sensorCache.get(redcharges[2].sensorid), ev, false)) {
                            redcharges[2].chargeauthorizationtime = 0L;
                        } else {
                            user.errorLog("CHARGECONTROLLER: DENY EV CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                        }
                    }
                    ChargeController.sensorStateGUIRefresh(sensor);
                    return;
                }
                if (redcharges[3] != null && (priorityChargeQueue[p] || imode[p] == 2)) {
                    sensor = Polling.sensorCache.get(redcharges[3].sensorid);
                    if (user.greenUpLogic) {
                        user.messageLog("CHARGECONTROLLER: THROTTLE DOWN LEVEL " + (redcharges[3].throttle + 1) + " [0013] [" + sensor.sensorid + "]");
                        if (CS.writeChargeLevel(sensor, redcharges[3].throttle + 1)) {
                            redcharges[3].chargeauthorizationtime = 0L;
                        } else {
                            user.errorLog("CHARGECONTROLLER: THROTTLE WRITE ERROR [" + sensor.sensorid + "]");
                        }
                    }
                    ChargeController.sensorStateGUIRefresh(sensor);
                    return;
                }
                if (redcharges[4] != null && (priorityChargeQueue[p] || imode[p] == 2)) {
                    sensor = Polling.sensorCache.get(redcharges[4].sensorid);
                    if (user.greenUpLogic) {
                        boolean ev = redcharges[4].plug == 0;
                        user.messageLog("CHARGECONTROLLER: DENY " + (ev ? "EV" : "DOM") + " CHARGE AUTHORIZATION [0009] [" + sensor.sensorid + "]");
                        if (CS.writeChargeAuthorization(Polling.sensorCache.get(redcharges[4].sensorid), ev, false)) {
                            redcharges[4].chargeauthorizationtime = 0L;
                        } else {
                            user.errorLog("CHARGECONTROLLER: DENY EV CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                        }
                    }
                    ChargeController.sensorStateGUIRefresh(sensor);
                    return;
                }
                if (redcharges[5] != null && imode[p] == 2) {
                    sensor = Polling.sensorCache.get(redcharges[5].sensorid);
                    if (user.greenUpLogic) {
                        boolean ev = redcharges[5].plug == 0;
                        user.messageLog("CHARGECONTROLLER: DENY " + (ev ? "EV" : "DOM") + " CHARGE AUTHORIZATION [0010] [" + sensor.sensorid + "]");
                        if (CS.writeChargeAuthorization(Polling.sensorCache.get(redcharges[5].sensorid), ev, false)) {
                            redcharges[5].chargeauthorizationtime = 0L;
                        } else {
                            user.errorLog("CHARGECONTROLLER: DENY EV CHARGE AUTHORIZATION WRITE ERROR [" + sensor.sensorid + "]");
                        }
                    }
                    ChargeController.sensorStateGUIRefresh(sensor);
                    return;
                }
                --p;
            }
        }
        catch (Exception e6) {
            user.errorLog("CHARGECONTROLLER: MAIN LOOP EXCEPTION (" + e6.getLocalizedMessage() + ")");
        }
    }

    private static void sensorStateGUIRefresh(SensorCache sensor) {
        try {
            Hashtable<String, String> stationCharge = CS.readStationCharge(sensor, false);
            String state = stationCharge.get("status");
            if ("charge".equals(state)) {
                user.uiSet("xchg.s" + sensor.sensorid, "text", "c");
            } else if ("wait".equals(state)) {
                user.uiSet("xchg.s" + sensor.sensorid, "text", "w");
            } else if ("available".equals(state)) {
                user.uiSet("xchg.s" + sensor.sensorid, "text", "a");
            } else if ("idle".equals(state)) {
                user.uiSet("xchg.s" + sensor.sensorid, "text", "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void logger(boolean eq) {
        if (eq) {
            if (EQChargeId != -1) {
                try {
                    SensorCache sensor = Polling.sensorCache.get(EQChargeId);
                    if (sensor.enabled && user.isGreenUpModel(sensor.modelid) && Polling.gatewayCache.get((Object)Integer.valueOf((int)sensor.gatewayid)).enabled) {
                        ChargeController.stateLogger(sensor);
                    }
                }
                catch (Exception sensor) {}
            }
        } else {
            Enumeration<Integer> ge = Polling.gatewayCache.keys();
            while (ge.hasMoreElements()) {
                GatewayCache gw = Polling.gatewayCache.get(ge.nextElement());
                if (!gw.enabled) continue;
                int i2 = 0;
                while (i2 < gw.sensors.length) {
                    try {
                        SensorCache sensor = gw.sensors[i2];
                        if (sensor.enabled && user.isGreenUpModel(sensor.modelid)) {
                            ChargeController.statLogger(sensor);
                            ChargeController.stateLogger(sensor);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    ++i2;
                }
            }
        }
    }

    private static void statLogger(SensorCache sensor) {
        try {
            ChargeController.csstatSave(sensor, CS.readChargeStat(sensor));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void stateLogger(SensorCache sensor) {
        try {
            Hashtable<String, String> chargedata = CS.readStationCharge(sensor, false);
            Hashtable<String, String> chargeproperties = CS.readChargeProperties(sensor);
            ChargeController.csstateSave(sensor, chargedata, chargeproperties);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int[] readLoad() {
        int[] values = new int[3];
        int[] err = new int[3];
        try {
            SensorCache sensor = Polling.sensorCache.get(user.greenUpTotalMeterId);
            if (sensor != null && user.Models.elementAt(sensor.modelid)[2].length() > 0) {
                GatewayCache gateway = Polling.gatewayCache.get(sensor.gatewayid);
                if (sensor.enabled && gateway.enabled) {
                    switch (sensor.modelid) {
                        case 0: 
                        case 1: 
                        case 2: 
                        case 3: {
                            Hashtable<String, Integer> data = EMDX3.decodeVIF(EMDX3.readVIF(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                        case 4: 
                        case 5: {
                            Hashtable<String, Integer> data = IME.decodeVIF467x(IME.readVIF467x(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                        case 6: 
                        case 7: 
                        case 8: 
                        case 94: {
                            Hashtable<String, Integer> data = IME.decodeVIF468x(IME.readVIF468x(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                        case 9: 
                        case 18: 
                        case 19: {
                            Hashtable<String, Integer> data = IME.decodeVIF4686(IME.readVIF4686(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                        case 20: {
                            Hashtable<String, Integer> data = DMX3.decodeVIF(DMX3.readVIF(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1");
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2");
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3");
                            }
                            return values;
                        }
                        case 21: {
                            Hashtable<String, Integer> data = DPX3.decodeVIF(DPX3.readVIF(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1");
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2");
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3");
                            }
                            return values;
                        }
                        case 41: {
                            Hashtable<String, Integer> data = CONTREL.decodeVIF(CONTREL.readVIF(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                        case 42: {
                            Hashtable<String, Integer> data = DX3.decodeVIF(DX3.readVIF(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1");
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2");
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3");
                            }
                            return values;
                        }
                        case 44: 
                        case 45: 
                        case 46: 
                        case 92: 
                        case 93: {
                            Hashtable<String, Integer> data = F4.decodeVIFN200(F4.readVIFN200(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                        case 48: 
                        case 49: {
                            Hashtable<String, Integer> data = ENTES.decodeVIFMPR46S(ENTES.readVIFMPR46S(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                        case 62: {
                            Hashtable<String, Integer> data = EMS.decodeVIF(EMS.readVIF(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                        case 63: {
                            Hashtable<String, Integer> data = IME.decodeVIF412068(IME.readVIF412068(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 10;
                            }
                            return values;
                        }
                        case 136: {
                            Hashtable<String, Integer> data = IME.decodeVIFD4DC(IME.readVIFD4DC(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            return values;
                        }
                        case 141: {
                            Hashtable<String, Integer> data = IME.decodeVIFCE2DF(IME.readVIFCE2DF(sensor.gatewayaddress, sensor.address));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            return values;
                        }
                        case 145: {
                            Hashtable<String, Integer> data = IME.decodeVIFCE4DF(IME.readVIFCE4DF(sensor.gatewayaddress, sensor.address, false));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                        case 152: {
                            Hashtable<String, Integer> data = IME.decodeVIFCE4DF(IME.readVIFCE4DF(sensor.gatewayaddress, sensor.address, true));
                            if (data.containsKey("I1")) {
                                values[0] = data.get("I1") / 1000;
                            }
                            if (data.containsKey("I2")) {
                                values[1] = data.get("I2") / 1000;
                            }
                            if (data.containsKey("I3")) {
                                values[2] = data.get("I3") / 1000;
                            }
                            return values;
                        }
                    }
                    return err;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return err;
    }

    static void syncClocks() {
        Hashtable<String, SensorCache> stations = new Hashtable<String, SensorCache>();
        try {
            Enumeration<Integer> ge = Polling.gatewayCache.keys();
            while (ge.hasMoreElements()) {
                GatewayCache gw = Polling.gatewayCache.get(ge.nextElement());
                if (!gw.enabled) continue;
                int i2 = 0;
                while (i2 < gw.sensors.length) {
                    String key;
                    SensorCache sensor = gw.sensors[i2];
                    if (sensor.enabled && user.isGreenUpModel(sensor.modelid) && !stations.containsKey(key = String.valueOf(sensor.gatewayaddress) + " " + sensor.address)) {
                        stations.put(key, sensor);
                    }
                    ++i2;
                }
            }
            Enumeration se = stations.elements();
            while (se.hasMoreElements()) {
                CS.syncClock((SensorCache)se.nextElement());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static boolean checkCurrentLimit(int phase, int current, int max) {
        try {
            if (phase == 0) {
                int i2 = 0;
                while (i2 < 3) {
                    if (current + iload[i2] > max) {
                        return false;
                    }
                    ++i2;
                }
                return true;
            }
            return current + iload[phase - 1] <= max;
        }
        catch (Exception e2) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void cschargesSave(SensorCache sensor, Hashtable<String, String> data) {
        try {
            PreparedStatement preparedStatement = cschargesinsertstmt;
            synchronized (preparedStatement) {
                cschargesinsertstmt.setTimestamp(1, new Timestamp(new Date().getTime()));
                cschargesinsertstmt.setInt(2, sensor.sensorid);
                cschargesinsertstmt.setInt(3, CS.sensorToSideNumber(sensor));
                cschargesinsertstmt.setInt(4, "ev".equals(data.get("plug")) ? 0 : 1);
                cschargesinsertstmt.setLong(5, Long.parseLong(data.get("chargeid")));
                cschargesinsertstmt.setString(6, data.get("userid"));
                cschargesinsertstmt.setTimestamp(7, new Timestamp(Long.parseLong(data.get("intime"))));
                cschargesinsertstmt.setTimestamp(8, new Timestamp(Long.parseLong(data.get("outtime"))));
                cschargesinsertstmt.setInt(9, Integer.parseInt(data.get("avgcurrent")));
                cschargesinsertstmt.setInt(10, Integer.parseInt(data.get("peakcurrent")));
                cschargesinsertstmt.setInt(11, Integer.parseInt(data.get("chgtime")));
                cschargesinsertstmt.setInt(12, Integer.parseInt(data.get("waittime")));
                cschargesinsertstmt.setBoolean(13, "1".equals(data.get("3p")));
                cschargesinsertstmt.setBoolean(14, "1".equals(data.get("powerfail")));
                cschargesinsertstmt.setBoolean(15, "1".equals(data.get("rechwerror")));
                cschargesinsertstmt.setBoolean(16, "1".equals(data.get("fatalhwerror")));
                cschargesinsertstmt.setBoolean(17, "1".equals(data.get("evlockerror")));
                cschargesinsertstmt.setBoolean(18, "1".equals(data.get("evdisconnect")));
                cschargesinsertstmt.setBoolean(19, "1".equals(data.get("evchgcurrlimit")));
                cschargesinsertstmt.setBoolean(20, "1".equals(data.get("evcpfail")));
                cschargesinsertstmt.setBoolean(21, "1".equals(data.get("evoverheat")));
                cschargesinsertstmt.setBoolean(22, "1".equals(data.get("domlockerror")));
                cschargesinsertstmt.setBoolean(23, "1".equals(data.get("domchgcurrlimit")));
                cschargesinsertstmt.setBoolean(24, "1".equals(data.get("domoverheat")));
                cschargesinsertstmt.setBoolean(25, "1".equals(data.get("other")));
                cschargesinsertstmt.execute();
            }
        }
        catch (Exception e2) {
            user.errorLog("CHARGECONTROLLER: CSCHARGES WRITE ERROR [" + sensor.sensorid + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void csstatSave(SensorCache sensor, Hashtable<String, String> data) {
        try {
            PreparedStatement preparedStatement = csstatinsertstmt;
            synchronized (preparedStatement) {
                csstatinsertstmt.setTimestamp(1, new Timestamp(new Date().getTime()));
                csstatinsertstmt.setInt(2, sensor.sensorid);
                csstatinsertstmt.setLong(3, Long.parseLong(data.get("numcharges")));
                csstatinsertstmt.setInt(4, Integer.parseInt(data.get("avgcurrent")));
                csstatinsertstmt.setInt(5, Integer.parseInt(data.get("peakcurrent")));
                csstatinsertstmt.setLong(6, Long.parseLong(data.get("chgtime")));
                csstatinsertstmt.setLong(7, Long.parseLong(data.get("waittime")));
                csstatinsertstmt.execute();
            }
        }
        catch (Exception e2) {
            user.errorLog("CHARGECONTROLLER: CSSTAT WRITE ERROR [" + sensor.sensorid + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void csstateSave(SensorCache sensor, Hashtable<String, String> chargedata, Hashtable<String, String> chargeproperties) {
        try {
            PreparedStatement preparedStatement = csstateinsertstmt;
            synchronized (preparedStatement) {
                csstateinsertstmt.setTimestamp(1, new Timestamp(new Date().getTime()));
                csstateinsertstmt.setInt(2, sensor.sensorid);
                String s = chargedata.get("plug");
                if ("ev".equals(s)) {
                    csstateinsertstmt.setInt(3, 0);
                } else if ("dom".equals(s)) {
                    csstateinsertstmt.setInt(3, 1);
                } else {
                    csstateinsertstmt.setInt(3, -1);
                }
                s = chargedata.get("status");
                if ("charge".equals(s)) {
                    csstateinsertstmt.setInt(4, 3);
                } else if ("wait".equals(s)) {
                    csstateinsertstmt.setInt(4, 2);
                } else if ("error".equals(s)) {
                    csstateinsertstmt.setInt(4, 1);
                } else {
                    csstateinsertstmt.setInt(4, 0);
                }
                csstateinsertstmt.setString(5, chargeproperties.get("userid"));
                csstateinsertstmt.setInt(6, Integer.parseInt(chargedata.get("instcurrent")));
                csstateinsertstmt.setInt(7, Integer.parseInt(chargedata.get("avgcurrent")));
                csstateinsertstmt.setInt(8, Integer.parseInt(chargedata.get("peakcurrent")));
                csstateinsertstmt.setInt(9, Integer.parseInt(chargedata.get("chgtime")));
                csstateinsertstmt.setInt(10, Integer.parseInt(chargedata.get("waitingtime")));
                csstateinsertstmt.setBoolean(11, "1".equals(chargeproperties.get("3p")));
                csstateinsertstmt.setBoolean(12, "1".equals(chargeproperties.get("powerfail")));
                csstateinsertstmt.setBoolean(13, "1".equals(chargeproperties.get("rechwerror")));
                csstateinsertstmt.setBoolean(14, "1".equals(chargeproperties.get("fatalhwerror")));
                csstateinsertstmt.setBoolean(15, "1".equals(chargeproperties.get("evlockerror")));
                csstateinsertstmt.setBoolean(16, "1".equals(chargeproperties.get("evdisconnect")));
                csstateinsertstmt.setBoolean(17, "1".equals(chargeproperties.get("evchgcurrlimit")));
                csstateinsertstmt.setBoolean(18, "1".equals(chargeproperties.get("evcpfail")));
                csstateinsertstmt.setBoolean(19, "1".equals(chargeproperties.get("evoverheat")));
                csstateinsertstmt.setBoolean(20, "1".equals(chargeproperties.get("domlockerror")));
                csstateinsertstmt.setBoolean(21, "1".equals(chargeproperties.get("domchgcurrlimit")));
                csstateinsertstmt.setBoolean(22, "1".equals(chargeproperties.get("domoverheat")));
                csstateinsertstmt.setBoolean(23, "1".equals(chargeproperties.get("other")));
                csstateinsertstmt.execute();
            }
        }
        catch (Exception e2) {
            user.errorLog("CHARGECONTROLLER: CSSTATE WRITE ERROR [" + sensor.sensorid + "]");
        }
    }
}

