/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import com.hsyco.Modbus;
import java.io.IOException;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Hashtable;
import plugins.wsmeasure.ChargeController;
import plugins.wsmeasure.SensorCache;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CS {
    static final int REQSPREADTIME = 100;
    private static final byte[] PASSWORD = new byte[]{70, 65, 48, 48};

    public static Hashtable<String, String> readStationState(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readDiscreteInputs(sensor.gatewayaddress, sensor.address, 45056, 2);
            if (data[0] != 2) {
                throw new IOException();
            }
            values.put("power", (data[2] & 1) != 0 ? "1" : "0");
            values.put("mode", (data[2] & 2) != 0 ? "1" : "0");
            Thread.sleep(100L);
            data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45056, 2);
            if (data[0] != 4) {
                throw new IOException();
            }
            values.put("generr", (data[3] & 1) != 0 ? "1" : "0");
            values.put("chgerr", (data[5] & 0x30) != 0 ? "1" : "0");
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readStationCharge(SensorCache sensor, boolean formatted) throws IOException {
        switch (sensor.modelid) {
            case 96: {
                return CS.readStationCharge96(sensor, formatted);
            }
            case 98: {
                return CS.readStationCharge98(sensor, formatted);
            }
            case 99: {
                return CS.readStationCharge99(sensor, formatted);
            }
            case 105: {
                return CS.readStationCharge105(sensor, formatted);
            }
        }
        return CS.readStationChargeLegacy(sensor, formatted);
    }

    public static Hashtable<String, String> readStationChargeLegacy(SensorCache sensor, boolean formatted) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        int side = CS.sensorToSideNumber(sensor);
        try {
            boolean plugged;
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, side == 1 ? 48128 : 48640, 1);
            if (data[0] == 4) {
                if ((data[3] & 4) != 0) {
                    values.put("plug", "ev");
                    plugged = true;
                } else if ((data[3] & 0x40) != 0) {
                    values.put("plug", "dom");
                    plugged = true;
                } else {
                    values.put("plug", "none");
                    plugged = false;
                }
            } else {
                throw new IOException();
            }
            Thread.sleep(100L);
            data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45056, 2);
            if (data[0] == 4) {
                if (side == 1) {
                    values.put("chgreq", (data[3] & 2) == 0 ? "false" : "true");
                    if ((data[3] & 8) != 0) {
                        values.put("status", "charge");
                    } else if ((data[3] & 0x10) != 0) {
                        values.put("status", "wait");
                    } else {
                        values.put("status", plugged ? "idle" : "available");
                    }
                    values.put("errors", (data[5] & 0x10) != 0 || (data[3] & 1) != 0 ? "1" : "0");
                } else {
                    values.put("chgreq", (data[3] & 0x20) == 0 ? "false" : "true");
                    if ((data[3] & 0x80) != 0) {
                        values.put("status", "charge");
                    } else if ((data[2] & 1) != 0) {
                        values.put("status", "wait");
                    } else {
                        values.put("status", plugged ? "idle" : "available");
                    }
                    values.put("errors", (data[5] & 0x20) != 0 || (data[3] & 1) != 0 ? "1" : "0");
                }
            } else {
                throw new IOException();
            }
            Thread.sleep(100L);
            data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, side == 1 ? 48131 : 48643, 9);
            if (data[0] == 4) {
                if (formatted) {
                    values.put("instcurrent", CS.numberFormat(CS.decodeInteger(data, 2, 2, false).intValue(), 4, 2, false));
                    values.put("avgcurrent", CS.numberFormat(CS.decodeInteger(data, 4, 2, false).intValue(), 4, 2, false));
                    values.put("peakcurrent", CS.numberFormat(CS.decodeInteger(data, 6, 2, false).intValue(), 4, 2, false));
                    values.put("chgtime", CS.timeFormat(CS.decodeInteger(data, 8, 4, false).longValue()));
                    values.put("idletime", CS.timeFormat(CS.decodeInteger(data, 12, 4, false).longValue()));
                    values.put("waitingtime", CS.timeFormat(CS.decodeInteger(data, 16, 4, false).longValue()));
                } else {
                    values.put("instcurrent", Integer.toString(CS.decodeInteger(data, 2, 2, false).intValue()));
                    values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 4, 2, false).intValue()));
                    values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 6, 2, false).intValue()));
                    values.put("chgtime", Long.toString(CS.decodeInteger(data, 8, 4, false).longValue()));
                    values.put("idletime", Long.toString(CS.decodeInteger(data, 12, 4, false).longValue()));
                    values.put("waitingtime", Long.toString(CS.decodeInteger(data, 16, 4, false).longValue()));
                }
            } else {
                throw new IOException();
            }
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readStationCharge96(SensorCache sensor, boolean formatted) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Thread.sleep(100L);
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45056, 2);
            if (data[0] == 4) {
                boolean plugged;
                if ((data[2] & 2) != 0) {
                    values.put("plug", "ev");
                    plugged = true;
                } else {
                    values.put("plug", "none");
                    plugged = false;
                }
                values.put("chgreq", (data[3] & 2) == 0 ? "false" : "true");
                if ((data[3] & 4) != 0) {
                    values.put("status", "charge");
                } else if ((data[3] & 8) != 0) {
                    values.put("status", "wait");
                } else {
                    values.put("status", plugged ? "idle" : "available");
                }
            } else {
                throw new IOException();
            }
            values.put("errors", (data[5] & 0x10) != 0 || (data[5] & 0x20) != 0 || (data[3] & 1) != 0 ? "1" : "0");
            Thread.sleep(100L);
            data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45074, 15);
            if (data[0] == 4) {
                if (formatted) {
                    values.put("instcurrent", CS.numberFormat(CS.decodeInteger(data, 2, 2, false).intValue(), 4, 2, false));
                    values.put("avgcurrent", CS.numberFormat(CS.decodeInteger(data, 8, 2, false).intValue(), 4, 2, false));
                    values.put("peakcurrent", CS.numberFormat(CS.decodeInteger(data, 14, 2, false).intValue(), 4, 2, false));
                    values.put("chgtime", CS.timeFormat(CS.decodeInteger(data, 20, 4, false).longValue()));
                    values.put("idletime", CS.timeFormat(CS.decodeInteger(data, 24, 4, false).longValue()));
                    values.put("waitingtime", CS.timeFormat(CS.decodeInteger(data, 28, 4, false).longValue()));
                } else {
                    values.put("instcurrent", Integer.toString(CS.decodeInteger(data, 2, 2, false).intValue()));
                    values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 8, 2, false).intValue()));
                    values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 14, 2, false).intValue()));
                    values.put("chgtime", Long.toString(CS.decodeInteger(data, 20, 4, false).longValue()));
                    values.put("idletime", Long.toString(CS.decodeInteger(data, 24, 4, false).longValue()));
                    values.put("waitingtime", Long.toString(CS.decodeInteger(data, 28, 4, false).longValue()));
                }
            } else {
                throw new IOException();
            }
            Thread.sleep(100L);
            data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, 45064, 2);
            if (data[0] == 1) {
                switch (data[2] & 3) {
                    case 0: {
                        values.put("chglevel", "100");
                        break;
                    }
                    case 1: {
                        values.put("chglevel", Integer.toString(user.greenUpCurrentFirstReduction));
                        break;
                    }
                    default: {
                        values.put("chglevel", Integer.toString(user.greenUpCurrentSecondReduction));
                        break;
                    }
                }
            } else {
                throw new IOException();
            }
            values.put("mode", ChargeController.chargeCache.get((Object)Integer.valueOf((int)sensor.sensorid)).priority ? "priority" : "normal");
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readStationCharge98(SensorCache sensor, boolean formatted) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            Thread.sleep(100L);
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45056, 2);
            if (data[0] == 4) {
                boolean plugged;
                if ((data[2] & 2) != 0) {
                    values.put("plug", "ev");
                    plugged = true;
                } else {
                    values.put("plug", "none");
                    plugged = false;
                }
                values.put("chgreq", (data[3] & 2) == 0 ? "false" : "true");
                if ((data[3] & 4) != 0) {
                    values.put("status", "charge");
                } else if ((data[3] & 8) != 0) {
                    values.put("status", "wait");
                } else {
                    values.put("status", plugged ? "idle" : "available");
                }
            } else {
                throw new IOException();
            }
            values.put("errors", (data[5] & 0x10) != 0 || (data[5] & 0x20) != 0 || (data[3] & 1) != 0 ? "1" : "0");
            Thread.sleep(100L);
            data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45074, 15);
            if (data[0] == 4) {
                if (formatted) {
                    values.put("instcurrent", CS.numberFormat(CS.decodeInteger(data, 2, 2, false).intValue() + CS.decodeInteger(data, 4, 2, false).intValue() + CS.decodeInteger(data, 6, 2, false).intValue(), 4, 2, false));
                    values.put("avgcurrent", CS.numberFormat(CS.decodeInteger(data, 8, 2, false).intValue() + CS.decodeInteger(data, 10, 2, false).intValue() + CS.decodeInteger(data, 12, 2, false).intValue(), 4, 2, false));
                    values.put("peakcurrent", CS.numberFormat(CS.decodeInteger(data, 14, 2, false).intValue() + CS.decodeInteger(data, 16, 2, false).intValue() + CS.decodeInteger(data, 18, 2, false).intValue(), 4, 2, false));
                    values.put("chgtime", CS.timeFormat(CS.decodeInteger(data, 20, 4, false).longValue()));
                    values.put("idletime", CS.timeFormat(CS.decodeInteger(data, 24, 4, false).longValue()));
                    values.put("waitingtime", CS.timeFormat(CS.decodeInteger(data, 28, 4, false).longValue()));
                } else {
                    values.put("instcurrent", Integer.toString(CS.decodeInteger(data, 2, 2, false).intValue() + CS.decodeInteger(data, 4, 2, false).intValue() + CS.decodeInteger(data, 6, 2, false).intValue()));
                    values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 8, 2, false).intValue() + CS.decodeInteger(data, 10, 2, false).intValue() + CS.decodeInteger(data, 12, 2, false).intValue()));
                    values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 14, 2, false).intValue() + CS.decodeInteger(data, 16, 2, false).intValue() + CS.decodeInteger(data, 18, 2, false).intValue()));
                    values.put("chgtime", Long.toString(CS.decodeInteger(data, 20, 4, false).longValue()));
                    values.put("idletime", Long.toString(CS.decodeInteger(data, 24, 4, false).longValue()));
                    values.put("waitingtime", Long.toString(CS.decodeInteger(data, 28, 4, false).longValue()));
                }
            } else {
                throw new IOException();
            }
            Thread.sleep(100L);
            data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, 45064, 2);
            if (data[0] == 1) {
                switch (data[2] & 3) {
                    case 0: {
                        values.put("chglevel", "100");
                        break;
                    }
                    case 1: {
                        values.put("chglevel", Integer.toString(user.greenUpCurrentFirstReduction));
                        break;
                    }
                    default: {
                        values.put("chglevel", Integer.toString(user.greenUpCurrentSecondReduction));
                        break;
                    }
                }
            } else {
                throw new IOException();
            }
            values.put("mode", ChargeController.chargeCache.get((Object)Integer.valueOf((int)sensor.sensorid)).priority ? "priority" : "normal");
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable<String, String> readStationCharge99(SensorCache sensor, boolean formatted) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            boolean evplug;
            boolean plugged;
            Thread.sleep(100L);
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45056, 2);
            if (data[0] != 4) throw new IOException();
            if ((data[2] & 2) != 0) {
                values.put("plug", "ev");
                plugged = true;
                evplug = true;
            } else if ((data[2] & 0x20) != 0) {
                values.put("plug", "dom");
                plugged = true;
                evplug = false;
            } else {
                values.put("plug", "none");
                plugged = false;
                evplug = false;
            }
            values.put("chgreq", (data[3] & 2) == 0 ? "false" : "true");
            if ((data[3] & 4) != 0) {
                values.put("status", "charge");
            } else if ((data[3] & 8) != 0) {
                values.put("status", "wait");
            } else {
                values.put("status", plugged ? "idle" : "available");
            }
            values.put("errors", (data[5] & 0x10) != 0 || (data[5] & 0x20) != 0 || (data[3] & 1) != 0 ? "1" : "0");
            Thread.sleep(100L);
            data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45074, 15);
            if (data[0] != 4) throw new IOException();
            if (formatted) {
                values.put("instcurrent", CS.numberFormat(CS.decodeInteger(data, 2, 2, false).intValue(), 4, 2, false));
                values.put("avgcurrent", CS.numberFormat(CS.decodeInteger(data, 8, 2, false).intValue(), 4, 2, false));
                values.put("peakcurrent", CS.numberFormat(CS.decodeInteger(data, 14, 2, false).intValue(), 4, 2, false));
                values.put("chgtime", CS.timeFormat(CS.decodeInteger(data, 20, 4, false).longValue()));
                values.put("idletime", CS.timeFormat(CS.decodeInteger(data, 24, 4, false).longValue()));
                values.put("waitingtime", CS.timeFormat(CS.decodeInteger(data, 28, 4, false).longValue()));
            } else {
                values.put("instcurrent", Integer.toString(CS.decodeInteger(data, 2, 2, false).intValue()));
                values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 8, 2, false).intValue()));
                values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 14, 2, false).intValue()));
                values.put("chgtime", Long.toString(CS.decodeInteger(data, 20, 4, false).longValue()));
                values.put("idletime", Long.toString(CS.decodeInteger(data, 24, 4, false).longValue()));
                values.put("waitingtime", Long.toString(CS.decodeInteger(data, 28, 4, false).longValue()));
            }
            if (evplug) {
                Thread.sleep(100L);
                data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, 45064, 2);
                if (data[0] != 1) throw new IOException();
                switch (data[2] & 3) {
                    case 0: {
                        values.put("chglevel", "100");
                        break;
                    }
                    case 1: {
                        values.put("chglevel", Integer.toString(user.greenUpCurrentFirstReduction));
                        break;
                    }
                    default: {
                        values.put("chglevel", Integer.toString(user.greenUpCurrentSecondReduction));
                        break;
                    }
                }
            } else {
                values.put("chglevel", "100");
            }
            values.put("mode", ChargeController.chargeCache.get((Object)Integer.valueOf((int)sensor.sensorid)).priority ? "priority" : "normal");
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable<String, String> readStationCharge105(SensorCache sensor, boolean formatted) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            boolean evplug;
            boolean plugged;
            Thread.sleep(100L);
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45056, 2);
            if (data[0] != 4) throw new IOException();
            if ((data[2] & 2) != 0) {
                values.put("plug", "ev");
                plugged = true;
                evplug = true;
            } else if ((data[2] & 0x20) != 0) {
                values.put("plug", "dom");
                plugged = true;
                evplug = false;
            } else {
                values.put("plug", "none");
                plugged = false;
                evplug = false;
            }
            values.put("chgreq", (data[3] & 2) == 0 ? "false" : "true");
            if ((data[3] & 4) != 0) {
                values.put("status", "charge");
            } else if ((data[3] & 8) != 0) {
                values.put("status", "wait");
            } else {
                values.put("status", plugged ? "idle" : "available");
            }
            values.put("errors", (data[5] & 0x10) != 0 || (data[5] & 0x20) != 0 || (data[3] & 1) != 0 ? "1" : "0");
            Thread.sleep(100L);
            data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45074, 15);
            if (data[0] != 4) throw new IOException();
            if (formatted) {
                values.put("instcurrent", CS.numberFormat(CS.decodeInteger(data, 2, 2, false).intValue() + CS.decodeInteger(data, 4, 2, false).intValue() + CS.decodeInteger(data, 6, 2, false).intValue(), 4, 2, false));
                values.put("avgcurrent", CS.numberFormat(CS.decodeInteger(data, 8, 2, false).intValue() + CS.decodeInteger(data, 10, 2, false).intValue() + CS.decodeInteger(data, 12, 2, false).intValue(), 4, 2, false));
                values.put("peakcurrent", CS.numberFormat(CS.decodeInteger(data, 14, 2, false).intValue() + CS.decodeInteger(data, 16, 2, false).intValue() + CS.decodeInteger(data, 18, 2, false).intValue(), 4, 2, false));
                values.put("chgtime", CS.timeFormat(CS.decodeInteger(data, 20, 4, false).longValue()));
                values.put("idletime", CS.timeFormat(CS.decodeInteger(data, 24, 4, false).longValue()));
                values.put("waitingtime", CS.timeFormat(CS.decodeInteger(data, 28, 4, false).longValue()));
            } else {
                values.put("instcurrent", Integer.toString(CS.decodeInteger(data, 2, 2, false).intValue() + CS.decodeInteger(data, 4, 2, false).intValue() + CS.decodeInteger(data, 6, 2, false).intValue()));
                values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 8, 2, false).intValue() + CS.decodeInteger(data, 10, 2, false).intValue() + CS.decodeInteger(data, 12, 2, false).intValue()));
                values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 14, 2, false).intValue() + CS.decodeInteger(data, 16, 2, false).intValue() + CS.decodeInteger(data, 18, 2, false).intValue()));
                values.put("chgtime", Long.toString(CS.decodeInteger(data, 20, 4, false).longValue()));
                values.put("idletime", Long.toString(CS.decodeInteger(data, 24, 4, false).longValue()));
                values.put("waitingtime", Long.toString(CS.decodeInteger(data, 28, 4, false).longValue()));
            }
            if (evplug) {
                Thread.sleep(100L);
                data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, 45064, 2);
                if (data[0] != 1) throw new IOException();
                switch (data[2] & 3) {
                    case 0: {
                        values.put("chglevel", "100");
                        break;
                    }
                    case 1: {
                        values.put("chglevel", Integer.toString(user.greenUpCurrentFirstReduction));
                        break;
                    }
                    default: {
                        values.put("chglevel", Integer.toString(user.greenUpCurrentSecondReduction));
                        break;
                    }
                }
            } else {
                values.put("chglevel", "100");
            }
            values.put("mode", ChargeController.chargeCache.get((Object)Integer.valueOf((int)sensor.sensorid)).priority ? "priority" : "normal");
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readStationInfo(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                return CS.readStationInfo96_98_99_105(sensor);
            }
        }
        return CS.readStationInfoLegacy(sensor);
    }

    public static Hashtable<String, String> readStationInfoLegacy(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            if (sensor.modelid == 30) {
                byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45059, 14);
                if (data[0] == 4) {
                    values.put("ratedcurrent", CS.numberFormat(CS.decodeInteger(data, 4, 2, false).intValue(), 4, 2, false));
                    values.put("fw", CS.versionFormat(data, 10));
                    values.put("hw", CS.versionFormat(data, 6));
                    values.put("serial", CS.decodeString(data, 14, 16));
                    values.put("display", (data[3] & 1) != 0 ? "1" : "0");
                    values.put("2sides", (data[3] & 2) != 0 ? "1" : "0");
                    values.put("rfid", (data[3] & 4) != 0 ? "1" : "0");
                    values.put("evlock", (data[3] & 0x10) != 0 ? "1" : "0");
                    values.put("domlock", (data[3] & 8) != 0 ? "1" : "0");
                    return values;
                }
                throw new IOException();
            }
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45064, 14);
            if (data[0] == 4) {
                values.put("ratedcurrent", CS.numberFormat(CS.decodeInteger(data, 20, 2, false).intValue(), 4, 2, false));
                values.put("fw", CS.versionFormat(data, 26));
                values.put("hw", CS.versionFormat(data, 22));
                values.put("serial", CS.decodeString(data, 4, 16));
                values.put("display", (data[3] & 1) != 0 ? "1" : "0");
                values.put("2sides", (data[3] & 2) != 0 ? "1" : "0");
                values.put("rfid", (data[3] & 4) != 0 ? "1" : "0");
                values.put("evlock", (data[3] & 0x10) != 0 ? "1" : "0");
                values.put("domlock", (data[3] & 8) != 0 ? "1" : "0");
                values.put("foot", (data[3] & 0x20) != 0 ? "1" : "0");
                values.put("fan", (data[3] & 0x40) != 0 ? "1" : "0");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readStationInfo96_98_99_105(SensorCache sensor) throws IOException {
        DecimalFormat df4 = new DecimalFormat("0000");
        DecimalFormat df6 = new DecimalFormat("000000");
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45064, 9);
            if (data[0] != 4) {
                throw new IOException();
            }
            values.put("ratedcurrent", CS.numberFormat(CS.decodeInteger(data, 10, 2, false).intValue(), 4, 2, false));
            values.put("fw", CS.versionFormat(data, 16));
            values.put("hw", CS.versionFormat(data, 12));
            values.put("reference", df6.format(256 * (data[4] & 0xFF) + (data[5] & 0xFF)));
            String s = df4.format(256 * (data[6] & 0xFF) + (data[7] & 0xFF));
            values.put("date", String.valueOf(s.substring(0, 2)) + "W" + s.substring(2));
            values.put("serial", df6.format(256 * (data[8] & 0xFF) + (data[9] & 0xFF)));
            values.put("2sides", (data[3] & 1) != 0 ? "1" : "0");
            values.put("rfid", (data[3] & 2) != 0 ? "1" : "0");
            values.put("evlock", (data[3] & 4) != 0 ? "1" : "0");
            values.put("fan", (data[3] & 8) != 0 ? "1" : "0");
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readStationErrors(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                return CS.readStationErrors96_98_99_105(sensor);
            }
        }
        return CS.readStationErrorsLegacy(sensor);
    }

    public static Hashtable<String, String> readStationErrorsLegacy(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45057, 1);
            if (data[0] == 4) {
                values.put("powerfail", (data[3] & 1) != 0 ? "1" : "0");
                values.put("rechwerror", (data[3] & 2) != 0 ? "1" : "0");
                values.put("fatalhwerror", (data[3] & 4) != 0 ? "1" : "0");
                values.put("chgerror", (data[3] & 0x30) != 0 ? "1" : "0");
                values.put("lowbatt", (data[3] & 8) != 0 ? "1" : "0");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readStationErrors96_98_99_105(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45057, 1);
            if (data[0] == 4) {
                values.put("powerfail", (data[3] & 1) != 0 ? "1" : "0");
                values.put("lowbatt", (data[3] & 2) != 0 ? "1" : "0");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readChargeErrors(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                return CS.readChargeErrors96_98_99_105(sensor);
            }
        }
        return CS.readChargeErrorsLegacy(sensor);
    }

    public static Hashtable<String, String> readChargeErrorsLegacy(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        int side = CS.sensorToSideNumber(sensor);
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, side == 1 ? 48129 : 48641, 1);
            if (data[0] == 4) {
                if (sensor.modelid == 30) {
                    values.put("evlockerror", (data[3] & 1) != 0 ? "1" : "0");
                    values.put("evdisconnect", (data[3] & 2) != 0 ? "1" : "0");
                    values.put("evchgcurrlimit", (data[3] & 4) != 0 ? "1" : "0");
                    values.put("evcpfail", (data[3] & 0x40) != 0 ? "1" : "0");
                    values.put("evoverheat", (data[2] & 1) != 0 ? "1" : "0");
                    values.put("domlockerror", (data[2] & 2) != 0 ? "1" : "0");
                    values.put("domchgcurrlimit", (data[2] & 8) != 0 ? "1" : "0");
                    values.put("domoverheat", (data[2] & 0x10) != 0 ? "1" : "0");
                    values.put("other", (data[2] & 4) != 0 || (data[3] & 0xB8) != 0 ? "1" : "0");
                    return values;
                }
                values.put("evlockerror", (data[3] & 1) != 0 ? "1" : "0");
                values.put("evdisconnect", (data[3] & 2) != 0 ? "1" : "0");
                values.put("evchgcurrlimit", (data[3] & 4) != 0 ? "1" : "0");
                values.put("evcpfail", (data[3] & 0x20) != 0 ? "1" : "0");
                values.put("evoverheat", (data[3] & 0x40) != 0 ? "1" : "0");
                values.put("domlockerror", (data[2] & 2) != 0 ? "1" : "0");
                values.put("domchgcurrlimit", (data[2] & 8) != 0 ? "1" : "0");
                values.put("domoverheat", (data[2] & 0x10) != 0 ? "1" : "0");
                values.put("other", (data[2] & 0xE5) != 0 || (data[3] & 0x98) != 0 ? "1" : "0");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readChargeErrors96_98_99_105(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45057, 1);
            if (data[0] == 4) {
                values.put("evlockerror", (data[3] & 0x30) != 0 ? "1" : "0");
                values.put("evchgcurrlimit", (data[3] & 0x40) != 0 ? "1" : "0");
                values.put("evcpfail", (data[3] & 0x40) != 0 || (data[2] & 1) != 0 ? "1" : "0");
                values.put("domchgcurrlimit", (data[2] & 0x10) != 0 ? "1" : "0");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readPlugsStatus(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 98: {
                return CS.readPlugsStatus96_98(sensor);
            }
            case 99: 
            case 105: {
                return CS.readPlugsStatus99_105(sensor);
            }
        }
        return CS.readPlugsStatusLegacy(sensor);
    }

    public static Hashtable<String, String> readPlugsStatusLegacy(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        int side = CS.sensorToSideNumber(sensor);
        try {
            byte[] data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, side == 1 ? 48130 : 48642, 5);
            if (data[0] == 1) {
                values.put("ev", (data[2] & 1) != 0 ? "off" : "on");
                values.put("dom", (data[2] & 0x10) != 0 ? "off" : "on");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readPlugsStatus96_98(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, 45063, 1);
            if (data[0] == 1) {
                values.put("ev", (data[2] & 1) != 0 ? "on" : "off");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readPlugsStatus99_105(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, 45063, 5);
            if (data[0] == 1) {
                values.put("ev", (data[2] & 1) != 0 ? "on" : "off");
                values.put("dom", (data[2] & 0x10) != 0 ? "on" : "off");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readStationCommandState(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 98: {
                return CS.readStationCommandState96_98(sensor);
            }
            case 99: 
            case 105: {
                return CS.readStationCommandState99_105(sensor);
            }
        }
        return CS.readStationCommandStateLegacy(sensor);
    }

    public static Hashtable<String, String> readStationCommandStateLegacy(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        int side = CS.sensorToSideNumber(sensor);
        try {
            int chgauthaddr;
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, side == 1 ? 48128 : 48640, 1);
            if (data[0] == 4) {
                chgauthaddr = (data[3] & 2) != 0 ? (side == 1 ? 48129 : 48641) : ((data[3] & 0x20) != 0 ? (side == 1 ? 48133 : 48645) : 0);
            } else {
                throw new IOException();
            }
            if (chgauthaddr == 0) {
                values.put("chargestart", "0");
                values.put("chargewait", "0");
            } else {
                Thread.sleep(100L);
                data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, chgauthaddr, 1);
                if (data[0] == 1) {
                    if (data[2] != 0) {
                        values.put("chargestart", "1");
                        values.put("chargewait", "0");
                    } else {
                        values.put("chargestart", "0");
                        values.put("chargewait", "1");
                    }
                } else {
                    throw new IOException();
                }
            }
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable<String, String> readStationCommandState96_98(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45056, 1);
            if (data[0] != 4) throw new IOException();
            if ((data[2] & 1) != 0) {
                Thread.sleep(100L);
                data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, 45062, 1);
                if (data[0] != 1) throw new IOException();
                if (data[2] != 0) {
                    values.put("chargestart", "1");
                    values.put("chargewait", "0");
                    return values;
                } else {
                    values.put("chargestart", "0");
                    values.put("chargewait", "1");
                }
                return values;
            } else {
                values.put("chargestart", "0");
                values.put("chargewait", "0");
            }
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readStationCommandState99_105(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            int chgauthaddr;
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45056, 1);
            if (data[0] == 4) {
                chgauthaddr = (data[2] & 1) != 0 ? 45062 : ((data[2] & 0x10) != 0 ? 45066 : 0);
            } else {
                throw new IOException();
            }
            if (chgauthaddr == 0) {
                values.put("chargestart", "0");
                values.put("chargewait", "0");
            } else {
                Thread.sleep(100L);
                data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, chgauthaddr, 1);
                if (data[0] == 1) {
                    if (data[2] != 0) {
                        values.put("chargestart", "1");
                        values.put("chargewait", "0");
                    } else {
                        values.put("chargestart", "0");
                        values.put("chargewait", "1");
                    }
                } else {
                    throw new IOException();
                }
            }
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static int readChargeLevel(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                return CS.readChargeLevel96_98_99_105(sensor);
            }
        }
        return CS.readChargeLevelLegacy(sensor);
    }

    public static int readChargeLevelLegacy(SensorCache sensor) throws IOException {
        int side = CS.sensorToSideNumber(sensor);
        byte[] data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, side == 1 ? 48131 : 48643, 2);
        if (data[0] == 1) {
            int v = data[2] & 3;
            return v > 2 ? 2 : v;
        }
        throw new IOException();
    }

    public static int readChargeLevel96_98_99_105(SensorCache sensor) throws IOException {
        byte[] data = Modbus.readCoils(sensor.gatewayaddress, sensor.address, 45064, 2);
        if (data[0] == 1) {
            int v = data[2] & 3;
            return v > 2 ? 2 : v;
        }
        throw new IOException();
    }

    public static int readRatedCurrent(SensorCache sensor) throws IOException {
        byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, sensor.modelid == 30 ? 45060 : 45073, 1);
        if (data[0] == 4) {
            return 10 * CS.decodeInteger(data, 2, 2, false).intValue();
        }
        throw new IOException();
    }

    public static long readChargeHistId(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                return CS.readChargeHistId96_98_99_105(sensor);
            }
        }
        return CS.readChargeHistIdLegacy(sensor);
    }

    public static long readChargeHistIdLegacy(SensorCache sensor) throws IOException {
        block4: {
            int side = CS.sensorToSideNumber(sensor);
            try {
                byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, side == 1 ? 48160 : 48672, 2);
                if (data[0] == 4) {
                    return CS.decodeInteger(data, 2, 4, false).longValue();
                }
                if (data[0] != -124 || data[1] != 4) break block4;
                return 0L;
            }
            catch (Exception e2) {
                throw new IOException();
            }
        }
        throw new IOException();
    }

    public static long readChargeHistId96_98_99_105(SensorCache sensor) throws IOException {
        block4: {
            try {
                byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45102, 2);
                if (data[0] == 4) {
                    return CS.decodeInteger(data, 2, 4, false).longValue();
                }
                if (data[0] != -124 || data[1] != 4) break block4;
                return 0L;
            }
            catch (Exception e2) {
                throw new IOException();
            }
        }
        throw new IOException();
    }

    public static Hashtable<String, String> readChargeHistData(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 99: {
                return CS.readChargeHistData96_99(sensor);
            }
            case 98: 
            case 105: {
                return CS.readChargeHistData98_105(sensor);
            }
        }
        return CS.readChargeHistDataLegacy(sensor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable<String, String> readChargeHistDataLegacy(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            if (sensor.modelid == 30) {
                byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 48160, 20);
                if (data[0] != 4) throw new IOException();
                values.put("chargeid", Long.toString(CS.decodeInteger(data, 2, 4, false).longValue()));
                values.put("userid", "");
                values.put("plug", (data[7] & 1) != 0 ? "ev" : "dom");
                values.put("powerfail", (data[7] & 8) != 0 ? "1" : "0");
                values.put("rechwerror", (data[7] & 0x10) != 0 ? "1" : "0");
                values.put("fatalhwerror", (data[7] & 0x20) != 0 ? "1" : "0");
                values.put("3p", "0");
                values.put("evlockerror", (data[9] & 1) != 0 ? "1" : "0");
                values.put("evdisconnect", (data[9] & 2) != 0 ? "1" : "0");
                values.put("evchgcurrlimit", (data[9] & 4) != 0 ? "1" : "0");
                values.put("evcpfail", (data[9] & 0x40) != 0 ? "1" : "0");
                values.put("evoverheat", (data[8] & 1) != 0 ? "1" : "0");
                values.put("domlockerror", (data[8] & 2) != 0 ? "1" : "0");
                values.put("domchgcurrlimit", (data[8] & 8) != 0 ? "1" : "0");
                values.put("domoverheat", (data[8] & 0x10) != 0 ? "1" : "0");
                values.put("other", (data[8] & 4) != 0 || (data[9] & 0xB8) != 0 ? "1" : "0");
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(((data[12] & 0xFF) << 8) + (data[13] & 0xFF), (data[11] & 0xFF) - 1, data[10] & 0xFF, data[14] & 0xFF, data[15] & 0xFF, data[16] & 0xFF);
                values.put("intime", Long.toString(cal.getTimeInMillis()));
                cal.clear();
                cal.set(((data[20] & 0xFF) << 8) + (data[21] & 0xFF), (data[19] & 0xFF) - 1, data[18] & 0xFF, data[22] & 0xFF, data[23] & 0xFF, data[24] & 0xFF);
                values.put("outtime", Long.toString(cal.getTimeInMillis()));
                values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 26, 2, false).intValue()));
                values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 28, 2, false).intValue()));
                values.put("chgtime", Long.toString(CS.decodeInteger(data, 30, 4, false).longValue()));
                values.put("waittime", Long.toString(CS.decodeInteger(data, 38, 4, false).longValue()));
                return values;
            } else {
                byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, CS.sensorToSideNumber(sensor) == 1 ? 48160 : 48672, 23);
                if (data[0] != 4) throw new IOException();
                values.put("chargeid", Long.toString(CS.decodeInteger(data, 2, 4, false).longValue()));
                String u = CS.decodeHex(data, 6, 10);
                values.put("userid", u.equals("80000000000000000000") ? "" : u);
                values.put("plug", (data[17] & 1) != 0 ? "ev" : "dom");
                values.put("powerfail", (data[17] & 8) != 0 ? "1" : "0");
                values.put("rechwerror", (data[17] & 0x10) != 0 ? "1" : "0");
                values.put("fatalhwerror", (data[17] & 0x20) != 0 ? "1" : "0");
                values.put("3p", (data[17] & 0x80) != 0 ? "1" : "0");
                values.put("evlockerror", (data[19] & 1) != 0 ? "1" : "0");
                values.put("evdisconnect", (data[19] & 2) != 0 ? "1" : "0");
                values.put("evchgcurrlimit", (data[19] & 4) != 0 ? "1" : "0");
                values.put("evcpfail", (data[19] & 0x20) != 0 ? "1" : "0");
                values.put("evoverheat", (data[19] & 0x40) != 0 ? "1" : "0");
                values.put("domlockerror", (data[18] & 2) != 0 ? "1" : "0");
                values.put("domchgcurrlimit", (data[18] & 8) != 0 ? "1" : "0");
                values.put("domoverheat", (data[18] & 0x10) != 0 ? "1" : "0");
                values.put("other", (data[18] & 0xE5) != 0 || (data[19] & 0x98) != 0 ? "1" : "0");
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(((data[22] & 0xFF) << 8) + (data[23] & 0xFF), (data[21] & 0xFF) - 1, data[20] & 0xFF, data[24] & 0xFF, data[25] & 0xFF, data[26] & 0xFF);
                values.put("intime", Long.toString(cal.getTimeInMillis()));
                cal.clear();
                cal.set(((data[30] & 0xFF) << 8) + (data[31] & 0xFF), (data[29] & 0xFF) - 1, data[28] & 0xFF, data[32] & 0xFF, data[33] & 0xFF, data[34] & 0xFF);
                values.put("outtime", Long.toString(cal.getTimeInMillis()));
                values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 36, 2, false).intValue()));
                values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 38, 2, false).intValue()));
                values.put("chgtime", Long.toString(CS.decodeInteger(data, 40, 4, false).longValue()));
                values.put("waittime", Long.toString(CS.decodeInteger(data, 44, 4, false).longValue()));
            }
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readChargeHistData96_99(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45102, 27);
            if (data[0] != 4) {
                throw new IOException();
            }
            values.put("chargeid", Long.toString(CS.decodeInteger(data, 2, 4, false).longValue()));
            String u = CS.decodeHex(data, 6, 10);
            values.put("userid", u.equals("80000000000000000000") ? "" : u);
            values.put("plug", (data[17] & 1) != 0 ? "ev" : "dom");
            values.put("powerfail", (data[17] & 8) != 0 ? "1" : "0");
            values.put("rechwerror", (data[17] & 0x10) != 0 ? "1" : "0");
            values.put("fatalhwerror", (data[17] & 0x20) != 0 ? "1" : "0");
            values.put("3p", (data[17] & 0x40) != 0 ? "1" : "0");
            values.put("evlockerror", (data[19] & 3) != 0 ? "1" : "0");
            values.put("evchgcurrlimit", (data[19] & 4) != 0 ? "1" : "0");
            values.put("evcpfail", (data[19] & 0x18) != 0 ? "1" : "0");
            values.put("domchgcurrlimit", (data[18] & 1) != 0 ? "1" : "0");
            values.put("other", (data[19] & 0xE0) != 0 ? "1" : "0");
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(((data[22] & 0xFF) << 8) + (data[23] & 0xFF), (data[21] & 0xFF) - 1, data[20] & 0xFF, data[24] & 0xFF, data[25] & 0xFF, data[26] & 0xFF);
            values.put("intime", Long.toString(cal.getTimeInMillis()));
            cal.clear();
            cal.set(((data[30] & 0xFF) << 8) + (data[31] & 0xFF), (data[29] & 0xFF) - 1, data[28] & 0xFF, data[32] & 0xFF, data[33] & 0xFF, data[34] & 0xFF);
            values.put("outtime", Long.toString(cal.getTimeInMillis()));
            values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 36, 2, false).intValue()));
            values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 42, 2, false).intValue()));
            values.put("chgtime", Long.toString(CS.decodeInteger(data, 48, 4, false).longValue()));
            values.put("waittime", Long.toString(CS.decodeInteger(data, 52, 4, false).longValue()));
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readChargeHistData98_105(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45102, 27);
            if (data[0] != 4) {
                throw new IOException();
            }
            values.put("chargeid", Long.toString(CS.decodeInteger(data, 2, 4, false).longValue()));
            String u = CS.decodeHex(data, 6, 10);
            values.put("userid", u.equals("80000000000000000000") ? "" : u);
            values.put("plug", (data[17] & 1) != 0 ? "ev" : "dom");
            values.put("powerfail", (data[17] & 8) != 0 ? "1" : "0");
            values.put("rechwerror", (data[17] & 0x10) != 0 ? "1" : "0");
            values.put("fatalhwerror", (data[17] & 0x20) != 0 ? "1" : "0");
            values.put("3p", (data[17] & 0x40) != 0 ? "1" : "0");
            values.put("evlockerror", (data[19] & 3) != 0 ? "1" : "0");
            values.put("evchgcurrlimit", (data[19] & 4) != 0 ? "1" : "0");
            values.put("evcpfail", (data[19] & 0x18) != 0 ? "1" : "0");
            values.put("domchgcurrlimit", (data[18] & 1) != 0 ? "1" : "0");
            values.put("other", (data[19] & 0xE0) != 0 ? "1" : "0");
            Calendar cal = Calendar.getInstance();
            cal.clear();
            cal.set(((data[22] & 0xFF) << 8) + (data[23] & 0xFF), (data[21] & 0xFF) - 1, data[20] & 0xFF, data[24] & 0xFF, data[25] & 0xFF, data[26] & 0xFF);
            values.put("intime", Long.toString(cal.getTimeInMillis()));
            cal.clear();
            cal.set(((data[30] & 0xFF) << 8) + (data[31] & 0xFF), (data[29] & 0xFF) - 1, data[28] & 0xFF, data[32] & 0xFF, data[33] & 0xFF, data[34] & 0xFF);
            values.put("outtime", Long.toString(cal.getTimeInMillis()));
            values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 36, 2, false).intValue() + CS.decodeInteger(data, 38, 2, false).intValue() + CS.decodeInteger(data, 40, 2, false).intValue()));
            values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 42, 2, false).intValue() + CS.decodeInteger(data, 44, 2, false).intValue() + CS.decodeInteger(data, 46, 2, false).intValue()));
            values.put("chgtime", Long.toString(CS.decodeInteger(data, 48, 4, false).longValue()));
            values.put("waittime", Long.toString(CS.decodeInteger(data, 52, 4, false).longValue()));
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readChargeStat(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                return CS.readChargeStat96_98_99_105(sensor);
            }
        }
        return CS.readChargeStatLegacy(sensor);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Hashtable<String, String> readChargeStatLegacy(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        int side = CS.sensorToSideNumber(sensor);
        try {
            if (sensor.modelid == 30) {
                byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 48142, 8);
                if (data[0] != 4) throw new IOException();
                values.put("numcharges", Long.toString(CS.decodeInteger(data, 2, 4, false).longValue()));
                values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 6, 2, false).intValue()));
                values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 8, 2, false).intValue()));
                values.put("chgtime", Long.toString(CS.decodeInteger(data, 10, 4, false).longValue()));
                values.put("waittime", Long.toString(CS.decodeInteger(data, 14, 4, false).longValue()));
                return values;
            } else {
                byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, side == 1 ? 48147 : 48659, 8);
                if (data[0] != 4) throw new IOException();
                values.put("numcharges", Long.toString(CS.decodeInteger(data, 2, 4, false).longValue()));
                values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 6, 2, false).intValue()));
                values.put("peakcurrent", Integer.toString(CS.decodeInteger(data, 8, 2, false).intValue()));
                values.put("chgtime", Long.toString(CS.decodeInteger(data, 10, 4, false).longValue()));
                values.put("waittime", Long.toString(CS.decodeInteger(data, 14, 4, false).longValue()));
            }
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readChargeStat96_98_99_105(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45094, 8);
            if (data[0] != 4) {
                throw new IOException();
            }
            values.put("numcharges", Long.toString(CS.decodeInteger(data, 2, 4, false).longValue()));
            values.put("avgcurrent", Integer.toString(CS.decodeInteger(data, 6, 2, false).intValue() + CS.decodeInteger(data, 8, 2, false).intValue()));
            values.put("chgtime", Long.toString(CS.decodeInteger(data, 10, 4, false).longValue() + CS.decodeInteger(data, 14, 4, false).longValue()));
            values.put("peakcurrent", "0");
            values.put("waittime", "0");
            return values;
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readChargeProperties(SensorCache sensor) throws IOException {
        switch (sensor.modelid) {
            case 96: 
            case 98: {
                return CS.readChargeProperties96_98(sensor);
            }
            case 99: 
            case 105: {
                return CS.readChargeProperties99_105(sensor);
            }
        }
        return CS.readChargePropertiesLegacy(sensor);
    }

    public static Hashtable<String, String> readChargePropertiesLegacy(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        int side = CS.sensorToSideNumber(sensor);
        try {
            if (sensor.modelid == 30) {
                byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 48140, 2);
                if (data[0] == 4) {
                    values.put("powerfail", (data[3] & 8) != 0 ? "1" : "0");
                    values.put("rechwerror", (data[3] & 0x10) != 0 ? "1" : "0");
                    values.put("fatalhwerror", (data[3] & 0x20) != 0 ? "1" : "0");
                    values.put("3p", "0");
                    values.put("evlockerror", (data[5] & 1) != 0 ? "1" : "0");
                    values.put("evdisconnect", (data[5] & 2) != 0 ? "1" : "0");
                    values.put("evchgcurrlimit", (data[5] & 4) != 0 ? "1" : "0");
                    values.put("evcpfail", (data[5] & 0x40) != 0 ? "1" : "0");
                    values.put("evoverheat", (data[4] & 1) != 0 ? "1" : "0");
                    values.put("domlockerror", (data[4] & 2) != 0 ? "1" : "0");
                    values.put("domchgcurrlimit", (data[4] & 8) != 0 ? "1" : "0");
                    values.put("domoverheat", (data[4] & 0x10) != 0 ? "1" : "0");
                    values.put("other", (data[4] & 4) != 0 || (data[5] & 0xB8) != 0 ? "1" : "0");
                    values.put("userid", "");
                    return values;
                }
                throw new IOException();
            }
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, side == 1 ? 48140 : 48652, 7);
            if (data[0] == 4) {
                values.put("powerfail", (data[3] & 8) != 0 ? "1" : "0");
                values.put("rechwerror", (data[3] & 0x10) != 0 ? "1" : "0");
                values.put("fatalhwerror", (data[3] & 0x20) != 0 ? "1" : "0");
                values.put("3p", (data[3] & 0x80) != 0 ? "1" : "0");
                values.put("evlockerror", (data[5] & 1) != 0 ? "1" : "0");
                values.put("evdisconnect", (data[5] & 2) != 0 ? "1" : "0");
                values.put("evchgcurrlimit", (data[5] & 4) != 0 ? "1" : "0");
                values.put("evcpfail", (data[5] & 0x20) != 0 ? "1" : "0");
                values.put("evoverheat", (data[5] & 0x40) != 0 ? "1" : "0");
                values.put("domlockerror", (data[4] & 2) != 0 ? "1" : "0");
                values.put("domchgcurrlimit", (data[4] & 8) != 0 ? "1" : "0");
                values.put("domoverheat", (data[4] & 0x10) != 0 ? "1" : "0");
                values.put("other", (data[4] & 0xE5) != 0 || (data[5] & 0x98) != 0 ? "1" : "0");
                String u = CS.decodeHex(data, 6, 10);
                values.put("userid", u.equals("80000000000000000000") ? "" : u);
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readChargeProperties96_98(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45102, 9);
            if (data[0] == 4) {
                values.put("chargeid", Long.toString(CS.decodeInteger(data, 2, 4, false).longValue()));
                String u = CS.decodeHex(data, 6, 10);
                values.put("userid", u.equals("80000000000000000000") ? "" : u);
                values.put("plug", (data[17] & 1) != 0 ? "ev" : "dom");
                values.put("powerfail", (data[17] & 8) != 0 ? "1" : "0");
                values.put("rechwerror", (data[17] & 0x10) != 0 ? "1" : "0");
                values.put("fatalhwerror", (data[17] & 0x20) != 0 ? "1" : "0");
                values.put("3p", (data[17] & 0x40) != 0 ? "1" : "0");
                values.put("evlockerror", (data[19] & 3) != 0 ? "1" : "0");
                values.put("evchgcurrlimit", (data[19] & 4) != 0 ? "1" : "0");
                values.put("evcpfail", (data[19] & 0x18) != 0 ? "1" : "0");
                values.put("other", (data[19] & 0xE0) != 0 ? "1" : "0");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static Hashtable<String, String> readChargeProperties99_105(SensorCache sensor) throws IOException {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            byte[] data = Modbus.readInputRegisters(sensor.gatewayaddress, sensor.address, 45102, 9);
            if (data[0] == 4) {
                values.put("chargeid", Long.toString(CS.decodeInteger(data, 2, 4, false).longValue()));
                String u = CS.decodeHex(data, 6, 10);
                values.put("userid", u.equals("80000000000000000000") ? "" : u);
                values.put("plug", (data[17] & 1) != 0 ? "ev" : "dom");
                values.put("powerfail", (data[17] & 8) != 0 ? "1" : "0");
                values.put("rechwerror", (data[17] & 0x10) != 0 ? "1" : "0");
                values.put("fatalhwerror", (data[17] & 0x20) != 0 ? "1" : "0");
                values.put("3p", (data[17] & 0x40) != 0 ? "1" : "0");
                values.put("evlockerror", (data[19] & 3) != 0 ? "1" : "0");
                values.put("evchgcurrlimit", (data[19] & 4) != 0 ? "1" : "0");
                values.put("evcpfail", (data[19] & 0x18) != 0 ? "1" : "0");
                values.put("domchgcurrlimit", (data[18] & 1) != 0 ? "1" : "0");
                values.put("other", (data[19] & 0xE0) != 0 ? "1" : "0");
                return values;
            }
            throw new IOException();
        }
        catch (Exception e2) {
            throw new IOException();
        }
    }

    public static boolean writePlugsDisabled(SensorCache sensor, boolean ev, boolean disable) {
        switch (sensor.modelid) {
            case 96: 
            case 98: {
                return CS.writePlugsDisabled96_98(sensor, disable);
            }
            case 99: 
            case 105: {
                return CS.writePlugsDisabled99_105(sensor, ev, disable);
            }
        }
        return CS.writePlugsDisabledLegacy(sensor, ev, disable);
    }

    public static boolean writePlugsDisabledLegacy(SensorCache sensor, boolean ev, boolean disable) {
        int side = CS.sensorToSideNumber(sensor);
        byte[] data = Modbus.writeMultipleRegisters(sensor.gatewayaddress, sensor.address, 45062, PASSWORD);
        if (data[0] != 16) {
            return false;
        }
        data = side == 1 ? Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, ev ? 48130 : 48134, disable) : Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, ev ? 48642 : 48646, disable);
        return data[0] == 5;
    }

    public static boolean writePlugsDisabled96_98(SensorCache sensor, boolean disable) {
        byte[] data = Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, 45063, !disable);
        return data[0] == 5;
    }

    public static boolean writePlugsDisabled99_105(SensorCache sensor, boolean ev, boolean disable) {
        byte[] data = Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, ev ? 45063 : 45067, !disable);
        return data[0] == 5;
    }

    public static boolean writeHardwareReset(SensorCache sensor) {
        switch (sensor.modelid) {
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                return CS.writeHardwareReset96_98_99_105(sensor);
            }
        }
        return CS.writeHardwareResetLegacy(sensor);
    }

    public static boolean writeHardwareResetLegacy(SensorCache sensor) {
        byte[] data = Modbus.writeMultipleRegisters(sensor.gatewayaddress, sensor.address, 45062, PASSWORD);
        if (data[0] != 16) {
            return false;
        }
        data = Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, 45056, true);
        return data[0] == 5;
    }

    public static boolean writeHardwareReset96_98_99_105(SensorCache sensor) {
        byte[] data = Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, 45056, true);
        return data[0] == 5;
    }

    public static boolean writeChargeAuthorization(SensorCache sensor, boolean ev, boolean charge) {
        switch (sensor.modelid) {
            case 96: 
            case 98: {
                return CS.writeChargeAuthorization96_98(sensor, charge);
            }
            case 99: 
            case 105: {
                return CS.writeChargeAuthorization99_105(sensor, ev, charge);
            }
        }
        return CS.writeChargeAuthorizationLegacy(sensor, ev, charge);
    }

    public static boolean writeChargeAuthorizationLegacy(SensorCache sensor, boolean ev, boolean charge) {
        int side = CS.sensorToSideNumber(sensor);
        byte[] data = side == 1 ? Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, ev ? 48129 : 48133, charge) : Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, ev ? 48641 : 48645, charge);
        return data[0] == 5;
    }

    public static boolean writeChargeAuthorization96_98(SensorCache sensor, boolean charge) {
        byte[] data = Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, 45062, charge);
        return data[0] == 5;
    }

    public static boolean writeChargeAuthorization99_105(SensorCache sensor, boolean ev, boolean charge) {
        byte[] data = Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, ev ? 45062 : 45066, charge);
        return data[0] == 5;
    }

    public static boolean writeChargeLevel(SensorCache sensor, int level) {
        switch (sensor.modelid) {
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                return CS.writeChargeLevel96_98_99_105(sensor, level);
            }
        }
        return CS.writeChargeLevelLegacy(sensor, level);
    }

    public static boolean writeChargeLevelLegacy(SensorCache sensor, int level) {
        byte[] levelbyte = new byte[]{(byte)(0xFF & level)};
        int side = CS.sensorToSideNumber(sensor);
        byte[] data = Modbus.writeMultipleCoils(sensor.gatewayaddress, sensor.address, side == 1 ? 48131 : 48643, 2, levelbyte);
        return data[0] == 15;
    }

    public static boolean writeChargeLevel96_98_99_105(SensorCache sensor, int level) {
        byte[] levelbyte = new byte[]{(byte)(0xFF & level)};
        byte[] data = Modbus.writeMultipleCoils(sensor.gatewayaddress, sensor.address, 45064, 2, levelbyte);
        return data[0] == 15;
    }

    public static boolean writeMode(SensorCache sensor, boolean priority) {
        if (sensor.modelid == 30) {
            byte[] data = Modbus.writeSingleCoil(sensor.gatewayaddress, sensor.address, 48136, priority);
            return data[0] == 5;
        }
        return true;
    }

    public static boolean writeCurrentLevels(SensorCache sensor, int level1, int level2) {
        switch (sensor.modelid) {
            case 96: 
            case 98: 
            case 99: 
            case 105: {
                return true;
            }
        }
        return CS.writeCurrentLevelsLegacy(sensor, level1, level2);
    }

    public static boolean writeCurrentLevelsLegacy(SensorCache sensor, int level1, int level2) {
        byte[] byArray = new byte[4];
        byArray[1] = (byte)(0xFF & level1);
        byArray[3] = (byte)(0xFF & level2);
        byte[] levels = byArray;
        byte[] data = Modbus.writeMultipleRegisters(sensor.gatewayaddress, sensor.address, 45060, levels);
        return data[0] == 16;
    }

    public static boolean testSensor(String gateway, int unitid, int modelid) {
        byte[] data = Modbus.readInputRegisters(gateway, unitid, modelid == 30 ? 45059 : 45064, 14);
        return data != null && data.length == 30;
    }

    public static boolean syncClock(SensorCache sensor) {
        try {
            byte[] data = Modbus.readHoldingRegisters(sensor.gatewayaddress, sensor.address, 45056, 4);
            if (data[0] == 3) {
                long now = System.currentTimeMillis();
                Calendar cal = Calendar.getInstance();
                cal.clear();
                cal.set(((data[4] & 0xFF) << 8) + (data[5] & 0xFF), (data[3] & 0xFF) - 1, data[2] & 0xFF, data[6] & 0xFF, data[7] & 0xFF, data[8] & 0xFF);
                if (Math.abs(cal.getTimeInMillis() - now) > 3000L) {
                    cal.setTimeInMillis(now);
                    data = new byte[]{(byte)(0xFF & cal.get(5)), (byte)(0xFF & cal.get(2) + 1), (byte)(0xFF & cal.get(1) >> 8), (byte)(0xFF & cal.get(1)), (byte)(0xFF & cal.get(11)), (byte)(0xFF & cal.get(12)), (byte)(0xFF & cal.get(13)), 0};
                    data = Modbus.writeMultipleRegisters(sensor.gatewayaddress, sensor.address, 45056, data);
                    return data[0] == 16;
                }
                return true;
            }
            return false;
        }
        catch (Exception e2) {
            return false;
        }
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String decodeHex(byte[] data, int index, int length) {
        StringBuffer sb = new StringBuffer();
        try {
            int i2 = 0;
            while (i2 < length) {
                String b2 = Integer.toHexString(data[index + i2] & 0xFF).toUpperCase();
                if (b2.length() == 1) {
                    sb.append('0');
                }
                sb.append(b2);
                ++i2;
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String decodeString(byte[] data, int index, int length) {
        StringBuffer sb = new StringBuffer();
        try {
            int i2 = 0;
            while (i2 < length) {
                char ch = (char)(data[index + i2] & 0xFF);
                if (ch == ' ' || ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') {
                    sb.append(ch);
                }
                ++i2;
            }
            return sb.toString();
        }
        catch (Exception e2) {
            return null;
        }
    }

    private static String numberFormat(int val, int digits, int decimals, boolean signed) {
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0) {
            return "0";
        }
        if (val > 0) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static String timeFormat(long val) {
        StringBuffer sb = new StringBuffer();
        long hours = val / 3600L;
        long minutes = val / 60L % 60L;
        long seconds = val % 60L;
        sb.append(hours);
        sb.append(':');
        if (minutes < 10L) {
            sb.append('0');
        }
        sb.append(minutes);
        sb.append(':');
        if (seconds < 10L) {
            sb.append('0');
        }
        sb.append(seconds);
        return sb.toString();
    }

    private static String versionFormat(byte[] data, int offset) {
        StringBuffer sb = new StringBuffer();
        sb.append(data[offset] & 0xFF);
        sb.append('.');
        sb.append(data[offset + 1] & 0xFF);
        sb.append('.');
        sb.append(data[offset + 2] & 0xFF);
        return sb.toString();
    }

    public static int sensorToSideNumber(SensorCache sensor) {
        switch (sensor.modelid) {
            case 30: {
                return 1;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 58: 
            case 59: {
                return 2;
            }
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 31: 
            case 32: 
            case 37: 
            case 38: 
            case 51: 
            case 53: 
            case 55: 
            case 57: 
            case 60: {
                return "left".equals(sensor.subaddress) ? 1 : 2;
            }
        }
        return 0;
    }
}

