/*
 * Decompiled with CFR 0.152.
 */
package plugins.wsmeasure;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Hashtable;
import plugins.wsmeasure.user;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CONTREL {
    public static byte[] readVIF(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(88);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4100, 24), 2, 48);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4128, 12), 2, 24);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4548, 4), 2, 8);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4236, 4), 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeVIF(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("V1", CONTREL.toUnsigned(data, 0) / 10);
            values.put("V2", CONTREL.toUnsigned(data, 8) / 10);
            values.put("V3", CONTREL.toUnsigned(data, 16) / 10);
            values.put("U12", CONTREL.toUnsigned(data, 24) / 10);
            values.put("U23", CONTREL.toUnsigned(data, 32) / 10);
            values.put("U31", CONTREL.toUnsigned(data, 40) / 10);
            values.put("I1", CONTREL.toUnsigned(data, 48));
            values.put("I2", CONTREL.toUnsigned(data, 56));
            values.put("I3", CONTREL.toUnsigned(data, 64));
            values.put("In", CONTREL.toUnsigned(data, 72));
            values.put("F", CONTREL.toUnsigned(data, 80) / 10);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayVIF(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("V1", CONTREL.toString(CONTREL.toUnsigned(data, 0) / 10, 4, 2));
            values.put("V2", CONTREL.toString(CONTREL.toUnsigned(data, 8) / 10, 4, 2));
            values.put("V3", CONTREL.toString(CONTREL.toUnsigned(data, 16) / 10, 4, 2));
            values.put("U12", CONTREL.toString(CONTREL.toUnsigned(data, 24) / 10, 4, 2));
            values.put("U23", CONTREL.toString(CONTREL.toUnsigned(data, 32) / 10, 4, 2));
            values.put("U31", CONTREL.toString(CONTREL.toUnsigned(data, 40) / 10, 4, 2));
            values.put("I1", CONTREL.toString(CONTREL.toUnsigned(data, 48), 4, 3));
            values.put("I2", CONTREL.toString(CONTREL.toUnsigned(data, 56), 4, 3));
            values.put("I3", CONTREL.toString(CONTREL.toUnsigned(data, 64), 4, 3));
            values.put("In", CONTREL.toString(CONTREL.toUnsigned(data, 72), 4, 3));
            values.put("F", CONTREL.toString(CONTREL.toUnsigned(data, 80) / 10, 4, 2));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPower(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(128);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4172, 48), 2, 96);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4140, 16), 2, 32);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodePower(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("S", CONTREL.toSigned(data, 0) / 10000);
            values.put("S1", CONTREL.toSigned(data, 8) / 10000);
            values.put("S2", CONTREL.toSigned(data, 16) / 10000);
            values.put("S3", CONTREL.toSigned(data, 24) / 10000);
            values.put("P", CONTREL.toSigned(data, 32) / 10000);
            values.put("P1", CONTREL.toSigned(data, 40) / 10000);
            values.put("P2", CONTREL.toSigned(data, 48) / 10000);
            values.put("P3", CONTREL.toSigned(data, 56) / 10000);
            values.put("Q", CONTREL.toSigned(data, 64) / 10000);
            values.put("Q1", CONTREL.toSigned(data, 72) / 10000);
            values.put("Q2", CONTREL.toSigned(data, 80) / 10000);
            values.put("Q3", CONTREL.toSigned(data, 88) / 10000);
            values.put("PF", CONTREL.toSigned(data, 96));
            values.put("PF1", CONTREL.toSigned(data, 104));
            values.put("PF2", CONTREL.toSigned(data, 112));
            values.put("PF3", CONTREL.toSigned(data, 120));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayPower(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("S", CONTREL.toString(CONTREL.toSigned(data, 0) / 10000, 4, 2));
            values.put("S1", CONTREL.toString(CONTREL.toSigned(data, 8) / 10000, 4, 2));
            values.put("S2", CONTREL.toString(CONTREL.toSigned(data, 16) / 10000, 4, 2));
            values.put("S3", CONTREL.toString(CONTREL.toSigned(data, 24) / 10000, 4, 2));
            values.put("P", CONTREL.toString(CONTREL.toSigned(data, 32) / 10000, 4, 2));
            values.put("P1", CONTREL.toString(CONTREL.toSigned(data, 40) / 10000, 4, 2));
            values.put("P2", CONTREL.toString(CONTREL.toSigned(data, 48) / 10000, 4, 2));
            values.put("P3", CONTREL.toString(CONTREL.toSigned(data, 56) / 10000, 4, 2));
            values.put("Q", CONTREL.toString(CONTREL.toSigned(data, 64) / 10000, 4, 2));
            values.put("Q1", CONTREL.toString(CONTREL.toSigned(data, 72) / 10000, 4, 2));
            values.put("Q2", CONTREL.toString(CONTREL.toSigned(data, 80) / 10000, 4, 2));
            values.put("Q3", CONTREL.toString(CONTREL.toSigned(data, 88) / 10000, 4, 2));
            values.put("PF", CONTREL.toString(CONTREL.toSigned(data, 96), 4, 3));
            values.put("PF1", CONTREL.toString(CONTREL.toSigned(data, 104), 4, 3));
            values.put("PF2", CONTREL.toString(CONTREL.toSigned(data, 112), 4, 3));
            values.put("PF3", CONTREL.toString(CONTREL.toSigned(data, 120), 4, 3));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readTHD(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(48);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4240, 24), 2, 48);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeTHD(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("THDV1", CONTREL.toUnsigned(data, 0) / 100);
            values.put("THDV2", CONTREL.toUnsigned(data, 8) / 100);
            values.put("THDV3", CONTREL.toUnsigned(data, 16) / 100);
            values.put("THDI1", CONTREL.toUnsigned(data, 24) / 100);
            values.put("THDI2", CONTREL.toUnsigned(data, 32) / 100);
            values.put("THDI3", CONTREL.toUnsigned(data, 40) / 100);
            values.put("THDIn", 0);
            values.put("THDU12", 0);
            values.put("THDU23", 0);
            values.put("THDU31", 0);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayTHD(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("THDV1", CONTREL.toString(CONTREL.toUnsigned(data, 0) / 100, 3, 1));
            values.put("THDV2", CONTREL.toString(CONTREL.toUnsigned(data, 8) / 100, 3, 1));
            values.put("THDV3", CONTREL.toString(CONTREL.toUnsigned(data, 16) / 100, 3, 1));
            values.put("THDI1", CONTREL.toString(CONTREL.toUnsigned(data, 24) / 100, 3, 1));
            values.put("THDI2", CONTREL.toString(CONTREL.toUnsigned(data, 32) / 100, 3, 1));
            values.put("THDI3", CONTREL.toString(CONTREL.toUnsigned(data, 40) / 100, 3, 1));
            values.put("THDIn", "");
            values.put("THDU12", "");
            values.put("THDU23", "");
            values.put("THDU31", "");
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPartialEnergyPos(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4220, 8), 2, 16);
        return bb.array();
    }

    public static Hashtable<String, Long> decodePartialEnergyPos(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea", CONTREL.toUnsignedLong(data, 0));
            values.put("Er", CONTREL.toUnsignedLong(data, 8));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayPartialEnergyPos(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("Ea", Long.toString(CONTREL.toUnsigned(data, 0)));
            values.put("Er", Long.toString(CONTREL.toUnsigned(data, 8)));
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readPartialEnergyNeg(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(16);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4228, 8), 2, 16);
        return bb.array();
    }

    public static Hashtable<String, Long> decodePartialEnergyNeg(byte[] data) {
        Hashtable<String, Long> values = new Hashtable<String, Long>();
        try {
            values.put("Ea-", CONTREL.toUnsignedLong(data, 0));
            values.put("Er-", CONTREL.toUnsignedLong(data, 8));
            values.put("Es", 0L);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Long>();
        }
    }

    public static Hashtable<String, String> displayPartialEnergyNeg(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("Ea-", Long.toString(CONTREL.toUnsigned(data, 0)));
            values.put("Er-", Long.toString(CONTREL.toUnsigned(data, 8)));
            values.put("Es", "");
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readAvgExt(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(48);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4264, 4), 2, 8);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4552, 16), 2, 32);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4588, 4), 2, 8);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeAvgExt(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("avgP+", CONTREL.toUnsigned(data, 0) / 10000);
            int q = CONTREL.toSigned(data, 8) / 10000;
            if (q >= 0) {
                values.put("avgQ+", q);
                values.put("avgQ-", 0);
            } else {
                values.put("avgQ+", 0);
                values.put("avgQ-", q);
            }
            values.put("avgI1", CONTREL.toSigned(data, 16));
            values.put("avgI2", CONTREL.toSigned(data, 24));
            values.put("avgI3", CONTREL.toSigned(data, 32));
            values.put("avgIn", CONTREL.toSigned(data, 40));
            values.put("avgU12", 0);
            values.put("avgU23", 0);
            values.put("avgU31", 0);
            values.put("avgV1", 0);
            values.put("avgV2", 0);
            values.put("avgV3", 0);
            values.put("avgF", 0);
            values.put("avgS", 0);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayAvgExt(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("avgP+", CONTREL.toString(CONTREL.toUnsigned(data, 0) / 10000, 4, 2));
            int q = CONTREL.toSigned(data, 8) / 10000;
            if (q >= 0) {
                values.put("avgQ+", CONTREL.toString(q, 4, 2));
                values.put("avgQ-", "");
            } else {
                values.put("avgQ+", "");
                values.put("avgQ-", CONTREL.toString(q, 4, 2));
            }
            values.put("avgI1", CONTREL.toString(CONTREL.toSigned(data, 16), 4, 3));
            values.put("avgI2", CONTREL.toString(CONTREL.toSigned(data, 24), 4, 3));
            values.put("avgI3", CONTREL.toString(CONTREL.toSigned(data, 32), 4, 3));
            values.put("avgIn", CONTREL.toString(CONTREL.toSigned(data, 40), 4, 3));
            values.put("avgU12", "");
            values.put("avgU23", "");
            values.put("avgU31", "");
            values.put("avgV1", "");
            values.put("avgV2", "");
            values.put("avgV3", "");
            values.put("avgF", "");
            values.put("avgS", "");
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static byte[] readMaxBase(String gateway, int unitid) {
        ByteBuffer bb = ByteBuffer.allocate(32);
        bb.put(user.modbusReadHoldingRegisters(gateway, unitid, 4572, 16), 2, 32);
        return bb.array();
    }

    public static Hashtable<String, Integer> decodeMaxBase(byte[] data) {
        Hashtable<String, Integer> values = new Hashtable<String, Integer>();
        try {
            values.put("maxI1", CONTREL.toSigned(data, 0));
            values.put("maxI2", CONTREL.toSigned(data, 8));
            values.put("maxI3", CONTREL.toSigned(data, 16));
            values.put("maxIn", CONTREL.toSigned(data, 24));
            values.put("maxP+", 0);
            values.put("maxP-", 0);
            values.put("maxQ+", 0);
            values.put("maxQ-", 0);
            values.put("maxS", 0);
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, Integer>();
        }
    }

    public static Hashtable<String, String> displayMaxBase(byte[] data) {
        Hashtable<String, String> values = new Hashtable<String, String>();
        try {
            values.put("maxI1", CONTREL.toString(CONTREL.toSigned(data, 0), 4, 3));
            values.put("maxI2", CONTREL.toString(CONTREL.toSigned(data, 8), 4, 3));
            values.put("maxI3", CONTREL.toString(CONTREL.toSigned(data, 16), 4, 3));
            values.put("maxIn", CONTREL.toString(CONTREL.toSigned(data, 24), 4, 3));
            values.put("maxP+", "");
            values.put("maxP-", "");
            values.put("maxQ+", "");
            values.put("maxQ-", "");
            values.put("maxS", "");
            return values;
        }
        catch (Exception e2) {
            return new Hashtable<String, String>();
        }
    }

    public static int toUnsigned(byte[] data, int index) {
        return CONTREL.decodeInteger(data, index, 8, false).intValue();
    }

    public static long toUnsignedLong(byte[] data, int index) {
        return CONTREL.decodeInteger(data, index, 8, false).longValue();
    }

    public static int toSigned(byte[] data, int index) {
        return CONTREL.decodeInteger(data, index, 8, true).intValue();
    }

    private static String toString(long val, int digits, int decimals) {
        if ((int)Math.log10(Math.abs(val)) >= digits + decimals) {
            return "###";
        }
        if (val == 0L) {
            return "0";
        }
        if (val > 0L) {
            String s = Double.toString((double)val / Math.pow(10.0, decimals));
            if (s.length() > digits + 1) {
                return s.charAt(digits) == '.' ? s.substring(0, digits) : s.substring(0, digits + 1);
            }
            return s;
        }
        String s = Double.toString((double)val / Math.pow(10.0, decimals));
        if (s.length() > digits + 2) {
            return s.charAt(digits + 1) == '.' ? s.substring(0, digits + 1) : s.substring(0, digits + 2);
        }
        return s;
    }

    private static BigInteger decodeInteger(byte[] data, int index, int length, boolean signed) {
        try {
            byte[] d2;
            byte[] byArray = d2 = index == 0 && length == 0 ? data : Arrays.copyOfRange(data, index, index + length);
            if (signed) {
                return new BigInteger(d2);
            }
            return new BigInteger(1, d2);
        }
        catch (Exception e2) {
            return null;
        }
    }
}

