/*
 * Decompiled with CFR 0.152.
 */
package plugins.wiringeditor;

import plugins.wiringeditor.Database;
import plugins.wiringeditor.InputGroup;
import plugins.wiringeditor.Listable;
import plugins.wiringeditor.Output;
import plugins.wiringeditor.Wiring;
import plugins.wiringeditor.WiringEditor;

public class Input
implements Listable {
    private static final long serialVersionUID = 2251002839992217691L;
    static final int VALUE_TYPE_UNKNOWN = -1;
    static final int VALUE_TYPE_BINARY = 0;
    static final int VALUE_TYPE_LEVEL = 1;
    final String id;
    String name;
    String typeName;
    int valueType;

    protected Input(String id) {
        this.id = id;
    }

    public Input(String id, String typeName, String name, int valueType) {
        this.id = id;
        this.name = name;
        this.typeName = typeName;
        this.valueType = valueType;
    }

    public Input(String id, String typeName) {
        this(id, typeName, Input.loadName(id), Input.loadValueType(id));
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    private static String loadName(String id) {
        try {
            return Database.loadString(String.valueOf(id) + ".name");
        }
        catch (Exception e2) {
            return id;
        }
    }

    private static int loadValueType(String id) {
        try {
            return Database.loadInt(String.valueOf(id) + ".valuetype");
        }
        catch (Exception e2) {
            return -1;
        }
    }

    @Override
    public String getRow(String list, Object filter) {
        if (list.startsWith("input.group.")) {
            return this.name;
        }
        if (list.startsWith("wiring.")) {
            if (filter != null && filter instanceof String) {
                int funcId;
                if (filter.equals("onoff") || filter.equals("blind") || filter.equals("scenario")) {
                    if (this.valueType == 0 || this.valueType == -1) {
                        return this.name;
                    }
                    return null;
                }
                if (((String)filter).startsWith("dimmer/") && ((funcId = Integer.parseInt(((String)filter).split("/")[1])) == 0 || funcId == 1 || funcId == 2)) {
                    if (this.valueType == 0 || this.valueType == -1) {
                        return this.name;
                    }
                    return null;
                }
            }
            return this.name;
        }
        if (list.startsWith("input.")) {
            if (filter == null || filter instanceof String || filter instanceof Wiring && ((Wiring)filter).hasInput(this) || filter instanceof Output && this.isWiredTo((Output)filter) || filter instanceof Input && (filter == this || this instanceof InputGroup && ((InputGroup)this).hasInput((Input)filter))) {
                return this.getInputRow();
            }
            return null;
        }
        return null;
    }

    protected String getInputRow() {
        String row = "<table class=\"listtable\">";
        row = String.valueOf(row) + "<colgroup><col class=\"id\"></colgroup>";
        row = String.valueOf(row) + "<tr><td colspan=\"2\" class=\"name\">" + this.name + "</td></tr>";
        row = String.valueOf(row) + "<tr>";
        row = String.valueOf(row) + "<td class=\"id\">" + this.id + "</td>";
        row = String.valueOf(row) + "<td class=\"type\">" + (this.typeName == null ? "IO Datapoint" : this.typeName) + "</td>";
        row = String.valueOf(row) + "</tr></table>";
        return row;
    }

    protected boolean isWiredTo(Output o2) {
        for (Wiring w : WiringEditor.wirings.values()) {
            if (!w.hasOutput(o2) || !w.hasInput(this)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String select(String list, boolean repeat, boolean up, String session) throws Exception {
        if (repeat) {
            if (!WiringEditor.expertMode) {
                return "!";
            }
            WiringEditor.uiSet("input.id", "text", this.id, session);
            WiringEditor.uiSet("input.name", "text", this.name, session);
            WiringEditor.uiSet("input.valtype", "visible", "true", session);
            if (this.valueType == 0) {
                WiringEditor.uiSet("input.valtype", "value", "01", session);
            } else if (this.valueType == 1) {
                WiringEditor.uiSet("input.valtype", "value", "lvl", session);
            } else {
                WiringEditor.uiSet("input.valtype", "value", "", session);
            }
            return "!page:input.edit";
        }
        if (up) {
            String nowSelected = WiringEditor.uiGet("input.list", "value", session);
            if (nowSelected == null || !nowSelected.equals(this.id)) {
                WiringEditor.uiSet("input.list", "value", this.id, session);
                WiringEditor.uiSet("output.list", "value", "", session);
                WiringEditor.uiSet("wiring.list", "value", "", session);
                WiringEditor.inputs.update(this, session);
                WiringEditor.outputs.update(this, session);
                WiringEditor.wirings.update(this, session);
            } else {
                WiringEditor.uiClear(session);
                WiringEditor.uiSet("input.list", "value", "", session);
                WiringEditor.uiSet("output.list", "value", "", session);
                WiringEditor.uiSet("wiring.list", "value", "", session);
                WiringEditor.inputs.update(null);
                WiringEditor.outputs.update(null);
                WiringEditor.wirings.update(null);
            }
        }
        return "!";
    }

    @Override
    public int compare(Listable anotherListable) {
        if (anotherListable instanceof Input) {
            Input i2 = (Input)anotherListable;
            return this.name.toLowerCase().compareTo(i2.name.toLowerCase());
        }
        return 0;
    }

    public void setName(String name) throws Exception {
        this.name = name;
        Database.save(String.valueOf(this.id) + ".name", name);
    }

    public String getValue() {
        return WiringEditor.ioGet(this.id);
    }

    public void setValueType(int valueType) {
        this.valueType = valueType;
        Database.save(String.valueOf(this.id) + ".valuetype", valueType);
    }

    public boolean matches(Input anotherInput) {
        return this == anotherInput;
    }

    @Override
    public void onRemove() {
        Database.delete(String.valueOf(this.id) + ".name");
        Database.delete(String.valueOf(this.id) + ".valuetype");
    }

    @Override
    public String toDBString() {
        return null;
    }
}

