/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import plugins.manager_settings.CommPort;
import plugins.manager_settings.Error;
import plugins.manager_settings.IOServerType;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;
import plugins.manager_settings.SynchronizedStringHashMap;

public class IOServer
extends Listable {
    private final IOServerType ioServerType;
    private String ipAddress;
    private String port;
    private String commId;
    private String failoverCommId;
    private String authUser;
    private String authPassword;
    private Boolean shutdownInactive;
    private boolean enabled = true;
    private SynchronizedStringHashMap<Option> options = new SynchronizedStringHashMap();

    IOServer(String id, IOServerType ioServerType, boolean check) throws InputException {
        super(id);
        if (check && !id.matches("[a-z0-9]+")) {
            throw new InputException("Illegal IOServer ID: " + id);
        }
        this.ioServerType = ioServerType;
        if (ioServerType != null) {
            if (ioServerType.connectionIP()) {
                this.ipAddress = "";
            } else if (ioServerType.connectionComm()) {
                this.commId = "";
                if (ioServerType.hasCommType("comm2")) {
                    this.failoverCommId = "";
                }
            }
        }
        Settings.log(1, "Created IO Server '" + this.id + "'");
    }

    IOServerType getType() {
        return this.ioServerType;
    }

    @Override
    String getListLabel(String list) {
        if (list.equals("comm.io")) {
            if (this.ioServerType.isCommPort() && this.enabled) {
                return this.id;
            }
            return null;
        }
        String lbl = String.valueOf(this.ioServerType.getId()) + " - " + this.id;
        if (this.enabled) {
            return lbl;
        }
        return "<div style=\"color:#A0A0A0\">" + lbl + "</div>";
    }

    void setIP(String ipAddress) throws InputException {
        if (this.ioServerType.connectionIP()) {
            if (ipAddress != null) {
                if (ipAddress.length() == 0) {
                    if (this.ioServerType.connectionOptional()) {
                        ipAddress = null;
                    } else {
                        throw new InputException("Illegal IP address for IO Server '" + this.id + "': " + ipAddress);
                    }
                }
                this.commId = null;
                this.failoverCommId = null;
            }
            this.ipAddress = ipAddress;
            Settings.log(1, "IO Server '" + this.id + "' - IP set to: " + this.ipAddress);
        }
    }

    void setPort(String port) throws InputException {
        if (this.ioServerType.connectionIP()) {
            if (port != null) {
                if (port.length() == 0) {
                    port = null;
                } else {
                    int p;
                    try {
                        p = Integer.parseInt(port);
                    }
                    catch (NumberFormatException e2) {
                        throw new InputException("Illegal port number for IO Server '" + this.id + "': " + port);
                    }
                    if (p <= 0 || p >= 65535) {
                        throw new InputException("Illegal port number for IO Server '" + this.id + "': " + port);
                    }
                    this.commId = null;
                    this.failoverCommId = null;
                }
            }
            this.port = port;
            Settings.log(1, "IO Server '" + this.id + "' - Port set to: " + this.port);
        }
    }

    void setCommIds(String commId) throws InputException {
        if (this.ioServerType.connectionComm()) {
            String[] comms = null;
            if (commId != null) {
                IOServer ioComm;
                boolean ok = false;
                if (this.ioServerType.hasCommType("comm")) {
                    if (Settings.commPorts.get(commId) != null) {
                        ok = true;
                    }
                } else if (this.ioServerType.hasCommType("comm2")) {
                    comms = commId.replaceAll("\\s+", "").split(",");
                    ok = true;
                    String[] stringArray = comms;
                    int n2 = comms.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        Object c2 = stringArray[n3];
                        if (Settings.commPorts.get((String)c2) == null) {
                            ok = false;
                            break;
                        }
                        ++n3;
                    }
                } else if (this.ioServerType.hasCommType("port")) {
                    ok = true;
                }
                if (!ok && (ioComm = Settings.ioServers.get(commId)) != null) {
                    List<String> commTypes = this.ioServerType.getCommTypes();
                    for (String commType : commTypes) {
                        if (!commType.startsWith("io:")) continue;
                        int end = commType.indexOf(",");
                        String ioType = end < 3 ? commType.substring(3) : commType.substring(3, end);
                        if (!ioComm.ioServerType.getId().equals(ioType)) continue;
                        ok = true;
                        break;
                    }
                }
                if (!ok) {
                    throw new InputException("Illegal CommPort for IO Server '" + this.id + "': port '" + commId + "' not defined");
                }
                this.port = null;
                this.ipAddress = null;
            }
            if (comms != null) {
                this.commId = comms[0];
                if (comms.length > 1) {
                    this.failoverCommId = comms[1];
                }
                Settings.log(1, "IO Server '" + this.id + "' - CommId set to: " + this.commId + "," + this.failoverCommId);
            } else {
                this.commId = commId;
                Settings.log(1, "IO Server '" + this.id + "' - CommId set to: " + this.commId);
            }
        }
    }

    void setCommId(String commId) throws InputException {
        if (this.ioServerType.connectionComm()) {
            IOServer ioComm;
            boolean ok = false;
            if (this.ioServerType.hasCommType("comm") || this.ioServerType.hasCommType("comm2")) {
                if (Settings.commPorts.get(commId) != null) {
                    ok = true;
                }
            } else if (this.ioServerType.hasCommType("port")) {
                ok = true;
            }
            if (!ok && (ioComm = Settings.ioServers.get(commId)) != null) {
                List<String> commTypes = this.ioServerType.getCommTypes();
                for (String commType : commTypes) {
                    if (!commType.startsWith("io:")) continue;
                    int end = commType.indexOf(",");
                    String ioType = end < 3 ? commType.substring(3) : commType.substring(3, end);
                    if (!ioComm.ioServerType.getId().equals(ioType)) continue;
                    ok = true;
                    break;
                }
            }
            if (!ok) {
                throw new InputException("Illegal CommPort for IO Server '" + this.id + "': port '" + commId + "' not defined");
            }
            this.port = null;
            this.ipAddress = null;
            this.commId = commId;
            Settings.log(1, "IO Server '" + this.id + "' - CommId set to: " + this.commId);
        }
    }

    void setFailoverCommId(String commId) throws InputException {
        if (this.ioServerType.connectionComm() && this.ioServerType.hasCommType("comm2")) {
            if (commId.length() > 0 && Settings.commPorts.get(commId) == null) {
                throw new InputException("Illegal failover CommPort for IO Server '" + this.id + "': port '" + commId + "' not defined");
            }
            this.port = null;
            this.ipAddress = null;
            this.failoverCommId = commId;
            Settings.log(1, "IO Server '" + this.id + "' - failover CommId set to: " + this.failoverCommId);
        }
    }

    void setOptions(String optionsString) {
        if (optionsString != null && !optionsString.trim().equals("")) {
            String[] ops;
            String[] stringArray = ops = optionsString.split(",");
            int n2 = ops.length;
            int n3 = 0;
            while (n3 < n2) {
                String op = stringArray[n3];
                String[] id_val = op.split("=");
                if (id_val.length >= 1) {
                    String id = id_val[0].trim().toLowerCase();
                    String value = id_val.length == 1 ? "true" : id_val[1].trim();
                    try {
                        Option o2 = new Option(id, value);
                        this.options.put(o2.id, o2);
                    }
                    catch (InputException e2) {
                        Settings.log(0, "error loading 'hsyco.ini' file - IO Server '" + this.id + "': " + e2.getLocalizedMessage());
                    }
                }
                ++n3;
            }
        }
        Settings.log(1, "IO Server '" + this.id + "' - Options set to: " + optionsString);
    }

    void setAuthUser(String user2) throws InputException {
        this.authUser = user2;
        Settings.log(1, "IO Server '" + this.id + "' - AuthUser set to: " + this.authUser);
    }

    void setAuthPassword(String password) throws InputException {
        this.authPassword = password;
        Settings.log(1, "IO Server '" + this.id + "' - AuthPassword set to: " + this.authPassword);
    }

    void setShutdownInactive(String value) throws InputException {
        if (value == null || value.length() == 0) {
            this.shutdownInactive = null;
        } else if (value.equalsIgnoreCase("true")) {
            this.shutdownInactive = true;
        } else if (value.equalsIgnoreCase("false")) {
            this.shutdownInactive = false;
        } else {
            throw new InputException("Illegal Shutdown Inactive value for IO Server '" + this.id + "': " + value);
        }
        Settings.log(1, "IO Server '" + this.id + "' - ShutdownInactive set to: " + this.shutdownInactive);
    }

    void show(String session) {
        Settings.uiSet("ios.list", "value", this.id, session);
        Settings.uiSet("ios.selected", "visible", "true", session);
        Settings.uiSet("ios.enabled", "value", Boolean.toString(this.enabled), session);
        if (this.ioServerType.connectionIP() && this.ioServerType.connectionComm()) {
            Settings.uiSet("ios.connection", "enabled", "true", session);
        } else {
            Settings.uiSet("ios.connection", "enabled", "false", session);
        }
        Settings.uiSet("ios.connection", "value", "", session);
        if (this.ioServerType.connectionIP()) {
            if (this.ipAddress != null || this.port != null || !this.ioServerType.connectionComm()) {
                Settings.uiSet("ios.connection", "value", "ip", session);
                Settings.uiSet("ios.ip", "enabled", "true", session);
                Settings.uiSet("ios.ip.label", "opacity", "1", session);
                Settings.uiSet("ios.port", "enabled", "true", session);
                Settings.uiSet("ios.port.label", "opacity", "1", session);
            } else {
                Settings.uiSet("ios.ip", "enabled", "false", session);
                Settings.uiSet("ios.ip.label", "opacity", "0.5", session);
                Settings.uiSet("ios.port", "enabled", "false", session);
                Settings.uiSet("ios.port.label", "opacity", "0.5", session);
            }
            if (this.ipAddress != null) {
                Settings.uiSet("ios.ip", "value", this.ipAddress, session);
            } else {
                Settings.uiSet("ios.ip", "value", "", session);
            }
            if (this.port != null) {
                Settings.uiSet("ios.port", "value", this.port, session);
            } else {
                Settings.uiSet("ios.port", "value", "", session);
            }
        } else {
            Settings.uiSet("ios.ip", "enabled", "false", session);
            Settings.uiSet("ios.ip.label", "opacity", "0.5", session);
            Settings.uiSet("ios.ip", "value", "", session);
            Settings.uiSet("ios.port", "enabled", "false", session);
            Settings.uiSet("ios.port.label", "opacity", "0.5", session);
            Settings.uiSet("ios.port", "value", "", session);
        }
        if (this.ioServerType.connectionComm()) {
            if (this.ioServerType.hasCommType("port")) {
                Settings.uiSet("ios.comm.id.select", "visible", "false", session);
                Settings.uiSet("ios.comm.id.input", "visible", "true", session);
                Settings.uiSet("ios.comm.fail.id", "visible", "false", session);
                Settings.uiSet("ios.comm.add", "visible", "false", session);
            } else {
                Settings.uiSet("ios.comm.id.input", "visible", "false", session);
                Settings.uiSet("ios.comm.id.select", "visible", "true", session);
                Settings.uiSet("ios.comm.add", "visible", "true", session);
                List<String> commTypes = this.ioServerType.getCommTypes();
                StringBuilder commValues = new StringBuilder();
                StringBuilder commLabels = new StringBuilder();
                for (String commType : commTypes) {
                    if (commType.startsWith("io:")) {
                        int end = commType.indexOf(",");
                        String ioType = end < 3 ? commType.substring(3) : commType.substring(3, end);
                        for (IOServer ios : Settings.ioServers.values()) {
                            if (!ios.ioServerType.getId().equals(ioType)) continue;
                            commValues.append(',').append(ios.getId());
                            commLabels.append(',').append("IO: " + ios.getId());
                        }
                        continue;
                    }
                    if (!commType.startsWith("comm")) continue;
                    for (CommPort cp : Settings.commPorts.values()) {
                        commValues.append(',').append(cp.getId());
                        commLabels.append(',').append(cp.getId());
                    }
                }
                String vals = commValues.length() > 0 ? commValues.substring(1) : "";
                String labls = commLabels.length() > 0 ? commLabels.substring(1) : "";
                Settings.uiSet("ios.comm.id.select", "values", vals, session);
                Settings.uiSet("ios.comm.id.select", "labels", labls, session);
                if (this.ioServerType.hasCommType("comm2")) {
                    Settings.uiSet("ios.comm.fail.id", "visible", "true", session);
                    Settings.updateList(session, Settings.commPorts, "ios.comm.fail.id");
                } else {
                    Settings.uiSet("ios.comm.fail.id", "visible", "false", session);
                }
            }
            if (this.commId != null || !this.ioServerType.connectionIP()) {
                Settings.uiSet("ios.connection", "value", "comm", session);
                Settings.uiSet("ios.comm.id.input", "enabled", "true", session);
                Settings.uiSet("ios.comm.id.input", "value", this.commId != null ? this.commId : "", session);
                Settings.uiSet("ios.comm.id.select", "enabled", "true", session);
                Settings.uiSet("ios.comm.id.label", "opacity", "1", session);
                Settings.uiSet("ios.comm.id.select", "value", this.commId != null ? this.commId : "", session);
            } else {
                Settings.uiSet("ios.comm.id.input", "enabled", "false", session);
                Settings.uiSet("ios.comm.id.input", "value", "", session);
                Settings.uiSet("ios.comm.id.select", "enabled", "false", session);
                Settings.uiSet("ios.comm.id.label", "opacity", "0.5", session);
                Settings.uiSet("ios.comm.id.select", "value", "", session);
            }
            if (this.failoverCommId != null) {
                Settings.uiSet("ios.comm.fail.id", "value", this.failoverCommId, session);
            } else {
                Settings.uiSet("ios.comm.fail.id", "value", "", session);
            }
        } else {
            Settings.uiSet("ios.comm.id.input", "enabled", "false", session);
            Settings.uiSet("ios.comm.id.input", "value", "", session);
            Settings.uiSet("ios.comm.id.select", "enabled", "false", session);
            Settings.uiSet("ios.comm.id.label", "opacity", "0.5", session);
            Settings.uiSet("ios.comm.id.select", "value", "", session);
            Settings.uiSet("ios.comm.fail.id", "visible", "false", session);
            Settings.uiSet("ios.comm.add", "visible", "false", session);
        }
        if (this.ioServerType.getAuthType() == 0) {
            Settings.uiSet("ios.auth.user", "enabled", "true", session);
            Settings.uiSet("ios.auth.user.label", "opacity", "1", session);
            Settings.uiSet("ios.auth.password", "enabled", "true", session);
            Settings.uiSet("ios.auth.password.label", "opacity", "1", session);
            if (this.authUser != null) {
                Settings.uiSet("ios.auth.user", "value", this.authUser, session);
            } else {
                Settings.uiSet("ios.auth.user", "value", "", session);
            }
            if (this.authPassword != null) {
                Settings.uiSet("ios.auth.password", "value", this.authPassword, session);
            } else {
                Settings.uiSet("ios.auth.password", "value", "", session);
            }
        } else if (this.ioServerType.getAuthType() == 2) {
            Settings.uiSet("ios.auth.user", "enabled", "false", session);
            Settings.uiSet("ios.auth.user.label", "opacity", "0.5", session);
            Settings.uiSet("ios.auth.password", "enabled", "true", session);
            Settings.uiSet("ios.auth.password.label", "opacity", "1", session);
            Settings.uiSet("ios.auth.user", "value", "", session);
            if (this.authPassword != null) {
                Settings.uiSet("ios.auth.password", "value", this.authPassword, session);
            } else {
                Settings.uiSet("ios.auth.password", "value", "", session);
            }
        } else {
            Settings.uiSet("ios.auth.user", "enabled", "false", session);
            Settings.uiSet("ios.auth.user.label", "opacity", "0.5", session);
            Settings.uiSet("ios.auth.password", "enabled", "false", session);
            Settings.uiSet("ios.auth.password.label", "opacity", "0.5", session);
            Settings.uiSet("ios.auth.user", "value", "", session);
            Settings.uiSet("ios.auth.password", "value", "", session);
        }
        if (this.shutdownInactive != null) {
            Settings.uiSet("ios.shdwn", "value", this.shutdownInactive.toString(), session);
        } else {
            Settings.uiSet("ios.shdwn", "value", "", session);
        }
        Settings.updateList(session, this.options, "ios.option.list");
    }

    void setConnection(String value, String session) {
        if (value.equals("ip")) {
            this.commId = null;
            this.failoverCommId = null;
            this.ipAddress = "";
            this.port = "";
        } else {
            this.ipAddress = null;
            this.port = null;
            this.commId = "";
            this.failoverCommId = this.ioServerType.hasCommType("comm2") ? "" : null;
        }
        this.show(session);
    }

    void addOption(String optionId, String value, String session) throws InputException {
        if (this.options.containsKeyIgnoreCase(optionId)) {
            throw new InputException("Option already added");
        }
        this.setOptionValue(optionId, value, session);
    }

    void setOptionValue(String optionId, String value, String session) throws InputException {
        value = value.trim();
        Option o2 = new Option(optionId, value);
        this.options.put(o2.getId(), o2);
        Settings.updateList(session, this.options, "ios.option.list");
    }

    void loadOptions(String session) {
        StringBuilder values = new StringBuilder();
        for (IOServerType.OptionType ot : this.ioServerType.getSortedOptions()) {
            if (this.options.containsKeyIgnoreCase(ot.getId())) continue;
            values.append(',').append(ot.getId());
        }
        Settings.uiSet("ios.option.id.select", "values", values.length() > 0 ? values.substring(1) : "", session);
    }

    void loadOptionValues(String optionId, String session) {
        IOServerType.OptionType ot = this.ioServerType.getOption(optionId);
        if (ot.getInputType().equals("input")) {
            Settings.uiSet("ios.option.value.input", "visible", "true", session);
            Settings.uiSet("ios.option.value.select", "visible", "false", session);
            Settings.uiSet("ios.option.value.input", "validatevalue", ot.getFormat(), session);
            Settings.uiSet("ios.option.value.input", "validatekey", ot.getKeyFormat(), session);
            Option o2 = this.options.get(optionId);
            if (o2 != null) {
                Settings.uiSet("ios.option.value.input", "value", o2.getValue(), session);
            }
        } else {
            Settings.uiSet("ios.option.value.input", "visible", "false", session);
            Settings.uiSet("ios.option.value.input", "validatevalue", "", session);
            Settings.uiSet("ios.option.value.input", "validatekey", "", session);
            Settings.uiSet("ios.option.value.select", "visible", "true", session);
            Settings.uiSet("ios.option.value.select", "values", ot.getFormat().replace('|', ','), session);
            Option o3 = this.options.get(optionId);
            if (o3 != null) {
                Settings.uiSet("ios.option.value.select", "value", o3.getValue(), session);
            }
        }
    }

    void removeOption(String optionId, String session) {
        this.options.remove(optionId);
        Settings.updateList(session, this.options, "ios.option.list");
    }

    void writeIniDeclaration(BufferedWriter bw) throws IOException {
        if (this.ioServerType == null) {
            new Error("IO Server '" + this.id + "' - Type not specified. Remove this IO Server", this);
            return;
        }
        if (bw != null) {
            bw.write("ioServersType." + this.id);
            bw.write(" = ");
            bw.write(this.ioServerType.getId());
            bw.write("\n");
        }
        boolean ipSet = true;
        boolean portSet = true;
        boolean commSet = true;
        if (this.ipAddress == null || this.ipAddress.length() == 0) {
            ipSet = false;
        }
        if (this.port == null || this.port.length() == 0) {
            portSet = false;
        }
        if (this.commId == null || this.commId.length() == 0) {
            commSet = false;
        }
        if (this.ioServerType.connectionIP() || this.ioServerType.connectionComm()) {
            if (!(ipSet || portSet || commSet || this.ioServerType.connectionOptional())) {
                new Error("IO Server '" + this.id + "' - Communication parameters not set", this);
            } else if (this.ioServerType.connectionIP() && !commSet) {
                if (!ipSet) {
                    if (!this.ioServerType.connectionOptional()) {
                        new Error("IO Server '" + this.id + "' - IP address not set", this);
                    }
                } else {
                    if (bw != null) {
                        bw.write("ioServersIP." + this.id);
                        bw.write(" = ");
                        bw.write(this.ipAddress);
                        bw.write("\n");
                    }
                    if (bw != null && portSet) {
                        bw.write("ioServersPort." + this.id);
                        bw.write(" = ");
                        bw.write(this.port);
                        bw.write("\n");
                    }
                }
            } else if (this.ioServerType.connectionComm()) {
                if (!commSet) {
                    if (!this.ioServerType.connectionOptional()) {
                        new Error("IO Server '" + this.id + "' - Comm port not set", this);
                    }
                } else if (bw != null) {
                    bw.write("ioServersComm." + this.id);
                    bw.write(" = ");
                    bw.write(this.commId);
                    if (this.failoverCommId != null && this.failoverCommId.length() > 0) {
                        bw.write(", ");
                        bw.write(this.failoverCommId);
                    }
                    bw.write("\n");
                }
            } else {
                new Error("IO Server '" + this.id + "' - Communication parameters error", this);
            }
        }
        if (bw != null && this.options.size() > 0) {
            int optNum = this.options.size();
            bw.write("ioServersOptions." + this.id);
            bw.write(" = ");
            for (Option o2 : this.options.values()) {
                bw.write(o2.getId());
                bw.write("=");
                bw.write(o2.getValue());
                if (--optNum == 0) continue;
                bw.write(", ");
            }
            bw.write("\n");
        }
        if (this.ioServerType.getAuthType() == 0) {
            if (bw != null) {
                if (this.authUser != null && this.authUser.length() != 0) {
                    bw.write("ioServersAuth." + this.id + ".User");
                    bw.write(" = ");
                    bw.write(this.authUser);
                    bw.write("\n");
                }
                if (this.authPassword != null && this.authPassword.length() != 0) {
                    bw.write("ioServersAuth." + this.id + ".Password");
                    bw.write(" = ");
                    bw.write(this.authPassword);
                    bw.write("\n");
                }
            }
        } else if (this.ioServerType.getAuthType() == 2 && bw != null && this.authPassword != null && this.authPassword.length() != 0) {
            bw.write("ioServersAuth." + this.id + ".Password");
            bw.write(" = ");
            bw.write(this.authPassword);
            bw.write("\n");
        }
        if (this.shutdownInactive != null && bw != null) {
            bw.write("ioServersShutdownInactive." + this.id);
            bw.write(" = ");
            bw.write(this.shutdownInactive.toString());
            bw.write("\n");
        }
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }

    private class Option
    extends Listable {
        private final String value;

        Option(String id, String value) throws InputException {
            super(id);
            if (!IOServer.this.ioServerType.checkOptionValue(id, value)) {
                throw new InputException("Illegal value for option '" + id + "': " + value);
            }
            this.value = value;
        }

        @Override
        String getListLabel(String list) {
            return String.valueOf(this.id) + " = " + this.value;
        }

        String getValue() {
            return this.value;
        }
    }
}

