/*
 * Decompiled with CFR 0.152.
 */
package plugins.manager_settings;

import java.io.BufferedWriter;
import java.io.IOException;
import plugins.manager_settings.Error;
import plugins.manager_settings.InputException;
import plugins.manager_settings.Listable;
import plugins.manager_settings.Settings;

public class DMX
extends Listable {
    private String ip;
    private String port;
    private String comm;
    private String serverID;
    private boolean enabled = true;

    DMX(String id, boolean check) throws InputException {
        super(id);
        if (check && !id.matches("[a-z0-9]+")) {
            throw new InputException("Illegal DMXServer ID: " + id);
        }
        this.ip = "";
        Settings.log(1, "Created DMXServer '" + this.id + "'");
    }

    @Override
    String getListLabel(String list) {
        if (this.enabled) {
            return this.id;
        }
        return "<div style=\"color:#A0A0A0\">" + this.id + "</div>";
    }

    void setIP(String ip) throws InputException {
        if (ip != null && !ip.matches("([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])\\.([01]?\\d\\d?|2[0-4]\\d|25[0-5])")) {
            throw new InputException("Illegal IP address for DMXServer '" + this.id + "': " + ip);
        }
        this.ip = ip;
        Settings.log(1, "DMXServer '" + this.id + "' - IP set to: " + this.ip);
    }

    void setPort(String port) throws InputException {
        if (port != null) {
            int p;
            try {
                p = Integer.parseInt(port);
            }
            catch (NumberFormatException e2) {
                throw new InputException("Illegal port number for DMXServer '" + this.id + "': " + port);
            }
            if (p <= 0 || p >= 65535) {
                throw new InputException("Illegal port number for DMXServer '" + this.id + "': " + port);
            }
        }
        this.port = port;
        Settings.log(1, "DMXServer '" + this.id + "' - Port set to: " + this.port);
    }

    void setComm(String comm) throws InputException {
        if (comm != null && comm.length() == 0) {
            throw new InputException("Illegal CommPort for DMXServer '" + this.id + "':" + comm);
        }
        this.comm = comm;
        Settings.log(1, "DMXServer '" + this.id + "' - CommId set to: " + this.comm);
    }

    void setServerId(String id) throws InputException {
        if (id != null && id.length() == 0) {
            throw new InputException("Illegal ID for DMXServer '" + this.id + "':" + id);
        }
        this.serverID = id;
        Settings.log(1, "DMXServer '" + this.id + "' - ID set to: " + this.serverID);
    }

    void setConnection(String value, String session) {
        if (value.equals("ip")) {
            this.serverID = null;
            this.comm = null;
            this.ip = "";
            this.port = "";
        } else if (value.equals("comm")) {
            this.serverID = null;
            this.ip = null;
            this.port = null;
            this.comm = "";
        } else {
            this.serverID = "";
            this.ip = null;
            this.port = null;
            this.comm = null;
        }
        this.show(session);
    }

    void show(String session) {
        Settings.uiSet("dmx.selected", "visible", "true", session);
        Settings.uiSet("dmx.list", "value", this.id, session);
        Settings.uiSet("dmx.enabled", "value", Boolean.toString(this.enabled), session);
        if (this.comm != null) {
            Settings.uiSet("dmx.connection", "value", "comm", session);
            Settings.uiSet("dmx.comm", "enabled", "true", session);
            Settings.uiSet("dmx.comm", "value", this.comm, session);
        } else {
            Settings.uiSet("dmx.comm", "enabled", "false", session);
            Settings.uiSet("dmx.comm", "value", "", session);
        }
        if (this.serverID != null) {
            Settings.uiSet("dmx.connection", "value", "srvid", session);
            Settings.uiSet("dmx.srvid", "enabled", "true", session);
            Settings.uiSet("dmx.srvid", "value", this.serverID, session);
        } else {
            Settings.uiSet("dmx.srvid", "enabled", "false", session);
            Settings.uiSet("dmx.srvid", "value", "", session);
        }
        if (this.ip != null || this.port != null) {
            Settings.uiSet("dmx.connection", "value", "ip", session);
            Settings.uiSet("dmx.ip", "enabled", "true", session);
            Settings.uiSet("dmx.ip.label", "opacity", "1", session);
            Settings.uiSet("dmx.port", "enabled", "true", session);
            Settings.uiSet("dmx.port.label", "opacity", "1", session);
        } else {
            Settings.uiSet("dmx.ip", "enabled", "false", session);
            Settings.uiSet("dmx.ip.label", "opacity", "0.5", session);
            Settings.uiSet("dmx.port", "enabled", "false", session);
            Settings.uiSet("dmx.port.label", "opacity", "0.5", session);
        }
        Settings.uiSet("dmx.ip", "value", this.ip == null ? "" : this.ip, session);
        Settings.uiSet("dmx.port", "value", this.port == null ? "" : this.port, session);
    }

    public void writeIniDeclaration(BufferedWriter bw) throws IOException {
        boolean ipSet = true;
        boolean portSet = true;
        boolean commSet = true;
        boolean idSet = true;
        if (this.ip == null || this.ip.length() == 0) {
            ipSet = false;
        }
        if (this.port == null || this.port.length() == 0) {
            portSet = false;
        }
        if (this.comm == null || this.comm.length() == 0) {
            commSet = false;
        }
        if (this.serverID == null || this.serverID.length() == 0) {
            idSet = false;
        }
        if (commSet) {
            if (bw != null) {
                bw.write("dmxServersComm." + this.id);
                bw.write(" = ");
                bw.write(this.comm);
                bw.write("\n");
            }
        } else if (idSet) {
            if (bw != null) {
                bw.write("dmxServersId." + this.id);
                bw.write(" = ");
                bw.write(this.serverID);
                bw.write("\n");
            }
        } else {
            if (!ipSet) {
                new Error("DMX Server '" + this.id + "' - Communication parameters not set", this);
            }
            if (bw != null) {
                bw.write("dmxServersIP." + this.id);
                bw.write(" = ");
                bw.write(this.ip);
                bw.write("\n");
                if (portSet) {
                    bw.write("dmxServersPort." + this.id);
                    bw.write(" = ");
                    bw.write(this.port);
                    bw.write("\n");
                }
            }
        }
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    boolean isEnabled() {
        return this.enabled;
    }
}

