/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import org.jcodec.common.model.Picture;
import org.jcodec.scale.Transform;

public class Yuv422pToRgb
implements Transform {
    private int downShift;
    private int upShift;

    public Yuv422pToRgb(int downShift, int upShift) {
        this.downShift = downShift;
        this.upShift = upShift;
    }

    @Override
    public void transform(Picture src, Picture dst) {
        int[] y = src.getPlaneData(0);
        int[] u = src.getPlaneData(1);
        int[] v = src.getPlaneData(2);
        int[] data = dst.getPlaneData(0);
        int offLuma = 0;
        int offChroma = 0;
        for (int i2 = 0; i2 < dst.getHeight(); ++i2) {
            for (int j2 = 0; j2 < dst.getWidth(); j2 += 2) {
                Yuv422pToRgb.YUV444toRGB888(y[offLuma] << this.upShift >> this.downShift, u[offChroma] << this.upShift >> this.downShift, v[offChroma] << this.upShift >> this.downShift, data, offLuma * 3);
                Yuv422pToRgb.YUV444toRGB888(y[offLuma + 1] << this.upShift >> this.downShift, u[offChroma] << this.upShift >> this.downShift, v[offChroma] << this.upShift >> this.downShift, data, (offLuma + 1) * 3);
                offLuma += 2;
                ++offChroma;
            }
        }
    }

    public static final void YUV444toRGB888(int y, int u, int v, int[] data, int off) {
        int c2 = y - 16;
        int d2 = u - 128;
        int e2 = v - 128;
        int r = 298 * c2 + 409 * e2 + 128 >> 8;
        int g2 = 298 * c2 - 100 * d2 - 208 * e2 + 128 >> 8;
        int b2 = 298 * c2 + 516 * d2 + 128 >> 8;
        data[off] = Yuv422pToRgb.crop(b2);
        data[off + 1] = Yuv422pToRgb.crop(g2);
        data[off + 2] = Yuv422pToRgb.crop(r);
    }

    private static int crop(int val) {
        return val < 0 ? 0 : (val > 255 ? 255 : val);
    }
}

