/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import org.jcodec.common.model.ColorSpace;
import org.jcodec.scale.RgbToYuv420;
import org.jcodec.scale.RgbToYuv422;
import org.jcodec.scale.Transform;
import org.jcodec.scale.Yuv420pToRgb;
import org.jcodec.scale.Yuv420pToYuv422p;
import org.jcodec.scale.Yuv422pToRgb;

public class ColorUtil {
    public static Transform getTransform(ColorSpace from, ColorSpace to) {
        switch (from) {
            case RGB: {
                switch (to) {
                    case YUV420: {
                        return new RgbToYuv420(0, 0);
                    }
                    case YUV422: {
                        return new RgbToYuv422(0, 0);
                    }
                    case YUV422_10: {
                        return new RgbToYuv422(2, 0);
                    }
                    case YUV444: {
                        return null;
                    }
                }
            }
            case YUV420: {
                switch (to) {
                    case RGB: {
                        return new Yuv420pToRgb(0, 0);
                    }
                    case YUV422: {
                        return new Yuv420pToYuv422p(0, 0);
                    }
                    case YUV422_10: {
                        return new Yuv420pToYuv422p(0, 2);
                    }
                    case YUV444: {
                        return null;
                    }
                }
            }
            case YUV422: {
                switch (to) {
                    case RGB: {
                        return new Yuv422pToRgb(0, 0);
                    }
                    case YUV420: {
                        return null;
                    }
                    case YUV444: {
                        return null;
                    }
                }
            }
            case YUV422_10: {
                switch (to) {
                    case RGB: {
                        return new Yuv422pToRgb(2, 0);
                    }
                    case YUV420: {
                        return null;
                    }
                    case YUV444: {
                        return null;
                    }
                }
            }
        }
        return null;
    }
}

