/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.scale;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class AWTUtil {
    public static BufferedImage toBufferedImage(Picture src) {
        BufferedImage dst = new BufferedImage(src.getWidth(), src.getHeight(), 5);
        AWTUtil.toBufferedImage(src, dst);
        return dst;
    }

    public static void toBufferedImage(Picture src, BufferedImage dst) {
        byte[] data = ((DataBufferByte)dst.getRaster().getDataBuffer()).getData();
        int[] srcData = src.getPlaneData(0);
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = (byte)srcData[i2];
        }
    }

    public static Picture fromBufferedImage(BufferedImage src) {
        Picture dst = Picture.create(src.getWidth(), src.getHeight(), ColorSpace.RGB);
        AWTUtil.fromBufferedImage(src, dst);
        return dst;
    }

    public static void fromBufferedImage(BufferedImage src, Picture dst) {
        int[] dstData = dst.getPlaneData(0);
        int off = 0;
        for (int i2 = 0; i2 < src.getHeight(); ++i2) {
            for (int j2 = 0; j2 < src.getWidth(); ++j2) {
                int rgb1 = src.getRGB(j2, i2);
                dstData[off++] = rgb1 >> 16 & 0xFF;
                dstData[off++] = rgb1 >> 8 & 0xFF;
                dstData[off++] = rgb1 & 0xFF;
            }
        }
    }
}

