/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.AudioFormat;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.EndianBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.muxer.MP4Muxer;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.DownmixHelper;
import org.jcodec.movtool.streaming.tracks.PCMFlatternTrack;

public class StereoDownmixTrack
implements VirtualTrack {
    private static final int FRAMES_IN_OUT_PACKET = 20480;
    private VirtualTrack[] sources;
    private AudioSampleEntry[] sampleEntries;
    private int rate = -1;
    private int frameNo;
    private boolean[][] solo;
    private DownmixHelper downmix;

    public StereoDownmixTrack(VirtualTrack ... tracks) {
        this.sources = new VirtualTrack[tracks.length];
        this.sampleEntries = new AudioSampleEntry[this.sources.length];
        this.solo = new boolean[tracks.length][];
        for (int i2 = 0; i2 < tracks.length; ++i2) {
            SampleEntry se = tracks[i2].getSampleEntry();
            if (!(se instanceof AudioSampleEntry)) {
                throw new IllegalArgumentException("Non audio track");
            }
            AudioSampleEntry ase = (AudioSampleEntry)se;
            if (!ase.isPCM()) {
                throw new IllegalArgumentException("Non PCM audio track.");
            }
            AudioFormat format = ase.getFormat();
            if (this.rate != -1 && (float)this.rate != format.getFrameRate()) {
                throw new IllegalArgumentException("Can not downmix tracks of different rate.");
            }
            this.rate = (int)format.getFrameRate();
            this.sampleEntries[i2] = ase;
            this.sources[i2] = new PCMFlatternTrack(tracks[i2], 20480);
            this.solo[i2] = new boolean[format.getChannels()];
        }
        this.downmix = new DownmixHelper(this.sampleEntries, 20480, null);
    }

    public void soloTrack(int track, boolean s) {
        for (int ch = 0; ch < this.solo[track].length; ++ch) {
            this.solo[track][ch] = s;
        }
        this.downmix = new DownmixHelper(this.sampleEntries, 20480, this.solo);
    }

    public void soloChannel(int track, int channel, boolean s) {
        this.solo[track][channel] = s;
        this.downmix = new DownmixHelper(this.sampleEntries, 20480, this.solo);
    }

    public boolean isChannelMute(int track, int channel) {
        return this.solo[track][channel];
    }

    public boolean[][] bulkGetSolo() {
        return this.solo;
    }

    public void bulkSetSolo(boolean[][] solo) {
        this.solo = solo;
        this.downmix = new DownmixHelper(this.sampleEntries, 20480, solo);
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        VirtualPacket[] packets = new VirtualPacket[this.sources.length];
        boolean allNull = true;
        for (int i2 = 0; i2 < packets.length; ++i2) {
            packets[i2] = this.sources[i2].nextPacket();
            allNull &= packets[i2] == null;
        }
        if (allNull) {
            return null;
        }
        DownmixVirtualPacket ret = new DownmixVirtualPacket(packets, this.frameNo);
        this.frameNo += 20480;
        return ret;
    }

    @Override
    public SampleEntry getSampleEntry() {
        return MP4Muxer.audioSampleEntry("sowt", 1, 2, 2, this.rate, EndianBox.Endian.LITTLE_ENDIAN);
    }

    @Override
    public void close() {
        for (VirtualTrack virtualTrack : this.sources) {
            virtualTrack.close();
        }
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return null;
    }

    @Override
    public int getPreferredTimescale() {
        return this.rate;
    }

    protected class DownmixVirtualPacket
    implements VirtualPacket {
        private VirtualPacket[] packets;
        private int frameNo;

        public DownmixVirtualPacket(VirtualPacket[] packets, int pktNo) {
            this.packets = packets;
            this.frameNo = pktNo;
        }

        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer[] data = new ByteBuffer[this.packets.length];
            for (int i2 = 0; i2 < data.length; ++i2) {
                data[i2] = this.packets[i2] == null ? null : this.packets[i2].getData();
            }
            ByteBuffer out = ByteBuffer.allocate(81920);
            StereoDownmixTrack.this.downmix.downmix(data, out);
            return out;
        }

        @Override
        public int getDataLen() {
            return 81920;
        }

        @Override
        public double getPts() {
            return (double)this.frameNo / (double)StereoDownmixTrack.this.rate;
        }

        @Override
        public double getDuration() {
            return 20480.0 / (double)StereoDownmixTrack.this.rate;
        }

        @Override
        public boolean isKeyframe() {
            return true;
        }

        @Override
        public int getFrameNo() {
            return this.frameNo;
        }
    }
}

