/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.FramesMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.PCMMP4DemuxerTrack;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.FilePool;

public class RealTrack
implements VirtualTrack {
    private TrakBox trak;
    private FilePool pool;
    private AbstractMP4DemuxerTrack demuxer;
    private ByteBuffer dummy;
    private MovieBox movie;

    public RealTrack(MovieBox movie, TrakBox trak, FilePool pool) {
        this.movie = movie;
        this.dummy = ByteBuffer.allocate(0x200000);
        SampleSizesBox stsz = Box.findFirst((NodeBox)trak, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz");
        this.demuxer = stsz.getDefaultSize() == 0 ? new FramesMP4DemuxerTrack(movie, trak, null){

            @Override
            protected ByteBuffer readPacketData(SeekableByteChannel ch, ByteBuffer buffer, long position, int size) throws IOException {
                return buffer;
            }
        } : new PCMMP4DemuxerTrack(movie, trak, null){

            @Override
            protected ByteBuffer readPacketData(SeekableByteChannel ch, ByteBuffer buffer, long position, int size) throws IOException {
                return buffer;
            }
        };
        this.trak = trak;
        this.pool = pool;
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        MP4Packet pkt = this.demuxer.nextFrame(this.dummy);
        if (pkt == null) {
            return null;
        }
        return new RealPacket(pkt);
    }

    @Override
    public SampleEntry getSampleEntry() {
        return this.trak.getSampleEntries()[0];
    }

    @Override
    public void close() {
        System.out.println("CLOSING FILE");
        this.pool.close();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        List<Edit> edits = this.demuxer.getEdits();
        if (edits == null) {
            return null;
        }
        VirtualTrack.VirtualEdit[] result = new VirtualTrack.VirtualEdit[edits.size()];
        for (int i2 = 0; i2 < edits.size(); ++i2) {
            Edit ee = edits.get(i2);
            result[i2] = new VirtualTrack.VirtualEdit((double)ee.getMediaTime() / (double)this.trak.getTimescale(), (double)ee.getDuration() / (double)this.movie.getTimescale());
        }
        return result;
    }

    @Override
    public int getPreferredTimescale() {
        return (int)this.demuxer.getTimescale();
    }

    public class RealPacket
    implements VirtualPacket {
        private MP4Packet packet;

        public RealPacket(MP4Packet nextFrame) {
            this.packet = nextFrame;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ByteBuffer getData() throws IOException {
            ByteBuffer bb = ByteBuffer.allocate(this.packet.getSize());
            SeekableByteChannel ch = null;
            try {
                ch = RealTrack.this.pool.getChannel();
                ch.position(this.packet.getFileOff());
                ch.read(bb);
                bb.flip();
                ByteBuffer byteBuffer = bb;
                return byteBuffer;
            }
            finally {
                if (ch != null) {
                    ch.close();
                }
            }
        }

        @Override
        public int getDataLen() {
            return this.packet.getSize();
        }

        @Override
        public double getPts() {
            return (double)this.packet.getMediaPts() / (double)this.packet.getTimescale();
        }

        @Override
        public double getDuration() {
            return (double)this.packet.getDuration() / (double)this.packet.getTimescale();
        }

        @Override
        public boolean isKeyframe() {
            return this.packet.isKeyFrame();
        }

        @Override
        public int getFrameNo() {
            return (int)this.packet.getFrameNo();
        }
    }
}

