/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.jcodec.common.IntArrayList;
import org.jcodec.common.NIOUtils;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.EndianBox;
import org.jcodec.containers.mp4.boxes.channel.ChannelUtils;
import org.jcodec.containers.mp4.boxes.channel.Label;

public class DownmixHelper {
    private int nSamples;
    private ThreadLocal<float[][]> fltBuf = new ThreadLocal();
    private float[][] matrix;
    private int[][] counts;
    private int[][] channels;
    private AudioSampleEntry[] se;
    private static float rev = 4.656613E-10f;

    public DownmixHelper(AudioSampleEntry[] se, int nSamples, boolean[][] solo) {
        this.nSamples = nSamples;
        this.se = se;
        ArrayList<float[]> matrixBuilder = new ArrayList<float[]>();
        ArrayList<int[]> countsBuilder = new ArrayList<int[]>();
        ArrayList<int[]> channelsBuilder = new ArrayList<int[]>();
        for (int tr = 0; tr < se.length; ++tr) {
            Label[] channels = ChannelUtils.getLabels(se[tr]);
            IntArrayList tmp = new IntArrayList();
            block9: for (int ch = 0; ch < channels.length; ++ch) {
                if (solo != null && !solo[tr][ch]) continue;
                tmp.add(ch);
                switch (channels[ch]) {
                    case Left: 
                    case LeftTotal: 
                    case LeftCenter: {
                        matrixBuilder.add(new float[]{1.0f, 0.0f});
                        countsBuilder.add(new int[]{1, 0});
                        continue block9;
                    }
                    case LeftSurround: 
                    case RearSurroundLeft: {
                        matrixBuilder.add(new float[]{0.7f, 0.0f});
                        countsBuilder.add(new int[]{1, 0});
                        continue block9;
                    }
                    case Right: 
                    case RightTotal: 
                    case RightCenter: {
                        matrixBuilder.add(new float[]{0.0f, 1.0f});
                        countsBuilder.add(new int[]{0, 1});
                        continue block9;
                    }
                    case RightSurround: 
                    case RearSurroundRight: {
                        matrixBuilder.add(new float[]{0.0f, 0.7f});
                        countsBuilder.add(new int[]{0, 1});
                        continue block9;
                    }
                    case Mono: 
                    case LFEScreen: 
                    case Center: 
                    case LFE2: {
                        matrixBuilder.add(new float[]{0.7f, 0.7f});
                        countsBuilder.add(new int[]{1, 1});
                        continue block9;
                    }
                    case Unused: {
                        continue block9;
                    }
                }
            }
            channelsBuilder.add(tmp.toArray());
        }
        this.matrix = (float[][])matrixBuilder.toArray((T[])new float[0][]);
        this.counts = (int[][])countsBuilder.toArray((T[])new int[0][]);
        this.channels = (int[][])channelsBuilder.toArray((T[])new int[0][]);
    }

    public void downmix(ByteBuffer[] data, ByteBuffer out) {
        out.order(ByteOrder.LITTLE_ENDIAN);
        float[][] flt = this.fltBuf.get();
        if (flt == null) {
            flt = new float[this.matrix.length][this.nSamples];
            this.fltBuf.set(flt);
        }
        int i2 = 0;
        for (int tr = 0; tr < this.se.length; ++tr) {
            int ch = 0;
            while (ch < this.channels[tr].length) {
                this.toFloat(flt[i2], this.se[tr], data[tr], this.channels[tr][ch], this.se[tr].getChannelCount());
                ++ch;
                ++i2;
            }
        }
        for (int s = 0; s < this.nSamples; ++s) {
            int lcount = 0;
            int rcount = 0;
            float lSum = 0.0f;
            float lMul = 1.0f;
            float rSum = 0.0f;
            float rMul = 1.0f;
            for (int inp = 0; inp < this.matrix.length; ++inp) {
                float sample = flt[inp][s];
                float l2 = this.matrix[inp][0] * sample;
                float r = this.matrix[inp][1] * sample;
                lSum += l2;
                lMul *= l2;
                rSum += r;
                rMul *= r;
                lcount += this.counts[inp][0];
                rcount += this.counts[inp][1];
            }
            float outLeft = lcount > 1 ? DownmixHelper.clamp1f(lSum - lMul) : lSum;
            float outRight = rcount > 1 ? DownmixHelper.clamp1f(rSum - rMul) : rSum;
            short left = (short)(outLeft * 32767.0f);
            short right = (short)(outRight * 32767.0f);
            out.putShort(left);
            out.putShort(right);
        }
        out.flip();
    }

    private void toFloat(float[] fSamples, AudioSampleEntry se, ByteBuffer bb, int ch, int nCh) {
        int bi;
        int s;
        int maxSamples;
        int step;
        int len;
        int off;
        byte[] ba;
        if (bb.hasArray()) {
            ba = bb.array();
            off = bb.arrayOffset() + bb.position();
            len = bb.remaining();
        } else {
            ba = NIOUtils.toArray(bb);
            off = 0;
            len = ba.length;
        }
        if (se.calcSampleSize() == 3) {
            step = nCh * 3;
            maxSamples = Math.min(this.nSamples, len / step);
            if (se.getEndian() == EndianBox.Endian.BIG_ENDIAN) {
                s = 0;
                bi = off + ch * 3;
                while (s < maxSamples) {
                    fSamples[s] = DownmixHelper.nextSample24BE(ba, bi);
                    ++s;
                    bi += step;
                }
            } else {
                s = 0;
                bi = off + ch * 3;
                while (s < maxSamples) {
                    fSamples[s] = DownmixHelper.nextSample24LE(ba, bi);
                    ++s;
                    bi += step;
                }
            }
        } else {
            step = nCh * 2;
            maxSamples = Math.min(this.nSamples, len / step);
            if (se.getEndian() == EndianBox.Endian.BIG_ENDIAN) {
                s = 0;
                bi = off + ch * 2;
                while (s < maxSamples) {
                    fSamples[s] = DownmixHelper.nextSample16BE(ba, bi);
                    ++s;
                    bi += step;
                }
            } else {
                s = 0;
                bi = off + ch * 2;
                while (s < maxSamples) {
                    fSamples[s] = DownmixHelper.nextSample16LE(ba, bi);
                    ++s;
                    bi += step;
                }
            }
        }
        for (int s2 = maxSamples; s2 < this.nSamples; ++s2) {
            fSamples[s2] = 0.0f;
        }
    }

    public static final float clamp1f(float f2) {
        if (f2 > 1.0f) {
            return 1.0f;
        }
        if (f2 < -1.0f) {
            return -1.0f;
        }
        return f2;
    }

    private static final float nextSample24BE(byte[] ba, int bi) {
        return rev * (float)((ba[bi] & 0xFF) << 24 | (ba[bi + 1] & 0xFF) << 16 | (ba[bi + 2] & 0xFF) << 8);
    }

    private static final float nextSample24LE(byte[] ba, int bi) {
        return rev * (float)((ba[bi] & 0xFF) << 8 | (ba[bi + 1] & 0xFF) << 16 | (ba[bi + 2] & 0xFF) << 24);
    }

    private static final float nextSample16BE(byte[] ba, int bi) {
        return rev * (float)((ba[bi] & 0xFF) << 24 | (ba[bi + 1] & 0xFF) << 16);
    }

    private static final float nextSample16LE(byte[] ba, int bi) {
        return rev * (float)((ba[bi] & 0xFF) << 16 | (ba[bi + 1] & 0xFF) << 24);
    }
}

