/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool.streaming.tracks;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.movtool.streaming.VirtualPacket;
import org.jcodec.movtool.streaming.VirtualTrack;
import org.jcodec.movtool.streaming.tracks.VirtualPacketWrapper;

public class CachingTrack
implements VirtualTrack {
    private VirtualTrack src;
    private List<CachingPacket> cachedPackets = Collections.synchronizedList(new ArrayList());

    public CachingTrack(VirtualTrack src, final int policy, ScheduledExecutorService policyExecutor) {
        if (policy < 1) {
            throw new IllegalArgumentException("Caching track with less then 1 entry.");
        }
        this.src = src;
        policyExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                while (CachingTrack.this.cachedPackets.size() > policy) {
                    ((CachingPacket)CachingTrack.this.cachedPackets.get(0)).wipe();
                }
            }
        }, 200L, 200L, TimeUnit.MILLISECONDS);
    }

    @Override
    public SampleEntry getSampleEntry() {
        return this.src.getSampleEntry();
    }

    @Override
    public VirtualPacket nextPacket() throws IOException {
        VirtualPacket pkt = this.src.nextPacket();
        if (pkt == null) {
            return null;
        }
        return new CachingPacket(pkt);
    }

    @Override
    public void close() {
        this.src.close();
    }

    @Override
    public VirtualTrack.VirtualEdit[] getEdits() {
        return this.src.getEdits();
    }

    @Override
    public int getPreferredTimescale() {
        return this.src.getPreferredTimescale();
    }

    public class CachingPacket
    extends VirtualPacketWrapper {
        private ByteBuffer cache;

        public CachingPacket(VirtualPacket src) {
            super(src);
        }

        public synchronized void wipe() {
            if (CachingTrack.this.cachedPackets.indexOf(this) == 0) {
                CachingTrack.this.cachedPackets.remove(0);
                this.cache = null;
            }
        }

        @Override
        public synchronized ByteBuffer getData() throws IOException {
            CachingTrack.this.cachedPackets.remove(this);
            if (this.cache == null) {
                this.cache = this.src.getData();
            }
            CachingTrack.this.cachedPackets.add(this);
            return this.cache.duplicate();
        }
    }
}

