/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jcodec.common.FileChannelWrapper;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.containers.mp4.Brand;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.TrackType;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;
import org.jcodec.containers.mp4.demuxer.MP4Demuxer;
import org.jcodec.containers.mp4.muxer.FramesMP4MuxerTrack;
import org.jcodec.containers.mp4.muxer.MP4Muxer;
import org.jcodec.containers.mp4.muxer.PCMMP4MuxerTrack;

public class Remux {
    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("remux <movie>");
            return;
        }
        File tgt = new File(args[0]);
        File src = Remux.hidFile(tgt);
        tgt.renameTo(src);
        try {
            new Remux().remux(tgt, src);
        }
        catch (Throwable t) {
            tgt.renameTo(new File(tgt.getParentFile(), tgt.getName() + ".error"));
            src.renameTo(tgt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remux(File tgt, File src) throws IOException {
        FileChannelWrapper input = null;
        FileChannelWrapper output = null;
        try {
            input = NIOUtils.readableFileChannel(src);
            output = NIOUtils.writableFileChannel(tgt);
            MP4Demuxer demuxer = new MP4Demuxer(input);
            MP4Muxer muxer = new MP4Muxer((SeekableByteChannel)output, Brand.MOV);
            List<AbstractMP4DemuxerTrack> at = demuxer.getAudioTracks();
            ArrayList<PCMMP4MuxerTrack> audioTracks = new ArrayList<PCMMP4MuxerTrack>();
            for (AbstractMP4DemuxerTrack demuxerTrack : at) {
                PCMMP4MuxerTrack att = muxer.addUncompressedAudioTrack(((AudioSampleEntry)demuxerTrack.getSampleEntries()[0]).getFormat());
                audioTracks.add(att);
                att.setEdits(demuxerTrack.getEdits());
                att.setName(demuxerTrack.getName());
            }
            AbstractMP4DemuxerTrack vt = demuxer.getVideoTrack();
            FramesMP4MuxerTrack video = muxer.addTrackForCompressed(TrackType.VIDEO, (int)vt.getTimescale());
            video.setTimecode(muxer.addTimecodeTrack((int)vt.getTimescale()));
            video.setEdits(vt.getEdits());
            video.addSampleEntries(vt.getSampleEntries());
            MP4Packet pkt = null;
            while ((pkt = (MP4Packet)vt.nextFrame()) != null) {
                pkt = this.processFrame(pkt);
                video.addFrame(pkt);
                for (int i2 = 0; i2 < at.size(); ++i2) {
                    AudioSampleEntry ase = (AudioSampleEntry)at.get(i2).getSampleEntries()[0];
                    int frames = (int)(ase.getSampleRate() * (float)pkt.getDuration() / (float)vt.getTimescale());
                    MP4Packet apkt = (MP4Packet)at.get(i2).nextFrame();
                    ((PCMMP4MuxerTrack)audioTracks.get(i2)).addSamples(apkt.getData());
                }
            }
            muxer.writeHeader();
        }
        finally {
            if (input != null) {
                input.close();
            }
            if (output != null) {
                output.close();
            }
        }
    }

    protected MP4Packet processFrame(MP4Packet pkt) {
        return pkt;
    }

    public static File hidFile(File tgt) {
        File src = new File(tgt.getParentFile(), "." + tgt.getName());
        if (src.exists()) {
            int i2 = 1;
            while ((src = new File(tgt.getParentFile(), "." + tgt.getName() + "." + i2++)).exists()) {
            }
        }
        return src;
    }
}

