/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.movtool.QTEdit;

public class QTRefEdit {
    protected final QTEdit.CommandFactory[] factories;

    public QTRefEdit(QTEdit.CommandFactory ... factories) {
        this.factories = factories;
    }

    public void execute(String[] args) throws Exception {
        LinkedList<String> aa = new LinkedList<String>(Arrays.asList(args));
        LinkedList<QTEdit.Command> commands = new LinkedList<QTEdit.Command>();
        while (aa.size() > 0) {
            int i2;
            for (i2 = 0; i2 < this.factories.length; ++i2) {
                if (!aa.get(0).equals(this.factories[i2].getName())) continue;
                aa.remove(0);
                try {
                    commands.add(this.factories[i2].parseArgs(aa));
                    break;
                }
                catch (Exception e2) {
                    System.err.println("ERROR: " + e2.getMessage());
                    return;
                }
            }
            if (i2 != this.factories.length) continue;
            break;
        }
        if (aa.size() == 0) {
            System.err.println("ERROR: A movie file should be specified");
            this.help();
        }
        if (commands.size() == 0) {
            System.err.println("ERROR: At least one command should be specified");
            this.help();
        }
        File input = new File(aa.remove(0));
        if (aa.size() == 0) {
            System.err.println("ERROR: A movie output file should be specified");
            this.help();
        }
        File output = new File(aa.remove(0));
        if (!input.exists()) {
            System.err.println("ERROR: Input file '" + input.getAbsolutePath() + "' doesn't exist");
            this.help();
        }
        if (output.exists()) {
            System.err.println("WARNING: Output file '" + output.getAbsolutePath() + "' exist, overwritting");
        }
        MovieBox ref = MP4Util.createRefMovie(input);
        QTRefEdit.applyCommands(ref, commands);
        MP4Util.writeMovie(output, ref);
        System.out.println("INFO: Created reference file: " + output.getAbsolutePath());
    }

    private static void applyCommands(MovieBox mov, List<QTEdit.Command> commands) throws IOException {
        for (QTEdit.Command command : commands) {
            command.apply(mov);
        }
    }

    protected void help() {
        System.out.println("Quicktime movie editor");
        System.out.println("Syntax: qtedit <command1> <options> ... <commandN> <options> <movie> <output>");
        System.out.println("Where options:");
        for (QTEdit.CommandFactory commandFactory : this.factories) {
            System.out.println("\t" + commandFactory.getHelp());
        }
        System.exit(-1);
    }
}

