/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.movtool;

import java.io.File;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.movtool.Flattern;
import org.jcodec.movtool.InplaceEdit;

public class QTEdit {
    protected final CommandFactory[] factories;
    private final List<Flattern.ProgressListener> listeners = new ArrayList<Flattern.ProgressListener>();

    public QTEdit(CommandFactory ... factories) {
        this.factories = factories;
    }

    public void addProgressListener(Flattern.ProgressListener listener) {
        this.listeners.add(listener);
    }

    public void execute(String[] args) throws Exception {
        boolean inplace;
        File input;
        LinkedList<String> aa = new LinkedList<String>(Arrays.asList(args));
        final LinkedList<Command> commands = new LinkedList<Command>();
        while (aa.size() > 0) {
            int i2;
            for (i2 = 0; i2 < this.factories.length; ++i2) {
                if (!aa.get(0).equals(this.factories[i2].getName())) continue;
                aa.remove(0);
                try {
                    commands.add(this.factories[i2].parseArgs(aa));
                    break;
                }
                catch (Exception e2) {
                    System.err.println("ERROR: " + e2.getMessage());
                    return;
                }
            }
            if (i2 != this.factories.length) continue;
            break;
        }
        if (aa.size() == 0) {
            System.err.println("ERROR: A movie file should be specified");
            this.help();
        }
        if (commands.size() == 0) {
            System.err.println("ERROR: At least one command should be specified");
            this.help();
        }
        if (!(input = new File(aa.remove(0))).exists()) {
            System.err.println("ERROR: Input file '" + input.getAbsolutePath() + "' doesn't exist");
            this.help();
        }
        if (!(inplace = new InplaceEdit(){

            @Override
            protected void apply(MovieBox mov) {
                QTEdit.applyCommands(mov, commands);
            }
        }.save(input))) {
            MovieBox movie = MP4Util.createRefMovie(input);
            QTEdit.applyCommands(movie, commands);
            File out = new File(input.getParentFile(), "." + input.getName());
            Flattern fl = new Flattern();
            for (Flattern.ProgressListener pl : this.listeners) {
                fl.addProgressListener(pl);
            }
            fl.flattern(movie, out);
            out.renameTo(input);
        }
    }

    private static void applyCommands(MovieBox mov, List<Command> commands) {
        for (Command command : commands) {
            command.apply(mov);
        }
    }

    protected void help() {
        System.out.println("Quicktime movie editor");
        System.out.println("Syntax: qtedit <command1> <options> ... <commandN> <options> <movie>");
        System.out.println("Where options:");
        for (CommandFactory commandFactory : this.factories) {
            System.out.println("\t" + commandFactory.getHelp());
        }
        System.exit(-1);
    }

    public static abstract class BaseCommand
    implements Command {
        public void apply(MovieBox movie, FileChannel[][] refs) {
            this.apply(movie);
        }

        @Override
        public abstract void apply(MovieBox var1);
    }

    public static interface Command {
        public void apply(MovieBox var1);
    }

    public static interface CommandFactory {
        public String getName();

        public Command parseArgs(List<String> var1);

        public String getHelp();
    }
}

