/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mps;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jcodec.codecs.mpeg12.MPEGES;
import org.jcodec.codecs.mpeg12.SegmentReader;
import org.jcodec.common.NIOUtils;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.Packet;
import org.jcodec.common.model.TapeTimecode;

public class MPSDemuxer
extends SegmentReader {
    public static final int VIDEO_MIN = 480;
    public static final int VIDEO_MAX = 495;
    public static final int AUDIO_MIN = 448;
    public static final int AUDIO_MAX = 479;
    public static final int PRIVATE_1 = 445;
    public static final int PRIVATE_2 = 447;
    private Map<Integer, Track> streams = new HashMap<Integer, Track>();
    private SeekableByteChannel channel;

    public MPSDemuxer(SeekableByteChannel channel) throws IOException {
        super(channel);
        this.channel = channel;
        this.findStreams();
    }

    protected void findStreams() throws IOException {
        PESPacket nextPacket;
        for (int i2 = 0; (i2 == 0 || i2 < 3 * this.streams.size()) && (nextPacket = this.nextPacket(ByteBuffer.allocate(65536))) != null; ++i2) {
            this.addToStream(nextPacket);
        }
    }

    public void seekByte(long offset) throws IOException {
        this.channel.position(offset);
        for (Track track : this.streams.values()) {
            track.pending.clear();
        }
    }

    private void addToStream(PESPacket pkt) throws IOException {
        Track pes = this.streams.get(pkt.streamId);
        if (pes == null) {
            pes = new Track(pkt.streamId);
            this.streams.put(pkt.streamId, pes);
        }
        pes.pending(pkt);
    }

    public PESPacket nextPacket(ByteBuffer out) throws IOException {
        ByteBuffer dup = out.duplicate();
        while (this.curMarker < 445 || this.curMarker > 495) {
            this.skipToMarker();
        }
        this.readToNextMarker(dup);
        ByteBuffer fork = NIOUtils.from(dup, 4);
        PESPacket pkt = MPSDemuxer.readPES(fork, this.curPos());
        if (pkt.length == 0) {
            while ((this.curMarker < 445 || this.curMarker > 495) && this.readToNextMarker(dup)) {
            }
        } else {
            this.read(dup, pkt.length - (fork.position() - dup.position() - 4));
        }
        dup.flip();
        pkt.data = dup;
        return pkt;
    }

    public static PESPacket readPES(ByteBuffer iss, long pos) {
        int streamId = iss.getInt() & 0xFF;
        short len = iss.getShort();
        int b0 = iss.get() & 0xFF;
        if ((b0 & 0xC0) == 128) {
            return MPSDemuxer.mpeg2Pes(b0, len, streamId, iss, pos);
        }
        return MPSDemuxer.mpeg1Pes(b0, len, streamId, iss, pos);
    }

    public static PESPacket mpeg1Pes(int b0, int len, int streamId, ByteBuffer is, long pos) {
        int c2 = b0;
        while (c2 == 255) {
            c2 = is.get() & 0xFF;
        }
        if ((c2 & 0xC0) == 64) {
            is.get();
            c2 = is.get() & 0xFF;
        }
        long pts = -1L;
        long dts = -1L;
        if ((c2 & 0xF0) == 32) {
            pts = MPSDemuxer.readTs(is, c2);
        } else if ((c2 & 0xF0) == 48) {
            pts = MPSDemuxer.readTs(is, c2);
            dts = MPSDemuxer.readTs(is);
        } else if (c2 != 15) {
            throw new RuntimeException("Invalid data");
        }
        return new PESPacket(null, pts, streamId, len, pos);
    }

    public static long readTs(ByteBuffer is, int c2) {
        return ((long)c2 & 0xEL) << 29 | (long)((is.get() & 0xFF) << 22) | (long)((is.get() & 0xFF) >> 1 << 15) | (long)((is.get() & 0xFF) << 7) | (long)((is.get() & 0xFF) >> 1);
    }

    public static PESPacket mpeg2Pes(int b0, int len, int streamId, ByteBuffer is, long pos) {
        int flags1 = b0;
        int flags2 = is.get() & 0xFF;
        int header_len = is.get() & 0xFF;
        long pts = -1L;
        long dts = -1L;
        if ((flags2 & 0xC0) == 128) {
            pts = MPSDemuxer.readTs(is);
            NIOUtils.skip(is, header_len - 5);
        } else if ((flags2 & 0xC0) == 192) {
            pts = MPSDemuxer.readTs(is);
            dts = MPSDemuxer.readTs(is);
            NIOUtils.skip(is, header_len - 10);
        }
        return new PESPacket(null, pts, streamId, len, pos);
    }

    public static long readTs(ByteBuffer is) {
        return ((long)is.get() & 0xEL) << 29 | (long)((is.get() & 0xFF) << 22) | (long)((is.get() & 0xFF) >> 1 << 15) | (long)((is.get() & 0xFF) << 7) | (long)((is.get() & 0xFF) >> 1);
    }

    public static final boolean mediaStream(int streamId) {
        return streamId >= 448 && streamId <= 495 || streamId == 445 || streamId == 447;
    }

    public static final boolean videoStream(int streamId) {
        return streamId >= 480 && streamId <= 495;
    }

    public static boolean audioStream(Integer streamId) {
        return streamId >= 448 && streamId <= 479 || streamId == 445 || streamId == 447;
    }

    public List<Track> getTracks() {
        return new ArrayList<Track>(this.streams.values());
    }

    public List<Track> getVideoTracks() {
        return this.getTracks(480, 495);
    }

    public List<Track> getAudioTracks() {
        return this.getTracks(448, 479);
    }

    private List<Track> getTracks(int min, int max) {
        ArrayList<Track> result = new ArrayList<Track>();
        for (Track p : this.streams.values()) {
            if (p.streamId < min || p.streamId > max) continue;
            result.add(p);
        }
        return result;
    }

    public static int probe(ByteBuffer b2) {
        int marker = -1;
        int score = 0;
        boolean inVideoPes = false;
        boolean hasHeader = false;
        boolean slicesStarted = false;
        while (b2.hasRemaining()) {
            int code = b2.get() & 0xFF;
            if ((marker = marker << 8 | code) < 256 || marker > 511) continue;
            if (code >= 480 && code <= 495) {
                if (inVideoPes) break;
                inVideoPes = true;
                continue;
            }
            if (code >= 176 && code <= 184 && inVideoPes) {
                if (hasHeader && code != 181 && code != 178 || slicesStarted) break;
                score += 5;
                continue;
            }
            if (code == 0 && inVideoPes) {
                if (slicesStarted) break;
                hasHeader = true;
                continue;
            }
            if (code <= 0 || code >= 176) continue;
            if (!hasHeader) break;
            if (!slicesStarted) {
                score += 50;
                slicesStarted = true;
            }
            ++score;
        }
        return score;
    }

    public static class MPEGPacket
    extends Packet {
        private long offset;
        private ByteBuffer seq;
        private int gop;
        private int timecode;

        public MPEGPacket(ByteBuffer data, long pts, long timescale, long duration, long frameNo, boolean keyFrame, TapeTimecode tapeTimecode) {
            super(data, pts, timescale, duration, frameNo, keyFrame, tapeTimecode);
        }

        public long getOffset() {
            return this.offset;
        }

        public ByteBuffer getSeq() {
            return this.seq;
        }

        public int getGOP() {
            return this.gop;
        }

        public int getTimecode() {
            return this.timecode;
        }
    }

    public class Track
    implements ReadableByteChannel {
        private List<PESPacket> pending = new ArrayList<PESPacket>();
        private int streamId;
        private MPEGES es;

        public Track(int streamId) throws IOException {
            this.streamId = streamId;
            this.es = new MPEGES(this);
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        public int getSid() {
            return this.streamId;
        }

        public MPEGES getES() {
            return this.es;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public int read(ByteBuffer arg0) throws IOException {
            PESPacket pes = this.pending.size() > 0 ? this.pending.remove(0) : this.getPacket();
            NIOUtils.write(arg0, pes.data);
            return pes.data.remaining();
        }

        public void pending(PESPacket pkt) {
            this.pending.add(pkt);
        }

        public List<PESPacket> getPending() {
            return this.pending;
        }

        private PESPacket getPacket() throws IOException {
            PESPacket pkt;
            if (this.pending.size() > 0) {
                return this.pending.remove(0);
            }
            while ((pkt = MPSDemuxer.this.nextPacket(ByteBuffer.allocate(65536))) != null) {
                if (pkt.streamId == this.streamId) {
                    if (pkt.pts != -1L) {
                        this.es.curPts = pkt.pts;
                    }
                    return pkt;
                }
                MPSDemuxer.this.addToStream(pkt);
            }
            return null;
        }

        public MPEGPacket getFrame(ByteBuffer buf) throws IOException {
            return this.es.getFrame(buf);
        }
    }

    public static class PESPacket {
        public ByteBuffer data;
        public long pts;
        public int streamId;
        public int length;
        public long pos;

        public PESPacket(ByteBuffer data, long pts, int streamId, int length, long pos) {
            this.data = data;
            this.pts = pts;
            this.streamId = streamId;
            this.length = length;
            this.pos = pos;
        }
    }
}

