/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.demuxer;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.jcodec.common.SeekableByteChannel;
import org.jcodec.common.model.Packet;
import org.jcodec.containers.mp4.MP4Packet;
import org.jcodec.containers.mp4.QTTimeUtil;
import org.jcodec.containers.mp4.boxes.AudioSampleEntry;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.MovieBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleEntry;
import org.jcodec.containers.mp4.boxes.SampleSizesBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.demuxer.AbstractMP4DemuxerTrack;

public class PCMMP4DemuxerTrack
extends AbstractMP4DemuxerTrack {
    private int defaultSampleSize;
    private int posShift;
    protected int totalFrames;
    private SeekableByteChannel input;
    private MovieBox movie;

    public PCMMP4DemuxerTrack(MovieBox movie, TrakBox trak, SeekableByteChannel input) {
        super(trak);
        this.movie = movie;
        this.input = input;
        SampleSizesBox stsz = Box.findFirst((NodeBox)trak, SampleSizesBox.class, "mdia", "minf", "stbl", "stsz");
        this.defaultSampleSize = stsz.getDefaultSize();
        int chunks = 0;
        for (int i2 = 1; i2 < this.sampleToChunks.length; ++i2) {
            int ch = (int)(this.sampleToChunks[i2].getFirst() - this.sampleToChunks[i2 - 1].getFirst());
            this.totalFrames += ch * this.sampleToChunks[i2 - 1].getCount();
            chunks += ch;
        }
        this.totalFrames += this.sampleToChunks[this.sampleToChunks.length - 1].getCount() * (this.chunkOffsets.length - chunks);
    }

    @Override
    public Packet nextFrame() throws IOException {
        int frameSize = this.getFrameSize();
        int chSize = this.sampleToChunks[this.stscInd].getCount() * frameSize - this.posShift;
        return this.nextFrame(ByteBuffer.allocate(chSize));
    }

    @Override
    public synchronized MP4Packet nextFrame(ByteBuffer buffer) throws IOException {
        if (this.stcoInd >= this.chunkOffsets.length) {
            return null;
        }
        int frameSize = this.getFrameSize();
        int se = this.sampleToChunks[this.stscInd].getEntry();
        int chSize = this.sampleToChunks[this.stscInd].getCount() * frameSize;
        long pktOff = this.chunkOffsets[this.stcoInd] + (long)this.posShift;
        int pktSize = chSize - this.posShift;
        ByteBuffer result = this.readPacketData(this.input, buffer, pktOff, pktSize);
        long _pts = this.pts;
        int doneFrames = pktSize / frameSize;
        this.shiftPts(doneFrames);
        MP4Packet pkt = new MP4Packet(result, QTTimeUtil.mediaToEdited(this.box, _pts, this.movie.getTimescale()), this.timescale, (int)(this.pts - _pts), this.curFrame, true, null, _pts, se - 1, pktOff, pktSize);
        this.curFrame += (long)doneFrames;
        this.posShift = 0;
        ++this.stcoInd;
        if (this.stscInd < this.sampleToChunks.length - 1 && (long)(this.stcoInd + 1) == this.sampleToChunks[this.stscInd + 1].getFirst()) {
            ++this.stscInd;
        }
        return pkt;
    }

    public int getFrameSize() {
        SampleEntry entry = this.sampleEntries[this.sampleToChunks[this.stscInd].getEntry() - 1];
        if (entry instanceof AudioSampleEntry) {
            return ((AudioSampleEntry)entry).calcFrameSize();
        }
        return this.defaultSampleSize;
    }

    @Override
    protected void seekPointer(long frameNo) {
        long nextFrame;
        this.stcoInd = 0;
        this.stscInd = 0;
        this.curFrame = 0L;
        while ((nextFrame = this.curFrame + (long)this.sampleToChunks[this.stscInd].getCount()) <= frameNo) {
            this.curFrame = nextFrame;
            this.nextChunk();
        }
        this.posShift = (int)((frameNo - this.curFrame) * (long)this.getFrameSize());
        this.curFrame = frameNo;
    }

    @Override
    public long getFrameCount() {
        return this.totalFrames;
    }
}

