/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.jcodec.common.model.Rational;
import org.jcodec.common.model.Size;
import org.jcodec.containers.mp4.MP4Util;
import org.jcodec.containers.mp4.boxes.Box;
import org.jcodec.containers.mp4.boxes.ClearApertureBox;
import org.jcodec.containers.mp4.boxes.Edit;
import org.jcodec.containers.mp4.boxes.EncodedPixelBox;
import org.jcodec.containers.mp4.boxes.Header;
import org.jcodec.containers.mp4.boxes.MovieHeaderBox;
import org.jcodec.containers.mp4.boxes.NodeBox;
import org.jcodec.containers.mp4.boxes.SampleDescriptionBox;
import org.jcodec.containers.mp4.boxes.TrakBox;
import org.jcodec.containers.mp4.boxes.VideoSampleEntry;

public class MovieBox
extends NodeBox {
    public MovieBox(Header atom) {
        super(atom);
    }

    public static String fourcc() {
        return "moov";
    }

    public MovieBox() {
        super(new Header(MovieBox.fourcc()));
    }

    public MovieBox(MovieBox movie) {
        super(movie);
    }

    public TrakBox[] getTracks() {
        return MovieBox.findAll((Box)this, TrakBox.class, "trak");
    }

    public TrakBox getVideoTrack() {
        for (TrakBox trakBox : this.getTracks()) {
            if (!trakBox.isVideo()) continue;
            return trakBox;
        }
        return null;
    }

    public TrakBox getTimecodeTrack() {
        for (TrakBox trakBox : this.getTracks()) {
            if (!trakBox.isTimecode()) continue;
            return trakBox;
        }
        return null;
    }

    public int getTimescale() {
        return this.getMovieHeader().getTimescale();
    }

    public long rescale(long tv, long ts) {
        return tv * (long)this.getTimescale() / ts;
    }

    public void fixTimescale(int newTs) {
        int oldTs = this.getTimescale();
        this.setTimescale(newTs);
        for (TrakBox trakBox : this.getTracks()) {
            trakBox.setDuration(this.rescale(trakBox.getDuration(), oldTs));
            List<Edit> edits = trakBox.getEdits();
            if (edits == null) continue;
            ListIterator<Edit> lit = edits.listIterator();
            while (lit.hasNext()) {
                Edit edit = lit.next();
                lit.set(new Edit(this.rescale(edit.getDuration(), oldTs), edit.getMediaTime(), edit.getRate()));
            }
        }
        this.setDuration(this.rescale(this.getDuration(), oldTs));
    }

    private void setTimescale(int newTs) {
        MovieBox.findFirst((NodeBox)this, MovieHeaderBox.class, "mvhd").setTimescale(newTs);
    }

    public void setDuration(long movDuration) {
        this.getMovieHeader().setDuration(movDuration);
    }

    private MovieHeaderBox getMovieHeader() {
        return MovieBox.findFirst((NodeBox)this, MovieHeaderBox.class, "mvhd");
    }

    public List<TrakBox> getAudioTracks() {
        ArrayList<TrakBox> result = new ArrayList<TrakBox>();
        for (TrakBox trakBox : this.getTracks()) {
            if (!trakBox.isAudio()) continue;
            result.add(trakBox);
        }
        return result;
    }

    public long getDuration() {
        return this.getMovieHeader().getDuration();
    }

    public TrakBox importTrack(MovieBox movie, TrakBox track) {
        TrakBox newTrack = (TrakBox)MP4Util.cloneBox(track, 0x100000);
        List<Edit> edits = newTrack.getEdits();
        ArrayList<Edit> result = new ArrayList<Edit>();
        if (edits != null) {
            for (Edit edit : edits) {
                result.add(new Edit(this.rescale(edit.getDuration(), movie.getTimescale()), edit.getMediaTime(), edit.getRate()));
            }
        }
        newTrack.setEdits(result);
        return newTrack;
    }

    public void appendTrack(TrakBox newTrack) {
        newTrack.getTrackHeader().setNo(this.getMovieHeader().getNextTrackId());
        this.getMovieHeader().setNextTrackId(this.getMovieHeader().getNextTrackId() + 1);
        this.boxes.add(newTrack);
    }

    public boolean isPureRefMovie(MovieBox movie) {
        boolean pureRef = true;
        for (TrakBox trakBox : movie.getTracks()) {
            pureRef &= trakBox.isPureRef();
        }
        return pureRef;
    }

    public void updateDuration() {
        TrakBox[] tracks = this.getTracks();
        long min = Integer.MAX_VALUE;
        for (TrakBox trakBox : tracks) {
            if (trakBox.getDuration() >= min) continue;
            min = trakBox.getDuration();
        }
        this.getMovieHeader().setDuration(min);
    }

    public Size getDisplaySize() {
        TrakBox videoTrack = this.getVideoTrack();
        if (videoTrack == null) {
            return null;
        }
        ClearApertureBox clef = NodeBox.findFirst((NodeBox)videoTrack, ClearApertureBox.class, "tapt", "clef");
        if (clef != null) {
            return this.applyMatrix(videoTrack, new Size((int)clef.getWidth(), (int)clef.getHeight()));
        }
        Box box = NodeBox.findFirst((NodeBox)videoTrack, SampleDescriptionBox.class, "mdia", "minf", "stbl", "stsd").getBoxes().get(0);
        if (box == null || !(box instanceof VideoSampleEntry)) {
            return null;
        }
        VideoSampleEntry vs = (VideoSampleEntry)box;
        Rational par = videoTrack.getPAR();
        return this.applyMatrix(videoTrack, new Size(vs.getWidth() * par.getNum() / par.getDen(), vs.getHeight()));
    }

    private Size applyMatrix(TrakBox videoTrack, Size size) {
        int[] matrix = videoTrack.getTrackHeader().getMatrix();
        return new Size((int)((double)size.getWidth() * (double)matrix[0] / 65536.0), (int)((double)size.getHeight() * (double)matrix[4] / 65536.0));
    }

    public Size getStoredSize() {
        TrakBox videoTrack = this.getVideoTrack();
        if (videoTrack == null) {
            return null;
        }
        EncodedPixelBox enof = NodeBox.findFirst((NodeBox)videoTrack, EncodedPixelBox.class, "tapt", "enof");
        if (enof != null) {
            return new Size((int)enof.getWidth(), (int)enof.getHeight());
        }
        Box box = NodeBox.findFirst((NodeBox)videoTrack, SampleDescriptionBox.class, "mdia", "minf", "stbl", "stsd").getBoxes().get(0);
        if (box == null || !(box instanceof VideoSampleEntry)) {
            return null;
        }
        VideoSampleEntry vs = (VideoSampleEntry)box;
        return new Size(vs.getWidth(), vs.getHeight());
    }
}

