/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mp4.boxes;

import java.nio.ByteBuffer;
import org.jcodec.containers.mp4.boxes.FullBox;
import org.jcodec.containers.mp4.boxes.Header;

public class CompositionOffsetsBox
extends FullBox {
    private Entry[] entries;

    public CompositionOffsetsBox() {
        super(new Header(CompositionOffsetsBox.fourcc()));
    }

    public CompositionOffsetsBox(Entry[] entries) {
        super(new Header(CompositionOffsetsBox.fourcc()));
        this.entries = entries;
    }

    public static String fourcc() {
        return "ctts";
    }

    @Override
    public void parse(ByteBuffer input) {
        super.parse(input);
        int num = input.getInt();
        this.entries = new Entry[num];
        for (int i2 = 0; i2 < num; ++i2) {
            this.entries[i2] = new Entry(input.getInt(), input.getInt());
        }
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        super.doWrite(out);
        out.putInt(this.entries.length);
        for (int i2 = 0; i2 < this.entries.length; ++i2) {
            out.putInt(this.entries[i2].count);
            out.putInt(this.entries[i2].offset);
        }
    }

    public Entry[] getEntries() {
        return this.entries;
    }

    public static class Entry {
        public int count;
        public int offset;

        public Entry(int count, int offset) {
            this.count = count;
            this.offset = offset;
        }

        public int getCount() {
            return this.count;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

