/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.elements;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.jcodec.common.ByteArrayList;
import org.jcodec.containers.mkv.Reader;
import org.jcodec.containers.mkv.Type;
import org.jcodec.containers.mkv.ebml.BinaryElement;
import org.jcodec.containers.mkv.ebml.Element;
import org.jcodec.containers.mkv.ebml.SignedIntegerElement;

public class BlockElement
extends BinaryElement {
    private static final String XIPH = "Xiph";
    private static final String EBML = "EBML";
    private static final String FIXED = "Fixed";
    private static final int MAX_BLOCK_HEADER_SIZE = 512;
    public long[] frameOffsets;
    public long[] frameSizes;
    public long trackNumber;
    public int timecode;
    public long absoluteTimecode;
    public boolean keyFrame;
    public int headerSize;
    public String lacing;
    public boolean discardable;
    public boolean lacingPresent;
    private byte[][] frames;

    public static BlockElement copy(BlockElement old) {
        BlockElement be = new BlockElement(old.id);
        be.trackNumber = old.trackNumber;
        be.timecode = old.timecode;
        be.absoluteTimecode = old.absoluteTimecode;
        be.keyFrame = old.keyFrame;
        be.headerSize = old.headerSize;
        be.lacing = old.lacing;
        be.discardable = old.discardable;
        be.lacingPresent = old.lacingPresent;
        be.frameOffsets = new long[old.frameOffsets.length];
        be.frameSizes = new long[old.frameSizes.length];
        be.dataOffset = old.dataOffset;
        be.offset = old.offset;
        be.type = old.type;
        System.arraycopy(old.frameOffsets, 0, be.frameOffsets, 0, be.frameOffsets.length);
        System.arraycopy(old.frameSizes, 0, be.frameSizes, 0, be.frameSizes.length);
        return be;
    }

    public BlockElement(byte[] type) {
        super(type);
        if (!Arrays.equals(Type.SimpleBlock.id, type) && !Arrays.equals(Type.Block.id, type)) {
            throw new IllegalArgumentException("Block initiated with invalid id: " + Reader.printAsHex(type));
        }
    }

    @Override
    public void readData(FileChannel source) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate((int)(512L > this.size ? this.size : 512L));
        source.read(bb);
        source.position(this.dataOffset + this.size);
        bb.flip();
        this.trackNumber = Reader.getEbmlVInt(bb);
        int blockTimecode1 = bb.get() & 0xFF;
        int blockTimecode2 = bb.get() & 0xFF;
        short tc = (short)((short)blockTimecode1 << 8 | (short)blockTimecode2);
        this.timecode = tc;
        int flags = bb.get() & 0xFF;
        this.keyFrame = (flags & 0x80) > 0;
        this.discardable = (flags & 1) > 0;
        int laceFlags = flags & 6;
        boolean bl = this.lacingPresent = laceFlags != 0;
        if (this.lacingPresent) {
            int lacesCount = bb.get() & 0xFF;
            this.frameSizes = new long[lacesCount + 1];
            if (laceFlags == 2) {
                this.lacing = XIPH;
                this.headerSize = BlockElement.readXiphLaceSizes(bb, this.frameSizes, (int)this.size, bb.position());
            } else if (laceFlags == 6) {
                this.lacing = EBML;
                this.headerSize = BlockElement.readEBMLLaceSizes(bb, this.frameSizes, (int)this.size, bb.position());
            } else if (laceFlags == 4) {
                this.lacing = FIXED;
                this.headerSize = bb.position();
                int aLaceSize = (int)((this.size - (long)this.headerSize) / (long)(lacesCount + 1));
                Arrays.fill(this.frameSizes, (long)aLaceSize);
            } else {
                throw new RuntimeException("Unsupported lacing type flag.");
            }
            this.turnSizesToFrameOffsets(this.frameSizes);
        } else {
            this.lacing = "";
            long frameOffset = this.dataOffset + (long)bb.position();
            this.frameOffsets = new long[1];
            this.frameOffsets[0] = frameOffset;
            this.headerSize = bb.position();
            this.frameSizes = new long[1];
            this.frameSizes[0] = this.size - (long)this.headerSize;
        }
    }

    private void turnSizesToFrameOffsets(long[] sizes) {
        this.frameOffsets = new long[sizes.length];
        this.frameOffsets[0] = this.dataOffset + (long)this.headerSize;
        for (int i2 = 1; i2 < sizes.length; ++i2) {
            this.frameOffsets[i2] = this.frameOffsets[i2 - 1] + sizes[i2 - 1];
        }
    }

    public static int readXiphLaceSizes(ByteBuffer bb, long[] sizes, int size, int preLacingHeaderSize) {
        int startPos = bb.position();
        int lastIndex = sizes.length - 1;
        sizes[lastIndex] = size;
        for (int l2 = 0; l2 < lastIndex; ++l2) {
            int laceSize = 255;
            while (laceSize == 255) {
                laceSize = bb.get() & 0xFF;
                int n2 = l2;
                sizes[n2] = sizes[n2] + (long)laceSize;
            }
            int n3 = lastIndex;
            sizes[n3] = sizes[n3] - sizes[l2];
        }
        int headerSize = bb.position() - startPos + preLacingHeaderSize;
        int n4 = lastIndex;
        sizes[n4] = sizes[n4] - (long)headerSize;
        return headerSize;
    }

    public static int readEBMLLaceSizes(ByteBuffer source, long[] sizes, int size, int preLacingHeaderSize) {
        int lastIndex = sizes.length - 1;
        sizes[lastIndex] = size;
        int startPos = source.position();
        sizes[0] = Reader.getEbmlVInt(source);
        int n2 = lastIndex;
        sizes[n2] = sizes[n2] - sizes[0];
        long laceSize = sizes[0];
        long laceSizeDiff = 0L;
        for (int l2 = 1; l2 < lastIndex; ++l2) {
            laceSizeDiff = Reader.getSignedEbmlVInt(source);
            sizes[l2] = laceSize += laceSizeDiff;
            int n3 = lastIndex;
            sizes[n3] = sizes[n3] - sizes[l2];
        }
        int headerSize = source.position() - startPos + preLacingHeaderSize;
        int n4 = lastIndex;
        sizes[n4] = sizes[n4] - (long)headerSize;
        return headerSize;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{dataOffset: ").append(this.dataOffset);
        sb.append(", trackNumber: ").append(this.trackNumber);
        sb.append(", timecode: ").append(this.timecode);
        sb.append(", keyFrame: ").append(this.keyFrame);
        sb.append(", headerSize: ").append(this.headerSize);
        sb.append(", lacing: ").append(this.lacing);
        for (int i2 = 0; i2 < this.frameSizes.length; ++i2) {
            sb.append(", frame[").append(i2).append("]  offset ").append(this.frameOffsets[i2]).append(" size ").append(this.frameSizes[i2]);
        }
        sb.append(" }");
        return sb.toString();
    }

    public byte[][] getFrames(FileChannel source) throws IOException {
        byte[][] frames = new byte[this.frameSizes.length][];
        for (int i2 = 0; i2 < this.frameSizes.length; ++i2) {
            ByteBuffer bb = ByteBuffer.allocate((int)this.frameSizes[i2]);
            source.position(this.frameOffsets[i2]);
            source.read(bb);
            bb.flip();
            frames[i2] = bb.array();
        }
        return frames;
    }

    public void readFrames(FileChannel source) throws IOException {
        this.frames = this.getFrames(source);
    }

    @Override
    public ByteBuffer mux() {
        int dataSize = (int)this.getDataSize();
        ByteBuffer bb = ByteBuffer.allocate(dataSize + BlockElement.getEbmlSize(dataSize) + this.id.length);
        bb.put(this.id);
        bb.put(BlockElement.ebmlBytes(dataSize));
        bb.put(BlockElement.ebmlBytes(this.trackNumber));
        bb.put((byte)(this.timecode >>> 8 & 0xFF));
        bb.put((byte)(this.timecode & 0xFF));
        int flags = 0;
        if (XIPH.equals(this.lacing)) {
            flags = 2;
        } else if (EBML.equals(this.lacing)) {
            flags = 6;
        } else if (FIXED.equals(this.lacing)) {
            flags = 4;
        }
        if (this.discardable) {
            flags = (byte)(flags | 1);
        }
        if (this.keyFrame) {
            flags = (byte)(flags | 0x80);
        }
        bb.put((byte)flags);
        if ((flags & 6) != 0) {
            bb.put((byte)(this.frames.length - 1 & 0xFF));
            bb.put(this.muxLacingInfo());
        }
        for (byte[] frame : this.frames) {
            bb.put(frame);
        }
        bb.flip();
        return bb;
    }

    public void seekAndReadContent(FileChannel source) throws IOException {
        this.data = ByteBuffer.allocate((int)this.size);
        source.position(this.dataOffset);
        source.read(this.data);
        this.data.flip();
    }

    @Override
    public long getSize() {
        long size = this.getDataSize();
        size += (long)BlockElement.getEbmlSize(size);
        return size += (long)this.id.length;
    }

    public long getDataSize() {
        long size = 0L;
        for (long fsize : this.frameSizes) {
            size += fsize;
        }
        if (this.lacingPresent) {
            size += (long)this.muxLacingInfo().length;
            ++size;
        }
        size += 3L;
        return size += (long)BlockElement.getEbmlSize(this.trackNumber);
    }

    private byte[] muxLacingInfo() {
        if (EBML.equals(this.lacing)) {
            return BlockElement.muxEbmlLacing(this.frameSizes);
        }
        if (XIPH.equals(this.lacing)) {
            return BlockElement.muxXiphLacing(this.frameSizes);
        }
        if (FIXED.equals(this.lacing)) {
            return new byte[0];
        }
        return null;
    }

    public static long[] calcEbmlLacingDiffs(long[] laceSizes) {
        int lacesCount = laceSizes.length - 1;
        long[] out = new long[lacesCount];
        out[0] = (int)laceSizes[0];
        for (int i2 = 1; i2 < lacesCount; ++i2) {
            out[i2] = laceSizes[i2] - laceSizes[i2 - 1];
        }
        return out;
    }

    public static byte[] muxEbmlLacing(long[] laceSizes) {
        ByteArrayList bytes = new ByteArrayList();
        long[] laceSizeDiffs = BlockElement.calcEbmlLacingDiffs(laceSizes);
        bytes.addAll(Element.ebmlBytes(laceSizeDiffs[0]));
        for (int i2 = 1; i2 < laceSizeDiffs.length; ++i2) {
            bytes.addAll(SignedIntegerElement.convertToBytes(laceSizeDiffs[i2]));
        }
        return bytes.toArray();
    }

    public static byte[] muxXiphLacing(long[] laceSizes) {
        ByteArrayList bytes = new ByteArrayList();
        for (int i2 = 0; i2 < laceSizes.length - 1; ++i2) {
            long laceSize;
            for (laceSize = laceSizes[i2]; laceSize >= 255L; laceSize -= 255L) {
                bytes.add((byte)-1);
            }
            bytes.add((byte)laceSize);
        }
        return bytes.toArray();
    }
}

