/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv.ebml;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import org.jcodec.containers.mkv.Reader;
import org.jcodec.containers.mkv.ebml.Element;

public class MasterElement
extends Element {
    protected long usedSize = 0L;
    public final ArrayList<Element> children = new ArrayList();

    public MasterElement(byte[] type) {
        super(type);
    }

    public Element readNextChild(Reader reader) throws IOException {
        if (this.usedSize >= this.size) {
            return null;
        }
        long start = reader.getPos();
        Element elem = reader.readNextElement();
        if (elem == null) {
            while (elem == null && reader.getPos() < reader.getAvailable()) {
                long pos = reader.getPos();
                this.usedSize += pos - start;
                start = pos;
                elem = reader.readNextElement();
            }
            if (elem == null || this.usedSize >= this.size) {
                return null;
            }
        }
        elem.setParent(this);
        this.usedSize += elem.getSize();
        return elem;
    }

    @Override
    public void skipData(FileChannel source) throws IOException {
        long l2 = this.size + this.dataOffset;
        source.position(l2);
        this.usedSize = this.size;
    }

    public void addChildElement(Element elem) {
        if (elem == null) {
            return;
        }
        elem.setParent(this);
        this.children.add(elem);
    }

    @Override
    public long mux(FileChannel os) throws IOException {
        return os.write(this.mux());
    }

    @Override
    public ByteBuffer mux() {
        int size = this.getDataSize();
        ByteBuffer bb = ByteBuffer.allocate(this.id.length + Element.getEbmlSize(size) + size);
        bb.put(this.id);
        bb.put(MasterElement.ebmlBytes(size));
        for (int i2 = 0; i2 < this.children.size(); ++i2) {
            Element elem = this.children.get(i2);
            bb.put(elem.mux());
        }
        bb.flip();
        return bb;
    }

    private int getDataSize() {
        int returnValue = 0;
        if (this.children != null && !this.children.isEmpty()) {
            for (Element e2 : this.children) {
                returnValue = (int)((long)returnValue + e2.getSize());
            }
        } else {
            returnValue = (int)((long)returnValue + this.size);
        }
        return returnValue;
    }

    @Override
    public long getSize() {
        long returnValue = this.getDataSize();
        returnValue += (long)Element.getEbmlSize(returnValue);
        return returnValue += (long)this.id.length;
    }
}

