/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jcodec.containers.mkv.Reader;
import org.jcodec.containers.mkv.ebml.BinaryElement;
import org.jcodec.containers.mkv.ebml.DateElement;
import org.jcodec.containers.mkv.ebml.Element;
import org.jcodec.containers.mkv.ebml.FloatElement;
import org.jcodec.containers.mkv.ebml.MasterElement;
import org.jcodec.containers.mkv.ebml.SignedIntegerElement;
import org.jcodec.containers.mkv.ebml.StringElement;
import org.jcodec.containers.mkv.ebml.UnsignedIntegerElement;
import org.jcodec.containers.mkv.elements.Attachments;
import org.jcodec.containers.mkv.elements.BlockElement;
import org.jcodec.containers.mkv.elements.Chapters;
import org.jcodec.containers.mkv.elements.Cluster;
import org.jcodec.containers.mkv.elements.CuePoint;
import org.jcodec.containers.mkv.elements.Info;
import org.jcodec.containers.mkv.elements.Tags;
import org.jcodec.containers.mkv.elements.TrackEntryElement;
import org.jcodec.containers.mkv.elements.Tracks;

public enum Type {
    Void(new byte[]{-20}, BinaryElement.class),
    CRC32(new byte[]{-65}, BinaryElement.class),
    EBML(new byte[]{26, 69, -33, -93}, MasterElement.class),
    EBMLVersion(new byte[]{66, -122}),
    EBMLReadVersion(new byte[]{66, -9}),
    EBMLMaxIDLength(new byte[]{66, -14}),
    EBMLMaxSizeLength(new byte[]{66, -13}),
    DocType(new byte[]{66, -126}, StringElement.class),
    DocTypeVersion(new byte[]{66, -121}),
    DocTypeReadVersion(new byte[]{66, -123}),
    Segment(new byte[]{24, 83, -128, 103}, MasterElement.class),
    SeekHead(new byte[]{17, 77, -101, 116}, MasterElement.class),
    Seek(new byte[]{77, -69}, MasterElement.class),
    SeekID(new byte[]{83, -85}, BinaryElement.class),
    SeekPosition(new byte[]{83, -84}),
    Info(new byte[]{21, 73, -87, 102}, Info.class),
    SegmentUID(new byte[]{115, -92}, BinaryElement.class),
    SegmentFilename(new byte[]{115, -124}, StringElement.class),
    PrevUID(new byte[]{60, -71, 35}, BinaryElement.class),
    PrevFilename(new byte[]{60, -125, -85}, StringElement.class),
    NextUID(new byte[]{62, -71, 35}, BinaryElement.class),
    NextFilenam(new byte[]{62, -125, -69}, StringElement.class),
    SegmentFamily(new byte[]{68, 68}, BinaryElement.class),
    ChapterTranslate(new byte[]{105, 36}, MasterElement.class),
    ChapterTranslateEditionUID(new byte[]{105, -4}),
    ChapterTranslateCodec(new byte[]{105, -65}),
    ChapterTranslateID(new byte[]{105, -91}, BinaryElement.class),
    TimecodeScale(new byte[]{42, -41, -79}),
    Duration(new byte[]{68, -119}, FloatElement.class),
    DateUTC(new byte[]{68, 97}, DateElement.class),
    Title(new byte[]{123, -87}, StringElement.class),
    MuxingApp(new byte[]{77, -128}, StringElement.class),
    WritingApp(new byte[]{87, 65}, StringElement.class),
    Cluster(new byte[]{31, 67, -74, 117}, Cluster.class),
    Timecode(new byte[]{-25}),
    SilentTracks(new byte[]{88, 84}, MasterElement.class),
    SilentTrackNumber(new byte[]{88, -41}),
    Position(new byte[]{-89}),
    PrevSize(new byte[]{-85}),
    SimpleBlock(new byte[]{-93}, BlockElement.class),
    BlockGroup(new byte[]{-96}, MasterElement.class),
    Block(new byte[]{-95}, BlockElement.class),
    BlockAdditions(new byte[]{117, -95}, MasterElement.class),
    BlockMore(new byte[]{-90}, MasterElement.class),
    BlockAddID(new byte[]{-18}),
    BlockAdditional(new byte[]{-91}, BinaryElement.class),
    BlockDuration(new byte[]{-101}),
    ReferencePriority(new byte[]{-6}),
    ReferenceBlock(new byte[]{-5}, SignedIntegerElement.class),
    CodecState(new byte[]{-92}, BinaryElement.class),
    Slices(new byte[]{-114}, MasterElement.class),
    TimeSlice(new byte[]{-24}, MasterElement.class),
    LaceNumber(new byte[]{-52}),
    Tracks(new byte[]{22, 84, -82, 107}, Tracks.class),
    TrackEntry(new byte[]{-82}, TrackEntryElement.class),
    TrackNumber(new byte[]{-41}),
    TrackUID(new byte[]{115, -59}),
    TrackType(new byte[]{-125}),
    FlagEnabled(new byte[]{-71}),
    FlagDefault(new byte[]{-120}),
    FlagForced(new byte[]{85, -86}),
    FlagLacing(new byte[]{-100}),
    MinCache(new byte[]{109, -25}),
    MaxCache(new byte[]{109, -8}),
    DefaultDuration(new byte[]{35, -29, -125}),
    MaxBlockAdditionID(new byte[]{85, -18}),
    Name(new byte[]{83, 110}, StringElement.class),
    Language(new byte[]{34, -75, -100}, StringElement.class),
    CodecID(new byte[]{-122}, StringElement.class),
    CodecPrivate(new byte[]{99, -94}, BinaryElement.class),
    CodecName(new byte[]{37, -122, -120}, StringElement.class),
    AttachmentLink(new byte[]{116, 70}),
    CodecDecodeAll(new byte[]{-86}),
    TrackOverlay(new byte[]{111, -85}),
    TrackTranslate(new byte[]{102, 36}, MasterElement.class),
    TrackTranslateEditionUID(new byte[]{102, -4}),
    TrackTranslateCodec(new byte[]{102, -65}),
    TrackTranslateTrackID(new byte[]{102, -91}, BinaryElement.class),
    Video(new byte[]{-32}, MasterElement.class),
    FlagInterlaced(new byte[]{-102}),
    StereoMode(new byte[]{83, -72}),
    AlphaMode(new byte[]{83, -64}),
    PixelWidth(new byte[]{-80}),
    PixelHeight(new byte[]{-70}),
    PixelCropBottom(new byte[]{84, -86}),
    PixelCropTop(new byte[]{84, -69}),
    PixelCropLeft(new byte[]{84, -52}),
    PixelCropRight(new byte[]{84, -35}),
    DisplayWidth(new byte[]{84, -80}),
    DisplayHeight(new byte[]{84, -70}),
    DisplayUnit(new byte[]{84, -78}),
    AspectRatioType(new byte[]{84, -77}),
    ColourSpace(new byte[]{46, -75, 36}, BinaryElement.class),
    Audio(new byte[]{-31}, MasterElement.class),
    SamplingFrequency(new byte[]{-75}, FloatElement.class),
    OutputSamplingFrequency(new byte[]{120, -75}, FloatElement.class),
    Channels(new byte[]{-97}),
    BitDepth(new byte[]{98, 100}),
    TrackOperation(new byte[]{-30}, MasterElement.class),
    TrackCombinePlanes(new byte[]{-29}, MasterElement.class),
    TrackPlane(new byte[]{-28}, MasterElement.class),
    TrackPlaneUID(new byte[]{-27}),
    TrackPlaneType(new byte[]{-26}),
    TrackJoinBlocks(new byte[]{-23}, MasterElement.class),
    TrackJoinUID(new byte[]{-19}),
    ContentEncodings(new byte[]{109, -128}, MasterElement.class),
    ContentEncoding(new byte[]{98, 64}, MasterElement.class),
    ContentEncodingOrder(new byte[]{80, 49}),
    ContentEncodingScope(new byte[]{80, 50}),
    ContentEncodingType(new byte[]{80, 51}),
    ContentCompression(new byte[]{80, 52}, MasterElement.class),
    ContentCompAlgo(new byte[]{66, 84}),
    ContentCompSettings(new byte[]{66, 85}, BinaryElement.class),
    ContentEncryption(new byte[]{80, 53}, MasterElement.class),
    ContentEncAlgo(new byte[]{71, -31}),
    ContentEncKeyID(new byte[]{71, -30}, BinaryElement.class),
    ContentSignature(new byte[]{71, -29}, BinaryElement.class),
    ContentSigKeyID(new byte[]{71, -28}, BinaryElement.class),
    ContentSigAlgo(new byte[]{71, -27}),
    ContentSigHashAlgo(new byte[]{71, -26}),
    Cues(new byte[]{28, 83, -69, 107}, MasterElement.class),
    CuePoint(new byte[]{-69}, CuePoint.class),
    CueTime(new byte[]{-77}),
    CueTrackPositions(new byte[]{-73}, MasterElement.class),
    CueTrack(new byte[]{-9}),
    CueClusterPosition(new byte[]{-15}),
    CueRelativePosition(new byte[]{-16}),
    CueDuration(new byte[]{-78}),
    CueBlockNumber(new byte[]{83, 120}),
    CueCodecState(new byte[]{-22}),
    CueReference(new byte[]{-37}, MasterElement.class),
    CueRefTime(new byte[]{-106}),
    Attachments(new byte[]{25, 65, -92, 105}, Attachments.class),
    AttachedFile(new byte[]{97, -89}, MasterElement.class),
    FileDescription(new byte[]{70, 126}, StringElement.class),
    FileName(new byte[]{70, 110}, StringElement.class),
    FileMimeType(new byte[]{70, 96}, StringElement.class),
    FileData(new byte[]{70, 92}, BinaryElement.class),
    FileUID(new byte[]{70, -82}),
    Chapters(new byte[]{16, 67, -89, 112}, Chapters.class),
    EditionEntry(new byte[]{69, -71}, MasterElement.class),
    EditionUID(new byte[]{69, -68}),
    EditionFlagHidden(new byte[]{69, -67}),
    EditionFlagDefault(new byte[]{69, -37}),
    EditionFlagOrdered(new byte[]{69, -35}),
    ChapterAtom(new byte[]{-74}, MasterElement.class),
    ChapterUID(new byte[]{115, -60}),
    ChapterStringUID(new byte[]{86, 84}, StringElement.class),
    ChapterTimeStart(new byte[]{-111}),
    ChapterTimeEnd(new byte[]{-110}),
    ChapterFlagHidden(new byte[]{-104}),
    ChapterFlagEnabled(new byte[]{69, -104}),
    ChapterSegmentUID(new byte[]{110, 103}, BinaryElement.class),
    ChapterSegmentEditionUID(new byte[]{110, -68}),
    ChapterPhysicalEquiv(new byte[]{99, -61}),
    ChapterTrack(new byte[]{-113}, MasterElement.class),
    ChapterTrackNumber(new byte[]{-119}),
    ChapterDisplay(new byte[]{-128}, MasterElement.class),
    ChapString(new byte[]{-123}, StringElement.class),
    ChapLanguage(new byte[]{67, 124}, StringElement.class),
    ChapCountry(new byte[]{67, 126}, StringElement.class),
    ChapProcess(new byte[]{105, 68}, MasterElement.class),
    ChapProcessCodecID(new byte[]{105, 85}),
    ChapProcessPrivate(new byte[]{69, 13}, BinaryElement.class),
    ChapProcessCommand(new byte[]{105, 17}, MasterElement.class),
    ChapProcessTime(new byte[]{105, 34}),
    ChapProcessData(new byte[]{105, 51}, BinaryElement.class),
    Tags(new byte[]{18, 84, -61, 103}, Tags.class),
    Tag(new byte[]{115, 115}, MasterElement.class),
    Targets(new byte[]{99, -64}, MasterElement.class),
    TargetTypeValue(new byte[]{104, -54}),
    TargetType(new byte[]{99, -54}, StringElement.class),
    TagTrackUID(new byte[]{99, -59}),
    TagEditionUID(new byte[]{99, -55}),
    TagChapterUID(new byte[]{99, -60}),
    TagAttachmentUID(new byte[]{99, -58}),
    SimpleTag(new byte[]{103, -56}, MasterElement.class),
    TagName(new byte[]{69, -93}, StringElement.class),
    TagLanguage(new byte[]{68, 122}, StringElement.class),
    TagDefault(new byte[]{68, -124}),
    TagString(new byte[]{68, -121}, StringElement.class),
    TagBinary(new byte[]{68, -123}, BinaryElement.class);

    public static Type[] firstLevelHeaders;
    public final byte[] id;
    public final Class<? extends Element> clazz;
    public static final Map<Type, Set<Type>> children;

    private Type(byte[] id) {
        this.id = id;
        this.clazz = UnsignedIntegerElement.class;
    }

    private Type(byte[] id, Class<? extends Element> clazz) {
        this.id = id;
        this.clazz = clazz;
    }

    public static <T extends Element> T createElementByType(Type g2) {
        try {
            Element elem = Type.createElement(g2.clazz, g2.id);
            elem.type = g2;
            return (T)elem;
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
            return (T)new BinaryElement(g2.id);
        }
        catch (IllegalArgumentException e3) {
            e3.printStackTrace();
            return (T)new BinaryElement(g2.id);
        }
        catch (NoSuchMethodException e4) {
            e4.printStackTrace();
            return (T)new BinaryElement(g2.id);
        }
        catch (InvocationTargetException e5) {
            e5.printStackTrace();
            return (T)new BinaryElement(g2.id);
        }
        catch (InstantiationException e6) {
            e6.printStackTrace();
            return (T)new BinaryElement(g2.id);
        }
        catch (IllegalAccessException e7) {
            e7.printStackTrace();
            return (T)new BinaryElement(g2.id);
        }
    }

    private static <T extends Element> T createElement(Class<T> clazz, byte[] id) throws SecurityException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException, InstantiationException, IllegalAccessException {
        Constructor<T> c2 = clazz.getConstructor(byte[].class);
        return (T)((Element)c2.newInstance(new Object[]{id}));
    }

    public static <T extends Element> T createElementById(byte[] id) {
        for (Type t : Type.values()) {
            if (!Arrays.equals(t.id, id)) continue;
            return Type.createElementByType(t);
        }
        System.err.println("Non standard element ID encountered: " + Reader.printAsHex(id));
        BinaryElement t = new BinaryElement(id);
        t.type = Void;
        return (T)t;
    }

    public static boolean isHeaderFirstByte(byte b2) {
        for (Type t : Type.values()) {
            if (t.id[0] != b2) continue;
            return true;
        }
        return false;
    }

    public static boolean isSpecifiedHeader(byte[] b2) {
        for (Type firstLevelHeader : Type.values()) {
            if (!Arrays.equals(firstLevelHeader.id, b2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFirstLevelHeader(byte[] b2) {
        for (Type firstLevelHeader : firstLevelHeaders) {
            if (!Arrays.equals(firstLevelHeader.id, b2)) continue;
            return true;
        }
        return false;
    }

    public static Type getParent(Type t) {
        for (Map.Entry<Type, Set<Type>> ent : children.entrySet()) {
            if (!ent.getValue().contains((Object)t)) continue;
            return ent.getKey();
        }
        return null;
    }

    public static boolean possibleChild(MasterElement parent, Element child) {
        if (parent == null) {
            return child.type == EBML || child.type == Segment;
        }
        if (Arrays.equals(child.id, Type.Void.id) || Arrays.equals(child.id, Type.CRC32.id)) {
            return child.offset != parent.dataOffset + parent.size;
        }
        if (child.type == Void || child.type == CRC32) {
            return true;
        }
        Set<Type> candidates = children.get((Object)parent.type);
        return candidates != null && candidates.contains((Object)child.type);
    }

    public static boolean possibleChild(MasterElement parent, byte[] typeId) {
        if (parent == null && (Arrays.equals(Type.EBML.id, typeId) || Arrays.equals(Type.Segment.id, typeId))) {
            return true;
        }
        if (parent == null) {
            return false;
        }
        if (Arrays.equals(Type.Void.id, typeId) || Arrays.equals(Type.CRC32.id, typeId)) {
            return true;
        }
        for (Type aCandidate : children.get((Object)parent.type)) {
            if (!Arrays.equals(aCandidate.id, typeId)) continue;
            return true;
        }
        return false;
    }

    public static Element findFirst(Element master, Type ... path) {
        LinkedList<Type> tlist = new LinkedList<Type>(Arrays.asList(path));
        return Type.findFirstSub(master, tlist);
    }

    public static <T> T findFirst(List<? extends Element> tree, Type ... path) {
        LinkedList<Type> tlist = new LinkedList<Type>(Arrays.asList(path));
        for (Element element : tree) {
            Element z = Type.findFirstSub(element, tlist);
            if (z == null) continue;
            return (T)z;
        }
        return null;
    }

    private static Element findFirstSub(Element elem, List<Type> path) {
        if (path.size() == 0) {
            return null;
        }
        if (!elem.type.equals((Object)path.get(0))) {
            return null;
        }
        if (path.size() == 1) {
            return elem;
        }
        Type head = path.remove(0);
        Element result = null;
        if (elem instanceof MasterElement) {
            Iterator<Element> iter = ((MasterElement)elem).children.iterator();
            while (iter.hasNext() && result == null) {
                result = Type.findFirstSub(iter.next(), path);
            }
        }
        path.add(0, head);
        return result;
    }

    public static <T> T[] findAll(List<? extends Element> tree, Class<T> class1, Type ... path) {
        LinkedList<Element> result = new LinkedList<Element>();
        LinkedList<Type> tlist = new LinkedList<Type>(Arrays.asList(path));
        if (tlist.size() > 0) {
            for (Element element : tree) {
                Type head = (Type)((Object)tlist.remove(0));
                if (head == null || head.equals((Object)element.type)) {
                    Type.findSub(element, tlist, result);
                }
                tlist.add(0, head);
            }
        }
        return result.toArray((Object[])Array.newInstance(class1, 0));
    }

    public static <T> T[] findAll(Element master, Class<T> class1, Type ... path) {
        LinkedList<Element> result = new LinkedList<Element>();
        LinkedList<Type> tlist = new LinkedList<Type>(Arrays.asList(path));
        if (!master.type.equals(tlist.get(0))) {
            return result.toArray((Object[])Array.newInstance(class1, 0));
        }
        tlist.remove(0);
        Type.findSub(master, tlist, result);
        return result.toArray((Object[])Array.newInstance(class1, 0));
    }

    private static void findSub(Element master, List<Type> path, Collection<Element> result) {
        if (path.size() > 0) {
            Type head = path.remove(0);
            if (master instanceof MasterElement) {
                MasterElement nb = (MasterElement)master;
                for (Element candidate : nb.children) {
                    if (head != null && !head.equals((Object)candidate.type)) continue;
                    Type.findSub(candidate, path, result);
                }
            }
            path.add(0, head);
        } else {
            result.add(master);
        }
    }

    static {
        firstLevelHeaders = new Type[]{SeekHead, Info, Cluster, Tracks, Cues, Attachments, Chapters, Tags, EBMLVersion, EBMLReadVersion, EBMLMaxIDLength, EBMLMaxSizeLength, DocType, DocTypeVersion, DocTypeReadVersion};
        children = new HashMap<Type, Set<Type>>();
        children.put(EBML, new HashSet<Type>(Arrays.asList(EBMLVersion, EBMLReadVersion, EBMLMaxIDLength, EBMLMaxSizeLength, DocType, DocTypeVersion, DocTypeReadVersion)));
        children.put(Segment, new HashSet<Type>(Arrays.asList(SeekHead, Info, Cluster, Tracks, Cues, Attachments, Chapters, Tags)));
        children.put(SeekHead, new HashSet<Type>(Arrays.asList(Seek)));
        children.put(Seek, new HashSet<Type>(Arrays.asList(SeekID, SeekPosition)));
        children.put(Info, new HashSet<Type>(Arrays.asList(SegmentUID, SegmentFilename, PrevUID, PrevFilename, NextUID, NextFilenam, SegmentFamily, ChapterTranslate, TimecodeScale, Duration, DateUTC, Title, MuxingApp, WritingApp)));
        children.put(ChapterTranslate, new HashSet<Type>(Arrays.asList(ChapterTranslateEditionUID, ChapterTranslateCodec, ChapterTranslateID)));
        children.put(Cluster, new HashSet<Type>(Arrays.asList(Timecode, SilentTracks, Position, PrevSize, SimpleBlock, BlockGroup)));
        children.put(SilentTracks, new HashSet<Type>(Arrays.asList(SilentTrackNumber)));
        children.put(BlockGroup, new HashSet<Type>(Arrays.asList(Block, BlockAdditions, BlockDuration, ReferencePriority, ReferenceBlock, CodecState, Slices)));
        children.put(BlockAdditions, new HashSet<Type>(Arrays.asList(BlockMore)));
        children.put(BlockMore, new HashSet<Type>(Arrays.asList(BlockAddID, BlockAdditional)));
        children.put(Slices, new HashSet<Type>(Arrays.asList(TimeSlice)));
        children.put(TimeSlice, new HashSet<Type>(Arrays.asList(LaceNumber)));
        children.put(Tracks, new HashSet<Type>(Arrays.asList(TrackEntry)));
        children.put(TrackEntry, new HashSet<Type>(Arrays.asList(TrackNumber, TrackUID, TrackType, TrackType, FlagDefault, FlagForced, FlagLacing, MinCache, MaxCache, DefaultDuration, MaxBlockAdditionID, Name, Language, CodecID, CodecPrivate, CodecName, AttachmentLink, CodecDecodeAll, TrackOverlay, TrackTranslate, Video, Audio, TrackOperation, ContentEncodings)));
        children.put(TrackTranslate, new HashSet<Type>(Arrays.asList(TrackTranslateEditionUID, TrackTranslateCodec, TrackTranslateTrackID)));
        children.put(Video, new HashSet<Type>(Arrays.asList(FlagInterlaced, StereoMode, AlphaMode, PixelWidth, PixelHeight, PixelCropBottom, PixelCropTop, PixelCropLeft, PixelCropRight, DisplayWidth, DisplayHeight, DisplayUnit, AspectRatioType, ColourSpace)));
        children.put(Audio, new HashSet<Type>(Arrays.asList(SamplingFrequency, OutputSamplingFrequency, Channels, BitDepth)));
        children.put(TrackOperation, new HashSet<Type>(Arrays.asList(TrackCombinePlanes, TrackJoinBlocks)));
        children.put(TrackCombinePlanes, new HashSet<Type>(Arrays.asList(TrackPlane)));
        children.put(TrackPlane, new HashSet<Type>(Arrays.asList(TrackPlaneUID, TrackPlaneType)));
        children.put(TrackJoinBlocks, new HashSet<Type>(Arrays.asList(TrackJoinUID)));
        children.put(ContentEncodings, new HashSet<Type>(Arrays.asList(ContentEncoding)));
        children.put(ContentEncoding, new HashSet<Type>(Arrays.asList(ContentEncodingOrder, ContentEncodingScope, ContentEncodingType, ContentCompression, ContentEncryption)));
        children.put(ContentCompression, new HashSet<Type>(Arrays.asList(ContentCompAlgo, ContentCompSettings)));
        children.put(ContentEncryption, new HashSet<Type>(Arrays.asList(ContentEncAlgo, ContentEncKeyID, ContentSignature, ContentSigKeyID, ContentSigAlgo, ContentSigHashAlgo)));
        children.put(Cues, new HashSet<Type>(Arrays.asList(CuePoint)));
        children.put(CuePoint, new HashSet<Type>(Arrays.asList(CueTime, CueTrackPositions)));
        children.put(CueTrackPositions, new HashSet<Type>(Arrays.asList(CueTrack, CueClusterPosition, CueRelativePosition, CueDuration, CueBlockNumber, CueCodecState, CueReference)));
        children.put(CueReference, new HashSet<Type>(Arrays.asList(CueRefTime)));
        children.put(Attachments, new HashSet<Type>(Arrays.asList(AttachedFile)));
        children.put(AttachedFile, new HashSet<Type>(Arrays.asList(FileDescription, FileName, FileMimeType, FileData, FileUID)));
        children.put(Chapters, new HashSet<Type>(Arrays.asList(EditionEntry)));
        children.put(EditionEntry, new HashSet<Type>(Arrays.asList(EditionUID, EditionFlagHidden, EditionFlagDefault, EditionFlagOrdered, ChapterAtom)));
        children.put(ChapterAtom, new HashSet<Type>(Arrays.asList(ChapterUID, ChapterStringUID, ChapterTimeStart, ChapterTimeEnd, ChapterFlagHidden, ChapterFlagEnabled, ChapterSegmentUID, ChapterSegmentEditionUID, ChapterPhysicalEquiv, ChapterTrack, ChapterDisplay, ChapProcess)));
        children.put(ChapterTrack, new HashSet<Type>(Arrays.asList(ChapterTrackNumber)));
        children.put(ChapterDisplay, new HashSet<Type>(Arrays.asList(ChapString, ChapLanguage, ChapCountry)));
        children.put(ChapProcess, new HashSet<Type>(Arrays.asList(ChapProcessCodecID, ChapProcessPrivate, ChapProcessCommand)));
        children.put(ChapProcessCommand, new HashSet<Type>(Arrays.asList(ChapProcessTime, ChapProcessData)));
        children.put(Tags, new HashSet<Type>(Arrays.asList(Tag)));
        children.put(Tag, new HashSet<Type>(Arrays.asList(Targets, SimpleTag)));
        children.put(Targets, new HashSet<Type>(Arrays.asList(TargetTypeValue, TargetType, TagTrackUID, TagEditionUID, TagChapterUID, TagAttachmentUID)));
        children.put(SimpleTag, new HashSet<Type>(Arrays.asList(TagName, TagLanguage, TagDefault, TagString, TagBinary)));
    }
}

