/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.containers.mkv;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.jcodec.containers.mkv.Reader;
import org.jcodec.containers.mkv.Type;
import org.jcodec.containers.mkv.ebml.BinaryElement;
import org.jcodec.containers.mkv.ebml.Element;
import org.jcodec.containers.mkv.ebml.MasterElement;

public class SimpleEBMLParser {
    private FileChannel is;
    private LinkedList<MasterElement> trace = new LinkedList();
    private ArrayList<MasterElement> tree = new ArrayList();

    public SimpleEBMLParser(FileChannel iFS) {
        this.is = iFS;
    }

    public void printParsedTree() {
        for (MasterElement e2 : this.tree) {
            this.printTree(0, e2);
        }
    }

    private void printTree(int i2, Element e2) {
        System.out.println(SimpleEBMLParser.printPaddedType(i2, e2).toString());
        if (e2 instanceof MasterElement) {
            MasterElement parent = (MasterElement)e2;
            for (Element child : parent.children) {
                this.printTree(i2 + 1, child);
            }
            System.out.println(SimpleEBMLParser.printPaddedType(i2, e2).append(" CLOSED.").toString());
        }
    }

    public void parse() throws IOException {
        Element e2 = null;
        while ((e2 = this.nextElement()) != null) {
            if (!this.isSpecifiedHeader(e2.getId())) {
                System.err.println("Unspecified header: " + Reader.printAsHex(e2.getId()) + " at " + e2.offset);
            }
            while (!this.possibleChild(this.trace.peekFirst(), e2)) {
                this.closeElem(this.trace.removeFirst());
            }
            this.openElem(e2);
            if (e2 instanceof MasterElement) {
                this.trace.push((MasterElement)e2);
                continue;
            }
            if (e2 instanceof BinaryElement) {
                if (this.trace.peekFirst().dataOffset + this.trace.peekFirst().size < e2.offset + e2.size) {
                    System.out.println("FYI: " + (Object)((Object)e2.type) + " ending at " + (e2.offset + e2.size) + " exceeds parent element ending at " + (this.trace.peekFirst().dataOffset + this.trace.peekFirst().size) + ". Tying to resume parsing by seeking to the suggested end of parent master element.");
                }
                if (this.trace.peekFirst().dataOffset + this.trace.peekFirst().size < e2.offset + e2.size) {
                    this.is.position(this.trace.peekFirst().dataOffset + this.trace.peekFirst().size);
                } else {
                    try {
                        e2.readData(this.is);
                    }
                    catch (OutOfMemoryError oome) {
                        System.err.println((Object)((Object)e2.type) + " 0x" + Reader.printAsHex(e2.getId()) + " size: " + e2.size + " offset: 0x" + Long.toHexString(e2.offset));
                        System.err.println(" top in trace " + (Object)((Object)this.trace.peekFirst().type) + " 0x" + Reader.printAsHex(this.trace.peekFirst().getId()) + " size: " + this.trace.peekFirst().size + " offset: 0x" + Long.toHexString(this.trace.peekFirst().offset));
                        throw oome;
                    }
                }
            } else {
                e2.skipData(this.is);
            }
            this.trace.peekFirst().addChildElement(e2);
        }
        while (this.trace.peekFirst() != null) {
            this.closeElem(this.trace.removeFirst());
        }
    }

    private boolean possibleChild(MasterElement parent, Element child) {
        if (!(parent == null || !Type.Cluster.equals((Object)parent.type) || child == null || Type.Cluster.equals((Object)child.type) || Type.Info.equals((Object)child.type) || Type.SeekHead.equals((Object)child.type) || Type.Tracks.equals((Object)child.type) || Type.Cues.equals((Object)child.type) || Type.Attachments.equals((Object)child.type) || Type.Tags.equals((Object)child.type) || Type.Chapters.equals((Object)child.type))) {
            return true;
        }
        return Type.possibleChild(parent, child);
    }

    private void openElem(Element e2) {
    }

    private static StringBuilder printPaddedType(int size, Element e2) {
        StringBuilder sb = new StringBuilder();
        while (size > 0) {
            sb.append("    ");
            --size;
        }
        sb.append((Object)e2.type);
        return sb;
    }

    private void closeElem(MasterElement e2) {
        if (this.trace.peekFirst() == null) {
            this.tree.add(e2);
        } else {
            this.trace.peekFirst().addChildElement(e2);
        }
    }

    private Element nextElement() throws IOException {
        long offset = this.is.position();
        if (offset >= this.is.size()) {
            return null;
        }
        byte[] typeId = Reader.getRawEbmlBytes(this.is);
        while (!(typeId != null && this.isSpecifiedHeader(typeId) || offset >= this.is.size())) {
            this.is.position(++offset);
            typeId = Reader.getRawEbmlBytes(this.is);
        }
        byte[] ebmlCodedElementSize = Reader.getEbmlBytes(this.is);
        long size = Reader.bytesToLong(ebmlCodedElementSize);
        if (size == 0L) {
            // empty if block
        }
        Object elem = Type.createElementById(typeId);
        ((Element)elem).offset = offset;
        ((Element)elem).dataOffset = this.is.position();
        ((Element)elem).size = size;
        return elem;
    }

    public boolean isSpecifiedHeader(byte[] b2) {
        if (!this.trace.isEmpty() && Type.Cluster.equals((Object)this.trace.peekFirst().type)) {
            return true;
        }
        return Type.isSpecifiedHeader(b2);
    }

    public List<MasterElement> getTree() {
        return this.tree;
    }

    public boolean matchesHierarchy(byte[] typeId) {
        if (Arrays.equals(Type.EBML.id, typeId) || Arrays.equals(Type.Segment.id, typeId)) {
            return true;
        }
        for (int i2 = 0; i2 < this.trace.size(); ++i2) {
            if (!Type.possibleChild(this.trace.get(i2), typeId)) continue;
            return true;
        }
        return false;
    }
}

