/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.raw;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jcodec.common.model.Picture;
import org.jcodec.common.tools.MathUtil;

public class V210Encoder {
    public ByteBuffer encodeFrame(ByteBuffer _out, Picture frame) throws IOException {
        ByteBuffer out = _out.duplicate();
        out.order(ByteOrder.LITTLE_ENDIAN);
        int tgtStride = (frame.getPlaneWidth(0) + 47) / 48 * 48;
        int[][] data = frame.getData();
        int[] tmpY = new int[tgtStride];
        int[] tmpCb = new int[tgtStride >> 1];
        int[] tmpCr = new int[tgtStride >> 1];
        int yOff = 0;
        int cbOff = 0;
        int crOff = 0;
        for (int yy = 0; yy < frame.getHeight(); ++yy) {
            System.arraycopy(data[0], yOff, tmpY, 0, frame.getPlaneWidth(0));
            System.arraycopy(data[1], cbOff, tmpCb, 0, frame.getPlaneWidth(1));
            System.arraycopy(data[2], crOff, tmpCr, 0, frame.getPlaneWidth(2));
            int yi = 0;
            int cbi = 0;
            int cri = 0;
            while (yi < tgtStride) {
                int i2 = 0;
                i2 |= V210Encoder.clip(tmpCr[cri++]) << 20;
                i2 |= V210Encoder.clip(tmpY[yi++]) << 10;
                out.putInt(i2 |= V210Encoder.clip(tmpCb[cbi++]));
                i2 = 0;
                i2 |= V210Encoder.clip(tmpY[yi++]);
                i2 |= V210Encoder.clip(tmpY[yi++]) << 20;
                out.putInt(i2 |= V210Encoder.clip(tmpCb[cbi++]) << 10);
                i2 = 0;
                i2 |= V210Encoder.clip(tmpCb[cbi++]) << 20;
                i2 |= V210Encoder.clip(tmpY[yi++]) << 10;
                out.putInt(i2 |= V210Encoder.clip(tmpCr[cri++]));
                i2 = 0;
                i2 |= V210Encoder.clip(tmpY[yi++]);
                i2 |= V210Encoder.clip(tmpY[yi++]) << 20;
                out.putInt(i2 |= V210Encoder.clip(tmpCr[cri++]) << 10);
            }
            yOff += frame.getPlaneWidth(0);
            cbOff += frame.getPlaneWidth(1);
            crOff += frame.getPlaneWidth(2);
        }
        out.flip();
        return out;
    }

    static final int clip(int val) {
        return MathUtil.clip(val, 8, 1019);
    }
}

