/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.prores;

import java.nio.ByteBuffer;
import org.jcodec.codecs.prores.ProresConsts;
import org.jcodec.codecs.prores.ProresDecoder;
import org.jcodec.common.io.BitReader;
import org.jcodec.common.model.ColorSpace;
import org.jcodec.common.model.Picture;

public class ProresToThumb
extends ProresDecoder {
    @Override
    protected int[] decodeOnePlane(BitReader bits, int blocksPerSlice, int[] qMat, int[] scan, int mbX, int mbY, int plane) {
        int[] out = new int[blocksPerSlice];
        ProresToThumb.readDCCoeffs(bits, qMat, out, blocksPerSlice, 1);
        int i2 = 0;
        while (i2 < blocksPerSlice) {
            int n2 = i2++;
            out[n2] = out[n2] >> 3;
        }
        return out;
    }

    @Override
    public Picture decodeFrame(ByteBuffer data, int[][] target) {
        ProresConsts.FrameHeader fh = ProresToThumb.readFrameHeader(data);
        int codedWidth = (fh.width + 15 & 0xFFFFFFF0) >> 3;
        int codedHeight = (fh.height + 15 & 0xFFFFFFF0) >> 3;
        int lumaSize = codedWidth * codedHeight;
        int chromaSize = lumaSize >> 1;
        if (target == null || target[0].length < lumaSize || target[1].length < chromaSize || target[2].length < chromaSize) {
            throw new RuntimeException("Provided output picture won't fit into provided buffer");
        }
        if (fh.frameType == 0) {
            this.decodePicture(data, target, codedWidth, codedHeight, codedWidth >> 1, fh.qMatLuma, fh.qMatChroma, new int[]{0}, 0);
        } else {
            this.decodePicture(data, target, codedWidth, codedHeight >> 1, codedWidth >> 1, fh.qMatLuma, fh.qMatChroma, new int[]{0}, fh.topFieldFirst ? 1 : 2);
            this.decodePicture(data, target, codedWidth, codedHeight >> 1, codedWidth >> 1, fh.qMatLuma, fh.qMatChroma, new int[]{0}, fh.topFieldFirst ? 2 : 1);
        }
        return new Picture(codedWidth, codedHeight, target, ColorSpace.YUV422_10);
    }

    @Override
    protected void putSlice(int[][] result, int lumaStride, int mbX, int mbY, int[] y, int[] u, int[] v, int dist, int shift) {
        int mbPerSlice = y.length >> 2;
        int chromaStride = lumaStride >> 1;
        this.putLuma(result[0], shift * lumaStride, lumaStride << dist, mbX, mbY, y, mbPerSlice, dist, shift);
        this.putChroma(result[1], shift * chromaStride, chromaStride << dist, mbX, mbY, u, mbPerSlice, dist, shift);
        this.putChroma(result[2], shift * chromaStride, chromaStride << dist, mbX, mbY, v, mbPerSlice, dist, shift);
    }

    private void putLuma(int[] y, int off, int stride, int mbX, int mbY, int[] luma, int mbPerSlice, int dist, int shift) {
        off += (mbX << 1) + (mbY << 1) * stride;
        int sOff = 0;
        for (int k2 = 0; k2 < mbPerSlice; ++k2) {
            y[off] = ProresToThumb.clip(luma[sOff], 4, 1019);
            y[off + 1] = ProresToThumb.clip(luma[sOff + 1], 4, 1019);
            y[off += stride] = ProresToThumb.clip(luma[sOff + 2], 4, 1019);
            y[off + 1] = ProresToThumb.clip(luma[sOff + 3], 4, 1019);
            off += 2 - stride;
            sOff += 4;
        }
    }

    private void putChroma(int[] y, int off, int stride, int mbX, int mbY, int[] chroma, int mbPerSlice, int dist, int shift) {
        off += mbX + (mbY << 1) * stride;
        int sOff = 0;
        for (int k2 = 0; k2 < mbPerSlice; ++k2) {
            y[off] = ProresToThumb.clip(chroma[sOff], 4, 1019);
            y[off += stride] = ProresToThumb.clip(chroma[sOff + 1], 4, 1019);
            off += 1 - stride;
            sOff += 2;
        }
    }
}

