/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mpeg4.es;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jcodec.codecs.mpeg4.es.Descriptor;

public class NodeDescriptor
extends Descriptor {
    private Collection<Descriptor> children = new ArrayList<Descriptor>();

    public NodeDescriptor(int tag, int size) {
        super(tag, size);
    }

    public NodeDescriptor(int tag) {
        super(tag);
    }

    public NodeDescriptor(int tag, Descriptor[] children) {
        super(tag);
        this.children.addAll(Arrays.asList(children));
    }

    @Override
    protected void doWrite(ByteBuffer out) {
        for (Descriptor descr : this.children) {
            descr.write(out);
        }
    }

    public Collection<Descriptor> getChildren() {
        return this.children;
    }

    @Override
    protected void parse(ByteBuffer input) {
        Descriptor d2;
        do {
            if ((d2 = Descriptor.read(input)) == null) continue;
            this.children.add(d2);
        } while (d2 != null);
    }
}

