/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mjpeg;

import java.io.IOException;
import java.io.InputStream;

public class ScanHeader {
    int ls;
    int ns;
    Component[] components;
    int ss;
    int se;
    int ah;
    int al;

    public boolean isInterleaved() {
        return this.ns > 1;
    }

    public static ScanHeader read(InputStream is) throws IOException {
        ScanHeader scan = new ScanHeader();
        scan.ls = ScanHeader.readShort(is);
        scan.ns = is.read();
        scan.components = new Component[scan.ns];
        for (int i2 = 0; i2 < scan.components.length; ++i2) {
            Component c2 = scan.components[i2] = new Component();
            c2.cs = is.read();
            int tdta = is.read();
            c2.td = (tdta & 0xF0) >>> 4;
            c2.ta = tdta & 0xF;
        }
        scan.ss = is.read();
        scan.se = is.read();
        int ahal = is.read();
        scan.ah = (ahal & 0xF0) >>> 4;
        scan.al = ahal & 0xF;
        return scan;
    }

    private static int readShort(InputStream is) throws IOException {
        int b1 = is.read();
        int b2 = is.read();
        return (b1 << 8) + b2;
    }

    public static class Component {
        int cs;
        int td;
        int ta;
    }
}

