/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.mjpeg;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;

public class ByteStuffingInputStream
extends FilterInputStream {
    private final PushbackInputStream pushBack;

    public ByteStuffingInputStream(PushbackInputStream in) {
        super(in);
        this.pushBack = in;
    }

    @Override
    public int read() throws IOException {
        int b2 = super.read();
        if (b2 != 255) {
            return b2;
        }
        int b22 = super.read();
        if (b22 == 0) {
            return 255;
        }
        this.pushBack.unread(b22);
        this.pushBack.unread(b2);
        return -1;
    }

    @Override
    public int read(byte[] b2, int off, int len) throws IOException {
        int count = 0;
        for (int i2 = off; i2 < off + len; ++i2) {
            int r = this.read();
            if (r != -1) {
                ++count;
            } else {
                if (count != 0) break;
                return -1;
            }
            b2[i2] = (byte)r;
        }
        return count;
    }
}

