/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.codecs.common.biari;

import java.io.IOException;
import org.jcodec.codecs.common.biari.Context;
import org.jcodec.codecs.common.biari.MQDecoder;
import org.jcodec.codecs.common.biari.MQEncoder;

public class TreeBinarizer {
    private Context[] models;

    public TreeBinarizer() {
        this.initContextModels();
    }

    private void initContextModels() {
        this.models = new Context[255];
        for (int i2 = 0; i2 < 255; ++i2) {
            this.models[i2] = new Context(0, 0);
        }
    }

    public void binarize(int symbol, MQEncoder encoder) throws IOException {
        int inverted = 0;
        int nextModel = 0;
        int levelOffset = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            int bin = symbol >> 7 - i2 & 1;
            encoder.encode(bin, this.models[nextModel]);
            nextModel = (levelOffset += 1 << i2) + (inverted |= bin << i2);
        }
    }

    public int debinarize(MQDecoder decoder) throws IOException {
        int symbol = 0;
        int inverted = 0;
        int nextModel = 0;
        int levelOffset = 0;
        for (int i2 = 0; i2 < 8; ++i2) {
            int bin = decoder.decode(this.models[nextModel]);
            symbol |= bin << 7 - i2;
            nextModel = (levelOffset += 1 << i2) + (inverted |= bin << i2);
        }
        return symbol;
    }
}

