/*
 * Decompiled with CFR 0.152.
 */
package org.jcodec.algo;

import org.jcodec.common.Assert;

public class StreamGauss {
    private int[] vect;

    public StreamGauss(float radius) {
        this.makeKernel(radius);
    }

    void gauss(int[] samples, int[] out) {
        for (int i2 = 0; i2 < samples.length - this.vect.length; ++i2) {
            int val = 0;
            for (int j2 = 0; j2 < this.vect.length; ++j2) {
                val += samples[i2 + j2] * this.vect[j2];
            }
            int v = val >> 10;
            Assert.assertTrue(v > 0);
            out[i2] = v;
        }
    }

    public void makeKernel(float radius) {
        int r = (int)Math.ceil(radius);
        int rows = r * 2 + 1;
        this.vect = new int[rows];
        float sigma = radius / 3.0f;
        float sigma22 = 2.0f * sigma * sigma;
        float sigmaPi2 = (float)Math.PI * 2 * sigma;
        float sqrtSigmaPi2 = (float)Math.sqrt(sigmaPi2);
        float radius2 = radius * radius;
        int total = 0;
        int index = 0;
        for (int row = -r; row <= r; ++row) {
            float distance = row * row;
            this.vect[index] = distance > radius2 ? 0 : (int)(Math.exp(-distance / sigma22) / (double)sqrtSigmaPi2 * 1024.0);
            total += this.vect[index];
            ++index;
        }
        for (int i2 = 0; i2 < rows; ++i2) {
            this.vect[i2] = (this.vect[i2] << 10) / total;
        }
    }
}

