/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class RCData {
    public static final String DEFAULT_JDBC_DRIVER = "org.hsqldb.jdbc.JDBCDriver";
    private String defaultJdbcDriverName = "org.hsqldb.jdbc.JDBCDriver";
    public String id;
    public String url;
    public String username;
    public String password;
    public String ti;
    public String driver;
    public String charset;
    public String truststore;
    public String libpath;

    public void setDefaultJdbcDriver(String string) {
        this.defaultJdbcDriverName = string;
    }

    public String getDefaultJdbcDriverName() {
        return this.defaultJdbcDriverName;
    }

    public String toString() {
        return "id: " + RCData.angleBracketNull(this.id) + ", url: " + RCData.angleBracketNull(this.url) + ", username: " + RCData.angleBracketNull(this.username) + ", password: <" + (this.password == null ? "NULL" : "PRESENT") + ">" + ", ti: " + RCData.angleBracketNull(this.ti) + ", driver: " + RCData.angleBracketNull(this.driver) + ", truststore: " + RCData.angleBracketNull(this.truststore) + ", libpath: " + RCData.angleBracketNull(this.libpath);
    }

    private static String angleBracketNull(String string) {
        return string == null ? "<NULL>" : string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RCData(File file, String string) throws Exception {
        HashSet<String> hashSet = new HashSet<String>();
        if (file == null) {
            throw new IllegalArgumentException("RC file name not specified");
        }
        if (!file.canRead()) {
            throw new IOException("Please set up authentication file '" + file + "'");
        }
        boolean bl = false;
        int n2 = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                String string4;
                ++n2;
                if ((string2 = string2.trim()).isEmpty() || string2.charAt(0) == '#') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                if (stringTokenizer.countTokens() == 1) {
                    string4 = stringTokenizer.nextToken();
                    string3 = "";
                } else if (stringTokenizer.countTokens() > 1) {
                    string4 = stringTokenizer.nextToken();
                    string3 = stringTokenizer.nextToken("").trim();
                } else {
                    throw new Exception("Corrupt line " + n2 + " in '" + file + "':  " + string2);
                }
                if (string4.equals("urlid")) {
                    String[] stringArray = string3.split("\\s*,\\s*", -1);
                    for (int i2 = 0; i2 < stringArray.length; ++i2) {
                        if (hashSet.contains(stringArray[i2])) {
                            throw new Exception("ID Pattern '" + stringArray[i2] + "' repeated at line " + n2 + " in '" + file + "'");
                        }
                        hashSet.add(stringArray[i2]);
                        if (string == null) {
                            System.out.println(stringArray[i2]);
                            continue;
                        }
                        bl = Pattern.compile(stringArray[i2]).matcher(string).matches();
                        if (this.id != null || !bl) continue;
                        this.id = string;
                    }
                    continue;
                }
                if (string == null || !bl) continue;
                if (string4.equals("url")) {
                    this.url = string3;
                    continue;
                }
                if (string4.equals("username")) {
                    this.username = string3;
                    continue;
                }
                if (string4.equals("driver")) {
                    this.driver = string3;
                    continue;
                }
                if (string4.equals("charset")) {
                    this.charset = string3;
                    continue;
                }
                if (string4.equals("truststore")) {
                    this.truststore = string3;
                    continue;
                }
                if (string4.equals("password")) {
                    this.password = string3;
                    continue;
                }
                if (string4.equals("transiso")) {
                    this.ti = string3;
                    continue;
                }
                if (string4.equals("libpath")) {
                    this.libpath = string3;
                    continue;
                }
                throw new Exception("Bad line " + n2 + " in '" + file + "':  " + string2);
            }
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {}
            bufferedReader = null;
        }
        if (string == null) {
            return;
        }
        if (this.libpath != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
        if (this.id == null) {
            throw new IllegalArgumentException("No match for '" + string + "' in file '" + file + "'");
        }
    }

    public RCData(String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        this(string, string2, string3, string4, string5, string6, string7, null);
    }

    public RCData(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws Exception {
        this(string, string2, string3, string4, string5, string6, string7, string8, null);
    }

    public RCData(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws Exception {
        this.id = string;
        this.url = string2;
        this.username = string3;
        this.password = string4;
        this.ti = string9;
        this.driver = string5;
        this.charset = string6;
        this.truststore = string7;
        this.libpath = string8;
        if (string8 != null) {
            throw new IllegalArgumentException("Sorry, 'libpath' not supported yet");
        }
        if (string == null) {
            throw new Exception("id was not set");
        }
    }

    public Connection getConnection() throws ClassNotFoundException, SQLException, MalformedURLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String string, String string2) throws MalformedURLException, SQLException {
        Connection connection;
        String string3;
        String string4 = null;
        String string5 = null;
        Properties properties = System.getProperties();
        string4 = string == null ? (this.driver == null ? DEFAULT_JDBC_DRIVER : this.driver) : RCData.expandSysPropVars(string);
        if (string2 == null) {
            if (this.truststore != null) {
                string5 = RCData.expandSysPropVars(this.truststore);
            }
        } else {
            string5 = RCData.expandSysPropVars(string2);
        }
        if (string5 == null) {
            properties.remove("javax.net.ssl.trustStore");
        } else {
            properties.put("javax.net.ssl.trustStore", string5);
        }
        if (this.url == null) {
            throw new MalformedURLException("url string is required to establish a connection, but is null");
        }
        try {
            string3 = RCData.expandSysPropVars(this.url);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new MalformedURLException(illegalArgumentException.toString() + " for URL '" + this.url + "'");
        }
        String string6 = null;
        if (this.username != null) {
            try {
                string6 = RCData.expandSysPropVars(this.username);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedURLException(illegalArgumentException.toString() + " for user name '" + this.username + "'");
            }
        }
        String string7 = null;
        if (this.password != null) {
            try {
                string7 = RCData.expandSysPropVars(this.password);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new MalformedURLException(illegalArgumentException.toString() + " for password");
            }
        }
        Connection connection2 = connection = string6 == null ? DriverManager.getConnection(string3) : DriverManager.getConnection(string3, string6, string7);
        if (this.ti != null) {
            RCData.setTI(connection, this.ti);
        }
        return connection;
    }

    public static String expandSysPropVars(String string) {
        int n2;
        int n3;
        String string2 = string;
        while ((n3 = string2.indexOf("${")) >= 0 && (n2 = string2.indexOf(125, n3 + 2)) >= 0) {
            String string3 = string2.substring(n3 + 2, n2);
            if (string3.length() < 1) {
                throw new IllegalArgumentException("Bad variable setting");
            }
            String string4 = System.getProperty(string3);
            if (string4 == null) {
                throw new IllegalArgumentException("No Java system property with name '" + string3 + "'");
            }
            string2 = string2.substring(0, n3) + string4 + string2.substring(n2 + 1);
        }
        return string2;
    }

    public static void setTI(Connection connection, String string) throws SQLException {
        int n2 = -1;
        if (string.equals("TRANSACTION_READ_UNCOMMITTED")) {
            n2 = 1;
        }
        if (string.equals("TRANSACTION_READ_COMMITTED")) {
            n2 = 2;
        }
        if (string.equals("TRANSACTION_REPEATABLE_READ")) {
            n2 = 4;
        }
        if (string.equals("TRANSACTION_SERIALIZABLE")) {
            n2 = 8;
        }
        if (string.equals("TRANSACTION_NONE")) {
            n2 = 0;
        }
        if (n2 < 0) {
            throw new SQLException("Trans. isol. value not supported by " + RCData.class.getName() + ": " + string);
        }
        connection.setTransactionIsolation(n2);
    }

    public static String tiToString(int n2) {
        switch (n2) {
            case 1: {
                return "TRANSACTION_READ_UNCOMMITTED";
            }
            case 2: {
                return "TRANSACTION_READ_COMMITTED";
            }
            case 4: {
                return "TRANSACTION_REPEATABLE_READ";
            }
            case 8: {
                return "TRANSACTION_SERIALIZABLE";
            }
            case 0: {
                return "TRANSACTION_NONE";
            }
        }
        return "Custom Transaction Isolation numerical value: " + n2;
    }
}

