/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.util.UUID;
import org.hsqldb.Session;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BinaryType;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.Type;

public class BinaryUUIDType
extends BinaryType {
    public static final int binaryUUIDPrecision = 16;

    protected BinaryUUIDType() {
        super(-11, 16L);
    }

    @Override
    public int displaySize() {
        return 36;
    }

    @Override
    public int getJDBCTypeCode() {
        return -2;
    }

    @Override
    public Class getJDBCClass() {
        return byte[].class;
    }

    @Override
    public String getJDBCClassName() {
        return "[B";
    }

    @Override
    public String getNameString() {
        return "UUID";
    }

    @Override
    public String getNameFullString() {
        return "UUID";
    }

    @Override
    public String getDefinition() {
        return this.getNameString();
    }

    @Override
    public boolean isBinaryType() {
        return true;
    }

    @Override
    public boolean isUUIDType() {
        return true;
    }

    @Override
    public boolean acceptsPrecision() {
        return false;
    }

    @Override
    public long getMaxPrecision() {
        return 16L;
    }

    @Override
    public boolean requiresPrecision() {
        return false;
    }

    @Override
    public int precedenceDegree(Type type) {
        if (type.typeCode == this.typeCode) {
            return 0;
        }
        if (!type.isBinaryType()) {
            return Integer.MIN_VALUE;
        }
        return type.typeCode == 30 ? 4 : 2;
    }

    @Override
    public Type getAggregateType(Type type) {
        if (type == null) {
            return this;
        }
        if (type == SQL_ALL_TYPES) {
            return this;
        }
        if (this.typeCode == type.typeCode) {
            return this;
        }
        if (type.isCharacterType()) {
            return this;
        }
        switch (type.typeCode) {
            case -11: 
            case 30: 
            case 60: 
            case 61: {
                return this;
            }
        }
        throw Error.error(5562);
    }

    @Override
    public Type getCombinedType(Session session, Type type, int n2) {
        return Type.SQL_VARBINARY_DEFAULT;
    }

    @Override
    public int compare(Session session, Object object, Object object2) {
        if (object == object2) {
            return 0;
        }
        if (object == null) {
            return -1;
        }
        if (object2 == null) {
            return 1;
        }
        if (object instanceof BinaryData && object2 instanceof BinaryData) {
            byte[] byArray;
            byte[] byArray2 = ((BinaryData)object).getBytes();
            int n2 = byArray2.length > (byArray = ((BinaryData)object2).getBytes()).length ? byArray.length : byArray2.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (byArray2[i2] == byArray[i2]) continue;
                return (byArray2[i2] & 0xFF) > (byArray[i2] & 0xFF) ? 1 : -1;
            }
            if (byArray2.length == byArray.length) {
                return 0;
            }
            return byArray2.length > byArray.length ? 1 : -1;
        }
        throw Error.runtimeError(201, "BinaryUUIDType");
    }

    @Override
    public Object convertToTypeLimits(SessionInterface sessionInterface, Object object) {
        return this.castOrConvertToType(sessionInterface, object, this, false);
    }

    @Override
    public Object castToType(SessionInterface sessionInterface, Object object, Type type) {
        return this.castOrConvertToType(sessionInterface, object, type, true);
    }

    @Override
    public Object convertToType(SessionInterface sessionInterface, Object object, Type type) {
        return this.castOrConvertToType(sessionInterface, object, type, false);
    }

    @Override
    public Object convertJavaToSQL(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof byte[]) {
            return new BinaryData((byte[])object, true);
        }
        if (object instanceof UUID) {
            return BinaryUUIDType.getBinary((UUID)object);
        }
        throw Error.error(5561);
    }

    @Override
    public Object convertSQLToJava(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return null;
        }
        return BinaryUUIDType.getJavaUUID((BinaryData)object);
    }

    @Override
    Object castOrConvertToType(SessionInterface sessionInterface, Object object, Type type, boolean bl) {
        BlobData blobData;
        if (object == null) {
            return null;
        }
        switch (type.typeCode) {
            case 40: {
                object = Type.SQL_VARCHAR.convertToType(sessionInterface, object, type);
            }
            case 1: 
            case 12: {
                blobData = sessionInterface.getScanner().convertToBinary((String)object, true);
                type = this;
                break;
            }
            case -11: 
            case 30: 
            case 60: 
            case 61: {
                blobData = (BlobData)object;
                break;
            }
            default: {
                throw Error.error(3471);
            }
        }
        if (type.typeCode == 30) {
            long l2 = blobData.length(sessionInterface);
            if (l2 != this.precision) {
                throw Error.error(3401);
            }
            byte[] byArray = blobData.getBytes(sessionInterface, 0L, (int)this.precision);
            blobData = new BinaryData(byArray, false);
        } else if (blobData.length(sessionInterface) != this.precision) {
            throw Error.error(3401);
        }
        return blobData;
    }

    @Override
    public Object convertToDefaultType(SessionInterface sessionInterface, Object object) {
        if (object == null) {
            return object;
        }
        if (object instanceof byte[]) {
            BinaryData binaryData = new BinaryData((byte[])object, false);
            this.castOrConvertToType(sessionInterface, binaryData, Type.SQL_VARBINARY, false);
        } else {
            if (object instanceof BinaryData) {
                return this.castOrConvertToType(sessionInterface, object, Type.SQL_VARBINARY, false);
            }
            if (object instanceof String) {
                return this.castOrConvertToType(sessionInterface, object, Type.SQL_VARCHAR, false);
            }
        }
        throw Error.error(3471);
    }

    @Override
    public String convertToString(Object object) {
        if (object == null) {
            return null;
        }
        return StringConverter.toStringUUID(((BlobData)object).getBytes());
    }

    @Override
    public String convertToSQLString(Object object) {
        if (object == null) {
            return "NULL";
        }
        return StringConverter.toStringUUID(((BlobData)object).getBytes());
    }

    @Override
    public boolean canConvertFrom(Type type) {
        return type.typeCode == 0 || type.isBinaryType() || type.isCharacterType();
    }

    @Override
    public int canMoveFrom(Type type) {
        if (type == this) {
            return 0;
        }
        switch (type.typeCode) {
            case -11: {
                return 0;
            }
            case 1: 
            case 12: 
            case 60: 
            case 61: {
                return -1;
            }
        }
        return -1;
    }

    @Override
    public long position(SessionInterface sessionInterface, BlobData blobData, BlobData blobData2, Type type, long l2) {
        if (blobData == null || blobData2 == null) {
            return -1L;
        }
        long l3 = blobData.length(sessionInterface);
        if (l2 + l3 > blobData.length(sessionInterface)) {
            return -1L;
        }
        return blobData.position(sessionInterface, blobData2, l2);
    }

    @Override
    public BlobData substring(SessionInterface sessionInterface, BlobData blobData, long l2, long l3, boolean bl) {
        long l4;
        long l5 = blobData.length(sessionInterface);
        if (bl) {
            l4 = l2 + l3;
        } else {
            long l6 = l4 = l5 > l2 ? l5 : l2;
        }
        if (l2 > l4) {
            throw Error.error(3431);
        }
        if (l4 < 0L) {
            l2 = 0L;
            l4 = 0L;
        }
        if (l2 < 0L) {
            l2 = 0L;
        }
        if (l4 > l5) {
            l4 = l5;
        }
        l3 = l4 - l2;
        byte[] byArray = blobData.getBytes(sessionInterface, l2, (int)l3);
        return new BinaryData(byArray, false);
    }

    @Override
    int getRightTrimSize(BlobData blobData) {
        byte[] byArray = blobData.getBytes();
        int n2 = byArray.length;
        --n2;
        while (n2 >= 0 && byArray[n2] == 0) {
            --n2;
        }
        return ++n2;
    }

    @Override
    public BlobData trim(Session session, BlobData blobData, int n2, boolean bl, boolean bl2) {
        int n3;
        if (blobData == null) {
            return null;
        }
        long l2 = blobData.length(session);
        if (l2 > Integer.MAX_VALUE) {
            throw Error.error(3460);
        }
        byte[] byArray = blobData.getBytes(session, 0L, (int)l2);
        int n4 = byArray.length;
        if (bl2) {
            --n4;
            while (n4 >= 0 && byArray[n4] == n2) {
                --n4;
            }
            ++n4;
        }
        if (bl) {
            for (n3 = 0; n3 < n4 && byArray[n3] == n2; ++n3) {
            }
        }
        byte[] byArray2 = byArray;
        if (n3 != 0 || n4 != byArray.length) {
            byArray2 = new byte[n4 - n3];
            System.arraycopy(byArray, n3, byArray2, 0, n4 - n3);
        }
        return new BinaryData(byArray2, byArray2 == byArray);
    }

    @Override
    public BlobData overlay(Session session, BlobData blobData, BlobData blobData2, long l2, long l3, boolean bl) {
        if (blobData == null || blobData2 == null) {
            return null;
        }
        if (!bl) {
            l3 = blobData2.length(session);
        }
        BinaryData binaryData = new BinaryData(session, this.substring(session, blobData, 0L, l2, true), blobData2);
        binaryData = new BinaryData(session, binaryData, this.substring(session, blobData, l2 + l3, 0L, false));
        return binaryData;
    }

    @Override
    public Object concat(Session session, Object object, Object object2) {
        if (object == null || object2 == null) {
            return null;
        }
        long l2 = ((BlobData)object).length(session) + ((BlobData)object2).length(session);
        if (l2 > this.precision) {
            throw Error.error(3401);
        }
        return new BinaryData(session, (BlobData)object, (BlobData)object2);
    }

    public static BinaryData getBinary(long l2, long l3) {
        return new BinaryData(ArrayUtil.toByteArray(l2, l3), false);
    }

    public static BinaryData getBinary(UUID uUID) {
        return BinaryUUIDType.getBinary(uUID.getMostSignificantBits(), uUID.getLeastSignificantBits());
    }

    public static UUID getJavaUUID(BinaryData binaryData) {
        if (binaryData == null) {
            return null;
        }
        byte[] byArray = binaryData.getBytes();
        long l2 = ArrayUtil.byteSequenceToLong(byArray, 0);
        long l3 = ArrayUtil.byteSequenceToLong(byArray, 8);
        return new UUID(l2, l3);
    }
}

