/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.types;

import java.io.DataInput;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.hsqldb.SessionInterface;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.BlobInputStream;
import org.hsqldb.types.Type;

public class BinaryData
implements BlobData {
    public static final BinaryData singleBitZero = new BinaryData(new byte[]{0}, 1L);
    public static final BinaryData singleBitOne = new BinaryData(new byte[]{-128}, 1L);
    public static final byte[] zeroLengthBytes = new byte[0];
    public static final BinaryData zeroLengthBinary = new BinaryData(zeroLengthBytes, false);
    long id;
    protected byte[] data;
    private boolean isBits;
    private long bitLength;
    private int hashCode = 0;

    public static BinaryData getBitData(byte[] byArray, long l2) {
        if (l2 == 1L) {
            return byArray[0] == 0 ? singleBitZero : singleBitOne;
        }
        return new BinaryData(byArray, l2);
    }

    public BinaryData(byte[] byArray, boolean bl) {
        if (bl) {
            byArray = Arrays.copyOf(byArray, byArray.length);
        }
        this.data = byArray;
        this.bitLength = (long)byArray.length * 8L;
    }

    public BinaryData(SessionInterface sessionInterface, BlobData blobData, BlobData blobData2) {
        long l2 = blobData.length(sessionInterface) + blobData2.length(sessionInterface);
        if (l2 > Integer.MAX_VALUE || blobData.length(sessionInterface) > Integer.MAX_VALUE || blobData2.length(sessionInterface) > Integer.MAX_VALUE) {
            throw Error.error(3401);
        }
        this.data = new byte[(int)l2];
        System.arraycopy(blobData.getBytes(sessionInterface, 0L, (int)blobData.length(sessionInterface)), 0, this.data, 0, (int)blobData.length(sessionInterface));
        System.arraycopy(blobData2.getBytes(sessionInterface, 0L, (int)blobData2.length(sessionInterface)), 0, this.data, (int)blobData.length(sessionInterface), (int)blobData2.length(sessionInterface));
        this.bitLength = (long)((int)l2) * 8L;
    }

    public BinaryData(byte[] byArray, long l2) {
        this.data = byArray;
        this.bitLength = l2;
        this.isBits = true;
    }

    public BinaryData(long l2, DataInput dataInput) {
        this.data = new byte[(int)l2];
        this.bitLength = (long)this.data.length * 8L;
        try {
            dataInput.readFully(this.data);
        }
        catch (IOException iOException) {
            throw Error.error(467, iOException);
        }
    }

    @Override
    public byte[] getBytes() {
        return this.data;
    }

    @Override
    public long length(SessionInterface sessionInterface) {
        return this.data.length;
    }

    @Override
    public long bitLength(SessionInterface sessionInterface) {
        return this.bitLength;
    }

    @Override
    public boolean isBits() {
        return this.isBits;
    }

    @Override
    public byte[] getBytes(SessionInterface sessionInterface, long l2, int n2) {
        if (!BinaryData.isInLimits(this.data.length, l2, n2)) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.data, (int)l2, byArray, 0, n2);
        return byArray;
    }

    @Override
    public BlobData getBlob(SessionInterface sessionInterface, long l2, long l3) {
        throw Error.runtimeError(201, "BinaryData");
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface) {
        return new BlobInputStream(sessionInterface, this, 0L, this.length(sessionInterface));
    }

    @Override
    public InputStream getBinaryStream(SessionInterface sessionInterface, long l2, long l3) {
        if (!BinaryData.isInLimits(this.data.length, l2, l3)) {
            throw new IndexOutOfBoundsException();
        }
        return new BlobInputStream(sessionInterface, this, l2, this.length(sessionInterface));
    }

    @Override
    public void setBytes(SessionInterface sessionInterface, long l2, byte[] byArray, int n2, int n3) {
        if (!BinaryData.isInLimits(this.data.length, l2, 0L)) {
            throw new IndexOutOfBoundsException();
        }
        if (!BinaryData.isInLimits(this.data.length, l2, n3)) {
            this.data = (byte[])ArrayUtil.resizeArray(this.data, (int)l2 + n3);
        }
        System.arraycopy(byArray, n2, this.data, (int)l2, n3);
        this.bitLength = (long)this.data.length * 8L;
    }

    @Override
    public void setBytes(SessionInterface sessionInterface, long l2, byte[] byArray) {
        this.setBytes(sessionInterface, l2, byArray, 0, byArray.length);
    }

    @Override
    public void setBytes(SessionInterface sessionInterface, long l2, BlobData blobData, long l3, long l4) {
        if (l4 > Integer.MAX_VALUE) {
            throw new IndexOutOfBoundsException();
        }
        byte[] byArray = blobData.getBytes(sessionInterface, l3, (int)l4);
        this.setBytes(sessionInterface, l2, byArray, 0, byArray.length);
    }

    @Override
    public void setBinaryStream(SessionInterface sessionInterface, long l2, InputStream inputStream) {
    }

    @Override
    public void truncate(SessionInterface sessionInterface, long l2) {
        if ((long)this.data.length > l2) {
            this.data = (byte[])ArrayUtil.resizeArray(this.data, (int)l2);
            this.bitLength = (long)this.data.length * 8L;
        }
    }

    @Override
    public BlobData duplicate(SessionInterface sessionInterface) {
        return new BinaryData(this.data, true);
    }

    @Override
    public long position(SessionInterface sessionInterface, byte[] byArray, long l2) {
        if (byArray.length > this.data.length) {
            return -1L;
        }
        if (l2 >= (long)this.data.length) {
            return -1L;
        }
        return ArrayUtil.find(this.data, (int)l2, this.data.length, byArray);
    }

    @Override
    public long position(SessionInterface sessionInterface, BlobData blobData, long l2) {
        if (blobData.length(sessionInterface) > (long)this.data.length) {
            return -1L;
        }
        byte[] byArray = blobData.getBytes(sessionInterface, 0L, (int)blobData.length(sessionInterface));
        return this.position(sessionInterface, byArray, l2);
    }

    @Override
    public long nonZeroLength(SessionInterface sessionInterface) {
        for (int i2 = this.data.length - 1; i2 > 0; --i2) {
            if (this.data[i2] == 0) continue;
            return i2 + 1;
        }
        return this.data.length;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long l2) {
        this.id = l2;
    }

    @Override
    public int getStreamBlockSize() {
        return 524288;
    }

    @Override
    public boolean isClosed() {
        return false;
    }

    @Override
    public void free() {
    }

    @Override
    public void setSession(SessionInterface sessionInterface) {
    }

    static boolean isInLimits(long l2, long l3, long l4) {
        return l3 >= 0L && l4 >= 0L && l3 + l4 <= l2;
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    public boolean equals(Object object) {
        if (object instanceof BinaryData) {
            return Type.SQL_VARBINARY.compare(null, this, object) == 0;
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int n2 = 0;
            for (int i2 = 0; i2 < this.data.length && i2 < 32; ++i2) {
                n2 = n2 * 31 + (0xFF & this.data[i2]);
            }
            this.hashCode = n2;
        }
        return this.hashCode;
    }
}

