/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.hsqldb.Row;
import org.hsqldb.error.Error;
import org.hsqldb.lib.StringConverter;
import org.hsqldb.rowio.RowOutputBase;
import org.hsqldb.rowio.RowOutputInterface;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.JavaObjectData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class RowOutputBinary
extends RowOutputBase {
    public static final int INT_STORE_SIZE = 4;
    int storageSize;
    int sizePosition;
    final int scale;
    final int mask;

    public RowOutputBinary() {
        this(new byte[64]);
    }

    public RowOutputBinary(int n2, int n3) {
        super(n2);
        this.scale = n3;
        this.mask = -n3;
        this.sizePosition = -1;
    }

    public RowOutputBinary(byte[] byArray) {
        super(byArray);
        this.scale = 1;
        this.mask = -this.scale;
        this.sizePosition = -1;
    }

    public void writeIntData(int n2, int n3) {
        int n4 = this.count;
        this.count = n3;
        this.writeInt(n2);
        if (this.count < n4) {
            this.count = n4;
        }
    }

    @Override
    public void writeData(Row row, Type[] typeArray) {
        super.writeData(row, typeArray);
    }

    @Override
    public long scaleFilePosition(long l2) {
        return l2 + (long)this.scale - 1L & (long)this.mask;
    }

    @Override
    public void setStorageSize(int n2) {
        this.storageSize = n2;
    }

    @Override
    public void setMode(int n2) {
    }

    @Override
    public void writeEnd() {
        if (this.count > this.storageSize) {
            throw Error.runtimeError(201, "RowOutputBinary");
        }
        while (this.count < this.storageSize) {
            this.write(0);
        }
    }

    @Override
    public void writeSize(int n2) {
        if (this.sizePosition < 0) {
            this.sizePosition = this.count;
            this.writeInt(n2);
        } else {
            this.writeIntData(n2, this.sizePosition);
        }
        this.storageSize = n2;
    }

    @Override
    public void writeType(int n2) {
        this.writeShort(n2);
    }

    @Override
    public void writeString(String string) {
        int n2 = this.count;
        this.writeInt(0);
        if (string != null && !string.isEmpty()) {
            StringConverter.stringToUTFBytes(string, this);
            this.writeIntData(this.count - n2 - 4, n2);
        }
    }

    @Override
    public int getSize(Row row) {
        Object[] objectArray = row.getData();
        Type[] typeArray = row.getTable().getColumnTypes();
        int n2 = row.getTable().getDataColumnCount();
        return 4 + this.getSize(objectArray, n2, typeArray);
    }

    @Override
    public int getStorageSize(int n2) {
        return n2 + this.scale - 1 & this.mask;
    }

    @Override
    public void writeFieldType(Type type) {
        this.write(1);
    }

    @Override
    public void writeNull(Type type) {
        this.write(0);
    }

    @Override
    protected void writeChar(String string, Type type) {
        this.writeString(string);
    }

    @Override
    protected void writeSmallint(Number number) {
        this.writeShort(number.intValue());
    }

    @Override
    protected void writeInteger(Number number) {
        this.writeInt(number.intValue());
    }

    @Override
    protected void writeBigint(Number number) {
        this.writeLong(number.longValue());
    }

    @Override
    protected void writeReal(Double d2) {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    @Override
    protected void writeDecimal(BigDecimal bigDecimal, Type type) {
        int n2 = bigDecimal.scale();
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        this.writeByteArray(byArray);
        this.writeInt(n2);
    }

    @Override
    protected void writeBoolean(Boolean bl) {
        this.write(bl != false ? 1 : 0);
    }

    @Override
    protected void writeDate(TimestampData timestampData, Type type) {
        this.writeLong(timestampData.getSeconds());
    }

    @Override
    protected void writeTime(TimeData timeData, Type type) {
        this.writeInt(timeData.getSeconds());
        this.writeInt(timeData.getNanos());
        if (type.typeCode == 94) {
            this.writeInt(timeData.getZone());
        }
    }

    @Override
    protected void writeTimestamp(TimestampData timestampData, Type type) {
        this.writeLong(timestampData.getSeconds());
        this.writeInt(timestampData.getNanos());
        if (type.typeCode == 95) {
            this.writeInt(timestampData.getZone());
        }
    }

    @Override
    protected void writeYearMonthInterval(IntervalMonthData intervalMonthData, Type type) {
        this.writeLong(intervalMonthData.units);
    }

    @Override
    protected void writeDaySecondInterval(IntervalSecondData intervalSecondData, Type type) {
        this.writeLong(intervalSecondData.getSeconds());
        this.writeInt(intervalSecondData.getNanos());
    }

    @Override
    protected void writeOther(JavaObjectData javaObjectData) {
        this.writeByteArray(javaObjectData.getBytes());
    }

    @Override
    protected void writeBit(BinaryData binaryData) {
        this.writeInt((int)binaryData.bitLength(null));
        this.write(binaryData.getBytes(), 0, binaryData.getBytes().length);
    }

    @Override
    protected void writeUUID(BinaryData binaryData) {
        this.writeByteArray(binaryData.getBytes());
    }

    @Override
    protected void writeBinary(BinaryData binaryData) {
        this.writeByteArray(binaryData.getBytes());
    }

    @Override
    protected void writeClob(ClobData clobData, Type type) {
        this.writeLong(clobData.getId());
    }

    @Override
    protected void writeBlob(BlobData blobData, Type type) {
        this.writeLong(blobData.getId());
    }

    @Override
    protected void writeArray(Object[] objectArray, Type type) {
        type = type.collectionBaseType();
        this.writeInt(objectArray.length);
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            this.writeData(objectArray[i2], type);
        }
    }

    public void writeArray(int[] nArray) {
        this.writeInt(nArray.length);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.write(1);
            this.writeInt(nArray[i2]);
        }
    }

    public void writeByteArray(byte[] byArray) {
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public void writeByteArray16(byte[] byArray) {
        this.write(byArray, 0, 16);
    }

    @Override
    public void writeBytes(byte[] byArray) {
        super.write(byArray);
    }

    public void writeCharArray(char[] cArray) {
        this.writeInt(cArray.length);
        this.write(cArray, 0, cArray.length);
    }

    public int getSize(int[] nArray) {
        return 4 + nArray.length * 5;
    }

    public int getSize(Object[] objectArray, int n2, Type[] typeArray) {
        int n3 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = objectArray[i2];
            n3 += this.getSize(object, typeArray[i2]);
        }
        return n3;
    }

    private int getSize(Object object, Type type) {
        int n2 = 1;
        if (object == null) {
            return n2;
        }
        switch (type.typeCode) {
            case 0: {
                break;
            }
            case 1: 
            case 12: {
                n2 += 4;
                n2 += StringConverter.getUTFSize((String)object);
                break;
            }
            case -6: 
            case 5: {
                n2 += 2;
                break;
            }
            case 4: {
                n2 += 4;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 25: {
                n2 += 8;
                break;
            }
            case 2: 
            case 3: {
                n2 += 8;
                BigDecimal bigDecimal = (BigDecimal)object;
                BigInteger bigInteger = bigDecimal.unscaledValue();
                n2 += bigInteger.toByteArray().length;
                break;
            }
            case 16: {
                ++n2;
                break;
            }
            case 91: {
                n2 += 8;
                break;
            }
            case 92: {
                n2 += 8;
                break;
            }
            case 94: {
                n2 += 12;
                break;
            }
            case 93: {
                n2 += 12;
                break;
            }
            case 95: {
                n2 += 16;
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                n2 += 8;
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                n2 += 12;
                break;
            }
            case -11: 
            case 60: 
            case 61: {
                n2 += 4;
                n2 = (int)((long)n2 + ((BinaryData)object).length(null));
                break;
            }
            case 14: 
            case 15: {
                n2 += 4;
                n2 = (int)((long)n2 + ((BinaryData)object).length(null));
                break;
            }
            case 30: 
            case 40: {
                n2 += 8;
                break;
            }
            case 50: {
                n2 += 4;
                Object[] objectArray = (Object[])object;
                type = type.collectionBaseType();
                for (int i2 = 0; i2 < objectArray.length; ++i2) {
                    n2 += this.getSize(objectArray[i2], type);
                }
                break;
            }
            case 1111: {
                JavaObjectData javaObjectData = (JavaObjectData)object;
                n2 += 4;
                n2 += javaObjectData.getBytesLength();
                break;
            }
            default: {
                throw Error.runtimeError(201, "RowOutputBinary");
            }
        }
        return n2;
    }

    @Override
    public void ensureRoom(int n2) {
        super.ensureRoom(n2);
    }

    @Override
    public void reset() {
        super.reset();
        this.storageSize = 0;
        this.sizePosition = -1;
    }

    @Override
    public void reset(int n2) {
        super.reset(n2);
        this.storageSize = 0;
        this.sizePosition = -1;
    }

    @Override
    public void reset(byte[] byArray) {
        super.reset(byArray);
        this.storageSize = 0;
        this.sizePosition = -1;
    }

    @Override
    public RowOutputInterface duplicate() {
        return new RowOutputBinary(128, this.scale);
    }
}

