/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.rowio;

import java.math.BigDecimal;
import org.hsqldb.error.Error;
import org.hsqldb.lib.HsqlByteArrayInputStream;
import org.hsqldb.types.BinaryData;
import org.hsqldb.types.BlobData;
import org.hsqldb.types.ClobData;
import org.hsqldb.types.IntervalMonthData;
import org.hsqldb.types.IntervalSecondData;
import org.hsqldb.types.TimeData;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

abstract class RowInputBase
extends HsqlByteArrayInputStream {
    static final int NO_POS = -1;
    protected long filePos = -1L;
    protected int size;

    RowInputBase() {
        this(new byte[4]);
    }

    RowInputBase(int n2) {
        this(new byte[n2]);
    }

    RowInputBase(byte[] byArray) {
        super(byArray);
        this.size = byArray.length;
    }

    public long getFilePosition() {
        if (this.filePos == -1L) {
            // empty if block
        }
        return this.filePos;
    }

    public int getSize() {
        return this.size;
    }

    public abstract int readType();

    public abstract String readString();

    protected abstract boolean readNull();

    protected abstract String readChar(Type var1);

    protected abstract Integer readSmallint();

    protected abstract Integer readInteger();

    protected abstract Long readBigint();

    protected abstract Double readReal();

    protected abstract BigDecimal readDecimal(Type var1);

    protected abstract Boolean readBoole();

    protected abstract TimeData readTime(Type var1);

    protected abstract TimestampData readDate(Type var1);

    protected abstract TimestampData readTimestamp(Type var1);

    protected abstract IntervalMonthData readYearMonthInterval(Type var1);

    protected abstract IntervalSecondData readDaySecondInterval(Type var1);

    protected abstract Object readOther();

    protected abstract BinaryData readUUID();

    protected abstract BinaryData readBinary();

    protected abstract BinaryData readBit();

    protected abstract ClobData readClob();

    protected abstract BlobData readBlob();

    protected abstract Object[] readArray(Type var1);

    public Object[] readData(Type[] typeArray) {
        int n2 = typeArray.length;
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            Type type = typeArray[i2];
            objectArray[i2] = this.readData(type);
        }
        return objectArray;
    }

    public Object readData(Type type) {
        Object[] objectArray = null;
        if (this.readNull()) {
            return null;
        }
        switch (type.typeCode) {
            case 0: {
                break;
            }
            case 1: 
            case 12: {
                objectArray = this.readChar(type);
                break;
            }
            case -6: 
            case 5: {
                objectArray = this.readSmallint();
                break;
            }
            case 4: {
                objectArray = this.readInteger();
                break;
            }
            case 25: {
                objectArray = this.readBigint();
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = this.readReal();
                break;
            }
            case 2: 
            case 3: {
                objectArray = this.readDecimal(type);
                break;
            }
            case 91: {
                objectArray = this.readDate(type);
                break;
            }
            case 92: 
            case 94: {
                objectArray = this.readTime(type);
                break;
            }
            case 93: 
            case 95: {
                objectArray = this.readTimestamp(type);
                break;
            }
            case 101: 
            case 102: 
            case 107: {
                objectArray = this.readYearMonthInterval(type);
                break;
            }
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: {
                objectArray = this.readDaySecondInterval(type);
                break;
            }
            case 16: {
                objectArray = this.readBoole();
                break;
            }
            case 1111: {
                objectArray = this.readOther();
                break;
            }
            case 40: {
                objectArray = this.readClob();
                break;
            }
            case 30: {
                objectArray = this.readBlob();
                break;
            }
            case 50: {
                objectArray = this.readArray(type);
                break;
            }
            case -11: {
                objectArray = this.readUUID();
                break;
            }
            case 60: 
            case 61: {
                objectArray = this.readBinary();
                break;
            }
            case 14: 
            case 15: {
                objectArray = this.readBit();
                break;
            }
            default: {
                throw Error.runtimeError(201, "RowInputBase - " + type.getNameString());
            }
        }
        return objectArray;
    }

    public void resetRow(long l2, int n2) {
        this.mark = 0;
        this.reset();
        if (this.buffer.length < n2) {
            this.buffer = new byte[n2];
        }
        this.filePos = l2;
        this.size = this.count = n2;
        this.pos = 4;
        this.buffer[0] = (byte)(n2 >>> 24 & 0xFF);
        this.buffer[1] = (byte)(n2 >>> 16 & 0xFF);
        this.buffer[2] = (byte)(n2 >>> 8 & 0xFF);
        this.buffer[3] = (byte)(n2 & 0xFF);
    }

    public void resetBlock(long l2, int n2) {
        this.mark = 0;
        this.reset();
        if (this.buffer.length < n2) {
            this.buffer = new byte[n2];
        }
        this.filePos = l2;
        this.size = this.count = n2;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int skipBytes(int n2) {
        throw Error.runtimeError(201, "RowInputBase");
    }

    @Override
    public String readLine() {
        throw Error.runtimeError(201, "RowInputBase");
    }
}

