/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;
import org.hsqldb.persist.RAFileSimple;
import org.hsqldb.persist.RandomAccessInterface;

public class LobStoreRAFile
implements LobStore {
    final int lobBlockSize;
    String fileName;
    RandomAccessInterface file;
    Database database;

    public LobStoreRAFile(Database database, int n2) {
        this.database = database;
        this.lobBlockSize = n2;
        this.fileName = database.getPath() + ".lobs";
        try {
            boolean bl = database.logger.getFileAccess().isStreamElement(this.fileName);
            if (bl) {
                this.openFile();
            }
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    private void openFile() {
        try {
            boolean bl = this.database.isFilesReadOnly();
            this.file = new RAFileSimple(this.database.logger, this.fileName, bl ? "r" : "rws");
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public byte[] getBlockBytes(int n2, int n3) {
        if (this.file == null) {
            throw Error.error(452);
        }
        try {
            long l2 = (long)n2 * (long)this.lobBlockSize;
            int n4 = n3 * this.lobBlockSize;
            byte[] byArray = new byte[n4];
            this.file.seek(l2);
            this.file.read(byArray, 0, n4);
            return byArray;
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void setBlockBytes(byte[] byArray, int n2, int n3) {
        if (this.file == null) {
            this.openFile();
        }
        try {
            long l2 = (long)n2 * (long)this.lobBlockSize;
            int n4 = n3 * this.lobBlockSize;
            this.file.seek(l2);
            this.file.write(byArray, 0, n4);
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void setBlockBytes(byte[] byArray, long l2, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if (this.file == null) {
            this.openFile();
        }
        try {
            this.file.seek(l2);
            this.file.write(byArray, n2, n3);
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public int getBlockSize() {
        return this.lobBlockSize;
    }

    @Override
    public long getLength() {
        if (this.file == null) {
            this.openFile();
        }
        try {
            return this.file.length();
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void setLength(long l2) {
        try {
            if (this.file != null) {
                this.file.setLength(l2);
                this.file.synch();
            }
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void close() {
        try {
            if (this.file != null) {
                this.file.synch();
                this.file.close();
            }
        }
        catch (Throwable throwable) {
            throw Error.error(466, throwable);
        }
    }

    @Override
    public void synch() {
        if (this.file != null) {
            this.file.synch();
        }
    }
}

