/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib.tar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.Properties;
import org.hsqldb.lib.InputStreamInterface;
import org.hsqldb.lib.InputStreamWrapper;
import org.hsqldb.lib.tar.RB;
import org.hsqldb.lib.tar.TarGenerator;
import org.hsqldb.lib.tar.TarMalformatException;

public class DbBackup {
    protected File dbDir;
    protected File archiveFile;
    protected String instanceName;
    protected boolean overWrite = false;
    protected boolean abortUponModify = true;
    File[] componentFiles;
    InputStreamInterface[] componentStreams;
    boolean[] existList;
    boolean[] ignoreList;

    public DbBackup(File file, String string) {
        this.archiveFile = file;
        File file2 = new File(string);
        this.dbDir = file2.getAbsoluteFile().getParentFile();
        this.instanceName = file2.getName();
        this.componentFiles = new File[]{new File(this.dbDir, this.instanceName + ".properties"), new File(this.dbDir, this.instanceName + ".script"), new File(this.dbDir, this.instanceName + ".data"), new File(this.dbDir, this.instanceName + ".backup"), new File(this.dbDir, this.instanceName + ".log"), new File(this.dbDir, this.instanceName + ".lobs")};
        this.componentStreams = new InputStreamInterface[this.componentFiles.length];
        this.existList = new boolean[this.componentFiles.length];
        this.ignoreList = new boolean[this.componentFiles.length];
    }

    public DbBackup(File file, String string, boolean bl) {
        this.archiveFile = file;
        File file2 = new File(string);
        this.dbDir = file2.getAbsoluteFile().getParentFile();
        this.instanceName = file2.getName();
        this.componentFiles = new File[]{new File(this.dbDir, this.instanceName + ".script")};
        this.componentStreams = new InputStreamInterface[this.componentFiles.length];
        this.existList = new boolean[this.componentFiles.length];
        this.ignoreList = new boolean[this.componentFiles.length];
        this.abortUponModify = false;
    }

    public void setStream(String string, InputStreamInterface inputStreamInterface) {
        for (int i2 = 0; i2 < this.componentFiles.length; ++i2) {
            if (!this.componentFiles[i2].getName().endsWith(string)) continue;
            this.componentStreams[i2] = inputStreamInterface;
            break;
        }
    }

    public void setFileIgnore(String string) {
        for (int i2 = 0; i2 < this.componentFiles.length; ++i2) {
            if (!this.componentFiles[i2].getName().endsWith(string)) continue;
            this.ignoreList[i2] = true;
            break;
        }
    }

    public void setOverWrite(boolean bl) {
        this.overWrite = bl;
    }

    public void setAbortUponModify(boolean bl) {
        this.abortUponModify = bl;
    }

    public boolean getOverWrite() {
        return this.overWrite;
    }

    public boolean getAbortUponModify() {
        return this.abortUponModify;
    }

    public void write() throws IOException, TarMalformatException {
        long l2 = new Date().getTime();
        this.checkEssentialFiles();
        TarGenerator tarGenerator = new TarGenerator(this.archiveFile, this.overWrite, DbBackup.generateBufferBlockValue(this.componentFiles));
        for (int i2 = 0; i2 < this.componentFiles.length; ++i2) {
            boolean bl;
            boolean bl2 = bl = this.componentStreams[i2] != null || this.componentFiles[i2].exists();
            if (!bl || this.ignoreList[i2]) continue;
            if (this.componentStreams[i2] == null) {
                tarGenerator.queueEntry(this.componentFiles[i2].getName(), this.componentFiles[i2]);
                this.existList[i2] = true;
                continue;
            }
            tarGenerator.queueEntry(this.componentFiles[i2].getName(), this.componentStreams[i2]);
        }
        tarGenerator.write();
        this.checkFilesNotChanged(l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsFiles() throws IOException {
        int n2 = 512 * DbBackup.generateBufferBlockValue(this.componentFiles);
        byte[] byArray = new byte[n2];
        this.checkEssentialFiles();
        FileOutputStream fileOutputStream = null;
        for (int i2 = 0; i2 < this.componentFiles.length; ++i2) {
            try {
                int n3;
                if (this.ignoreList[i2] || !this.componentFiles[i2].exists()) continue;
                File file = new File(this.archiveFile, this.componentFiles[i2].getName());
                fileOutputStream = new FileOutputStream(file);
                if (this.componentStreams[i2] == null) {
                    this.componentStreams[i2] = new InputStreamWrapper(new FileInputStream(this.componentFiles[i2]));
                }
                InputStreamInterface inputStreamInterface = this.componentStreams[i2];
                while ((n3 = inputStreamInterface.read(byArray, 0, byArray.length)) > 0) {
                    fileOutputStream.write(byArray, 0, n3);
                }
                inputStreamInterface.close();
                fileOutputStream.flush();
                fileOutputStream.getFD().sync();
                continue;
            }
            finally {
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkEssentialFiles() throws FileNotFoundException, IllegalStateException {
        Object object;
        if (!this.componentFiles[0].getName().endsWith(".properties")) {
            return;
        }
        for (int i2 = 0; i2 < 2; ++i2) {
            boolean bl;
            boolean bl2 = bl = this.componentStreams[i2] != null || this.componentFiles[i2].exists();
            if (bl) continue;
            throw new FileNotFoundException(RB.file_missing.getString(this.componentFiles[i2].getAbsolutePath()));
        }
        if (!this.abortUponModify) {
            return;
        }
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        try {
            object = this.componentFiles[0];
            fileInputStream = new FileInputStream((File)object);
            properties.load(fileInputStream);
        }
        catch (IOException iOException) {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException2) {
            }
            finally {
                fileInputStream = null;
            }
        }
        finally {
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                fileInputStream = null;
            }
        }
        object = properties.getProperty("modified");
        if (object != null && (((String)object).equalsIgnoreCase("yes") || ((String)object).equalsIgnoreCase("true"))) {
            throw new IllegalStateException(RB.modified_property.getString(new String[]{object}));
        }
    }

    void checkFilesNotChanged(long l2) throws FileNotFoundException {
        if (!this.abortUponModify) {
            return;
        }
        try {
            for (int i2 = 0; i2 < this.componentFiles.length; ++i2) {
                if (this.componentFiles[i2].exists()) {
                    if (!this.existList[i2]) {
                        throw new FileNotFoundException(RB.file_disappeared.getString(this.componentFiles[i2].getAbsolutePath()));
                    }
                    if (this.componentFiles[i2].lastModified() <= l2) continue;
                    throw new FileNotFoundException(RB.file_changed.getString(this.componentFiles[i2].getAbsolutePath()));
                }
                if (!this.existList[i2]) continue;
                throw new FileNotFoundException(RB.file_appeared.getString(this.componentFiles[i2].getAbsolutePath()));
            }
        }
        catch (IllegalStateException illegalStateException) {
            if (!this.archiveFile.delete()) {
                System.out.println(RB.cleanup_rmfail.getString(this.archiveFile.getAbsolutePath()));
            }
            throw illegalStateException;
        }
    }

    protected static int generateBufferBlockValue(File[] fileArray) {
        int n2;
        long l2 = 0L;
        for (n2 = 0; n2 < fileArray.length; ++n2) {
            if (fileArray[n2] == null || fileArray[n2].length() <= l2) continue;
            l2 = fileArray[n2].length();
        }
        n2 = (int)(l2 / 5120L);
        if (n2 < 1) {
            return 1;
        }
        if (n2 > 40960) {
            return 40960;
        }
        return n2;
    }

    protected static int generateBufferBlockValue(File file) {
        return DbBackup.generateBufferBlockValue(new File[]{file});
    }
}

