/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.HashMap;

public class OrderedHashMap<K, V>
extends HashMap<K, V> {
    public OrderedHashMap() {
        this(8);
    }

    public OrderedHashMap(int n2) throws IllegalArgumentException {
        super(n2);
        this.isList = true;
    }

    public K getKeyAt(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        return (K)this.objectKeyTable[n2];
    }

    public V getValueAt(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        return (V)this.objectValueTable[n2];
    }

    public V get(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        return (V)this.objectValueTable[n2];
    }

    @Override
    public V remove(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        return (V)super.remove(0L, 0L, object, null, false, true);
    }

    public void removeEntry(int n2) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        Object object = this.objectKeyTable[n2];
        super.remove(0L, 0L, object, null, false, true);
    }

    public boolean add(K k2, V v) {
        if (k2 == null) {
            throw new NullPointerException();
        }
        int n2 = this.getLookup(k2);
        if (n2 >= 0) {
            return false;
        }
        super.put(k2, v);
        return true;
    }

    public V setValueAt(int n2, V v) throws IndexOutOfBoundsException {
        this.checkRange(n2);
        Object object = this.objectValueTable[n2];
        this.objectValueTable[n2] = v;
        return (V)object;
    }

    public boolean insert(int n2, K k2, V v) throws IndexOutOfBoundsException {
        if (k2 == null) {
            throw new NullPointerException();
        }
        if (n2 < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = this.getLookup(k2);
        if (n3 >= 0) {
            return false;
        }
        if (n2 < this.size()) {
            super.insertRow(n2);
        }
        super.put(k2, v);
        return true;
    }

    public boolean set(int n2, K k2, V v) throws IndexOutOfBoundsException {
        if (k2 == null) {
            throw new NullPointerException();
        }
        this.checkRange(n2);
        if (this.keySet().contains(k2) && this.getIndex(k2) != n2) {
            return false;
        }
        super.remove(0L, 0L, this.objectKeyTable[n2], null, false, false);
        super.put(k2, v);
        return true;
    }

    public boolean setKeyAt(int n2, K k2) throws IndexOutOfBoundsException {
        if (k2 == null) {
            throw new NullPointerException();
        }
        this.checkRange(n2);
        Object object = this.objectValueTable[n2];
        return this.set(n2, k2, object);
    }

    public int getIndex(K k2) {
        return this.getLookup(k2);
    }

    private void checkRange(int n2) {
        if (n2 < 0 || n2 >= this.size()) {
            throw new IndexOutOfBoundsException();
        }
    }
}

