/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.lib.java.JavaSystem;
import org.hsqldb.map.ValuePool;

public class LineGroupReader {
    private static final String[] defaultContinuations = new String[]{" ", "*"};
    private static final String[] defaultIgnoredStarts = new String[]{"--"};
    static final String LS = System.getProperty("line.separator", "\n");
    LineNumberReader reader;
    String nextStartLine = null;
    int startLineNumber = 0;
    int nextStartLineNumber = 0;
    final String[] sectionContinuations;
    final String[] sectionStarts;
    final String[] ignoredStarts;

    public LineGroupReader(LineNumberReader lineNumberReader) {
        this.sectionContinuations = defaultContinuations;
        this.sectionStarts = ValuePool.emptyStringArray;
        this.ignoredStarts = defaultIgnoredStarts;
        this.reader = lineNumberReader;
        try {
            this.getNextSection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public LineGroupReader(LineNumberReader lineNumberReader, String[] stringArray) {
        this.sectionStarts = stringArray;
        this.sectionContinuations = ValuePool.emptyStringArray;
        this.ignoredStarts = ValuePool.emptyStringArray;
        this.reader = lineNumberReader;
        try {
            this.getNextSection();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public HsqlArrayList getNextSection() {
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>(new String[128], 0);
        if (this.nextStartLine != null) {
            hsqlArrayList.add(this.nextStartLine);
            this.startLineNumber = this.nextStartLineNumber;
        }
        while (true) {
            boolean bl = false;
            String string = null;
            try {
                string = this.reader.readLine();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string == null) {
                this.nextStartLine = null;
                return hsqlArrayList;
            }
            if ((string = string.substring(0, StringUtil.rightTrimSize(string))).isEmpty() || this.isIgnoredLine(string)) continue;
            if (this.isNewSectionLine(string)) {
                bl = true;
            }
            if (bl) {
                this.nextStartLine = string;
                this.nextStartLineNumber = this.reader.getLineNumber();
                return hsqlArrayList;
            }
            hsqlArrayList.add(string);
        }
    }

    public String getSectionAsString() {
        HsqlArrayList hsqlArrayList = this.getNextSection();
        return LineGroupReader.convertToString(hsqlArrayList, 0);
    }

    public OrderedHashMap getAsMap() {
        HsqlArrayList hsqlArrayList;
        OrderedHashMap<String, String> orderedHashMap = new OrderedHashMap<String, String>();
        while ((hsqlArrayList = this.getNextSection()).size() != 0) {
            String string = (String)hsqlArrayList.get(0);
            String string2 = LineGroupReader.convertToString(hsqlArrayList, 1);
            orderedHashMap.put(string, string2);
        }
        return orderedHashMap;
    }

    private boolean isNewSectionLine(String string) {
        if (this.sectionStarts.length == 0) {
            for (int i2 = 0; i2 < this.sectionContinuations.length; ++i2) {
                if (!string.startsWith(this.sectionContinuations[i2])) continue;
                return false;
            }
            return true;
        }
        for (int i3 = 0; i3 < this.sectionStarts.length; ++i3) {
            if (!string.startsWith(this.sectionStarts[i3])) continue;
            return true;
        }
        return false;
    }

    private boolean isIgnoredLine(String string) {
        for (int i2 = 0; i2 < this.ignoredStarts.length; ++i2) {
            if (!string.startsWith(this.ignoredStarts[i2])) continue;
            return true;
        }
        return false;
    }

    public int getStartLineNumber() {
        return this.startLineNumber;
    }

    public void close() {
        try {
            this.reader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String convertToString(HsqlArrayList hsqlArrayList, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = n2; i2 < hsqlArrayList.size(); ++i2) {
            stringBuilder.append(hsqlArrayList.get(i2)).append(LS);
        }
        return stringBuilder.toString();
    }

    public static OrderedHashMap getStatementMap(String string) {
        String[] stringArray = new String[]{"/*"};
        LineGroupReader lineGroupReader = LineGroupReader.getGroupReader(string, stringArray);
        OrderedHashMap orderedHashMap = lineGroupReader.getAsMap();
        lineGroupReader.close();
        return orderedHashMap;
    }

    public static LineGroupReader getGroupReader(final String string, String[] stringArray) {
        InputStream inputStream = AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return this.getClass().getResourceAsStream(string);
            }
        });
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream, JavaSystem.CS_ISO_8859_1);
        LineNumberReader lineNumberReader = new LineNumberReader(inputStreamReader);
        return new LineGroupReader(lineNumberReader, stringArray);
    }

    public static LineGroupReader getGroupReader(String string) {
        return LineGroupReader.getGroupReader(string, ValuePool.emptyStringArray);
    }
}

