/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import org.hsqldb.lib.Collection;
import org.hsqldb.lib.Iterator;
import org.hsqldb.lib.PrimitiveIterator;
import org.hsqldb.map.BaseHashMap;

public class IntHashSet
extends BaseHashMap {
    public IntHashSet() {
        this(8);
    }

    public IntHashSet(int n2) throws IllegalArgumentException {
        super(n2, 1, 0, false);
    }

    public IntHashSet(int[] nArray) {
        super(nArray.length, 1, 0, false);
        this.addAll(nArray);
    }

    public IntHashSet(int[] nArray, int[] nArray2) {
        super(nArray.length + nArray2.length, 1, 0, false);
        this.addAll(nArray);
        this.addAll(nArray2);
    }

    public boolean contains(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return this.containsKey(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean contains(int n2) {
        return super.containsKey(n2);
    }

    public boolean add(Integer n2) {
        if (n2 == null) {
            throw new NullPointerException();
        }
        int n3 = n2;
        return this.add(n3);
    }

    public boolean add(int n2) {
        return (Boolean)super.addOrUpdate(n2, 0L, null, null);
    }

    public boolean remove(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return this.remove(n2);
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean remove(int n2) {
        return (Boolean)super.remove(n2, 0L, null, null, false, false);
    }

    public int getStartMatchCount(int[] nArray) {
        int n2;
        for (n2 = 0; n2 < nArray.length && super.containsKey(nArray[n2]); ++n2) {
        }
        return n2;
    }

    public boolean addAll(Collection<? extends Integer> collection) {
        int n2 = this.size();
        Iterator<? extends Integer> iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
        return n2 != this.size();
    }

    public boolean addAll(IntHashSet intHashSet) {
        boolean bl = false;
        PrimitiveIterator<Integer> primitiveIterator = intHashSet.iterator();
        while (primitiveIterator.hasNext()) {
            bl |= this.add(primitiveIterator.nextInt());
        }
        return bl;
    }

    public boolean addAll(int[] nArray) {
        int n2 = this.size();
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            this.add(nArray[i2]);
        }
        return n2 != this.size();
    }

    public boolean containsAll(Collection<?> collection) {
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    public boolean retainAll(Collection<?> collection) {
        int n2 = this.size();
        BaseHashMap.BaseHashIterator baseHashIterator = new BaseHashMap.BaseHashIterator(true);
        while (baseHashIterator.hasNext()) {
            if (collection.contains(baseHashIterator.nextInt())) continue;
            baseHashIterator.remove();
        }
        return n2 != this.size();
    }

    public boolean removeAll(Collection<?> collection) {
        int n2 = this.size();
        Iterator<?> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (!(obj instanceof Integer)) continue;
            this.remove(obj);
        }
        return n2 != this.size();
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        return this.toIntArray(nArray, true);
    }

    public int[] toArray(int[] nArray) {
        return this.toIntArray(nArray, true);
    }

    public PrimitiveIterator<Integer> iterator() {
        return new BaseHashMap.BaseHashIterator(true);
    }
}

