/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.StringConverter;

public class HsqlByteArrayOutputStream
extends OutputStream
implements DataOutput {
    protected byte[] buffer;
    protected int count;

    public HsqlByteArrayOutputStream() {
        this(128);
    }

    public HsqlByteArrayOutputStream(int n2) {
        if (n2 < 128) {
            n2 = 128;
        }
        this.buffer = new byte[n2];
    }

    public HsqlByteArrayOutputStream(byte[] byArray) {
        this.buffer = byArray;
    }

    public HsqlByteArrayOutputStream(InputStream inputStream, int n2) throws IOException {
        this.buffer = new byte[n2];
        int n3 = this.write(inputStream, n2);
        if (n3 != n2) {
            throw new EOFException();
        }
    }

    public HsqlByteArrayOutputStream(InputStream inputStream) throws IOException {
        int n2;
        this.buffer = new byte[128];
        while ((n2 = inputStream.read(this.buffer, this.count, this.buffer.length - this.count)) != -1) {
            this.count += n2;
            if (this.count != this.buffer.length) continue;
            this.ensureRoom(128);
        }
    }

    @Override
    public void writeShort(int n2) {
        this.ensureRoom(2);
        this.buffer[this.count++] = (byte)(n2 >>> 8);
        this.buffer[this.count++] = (byte)n2;
    }

    @Override
    public void writeInt(int n2) {
        if (this.count + 4 > this.buffer.length) {
            this.ensureRoom(4);
        }
        this.buffer[this.count++] = (byte)(n2 >>> 24);
        this.buffer[this.count++] = (byte)(n2 >>> 16);
        this.buffer[this.count++] = (byte)(n2 >>> 8);
        this.buffer[this.count++] = (byte)n2;
    }

    @Override
    public void writeLong(long l2) {
        this.writeInt((int)(l2 >>> 32));
        this.writeInt((int)l2);
    }

    @Override
    public void writeBytes(String string) {
        int n2 = string.length();
        this.ensureRoom(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            this.buffer[this.count++] = (byte)string.charAt(i2);
        }
    }

    @Override
    public final void writeFloat(float f2) {
        this.writeInt(Float.floatToIntBits(f2));
    }

    @Override
    public final void writeDouble(double d2) {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    @Override
    public void writeBoolean(boolean bl) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)(bl ? 1 : 0);
    }

    @Override
    public void writeByte(int n2) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)n2;
    }

    @Override
    public void writeChar(int n2) {
        this.ensureRoom(2);
        this.buffer[this.count++] = (byte)(n2 >>> 8);
        this.buffer[this.count++] = (byte)n2;
    }

    @Override
    public void writeChars(String string) {
        int n2 = string.length();
        this.ensureRoom(n2 * 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            this.buffer[this.count++] = (byte)(c2 >>> 8);
            this.buffer[this.count++] = (byte)c2;
        }
    }

    @Override
    public void writeUTF(String string) throws IOException {
        int n2 = string.length();
        if (n2 > 65535) {
            throw new UTFDataFormatException();
        }
        this.ensureRoom(n2 * 3 + 2);
        int n3 = this.count;
        this.count += 2;
        StringConverter.stringToUTFBytes(string, this);
        int n4 = this.count - n3 - 2;
        if (n4 > 65535) {
            this.count = n3;
            throw new UTFDataFormatException();
        }
        this.buffer[n3++] = (byte)(n4 >>> 8);
        this.buffer[n3] = (byte)n4;
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(int n2) {
        this.ensureRoom(1);
        this.buffer[this.count++] = (byte)n2;
    }

    @Override
    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) {
        this.ensureRoom(n3);
        System.arraycopy(byArray, n2, this.buffer, this.count, n3);
        this.count += n3;
    }

    public String toString() {
        return new String(this.buffer, 0, this.count);
    }

    @Override
    public void close() {
    }

    public void writeNoCheck(int n2) {
        this.buffer[this.count++] = (byte)n2;
    }

    public void writeChars(char[] cArray) {
        int n2 = cArray.length;
        this.ensureRoom(n2 * 2);
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = cArray[i2];
            this.buffer[this.count++] = (byte)(c2 >>> 8);
            this.buffer[this.count++] = (byte)c2;
        }
    }

    public int write(InputStream inputStream, int n2) throws IOException {
        int n3;
        int n4 = n2;
        this.ensureRoom(n2);
        while (n4 > 0 && (n3 = inputStream.read(this.buffer, this.count, n4)) != -1) {
            n4 -= n3;
            this.count += n3;
        }
        return n2 - n4;
    }

    public int write(Reader reader, int n2) throws IOException {
        int n3;
        int n4;
        this.ensureRoom(n2 * 2);
        for (n4 = n2; n4 > 0 && (n3 = reader.read()) != -1; --n4) {
            this.writeChar(n3);
        }
        return n2 - n4;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this.buffer, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] byArray = new byte[this.count];
        System.arraycopy(this.buffer, 0, byArray, 0, this.count);
        return byArray;
    }

    public final int size() {
        return this.count;
    }

    public void setPosition(int n2) {
        if (n2 > this.buffer.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        this.count = n2;
    }

    public String toString(String string) throws UnsupportedEncodingException {
        return new String(this.buffer, 0, this.count, string);
    }

    public void write(char[] cArray, int n2, int n3) {
        this.ensureRoom(n3 * 2);
        for (int i2 = n2; i2 < n3; ++i2) {
            char c2 = cArray[i2];
            this.buffer[this.count++] = (byte)(c2 >>> 8);
            this.buffer[this.count++] = (byte)c2;
        }
    }

    public void fill(int n2, int n3) {
        this.ensureRoom(n3);
        for (int i2 = 0; i2 < n3; ++i2) {
            this.buffer[this.count++] = (byte)n2;
        }
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public void ensureRoom(int n2) {
        long l2;
        long l3 = this.count + n2;
        if (l3 > 0x7FFFFFFDL) {
            throw new OutOfMemoryError("2GB maximum buffer length exceeded");
        }
        if (l3 > l2) {
            for (l2 = (long)this.buffer.length; l3 > l2; l2 *= 2L) {
            }
            if (l2 > 0x7FFFFFFDL) {
                l2 = 0x7FFFFFFDL;
            }
            byte[] byArray = new byte[(int)l2];
            System.arraycopy(this.buffer, 0, byArray, 0, this.count);
            this.buffer = byArray;
        }
    }

    public void reset(int n2) {
        this.count = 0;
        if (n2 > this.buffer.length) {
            n2 = (int)ArrayUtil.getBinaryMultipleCeiling(n2, 4096L);
            this.buffer = new byte[n2];
        }
    }

    public void reset(byte[] byArray) {
        this.count = 0;
        this.buffer = byArray;
    }

    public void setSize(int n2) {
        this.count = n2;
    }
}

