/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Comparator;
import org.hsqldb.lib.ArraySort;
import org.hsqldb.lib.BaseList;
import org.hsqldb.lib.List;

public class HsqlArrayList<E>
extends BaseList<E>
implements List<E> {
    private static final int DEFAULT_INITIAL_CAPACITY = 8;
    private static final float DEFAULT_RESIZE_FACTOR = 2.0f;
    E[] elementData;
    E[] reserveElementData;
    private boolean minimizeOnClear;

    public HsqlArrayList(E[] EArray, int n2) {
        this.elementData = EArray;
        this.elementCount = n2;
    }

    public HsqlArrayList() {
        this.elementData = new Object[8];
    }

    public HsqlArrayList(int n2, boolean bl) {
        if (n2 < 8) {
            n2 = 8;
        }
        this.elementData = new Object[n2];
        this.minimizeOnClear = bl;
    }

    public HsqlArrayList(int n2) {
        if (n2 < 0) {
            throw new NegativeArraySizeException("Invalid initial capacity given");
        }
        if (n2 < 8) {
            n2 = 8;
        }
        this.elementData = new Object[n2];
    }

    @Override
    public void add(int n2, E e2) {
        if (n2 > this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + ">" + this.elementCount);
        }
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " < 0");
        }
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        if (n2 < this.elementCount) {
            System.arraycopy(this.elementData, n2, this.elementData, n2 + 1, this.elementCount - n2);
        }
        this.elementData[n2] = e2;
        ++this.elementCount;
    }

    @Override
    public boolean add(E e2) {
        if (this.elementCount >= this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementData[this.elementCount] = e2;
        ++this.elementCount;
        return true;
    }

    @Override
    public E get(int n2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.elementCount);
        }
        return this.elementData[n2];
    }

    @Override
    public int indexOf(Object object) {
        if (object == null) {
            for (int i2 = 0; i2 < this.elementCount; ++i2) {
                if (this.elementData[i2] != null) continue;
                return i2;
            }
            return -1;
        }
        for (int i3 = 0; i3 < this.elementCount; ++i3) {
            if (!this.comparator.equals(object, this.elementData[i3])) continue;
            return i3;
        }
        return -1;
    }

    @Override
    public E remove(int n2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.elementCount);
        }
        E e2 = this.elementData[n2];
        if (n2 < this.elementCount - 1) {
            System.arraycopy(this.elementData, n2 + 1, this.elementData, n2, this.elementCount - 1 - n2);
        }
        --this.elementCount;
        this.elementData[this.elementCount] = null;
        if (this.elementCount == 0) {
            this.clear();
        }
        return e2;
    }

    @Override
    public E set(int n2, E e2) {
        if (n2 >= this.elementCount) {
            throw new IndexOutOfBoundsException("Index out of bounds: " + n2 + " >= " + this.elementCount);
        }
        E e3 = this.elementData[n2];
        this.elementData[n2] = e2;
        return e3;
    }

    @Override
    public final int size() {
        return this.elementCount;
    }

    private void increaseCapacity() {
        int n2 = this.elementData.length == 0 ? 1 : this.elementData.length;
        n2 = (int)((float)n2 * 2.0f);
        this.resize(n2);
    }

    private void resize(int n2) {
        if (n2 == this.elementData.length) {
            return;
        }
        Object[] objectArray = (Object[])Array.newInstance(this.elementData.getClass().getComponentType(), n2);
        int n3 = this.elementData.length > objectArray.length ? objectArray.length : this.elementData.length;
        System.arraycopy(this.elementData, 0, objectArray, 0, n3);
        if (this.minimizeOnClear && this.reserveElementData == null) {
            Arrays.fill(this.elementData, (Object)0);
            this.reserveElementData = this.elementData;
        }
        this.elementData = objectArray;
    }

    public void trim() {
        this.resize(this.elementCount);
    }

    @Override
    public void clear() {
        if (this.minimizeOnClear && this.reserveElementData != null) {
            this.elementData = this.reserveElementData;
            this.reserveElementData = null;
            this.elementCount = 0;
            return;
        }
        for (int i2 = 0; i2 < this.elementCount; ++i2) {
            this.elementData[i2] = null;
        }
        this.elementCount = 0;
    }

    public void setSize(int n2) {
        if (n2 == 0) {
            this.clear();
            return;
        }
        if (n2 <= this.elementCount) {
            for (int i2 = n2; i2 < this.elementCount; ++i2) {
                this.elementData[i2] = null;
            }
            this.elementCount = n2;
            return;
        }
        while (n2 > this.elementData.length) {
            this.increaseCapacity();
        }
        this.elementCount = n2;
    }

    public Object[] toArray() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.elementCount) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.elementCount);
        }
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        return objectArray;
    }

    public void toArraySlice(E[] EArray, int n2, int n3) {
        System.arraycopy(this.elementData, n2, EArray, 0, n3 - n2);
    }

    public E[] getArray() {
        return this.elementData;
    }

    public void sort(Comparator<? super E> comparator) {
        if (this.elementCount < 2) {
            return;
        }
        ArraySort.sort(this.elementData, this.elementCount, comparator);
    }

    public int lastIndexOf(Object object) {
        if (object == null) {
            for (int i2 = this.elementCount - 1; i2 >= 0; --i2) {
                if (this.elementData[i2] != null) continue;
                return i2;
            }
            return -1;
        }
        for (int i3 = this.elementCount - 1; i3 >= 0; --i3) {
            if (!this.comparator.equals(object, this.elementData[i3])) continue;
            return i3;
        }
        return -1;
    }
}

