/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.util.Arrays;
import java.util.NoSuchElementException;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.LongLookup;

public class DoubleIntIndex
implements LongLookup {
    private int count = 0;
    private int capacity;
    private boolean sorted = true;
    private boolean sortOnValues = false;
    private final boolean fixedSize;
    private int[] keys;
    private int[] values;
    private int targetSearchValue;

    public DoubleIntIndex(int n2) {
        this(n2, false);
    }

    public DoubleIntIndex(int n2, boolean bl) {
        this.capacity = n2;
        this.keys = new int[n2];
        this.values = new int[n2];
        this.fixedSize = bl;
    }

    public int getKey(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.keys[n2];
    }

    @Override
    public long getLongKey(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return (long)this.keys[n2] & 0xFFFFFFFFL;
    }

    @Override
    public long getLongValue(int n2) {
        return this.values[n2];
    }

    public int getValue(int n2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        return this.values[n2];
    }

    public void setKey(int n2, int n3) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.keys[n2] = n3;
    }

    public void setValue(int n2, int n3) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.values[n2] = n3;
    }

    @Override
    public void setLongValue(int n2, long l2) {
        if (n2 < 0 || n2 >= this.count) {
            throw new IndexOutOfBoundsException();
        }
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.values[n2] = (int)l2;
    }

    @Override
    public int size() {
        return this.count;
    }

    public int capacity() {
        return this.capacity;
    }

    public int[] getKeys() {
        return this.keys;
    }

    public int[] getValues() {
        return this.values;
    }

    @Override
    public long getTotalValues() {
        long l2 = 0L;
        for (int i2 = 0; i2 < this.count; ++i2) {
            l2 += (long)this.values[i2];
        }
        return l2;
    }

    public void setSize(int n2) {
        this.count = n2;
    }

    @Override
    public boolean addUnsorted(long l2, long l3) {
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        if (l3 > Integer.MAX_VALUE || l3 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.addUnsorted((int)l2, (int)l3);
    }

    public boolean addUnsorted(int n2, int n3) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.sorted && this.count != 0) {
            if (this.sortOnValues) {
                if (n3 < this.values[this.count - 1]) {
                    this.sorted = false;
                }
            } else if (n2 < this.keys[this.count - 1]) {
                this.sorted = false;
            }
        }
        this.keys[this.count] = n2;
        this.values[this.count] = n3;
        ++this.count;
        return true;
    }

    @Override
    public boolean addUnsorted(LongLookup longLookup) {
        if (!this.ensureCapacityToAdd(longLookup.size())) {
            return false;
        }
        this.sorted = false;
        for (int i2 = 0; i2 < longLookup.size(); ++i2) {
            long l2 = longLookup.getLongKey(i2);
            long l3 = longLookup.getLongValue(i2);
            this.addUnsorted(l2, l3);
        }
        return true;
    }

    private boolean ensureCapacityToAdd(int n2) {
        if (this.count + n2 > this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            while (this.count + n2 > this.capacity) {
                this.doubleCapacity();
            }
        }
        return true;
    }

    public boolean addSorted(int n2, int n3) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (this.count != 0) {
            if (this.sortOnValues) {
                if (n3 < this.values[this.count - 1]) {
                    return false;
                }
                if (n3 == this.values[this.count - 1] && n2 < this.keys[this.count - 1]) {
                    return false;
                }
            } else if (n2 < this.keys[this.count - 1]) {
                return false;
            }
        }
        this.keys[this.count] = n2;
        this.values[this.count] = n3;
        ++this.count;
        return true;
    }

    public boolean addUnique(int n2, int n3) {
        if (this.sortOnValues) {
            throw new IllegalArgumentException();
        }
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return false;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n3 : n2;
        int n4 = this.binaryEmptySlotSearch();
        if (n4 == -1) {
            return false;
        }
        if (this.count != n4) {
            this.moveRows(n4, n4 + 1, this.count - n4);
        }
        this.keys[n4] = n2;
        this.values[n4] = n3;
        ++this.count;
        return true;
    }

    public boolean removeKey(int n2) {
        if (this.sortOnValues) {
            throw new IllegalArgumentException();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        int n3 = this.binarySlotSearch(false);
        if (n3 == this.count) {
            return false;
        }
        if (this.keys[n3] != n2) {
            return false;
        }
        this.remove(n3);
        return true;
    }

    public boolean addOrReplaceUnique(int n2, int n3) {
        if (this.sortOnValues) {
            throw new IllegalArgumentException();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        int n4 = this.binarySlotSearch(false);
        if (n4 < this.count) {
            if (this.keys[n4] == n2) {
                this.values[n4] = n3;
                return true;
            }
            if (this.count == this.capacity) {
                if (this.fixedSize) {
                    return false;
                }
                this.doubleCapacity();
            }
            this.moveRows(n4, n4 + 1, this.count - n4);
        }
        this.keys[n4] = n2;
        this.values[n4] = n3;
        ++this.count;
        return true;
    }

    public int addCount(int n2, int n3) {
        int n4;
        this.sortOnValues = false;
        if (this.addUnique(n2, n3)) {
            return n3;
        }
        this.targetSearchValue = n2;
        int n5 = n4 = this.binarySlotSearch(false);
        this.values[n5] = this.values[n5] + n3;
        return this.values[n4];
    }

    public int addCount(int n2) {
        return this.addCount(n2, 1);
    }

    @Override
    public int add(long l2, long l3) {
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        if (l3 > Integer.MAX_VALUE || l3 < Integer.MIN_VALUE) {
            throw new IllegalArgumentException();
        }
        return this.add((int)l2, (int)l3);
    }

    public int add(int n2, int n3) {
        if (this.count == this.capacity) {
            if (this.fixedSize) {
                return -1;
            }
            this.doubleCapacity();
        }
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = this.sortOnValues ? n3 : n2;
        int n4 = this.binarySlotSearch(true);
        if (this.count != n4) {
            this.moveRows(n4, n4 + 1, this.count - n4);
        }
        this.keys[n4] = n2;
        this.values[n4] = n3;
        ++this.count;
        return n4;
    }

    @Override
    public long lookup(long l2) throws NoSuchElementException {
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            throw new NoSuchElementException();
        }
        return this.lookup((int)l2);
    }

    public int lookup(int n2) throws NoSuchElementException {
        int n3;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n3 = this.findFirstEqualKeyIndex(n2)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n3);
    }

    @Override
    public long lookup(long l2, long l3) {
        int n2;
        if (l2 > Integer.MAX_VALUE || l2 < Integer.MIN_VALUE) {
            return l3;
        }
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n2 = this.findFirstEqualKeyIndex((int)l2)) == -1) {
            return l3;
        }
        return this.getValue(n2);
    }

    public int lookup(int n2, int n3) {
        int n4;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n4 = this.findFirstEqualKeyIndex(n2)) == -1) {
            return n3;
        }
        return this.getValue(n4);
    }

    @Override
    public void clear() {
        this.removeAll();
    }

    @Override
    public LongLookup duplicate() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(this.capacity);
        this.copyTo(doubleIntIndex);
        return doubleIntIndex;
    }

    public int lookupFirstGreaterEqual(int n2) throws NoSuchElementException {
        int n3;
        if (this.sortOnValues) {
            this.sorted = false;
            this.sortOnValues = false;
        }
        if ((n3 = this.findFirstGreaterEqualKeyIndex(n2)) == -1) {
            throw new NoSuchElementException();
        }
        return this.getValue(n3);
    }

    public void setValuesSearchTarget() {
        if (!this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = true;
    }

    public void setKeysSearchTarget() {
        if (this.sortOnValues) {
            this.sorted = false;
        }
        this.sortOnValues = false;
    }

    public int findFirstGreaterEqualKeyIndex(int n2) {
        int n3 = this.findFirstGreaterEqualSlotIndex(n2);
        return n3 == this.count ? -1 : n3;
    }

    public int findFirstEqualKeyIndex(int n2) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        return this.binaryFirstSearch();
    }

    @Override
    public boolean compactLookupAsIntervals() {
        int n2;
        if (this.size() == 0) {
            return false;
        }
        this.setKeysSearchTarget();
        if (!this.sorted) {
            this.fastQuickSort();
        }
        int n3 = 0;
        for (n2 = 1; n2 < this.count; ++n2) {
            long l2 = this.keys[n3] + this.values[n3];
            if (l2 == (long)this.keys[n2]) {
                int n4 = n3;
                this.values[n4] = this.values[n4] + this.values[n2];
                continue;
            }
            this.keys[++n3] = this.keys[n2];
            this.values[n3] = this.values[n2];
        }
        for (n2 = n3 + 1; n2 < this.count; ++n2) {
            this.keys[n2] = 0;
            this.values[n2] = 0;
        }
        if (this.count != n3 + 1) {
            this.setSize(n3 + 1);
            return true;
        }
        return false;
    }

    public int findFirstGreaterEqualSlotIndex(int n2) {
        if (!this.sorted) {
            this.fastQuickSort();
        }
        this.targetSearchValue = n2;
        return this.binarySlotSearch(false);
    }

    private int binaryFirstSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.count;
        while (n2 < n3) {
            n4 = n2 + n3 >>> 1;
            n5 = this.compare(n4);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            n3 = n4;
            n6 = n4;
        }
        return n6 == this.count ? -1 : n6;
    }

    private int binarySlotSearch(boolean bl) {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n3) {
            n4 = n2 + n3 >>> 1;
            n5 = this.compare(n4);
            if (n5 <= 0) {
                n3 = n4;
                continue;
            }
            n2 = n4 + 1;
        }
        return n2;
    }

    private int binaryEmptySlotSearch() {
        int n2 = 0;
        int n3 = this.count;
        int n4 = 0;
        int n5 = 0;
        while (n2 < n3) {
            n4 = n2 + n3 >>> 1;
            n5 = this.compare(n4);
            if (n5 < 0) {
                n3 = n4;
                continue;
            }
            if (n5 > 0) {
                n2 = n4 + 1;
                continue;
            }
            return -1;
        }
        return n2;
    }

    public void sortOnKeys() {
        this.sortOnValues = false;
        this.fastQuickSort();
    }

    public void sortOnValues() {
        this.sortOnValues = true;
        this.fastQuickSort();
    }

    @Override
    public void sort() {
        if (this.sortOnValues || this.count <= 16384) {
            this.fastQuickSortRecursive();
        } else {
            this.fastQuickSort();
        }
    }

    private void fastQuickSort() {
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(32768);
        int n2 = 16;
        doubleIntIndex.push(0, this.count - 1);
        while (doubleIntIndex.size() > 0) {
            int n3 = doubleIntIndex.peekKey();
            int n4 = doubleIntIndex.peekValue();
            doubleIntIndex.pop();
            if (n4 - n3 < n2) continue;
            int n5 = this.partition(n3, n4);
            doubleIntIndex.push(n3, n5 - 1);
            doubleIntIndex.push(n5 + 1, n4);
        }
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private int partition(int n2, int n3) {
        int n4 = n2 + n3 >>> 1;
        if (this.keys[n4] < this.keys[n2 + n4 >>> 1]) {
            this.swap(n4, n2 + n4 >>> 1);
        }
        if (this.keys[n3 + n4 >>> 1] < this.keys[n2 + n4 >>> 1]) {
            this.swap(n3 + n4 >>> 1, n2 + n4 >>> 1);
        }
        if (this.keys[n3 + n4 >>> 1] < this.keys[n4]) {
            this.swap(n3 + n4 >>> 1, n4);
        }
        int n5 = this.keys[n4];
        int n6 = n2 - 1;
        int n7 = n3;
        this.swap(n4, n3);
        while (true) {
            if (this.keys[++n6] < n5) {
                continue;
            }
            while (n5 < this.keys[--n7]) {
            }
            if (n7 < n6) break;
            this.swap(n6, n7);
        }
        this.swap(n6, n3);
        return n6;
    }

    private void fastQuickSortRecursive() {
        this.quickSort(0, this.count - 1);
        this.insertionSort(0, this.count - 1);
        this.sorted = true;
    }

    private void quickSort(int n2, int n3) {
        int n4 = 16;
        if (n3 - n2 > n4) {
            int n5 = n3 + n2 >>> 1;
            if (this.lessThan(n5, n2)) {
                this.swap(n2, n5);
            }
            if (this.lessThan(n3, n2)) {
                this.swap(n2, n3);
            }
            if (this.lessThan(n3, n5)) {
                this.swap(n5, n3);
            }
            int n6 = n3 - 1;
            this.swap(n5, n6);
            n5 = n2;
            int n7 = n6;
            while (true) {
                if (this.lessThan(++n5, n7)) {
                    continue;
                }
                while (this.lessThan(n7, --n6)) {
                }
                if (n6 < n5) break;
                this.swap(n5, n6);
            }
            this.swap(n5, n3 - 1);
            this.quickSort(n2, n6);
            this.quickSort(n5 + 1, n3);
        }
    }

    private void insertionSort(int n2, int n3) {
        for (int i2 = n2 + 1; i2 <= n3; ++i2) {
            int n4;
            for (n4 = i2; n4 > n2 && this.lessThan(i2, n4 - 1); --n4) {
            }
            if (i2 == n4) continue;
            this.moveAndInsertRow(i2, n4);
        }
    }

    protected void moveAndInsertRow(int n2, int n3) {
        int n4 = this.keys[n2];
        int n5 = this.values[n2];
        this.moveRows(n3, n3 + 1, n2 - n3);
        this.keys[n3] = n4;
        this.values[n3] = n5;
    }

    protected void swap(int n2, int n3) {
        int n4 = this.keys[n2];
        int n5 = this.values[n2];
        this.keys[n2] = this.keys[n3];
        this.values[n2] = this.values[n3];
        this.keys[n3] = n4;
        this.values[n3] = n5;
    }

    protected int compare(int n2) {
        if (this.sortOnValues) {
            if (this.targetSearchValue > this.values[n2]) {
                return 1;
            }
            if (this.targetSearchValue < this.values[n2]) {
                return -1;
            }
            return 0;
        }
        if (this.targetSearchValue > this.keys[n2]) {
            return 1;
        }
        if (this.targetSearchValue < this.keys[n2]) {
            return -1;
        }
        return 0;
    }

    protected boolean lessThan(int n2, int n3) {
        if (this.sortOnValues) {
            if (this.values[n2] < this.values[n3]) {
                return true;
            }
            if (this.values[n2] > this.values[n3]) {
                return false;
            }
        }
        return this.keys[n2] < this.keys[n3];
    }

    protected void moveRows(int n2, int n3, int n4) {
        System.arraycopy(this.keys, n2, this.keys, n3, n4);
        System.arraycopy(this.values, n2, this.values, n3, n4);
    }

    protected void doubleCapacity() {
        this.keys = (int[])ArrayUtil.resizeArray(this.keys, this.capacity * 2);
        this.values = (int[])ArrayUtil.resizeArray(this.values, this.capacity * 2);
        this.capacity *= 2;
    }

    public void removeRange(int n2, int n3) {
        ArrayUtil.adjustArray(73, this.keys, this.count, n2, n2 - n3);
        ArrayUtil.adjustArray(73, this.values, this.count, n2, n2 - n3);
        this.count -= n3 - n2;
    }

    public void removeAll() {
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, 0);
        this.count = 0;
        this.sorted = true;
    }

    public void copyTo(DoubleIntIndex doubleIntIndex) {
        System.arraycopy(this.keys, 0, doubleIntIndex.keys, 0, this.count);
        System.arraycopy(this.values, 0, doubleIntIndex.values, 0, this.count);
        doubleIntIndex.setSize(this.count);
        doubleIntIndex.sorted = false;
    }

    public final void remove(int n2) {
        this.moveRows(n2 + 1, n2, this.count - n2 - 1);
        --this.count;
        this.keys[this.count] = 0;
        this.values[this.count] = 0;
    }

    int peekKey() {
        return this.getKey(this.count - 1);
    }

    int peekValue() {
        return this.getValue(this.count - 1);
    }

    boolean pop() {
        if (this.count > 0) {
            --this.count;
            return true;
        }
        return false;
    }

    boolean push(int n2, int n3) {
        return this.addUnsorted(n2, n3);
    }
}

