/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.Writer;
import java.sql.Blob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hsqldb.jdbc.JDBCBlob;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.CountdownInputStream;
import org.hsqldb.lib.FileUtil;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.InOutUtil;
import org.hsqldb.lib.KMPSearchAlgorithm;

public class JDBCBlobFile
implements Blob {
    private static final FrameworkLogger LOG = FrameworkLogger.getLog(JDBCBlobFile.class);
    public static final String TEMP_FILE_PREFIX = "hsql_jdbc_blob_file_";
    public static final String TEMP_FILE_SUFFIX = ".tmp";
    private final File m_file;
    private boolean m_closed;
    private boolean m_deleteOnFree;
    private List<Object> m_streams = new ArrayList<Object>();

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        try {
            return this.m_file.length();
        }
        catch (SecurityException securityException) {
            throw JDBCUtil.sqlException(securityException);
        }
    }

    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        InputStream inputStream = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n3 = Math.min(8192, n2);
        try {
            inputStream = this.getBinaryStream(l2, n2);
            byteArrayOutputStream = new ByteArrayOutputStream(n3);
            InOutUtil.copy(inputStream, byteArrayOutputStream, (long)n2);
        }
        catch (IOException iOException) {
            try {
                throw JDBCUtil.sqlException(iOException);
            }
            catch (Throwable throwable) {
                JDBCBlobFile.closeSafely(inputStream);
                throw throwable;
            }
        }
        JDBCBlobFile.closeSafely(inputStream);
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return this.getBinaryStream(1L, Long.MAX_VALUE);
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (byArray == null || byArray.length == 0) {
            return -1L;
        }
        long l3 = this.length();
        if (l2 > l3 || (long)byArray.length > l3 || l2 > l3 - (long)byArray.length) {
            return -1L;
        }
        return this.position0(byArray, l2);
    }

    private long position0(byte[] byArray, long l2) throws SQLException {
        long l3;
        InputStream inputStream = null;
        try {
            inputStream = this.getBinaryStream(l2, Long.MAX_VALUE);
            long l4 = KMPSearchAlgorithm.search(inputStream, byArray, KMPSearchAlgorithm.computeTable(byArray));
            l3 = l4 == -1L ? -1L : l2 + l4;
        }
        catch (IOException iOException) {
            try {
                throw JDBCUtil.sqlException(iOException);
            }
            catch (Throwable throwable) {
                JDBCBlobFile.closeSafely(inputStream);
                throw throwable;
            }
        }
        JDBCBlobFile.closeSafely(inputStream);
        return l3;
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (blob == null) {
            return -1L;
        }
        long l3 = blob.length();
        if (l3 == 0L) {
            return -1L;
        }
        if (l3 > Integer.MAX_VALUE) {
            throw JDBCUtil.outOfRangeArgument("pattern.length(): " + l3);
        }
        long l4 = this.length();
        if (l2 > l4 || l3 > l4 || l2 > l4 - l3) {
            return -1L;
        }
        byte[] byArray = blob instanceof JDBCBlob ? ((JDBCBlob)blob).data() : blob.getBytes(1L, (int)l3);
        return this.position0(byArray, l2);
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        return this.setBytes(l2, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        if (byArray == null) {
            throw JDBCUtil.nullArgument("bytes");
        }
        OutputStream outputStream = this.setBinaryStream(l2);
        try {
            outputStream.write(byArray, n2, n3);
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        finally {
            JDBCBlobFile.closeSafely(outputStream);
        }
        return n3;
    }

    @Override
    public OutputStream setBinaryStream(long l2) throws SQLException {
        OutputStreamAdapter outputStreamAdapter;
        if (l2 < 1L) {
            throw JDBCUtil.invalidArgument("pos: " + l2);
        }
        this.checkClosed();
        this.createFile();
        try {
            outputStreamAdapter = new OutputStreamAdapter(this.m_file, l2 - 1L){
                private boolean closed;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public synchronized void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw JDBCUtil.sqlException(illegalArgumentException);
        }
        catch (SecurityException securityException) {
            throw JDBCUtil.sqlException(securityException);
        }
        this.m_streams.add(outputStreamAdapter);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStreamAdapter);
        return bufferedOutputStream;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void truncate(long l2) throws SQLException {
        if (l2 < 0L) {
            throw JDBCUtil.invalidArgument("len: " + l2);
        }
        this.checkClosed();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.m_file, "rw");
            randomAccessFile.setLength(l2);
        }
        catch (IOException iOException) {
            try {
                throw JDBCUtil.sqlException(iOException);
                catch (IllegalArgumentException illegalArgumentException) {
                    throw JDBCUtil.sqlException(illegalArgumentException);
                }
                catch (SecurityException securityException) {
                    throw JDBCUtil.sqlException(securityException);
                }
            }
            catch (Throwable throwable) {
                JDBCBlobFile.closeSafely(randomAccessFile);
                throw throwable;
            }
        }
        JDBCBlobFile.closeSafely(randomAccessFile);
    }

    @Override
    public synchronized void free() throws SQLException {
        if (this.m_closed) {
            return;
        }
        this.m_closed = true;
        ArrayList<Object> arrayList = new ArrayList<Object>(this.m_streams);
        this.m_streams = null;
        for (Object e2 : arrayList) {
            this.closeSafely(e2);
        }
        if (this.m_deleteOnFree) {
            try {
                this.m_file.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        InputStreamAdapter inputStreamAdapter;
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        this.checkClosed();
        try {
            inputStreamAdapter = new InputStreamAdapter(this.m_file, l2 - 1L, l3){
                private boolean closed;

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void close() throws IOException {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                    try {
                        super.close();
                    }
                    finally {
                        JDBCBlobFile.this.m_streams.remove(this);
                    }
                }
            };
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        this.m_streams.add(inputStreamAdapter);
        return inputStreamAdapter;
    }

    public File getFile() {
        return this.m_file;
    }

    public boolean isDeleteOnFree() {
        return this.m_deleteOnFree;
    }

    public void setDeleteOnFree(boolean bl) {
        this.m_deleteOnFree = bl;
    }

    public JDBCBlobFile() throws SQLException {
        this(true);
    }

    public JDBCBlobFile(boolean bl) throws SQLException {
        this.m_deleteOnFree = bl;
        try {
            this.m_file = File.createTempFile(TEMP_FILE_PREFIX, TEMP_FILE_SUFFIX).getCanonicalFile();
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
    }

    public JDBCBlobFile(File file) throws SQLException {
        this(file, false);
    }

    public JDBCBlobFile(File file, boolean bl) throws SQLException {
        this.m_deleteOnFree = bl;
        try {
            this.m_file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        this.checkIsFile(false);
    }

    protected final void checkIsFile(boolean bl) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = this.m_file.exists();
        }
        catch (Exception exception) {
            throw JDBCUtil.sqlException(exception);
        }
        if (bl2) {
            try {
                bl3 = this.m_file.isFile();
            }
            catch (Exception exception) {
                throw JDBCUtil.sqlException(exception);
            }
        }
        if (bl2) {
            if (!bl3) {
                throw JDBCUtil.invalidArgument("Is not a file: " + this.m_file);
            }
        } else if (bl) {
            throw JDBCUtil.invalidArgument("Does not exist: " + this.m_file);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    private void createFile() throws SQLException {
        try {
            if (!this.m_file.exists()) {
                FileUtil.getFileUtil().makeParentDirectories(this.m_file);
                this.m_file.createNewFile();
            }
        }
        catch (IOException iOException) {
            throw JDBCUtil.sqlException(iOException);
        }
        this.checkIsFile(true);
    }

    private static void closeSafely(RandomAccessFile randomAccessFile) {
        if (randomAccessFile != null) {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(Reader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private static void closeSafely(Writer writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                LOG.info(iOException.getMessage(), iOException);
            }
            catch (Throwable throwable) {
                LOG.info(throwable.getMessage(), throwable);
            }
        }
    }

    private void closeSafely(Object object) {
        if (object instanceof RandomAccessFile) {
            JDBCBlobFile.closeSafely((RandomAccessFile)object);
        } else if (object instanceof InputStream) {
            JDBCBlobFile.closeSafely((InputStream)object);
        } else if (object instanceof OutputStream) {
            JDBCBlobFile.closeSafely((OutputStream)object);
        } else if (object instanceof Reader) {
            JDBCBlobFile.closeSafely((Reader)object);
        } else if (object instanceof Writer) {
            JDBCBlobFile.closeSafely((Writer)object);
        }
    }

    static class InputStreamAdapter
    extends InputStream {
        private final CountdownInputStream m_ciStream;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        InputStreamAdapter(File file, long l2, long l3) throws FileNotFoundException, IOException, SecurityException, NullPointerException, IllegalArgumentException {
            if (file == null) {
                throw new NullPointerException("file");
            }
            if (l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            if (l3 < 0L) {
                throw new IllegalArgumentException("length: " + l3);
            }
            FileInputStream fileInputStream = null;
            boolean bl = false;
            try {
                fileInputStream = new FileInputStream(file);
                if (l2 > 0L) {
                    long l4 = fileInputStream.skip(l2);
                }
                bl = true;
            }
            finally {
                if (!bl) {
                    JDBCBlobFile.closeSafely(fileInputStream);
                }
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            CountdownInputStream countdownInputStream = new CountdownInputStream(bufferedInputStream);
            countdownInputStream.setCount(l3);
            this.m_ciStream = countdownInputStream;
        }

        @Override
        public int available() throws IOException {
            return this.m_ciStream.available();
        }

        @Override
        public int read() throws IOException {
            return this.m_ciStream.read();
        }

        @Override
        public int read(byte[] byArray) throws IOException {
            return this.m_ciStream.read(byArray);
        }

        @Override
        public int read(byte[] byArray, int n2, int n3) throws IOException {
            return this.m_ciStream.read(byArray, n2, n3);
        }

        @Override
        public long skip(long l2) throws IOException {
            return this.m_ciStream.skip(l2);
        }

        @Override
        public void close() throws IOException {
            this.m_ciStream.close();
        }
    }

    protected static class OutputStreamAdapter
    extends OutputStream {
        private final RandomAccessFile m_randomAccessFile;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected OutputStreamAdapter(File file, long l2) throws FileNotFoundException, IOException, IllegalArgumentException, NullPointerException, SecurityException {
            if (l2 < 0L) {
                throw new IllegalArgumentException("pos: " + l2);
            }
            this.m_randomAccessFile = new RandomAccessFile(file, "rw");
            boolean bl = false;
            try {
                this.m_randomAccessFile.seek(l2);
                bl = true;
            }
            finally {
                if (!bl) {
                    JDBCBlobFile.closeSafely(this.m_randomAccessFile);
                }
            }
        }

        protected OutputStreamAdapter(RandomAccessFile randomAccessFile) {
            if (randomAccessFile == null) {
                throw new NullPointerException();
            }
            this.m_randomAccessFile = randomAccessFile;
        }

        @Override
        public void write(int n2) throws IOException {
            this.m_randomAccessFile.write(n2);
        }

        @Override
        public void write(byte[] byArray) throws IOException {
            this.m_randomAccessFile.write(byArray);
        }

        @Override
        public void write(byte[] byArray, int n2, int n3) throws IOException {
            this.m_randomAccessFile.write(byArray, n2, n3);
        }

        @Override
        public void flush() throws IOException {
            if (this.m_randomAccessFile.getFD().valid()) {
                this.m_randomAccessFile.getFD().sync();
            }
        }

        @Override
        public void close() throws IOException {
            this.m_randomAccessFile.close();
        }
    }
}

