/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.lib.KMPSearchAlgorithm;
import org.hsqldb.lib.java.JavaSystem;

public class JDBCBlob
implements Blob {
    private static final long MIN_POS = 1L;
    private static final long MAX_POS = 0x80000000L;
    private static final byte[] NO_BYTES = new byte[0];
    private boolean m_closed;
    private byte[] m_data;
    private final boolean m_createdByConnection;

    @Override
    public long length() throws SQLException {
        return this.getData().length;
    }

    @Override
    public byte[] getBytes(long l2, int n2) throws SQLException {
        byte[] byArray = this.getData();
        int n3 = byArray.length;
        if (l2 < 1L || l2 - 1L > (long)n3) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        int n4 = (int)l2 - 1;
        if (n2 < 0 || n2 > n3 - n4) {
            throw JDBCUtil.outOfRangeArgument("length: " + n2);
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n4, byArray2, 0, n2);
        return byArray2;
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        return new ByteArrayInputStream(this.getData());
    }

    @Override
    public long position(byte[] byArray, long l2) throws SQLException {
        byte[] byArray2 = this.getData();
        int n2 = byArray2.length;
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (l2 > (long)n2 || byArray == null) {
            return -1L;
        }
        int n3 = (int)l2 - 1;
        int n4 = byArray.length;
        if (n4 == 0 || n3 > n2 - n4) {
            return -1L;
        }
        int n5 = KMPSearchAlgorithm.search(byArray2, byArray, KMPSearchAlgorithm.computeTable(byArray), n3);
        return n5 == -1 ? -1L : (long)(n5 + 1);
    }

    @Override
    public long position(Blob blob, long l2) throws SQLException {
        byte[] byArray = this.getData();
        int n2 = byArray.length;
        if (l2 < 1L) {
            throw JDBCUtil.outOfRangeArgument("start: " + l2);
        }
        if (l2 > (long)n2 || blob == null) {
            return -1L;
        }
        int n3 = (int)(l2 - 1L);
        long l3 = blob.length();
        if (l3 == 0L || (long)n3 > (long)n2 - l3) {
            return -1L;
        }
        int n4 = (int)l3;
        byte[] byArray2 = blob instanceof JDBCBlob ? ((JDBCBlob)blob).data() : blob.getBytes(1L, n4);
        int n5 = KMPSearchAlgorithm.search(byArray, byArray2, KMPSearchAlgorithm.computeTable(byArray2), n3);
        return n5 == -1 ? -1L : (long)(n5 + 1);
    }

    @Override
    public int setBytes(long l2, byte[] byArray) throws SQLException {
        return this.setBytes(l2, byArray, 0, byArray == null ? 0 : byArray.length);
    }

    @Override
    public int setBytes(long l2, byte[] byArray, int n2, int n3) throws SQLException {
        this.checkReadonly();
        if (byArray == null) {
            throw JDBCUtil.nullArgument("bytes");
        }
        if (n2 < 0 || n2 > byArray.length) {
            throw JDBCUtil.outOfRangeArgument("offset: " + n2);
        }
        if (n3 > byArray.length - n2) {
            throw JDBCUtil.outOfRangeArgument("len: " + n3);
        }
        if (l2 < 1L || l2 - 1L > (long)(Integer.MAX_VALUE - n3)) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        int n4 = (int)(l2 - 1L);
        byte[] byArray2 = this.getData();
        int n5 = byArray2.length;
        if (n4 > n5 - n3) {
            byte[] byArray3 = new byte[n4 + n3];
            System.arraycopy(byArray2, 0, byArray3, 0, n5);
            byArray2 = byArray3;
            byArray3 = null;
        }
        System.arraycopy(byArray, n2, byArray2, n4, n3);
        this.setData(byArray2);
        return n3;
    }

    @Override
    public OutputStream setBinaryStream(final long l2) throws SQLException {
        this.checkReadonly();
        if (l2 < 1L || l2 > 0x80000000L) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        this.checkClosed();
        return new ByteArrayOutputStream(){
            private boolean closed;

            @Override
            public synchronized void close() throws IOException {
                if (this.closed) {
                    return;
                }
                this.closed = true;
                byte[] byArray = this.buf;
                int n2 = this.count;
                this.buf = NO_BYTES;
                this.count = 0;
                try {
                    JDBCBlob.this.setBytes(l2, byArray, 0, n2);
                }
                catch (SQLException sQLException) {
                    throw JavaSystem.toIOException(sQLException);
                }
                finally {
                    super.close();
                }
            }
        };
    }

    @Override
    public void truncate(long l2) throws SQLException {
        this.checkReadonly();
        byte[] byArray = this.getData();
        if (l2 < 0L || l2 > (long)byArray.length) {
            throw JDBCUtil.outOfRangeArgument("len: " + l2);
        }
        if (l2 == (long)byArray.length) {
            return;
        }
        byte[] byArray2 = new byte[(int)l2];
        System.arraycopy(byArray, 0, byArray2, 0, (int)l2);
        this.setData(byArray2);
    }

    @Override
    public synchronized void free() throws SQLException {
        this.m_closed = true;
        this.m_data = null;
    }

    @Override
    public InputStream getBinaryStream(long l2, long l3) throws SQLException {
        byte[] byArray = this.getData();
        int n2 = byArray.length;
        if (l2 < 1L || l2 > (long)n2) {
            throw JDBCUtil.outOfRangeArgument("pos: " + l2);
        }
        int n3 = (int)(l2 - 1L);
        if (l3 < 0L || l3 > (long)(n2 - n3)) {
            throw JDBCUtil.outOfRangeArgument("length: " + l3);
        }
        if (n3 == 0 && l3 == (long)n2) {
            return new ByteArrayInputStream(byArray);
        }
        int n4 = (int)l3;
        byte[] byArray2 = new byte[n4];
        System.arraycopy(byArray, n3, byArray2, 0, n4);
        return new ByteArrayInputStream(byArray2);
    }

    public JDBCBlob(byte[] byArray) throws SQLException {
        if (byArray == null) {
            throw JDBCUtil.nullArgument("data");
        }
        this.m_data = byArray;
        this.m_createdByConnection = false;
    }

    protected JDBCBlob() {
        this.m_data = new byte[0];
        this.m_createdByConnection = true;
    }

    protected void checkReadonly() throws SQLException {
        if (!this.m_createdByConnection) {
            throw JDBCUtil.sqlException(3706, "Blob is read-only");
        }
    }

    protected synchronized void checkClosed() throws SQLException {
        if (this.m_closed) {
            throw JDBCUtil.sqlException(1251);
        }
    }

    protected byte[] data() throws SQLException {
        return this.getData();
    }

    private synchronized byte[] getData() throws SQLException {
        this.checkClosed();
        return this.m_data;
    }

    private synchronized void setData(byte[] byArray) throws SQLException {
        this.checkClosed();
        this.m_data = byArray;
    }
}

