/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.index;

import org.hsqldb.Constraint;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.RangeVariable;
import org.hsqldb.Row;
import org.hsqldb.RowAVL;
import org.hsqldb.SchemaObject;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.index.Index;
import org.hsqldb.index.NodeAVL;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.navigator.RangeIterator;
import org.hsqldb.navigator.RowIterator;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.rights.Grantee;
import org.hsqldb.types.DateTimeType;
import org.hsqldb.types.TimestampData;
import org.hsqldb.types.Type;

public class IndexAVL
implements Index {
    private final long persistenceId;
    protected final HsqlNameManager.HsqlName name;
    private final boolean[] colCheck;
    final int[] colIndex;
    private final int[] defaultColMap;
    final Type[] colTypes;
    private final boolean[] colDesc;
    private final boolean[] nullsLast;
    final boolean isSimpleOrder;
    final boolean isSimple;
    protected final boolean isPK;
    protected final boolean isUnique;
    protected final boolean isConstraint;
    private final boolean isForward;
    private boolean isClustered;
    protected TableBase table;
    int position;
    private Index.IndexUse[] asArray;
    Object[] nullData;

    public IndexAVL(HsqlNameManager.HsqlName hsqlName, long l2, TableBase tableBase, int[] nArray, boolean[] blArray, boolean[] blArray2, Type[] typeArray, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.persistenceId = l2;
        this.name = hsqlName;
        this.colIndex = nArray;
        this.colTypes = typeArray;
        this.colDesc = blArray == null ? new boolean[nArray.length] : blArray;
        this.nullsLast = blArray2 == null ? new boolean[nArray.length] : blArray2;
        this.isPK = bl;
        this.isUnique = bl2;
        this.isConstraint = bl3;
        this.isForward = bl4;
        this.table = tableBase;
        this.colCheck = tableBase.getNewColumnCheckList();
        this.asArray = new Index.IndexUse[]{new Index.IndexUse(this, this.colIndex.length)};
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
        this.defaultColMap = new int[nArray.length];
        ArrayUtil.fillSequence(this.defaultColMap);
        boolean bl5 = this.colIndex.length > 0;
        for (int i2 = 0; i2 < this.colDesc.length; ++i2) {
            if (!this.colDesc[i2] && !this.nullsLast[i2]) continue;
            bl5 = false;
        }
        this.isSimpleOrder = bl5;
        this.isSimple = this.isSimpleOrder && this.colIndex.length == 1;
        this.nullData = new Object[this.colIndex.length];
    }

    @Override
    public int getType() {
        return 20;
    }

    @Override
    public HsqlNameManager.HsqlName getName() {
        return this.name;
    }

    @Override
    public HsqlNameManager.HsqlName getSchemaName() {
        return this.name.schema;
    }

    @Override
    public HsqlNameManager.HsqlName getCatalogName() {
        return this.name.schema.schema;
    }

    @Override
    public Grantee getOwner() {
        return this.name.schema.owner;
    }

    @Override
    public OrderedHashSet getReferences() {
        return new OrderedHashSet();
    }

    @Override
    public OrderedHashSet getComponents() {
        return null;
    }

    @Override
    public void compile(Session session, SchemaObject schemaObject) {
    }

    @Override
    public String getSQL() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("CREATE").append(' ');
        if (this.isUnique()) {
            stringBuilder.append("UNIQUE").append(' ');
        }
        stringBuilder.append("INDEX").append(' ');
        stringBuilder.append(this.getName().statementName);
        stringBuilder.append(' ').append("ON").append(' ');
        stringBuilder.append(((Table)this.table).getName().getSchemaQualifiedStatementName());
        stringBuilder.append(((Table)this.table).getColumnListSQL(this.colIndex, this.colIndex.length));
        return stringBuilder.toString();
    }

    @Override
    public long getChangeTimestamp() {
        return 0L;
    }

    @Override
    public Index.IndexUse[] asArray() {
        return this.asArray;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int n2) {
        this.position = n2;
    }

    @Override
    public long getPersistenceId() {
        return this.persistenceId;
    }

    @Override
    public int getColumnCount() {
        return this.colIndex.length;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPK;
    }

    @Override
    public boolean isUnique() {
        return this.isUnique;
    }

    @Override
    public boolean isConstraint() {
        return this.isConstraint;
    }

    @Override
    public int[] getColumns() {
        return this.colIndex;
    }

    @Override
    public Type[] getColumnTypes() {
        return this.colTypes;
    }

    @Override
    public boolean[] getColumnDesc() {
        return this.colDesc;
    }

    @Override
    public int[] getDefaultColumnMap() {
        return this.defaultColMap;
    }

    @Override
    public int getIndexOrderValue() {
        if (this.isPK) {
            return 0;
        }
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    @Override
    public boolean isForward() {
        return this.isForward;
    }

    @Override
    public void setTable(TableBase tableBase) {
        this.table = tableBase;
    }

    @Override
    public TableBase getTable() {
        return this.table;
    }

    @Override
    public void setClustered(boolean bl) {
        this.isClustered = bl;
    }

    @Override
    public boolean isClustered() {
        return this.isClustered;
    }

    @Override
    public long size(Session session, PersistentStore persistentStore) {
        long l2 = 0L;
        RowIterator rowIterator = this.firstRow(session, persistentStore, null, 0, null);
        while (rowIterator.next()) {
            ++l2;
        }
        return l2;
    }

    @Override
    public long sizeUnique(PersistentStore persistentStore) {
        return persistentStore.elementCountUnique(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double[] searchCost(Session session, PersistentStore persistentStore) {
        boolean bl = false;
        int n2 = 1;
        double[] dArray = new double[this.colIndex.length];
        int n3 = 0;
        int[] nArray = new int[1];
        persistentStore.readLock();
        try {
            int n4;
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            if (nodeAVL == null) {
                double[] dArray2 = dArray;
                return dArray2;
            }
            while ((nodeAVL2 = (nodeAVL = nodeAVL2).getLeft(persistentStore)) != null) {
                if (n3 == 4) {
                    bl = true;
                    break;
                }
                ++n3;
            }
            while (true) {
                nodeAVL2 = this.next(persistentStore, nodeAVL, n3, 4, nArray);
                n3 = nArray[0];
                if (nodeAVL2 == null) break;
                this.compareRowForChange(session, nodeAVL.getData(persistentStore), nodeAVL2.getData(persistentStore), dArray);
                nodeAVL = nodeAVL2;
                ++n2;
            }
            if (bl) {
                double[] dArray3 = new double[this.colIndex.length];
                int n5 = this.probeFactor(session, persistentStore, dArray3, true) + this.probeFactor(session, persistentStore, dArray3, false);
                for (n4 = 0; n4 < this.colIndex.length; ++n4) {
                    int n6 = n4;
                    dArray3[n6] = dArray3[n6] / 2.0;
                    int n7 = 0;
                    while ((double)n7 < dArray3[n4]) {
                        int n8 = n4;
                        dArray[n8] = dArray[n8] * 2.0;
                        ++n7;
                    }
                }
            }
            long l2 = persistentStore.elementCount();
            for (n4 = 0; n4 < this.colIndex.length; ++n4) {
                if (dArray[n4] == 0.0) {
                    dArray[n4] = 1.0;
                }
                dArray[n4] = (double)l2 / dArray[n4];
                if (!(dArray[n4] < 2.0)) continue;
                dArray[n4] = 2.0;
            }
            double[] dArray4 = dArray;
            return dArray4;
        }
        finally {
            persistentStore.readUnlock();
        }
    }

    int probeFactor(Session session, PersistentStore persistentStore, double[] dArray, boolean bl) {
        NodeAVL nodeAVL;
        int n2 = 0;
        NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
        if (nodeAVL == null) {
            return 0;
        }
        while (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            NodeAVL nodeAVL3 = nodeAVL2 = bl ? nodeAVL.getLeft(persistentStore) : nodeAVL.getRight(persistentStore);
            if (++n2 <= 4 || nodeAVL2 == null) continue;
            this.compareRowForChange(session, nodeAVL.getData(persistentStore), nodeAVL2.getData(persistentStore), dArray);
        }
        return n2 - 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty(PersistentStore persistentStore) {
        persistentStore.readLock();
        try {
            boolean bl = this.getAccessor(persistentStore) == null;
            return bl;
        }
        finally {
            persistentStore.readUnlock();
        }
    }

    public void unlinkNodes(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVL nodeAVL2;
        NodeAVL nodeAVL3 = nodeAVL2 = nodeAVL;
        while (nodeAVL3 != null) {
            nodeAVL2 = nodeAVL3;
            nodeAVL3 = nodeAVL2.getLeft(null);
        }
        while (nodeAVL2 != null) {
            NodeAVL nodeAVL4;
            nodeAVL2 = nodeAVL4 = this.nextUnlink(persistentStore, nodeAVL2);
        }
    }

    private NodeAVL nextUnlink(PersistentStore persistentStore, NodeAVL nodeAVL) {
        NodeAVL nodeAVL2 = nodeAVL.getRight(null);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            nodeAVL2 = nodeAVL.getLeft(null);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getLeft(null);
            }
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        for (nodeAVL = nodeAVL.getParent(null); nodeAVL != null && nodeAVL.isRight(persistentStore, nodeAVL2); nodeAVL = nodeAVL.getParent(null)) {
            nodeAVL.nRight = null;
            nodeAVL2.getRow(null).destroy();
            nodeAVL2.delete();
            nodeAVL2 = nodeAVL;
        }
        if (nodeAVL != null) {
            nodeAVL.nLeft = null;
        }
        nodeAVL2.getRow(null).destroy();
        nodeAVL2.delete();
        return nodeAVL;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray) {
        int n2 = nArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.colTypes[i2].compare(session, objectArray[this.colIndex[i2]], objectArray2[nArray[i2]]);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.colTypes[i2].compare(session, objectArray[this.colIndex[i2]], objectArray2[nArray[i2]]);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    @Override
    public int compareRowNonUnique(Session session, Object[] objectArray, Object[] objectArray2, int n2) {
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.colTypes[i2].compare(session, objectArray[this.colIndex[i2]], objectArray2[this.colIndex[i2]]);
            if (n3 == 0) continue;
            return n3;
        }
        return 0;
    }

    public void compareRowForChange(Session session, Object[] objectArray, Object[] objectArray2, double[] dArray) {
        int n2 = 0;
        for (int i2 = 0; i2 < this.colIndex.length; ++i2) {
            if (n2 == 0) {
                n2 = this.colTypes[i2].compare(session, objectArray[this.colIndex[i2]], objectArray2[this.colIndex[i2]]);
            }
            if (n2 == 0) continue;
            int n3 = i2;
            dArray[n3] = dArray[n3] + 1.0;
        }
    }

    @Override
    public int compareRow(Session session, Object[] objectArray, Object[] objectArray2) {
        for (int i2 = 0; i2 < this.colIndex.length; ++i2) {
            boolean bl;
            int n2 = this.colTypes[i2].compare(session, objectArray[this.colIndex[i2]], objectArray2[this.colIndex[i2]]);
            if (n2 == 0) continue;
            if (this.isSimpleOrder) {
                return n2;
            }
            boolean bl2 = bl = objectArray[this.colIndex[i2]] == null || objectArray2[this.colIndex[i2]] == null;
            if (this.colDesc[i2] && !bl) {
                n2 = -n2;
            }
            if (this.nullsLast[i2] && bl) {
                n2 = -n2;
            }
            return n2;
        }
        return 0;
    }

    int compareRowForInsertOrDelete(Session session, Row row, Row row2, boolean bl, int n2) {
        Object[] objectArray = row.getData();
        Object[] objectArray2 = row2.getData();
        for (int i2 = n2; i2 < this.colIndex.length; ++i2) {
            boolean bl2;
            int n3 = this.colTypes[i2].compare(session, objectArray[this.colIndex[i2]], objectArray2[this.colIndex[i2]]);
            if (n3 == 0) continue;
            if (this.isSimpleOrder) {
                return n3;
            }
            boolean bl3 = bl2 = objectArray[this.colIndex[i2]] == null || objectArray2[this.colIndex[i2]] == null;
            if (this.colDesc[i2] && !bl2) {
                n3 = -n3;
            }
            if (this.nullsLast[i2] && bl2) {
                n3 = -n3;
            }
            return n3;
        }
        if (n2 == 0 && this.table.isSystemVersioned) {
            TimestampData timestampData;
            TimestampData timestampData2 = row.getSystemEndVersion();
            int n4 = Type.SQL_TIMESTAMP_WITH_TIME_ZONE.compare(session, timestampData2, timestampData = row2.getSystemEndVersion());
            if (n4 == 0) {
                if (timestampData2.getSeconds() != DateTimeType.epochLimitSeconds) {
                    bl = true;
                }
            } else {
                return n4;
            }
        }
        if (bl) {
            long l2 = row.getPos() - row2.getPos();
            return l2 == 0L ? 0 : (l2 > 0L ? 1 : -1);
        }
        return 0;
    }

    int compareObject(Session session, Object[] objectArray, Object[] objectArray2, int[] nArray, int n2, int n3) {
        return this.colTypes[n2].compare(session, objectArray[this.colIndex[n2]], objectArray2[nArray[n2]], n3);
    }

    boolean hasNulls(Session session, Object[] objectArray) {
        boolean bl = session == null || session.database.sqlUniqueNulls;
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.colIndex.length; ++i2) {
            if (objectArray[this.colIndex[i2]] == null) {
                bl2 = true;
                if (!bl) continue;
                break;
            }
            if (bl) continue;
            bl2 = false;
            break;
        }
        return bl2;
    }

    @Override
    public void insert(Session session, PersistentStore persistentStore, Row row) {
        NodeAVL nodeAVL;
        boolean bl = true;
        int n2 = -1;
        boolean bl2 = !this.isUnique || this.hasNulls(session, row.getData());
        NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
        if (nodeAVL == null) {
            persistentStore.setAccessor((Index)this, ((RowAVL)row).getNode(this.position));
            return;
        }
        do {
            RowAVL rowAVL;
            if ((n2 = this.compareRowForInsertOrDelete(session, row, rowAVL = nodeAVL.getRow(persistentStore), bl2, 0)) == 0 && session != null && !bl2 && session.database.txManager.isMVRows() && !this.isEqualReadable(session, persistentStore, nodeAVL)) {
                bl2 = true;
                n2 = this.compareRowForInsertOrDelete(session, row, rowAVL, bl2, this.colIndex.length);
            }
            if (n2 != 0) continue;
            Constraint constraint = null;
            if (this.isConstraint) {
                constraint = ((Table)this.table).getUniqueConstraintForIndex(this);
            }
            if (constraint == null) {
                throw Error.error(104, this.name.statementName);
            }
            throw constraint.getException(row.getData());
        } while ((nodeAVL = (nodeAVL2 = nodeAVL).child(persistentStore, bl = n2 < 0)) != null);
        nodeAVL2 = nodeAVL2.set(persistentStore, bl, ((RowAVL)row).getNode(this.position));
        this.balance(persistentStore, nodeAVL2, bl);
    }

    @Override
    public void delete(Session session, PersistentStore persistentStore, Row row) {
        NodeAVL nodeAVL;
        NodeAVL nodeAVL2;
        int n2;
        NodeAVL nodeAVL3;
        NodeAVL nodeAVL4 = ((RowAVL)(row = (Row)persistentStore.get((CachedObject)row, false))).getNode(this.position);
        if (nodeAVL4 == null) {
            return;
        }
        if (nodeAVL4.getLeft(persistentStore) == null) {
            nodeAVL3 = nodeAVL4.getRight(persistentStore);
        } else if (nodeAVL4.getRight(persistentStore) == null) {
            nodeAVL3 = nodeAVL4.getLeft(persistentStore);
        } else {
            NodeAVL nodeAVL5;
            NodeAVL nodeAVL6 = nodeAVL4;
            nodeAVL4 = nodeAVL4.getLeft(persistentStore);
            while ((nodeAVL5 = nodeAVL4.getRight(persistentStore)) != null) {
                nodeAVL4 = nodeAVL5;
            }
            nodeAVL3 = nodeAVL4.getLeft(persistentStore);
            n2 = nodeAVL4.getBalance(persistentStore);
            nodeAVL4 = nodeAVL4.setBalance(persistentStore, nodeAVL6.getBalance(persistentStore));
            nodeAVL6 = nodeAVL6.setBalance(persistentStore, n2);
            nodeAVL2 = nodeAVL4.getParent(persistentStore);
            NodeAVL nodeAVL7 = nodeAVL6.getParent(persistentStore);
            if (nodeAVL6.isRoot(persistentStore)) {
                persistentStore.setAccessor((Index)this, nodeAVL4);
            }
            nodeAVL4 = nodeAVL4.setParent(persistentStore, nodeAVL7);
            if (nodeAVL7 != null) {
                nodeAVL7 = nodeAVL7.isRight(persistentStore, nodeAVL6) ? nodeAVL7.setRight(persistentStore, nodeAVL4) : nodeAVL7.setLeft(persistentStore, nodeAVL4);
            }
            if (nodeAVL6.equals(nodeAVL2)) {
                if ((nodeAVL6 = nodeAVL6.setParent(persistentStore, nodeAVL4)).isLeft(persistentStore, nodeAVL4)) {
                    nodeAVL4 = nodeAVL4.setLeft(persistentStore, nodeAVL6);
                    nodeAVL = nodeAVL6.getRight(persistentStore);
                    nodeAVL4 = nodeAVL4.setRight(persistentStore, nodeAVL);
                } else {
                    nodeAVL4 = nodeAVL4.setRight(persistentStore, nodeAVL6);
                    nodeAVL = nodeAVL6.getLeft(persistentStore);
                    nodeAVL4 = nodeAVL4.setLeft(persistentStore, nodeAVL);
                }
            } else {
                nodeAVL6 = nodeAVL6.setParent(persistentStore, nodeAVL2);
                nodeAVL2 = nodeAVL2.setRight(persistentStore, nodeAVL6);
                nodeAVL = nodeAVL6.getLeft(persistentStore);
                NodeAVL nodeAVL8 = nodeAVL6.getRight(persistentStore);
                nodeAVL4 = nodeAVL4.setLeft(persistentStore, nodeAVL);
                nodeAVL4 = nodeAVL4.setRight(persistentStore, nodeAVL8);
            }
            nodeAVL4.getRight(persistentStore).setParent(persistentStore, nodeAVL4);
            nodeAVL4.getLeft(persistentStore).setParent(persistentStore, nodeAVL4);
            nodeAVL6 = nodeAVL6.setLeft(persistentStore, nodeAVL3);
            if (nodeAVL3 != null) {
                nodeAVL3 = nodeAVL3.setParent(persistentStore, nodeAVL6);
            }
            nodeAVL4 = nodeAVL6 = nodeAVL6.setRight(persistentStore, null);
        }
        boolean bl = nodeAVL4.isFromLeft(persistentStore);
        nodeAVL4.replace(persistentStore, this, nodeAVL3);
        nodeAVL3 = nodeAVL4.getParent(persistentStore);
        nodeAVL4.delete();
        while (nodeAVL3 != null) {
            nodeAVL4 = nodeAVL3;
            n2 = bl ? 1 : -1;
            switch (nodeAVL4.getBalance(persistentStore) * n2) {
                case -1: {
                    nodeAVL4 = nodeAVL4.setBalance(persistentStore, 0);
                    break;
                }
                case 0: {
                    nodeAVL4 = nodeAVL4.setBalance(persistentStore, n2);
                    return;
                }
                case 1: {
                    nodeAVL2 = nodeAVL4.child(persistentStore, !bl);
                    int n3 = nodeAVL2.getBalance(persistentStore);
                    if (n3 * n2 >= 0) {
                        nodeAVL4.replace(persistentStore, this, nodeAVL2);
                        nodeAVL = nodeAVL2.child(persistentStore, bl);
                        nodeAVL4 = nodeAVL4.set(persistentStore, !bl, nodeAVL);
                        nodeAVL2 = nodeAVL2.set(persistentStore, bl, nodeAVL4);
                        if (n3 == 0) {
                            nodeAVL4 = nodeAVL4.setBalance(persistentStore, n2);
                            nodeAVL2 = nodeAVL2.setBalance(persistentStore, -n2);
                            return;
                        }
                        nodeAVL4 = nodeAVL4.setBalance(persistentStore, 0);
                        nodeAVL4 = nodeAVL2 = nodeAVL2.setBalance(persistentStore, 0);
                        break;
                    }
                    nodeAVL = nodeAVL2.child(persistentStore, bl);
                    nodeAVL4.replace(persistentStore, this, nodeAVL);
                    n3 = nodeAVL.getBalance(persistentStore);
                    nodeAVL2 = nodeAVL2.set(persistentStore, bl, nodeAVL.child(persistentStore, !bl));
                    nodeAVL = nodeAVL.set(persistentStore, !bl, nodeAVL2);
                    nodeAVL4 = nodeAVL4.set(persistentStore, !bl, nodeAVL.child(persistentStore, bl));
                    nodeAVL = nodeAVL.set(persistentStore, bl, nodeAVL4);
                    nodeAVL4 = nodeAVL4.setBalance(persistentStore, n3 == n2 ? -n2 : 0);
                    nodeAVL2 = nodeAVL2.setBalance(persistentStore, n3 == -n2 ? n2 : 0);
                    nodeAVL4 = nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                }
            }
            bl = nodeAVL4.isFromLeft(persistentStore);
            nodeAVL3 = nodeAVL4.getParent(persistentStore);
        }
    }

    @Override
    public boolean existsParent(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, nArray, nArray.length, 40, 2, false);
        return nodeAVL != null;
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore persistentStore, Object[] objectArray, int n2, int n3, int n4, boolean bl, boolean[] blArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, this.defaultColMap, n2, n4, 0, bl);
        if (nodeAVL == null) {
            return RangeIterator.emptyRowIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, n3, false, bl);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore persistentStore, Object[] objectArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, this.colIndex, this.colIndex.length, 40, 0, false);
        if (nodeAVL == null) {
            return RangeIterator.emptyRowIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
    }

    @Override
    public RowIterator findFirstRow(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, objectArray, nArray, nArray.length, 40, 0, false);
        if (nodeAVL == null) {
            return RangeIterator.emptyRowIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
    }

    @Override
    public RowIterator findFirstRowNotNull(Session session, PersistentStore persistentStore) {
        NodeAVL nodeAVL = this.findNode(session, persistentStore, this.nullData, this.defaultColMap, 1, 48, 0, false);
        if (nodeAVL == null) {
            return RangeIterator.emptyRowIterator;
        }
        return new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(Session session, PersistentStore persistentStore, RangeVariable.RangeVariableConditions[] rangeVariableConditionsArray, int n2, boolean[] blArray) {
        persistentStore.readLock();
        try {
            Object object;
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getLeft(persistentStore);
            }
            while (session != null && nodeAVL != null && !persistentStore.canRead(session, (CachedObject)(object = nodeAVL.getRow(persistentStore)), 0, null)) {
                nodeAVL = this.next(persistentStore, nodeAVL);
            }
            if (nodeAVL == null) {
                object = RangeIterator.emptyRowIterator;
                return object;
            }
            object = new IndexRowIterator(session, persistentStore, this, nodeAVL, n2, false, false);
            return object;
        }
        finally {
            persistentStore.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator firstRow(PersistentStore persistentStore) {
        persistentStore.readLock();
        try {
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getLeft(persistentStore);
            }
            if (nodeAVL == null) {
                RowIterator rowIterator = RangeIterator.emptyRowIterator;
                return rowIterator;
            }
            IndexRowIterator indexRowIterator = new IndexRowIterator(null, persistentStore, this, nodeAVL, 0, false, false);
            return indexRowIterator;
        }
        finally {
            persistentStore.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowIterator lastRow(Session session, PersistentStore persistentStore, int n2, boolean[] blArray) {
        persistentStore.readLock();
        try {
            Object object;
            NodeAVL nodeAVL;
            NodeAVL nodeAVL2 = nodeAVL = this.getAccessor(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getRight(persistentStore);
            }
            while (session != null && nodeAVL != null && !persistentStore.canRead(session, (CachedObject)(object = nodeAVL.getRow(persistentStore)), 0, null)) {
                nodeAVL = this.last(persistentStore, nodeAVL);
            }
            if (nodeAVL == null) {
                object = RangeIterator.emptyRowIterator;
                return object;
            }
            object = new IndexRowIterator(session, persistentStore, this, nodeAVL, n2, false, true);
            return object;
        }
        finally {
            persistentStore.readUnlock();
        }
    }

    NodeAVL next(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, int n2) {
        RowAVL rowAVL;
        if (nodeAVL == null) {
            return null;
        }
        if (n2 != 0) {
            return this.findDistinctNode(session, persistentStore, nodeAVL, n2, false);
        }
        do {
            if ((nodeAVL = this.next(persistentStore, nodeAVL)) == null) {
                return nodeAVL;
            }
            if (session != null) continue;
            return nodeAVL;
        } while (!persistentStore.canRead(session, rowAVL = nodeAVL.getRow(persistentStore), 0, null));
        return nodeAVL;
    }

    NodeAVL last(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, int n2) {
        RowAVL rowAVL;
        if (nodeAVL == null) {
            return null;
        }
        if (n2 != 0) {
            return this.findDistinctNode(session, persistentStore, nodeAVL, n2, true);
        }
        do {
            if ((nodeAVL = this.last(persistentStore, nodeAVL)) == null) {
                return nodeAVL;
            }
            if (session != null) continue;
            return nodeAVL;
        } while (!persistentStore.canRead(session, rowAVL = nodeAVL.getRow(persistentStore), 0, null));
        return nodeAVL;
    }

    NodeAVL next(PersistentStore persistentStore, NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return null;
        }
        RowAVL rowAVL = nodeAVL.getRow(persistentStore);
        NodeAVL nodeAVL2 = (nodeAVL = rowAVL.getNode(this.position)).getRight(persistentStore);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            nodeAVL2 = nodeAVL.getLeft(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getLeft(persistentStore);
            }
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        for (nodeAVL = nodeAVL.getParent(persistentStore); nodeAVL != null && nodeAVL.isRight(persistentStore, nodeAVL2); nodeAVL = nodeAVL.getParent(persistentStore)) {
            nodeAVL2 = nodeAVL;
        }
        return nodeAVL;
    }

    NodeAVL next(PersistentStore persistentStore, NodeAVL nodeAVL, int n2, int n3, int[] nArray) {
        NodeAVL nodeAVL2;
        NodeAVL nodeAVL3 = nodeAVL2 = n2 == n3 ? null : nodeAVL.getRight(persistentStore);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            NodeAVL nodeAVL4 = nodeAVL2 = ++n2 == n3 ? null : nodeAVL.getLeft(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                if (++n2 == n3) {
                    nodeAVL2 = null;
                    continue;
                }
                nodeAVL2 = nodeAVL.getLeft(persistentStore);
            }
            nArray[0] = n2;
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        nodeAVL = nodeAVL.getParent(persistentStore);
        --n2;
        while (nodeAVL != null && nodeAVL.isRight(persistentStore, nodeAVL2)) {
            nodeAVL2 = nodeAVL;
            nodeAVL = nodeAVL.getParent(persistentStore);
            --n2;
        }
        nArray[0] = n2;
        return nodeAVL;
    }

    NodeAVL last(PersistentStore persistentStore, NodeAVL nodeAVL) {
        if (nodeAVL == null) {
            return null;
        }
        RowAVL rowAVL = nodeAVL.getRow(persistentStore);
        NodeAVL nodeAVL2 = (nodeAVL = rowAVL.getNode(this.position)).getLeft(persistentStore);
        if (nodeAVL2 != null) {
            nodeAVL = nodeAVL2;
            nodeAVL2 = nodeAVL.getRight(persistentStore);
            while (nodeAVL2 != null) {
                nodeAVL = nodeAVL2;
                nodeAVL2 = nodeAVL.getRight(persistentStore);
            }
            return nodeAVL;
        }
        nodeAVL2 = nodeAVL;
        for (nodeAVL = nodeAVL.getParent(persistentStore); nodeAVL != null && nodeAVL.isLeft(persistentStore, nodeAVL2); nodeAVL = nodeAVL.getParent(persistentStore)) {
            nodeAVL2 = nodeAVL;
        }
        return nodeAVL;
    }

    boolean isEqualReadable(Session session, PersistentStore persistentStore, NodeAVL nodeAVL) {
        Object[] objectArray;
        NodeAVL nodeAVL2 = nodeAVL;
        RowAVL rowAVL = nodeAVL.getRow(persistentStore);
        if (persistentStore.canRead(session, rowAVL, 1, null) && rowAVL.isCurrentSystemVersion()) {
            return true;
        }
        Object[] objectArray2 = nodeAVL.getData(persistentStore);
        while ((nodeAVL2 = this.last(persistentStore, nodeAVL2)) != null && this.compareRow(session, objectArray2, objectArray = nodeAVL2.getData(persistentStore)) == 0) {
            rowAVL = nodeAVL2.getRow(persistentStore);
            if (!persistentStore.canRead(session, rowAVL, 1, null) || !rowAVL.isCurrentSystemVersion()) continue;
            return true;
        }
        nodeAVL2 = nodeAVL;
        while ((nodeAVL2 = this.next(persistentStore, nodeAVL2)) != null && this.compareRow(session, objectArray2, objectArray = nodeAVL2.getData(persistentStore)) == 0) {
            rowAVL = nodeAVL2.getRow(persistentStore);
            if (!persistentStore.canRead(session, rowAVL, 1, null) || !rowAVL.isCurrentSystemVersion()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findNode(Session session, PersistentStore persistentStore, Object[] objectArray, int[] nArray, int n2, int n3, int n4, boolean bl) {
        persistentStore.readLock();
        try {
            NodeAVL nodeAVL = this.getAccessor(persistentStore);
            NodeAVL nodeAVL2 = null;
            NodeAVL nodeAVL3 = null;
            RowAVL rowAVL = null;
            if (n3 != 40 && n3 != 47) {
                --n2;
                if (n3 == 44 || n3 == 45 || n3 == 77) {
                    bl = true;
                }
            }
            while (nodeAVL != null) {
                block29: {
                    int n5;
                    block28: {
                        rowAVL = nodeAVL.getRow(persistentStore);
                        n5 = 0;
                        if (n2 > 0) {
                            n5 = this.compareRowNonUnique(session, rowAVL.getData(), objectArray, nArray, n2);
                        }
                        if (n5 != 0) break block28;
                        switch (n3) {
                            case 40: 
                            case 47: 
                            case 77: {
                                nodeAVL3 = nodeAVL;
                                nodeAVL2 = bl ? nodeAVL.getRight(persistentStore) : nodeAVL.getLeft(persistentStore);
                                break block29;
                            }
                            case 43: 
                            case 48: {
                                n5 = this.compareObject(session, rowAVL.getData(), objectArray, nArray, n2, n3);
                                if (n5 <= 0) {
                                    nodeAVL2 = nodeAVL.getRight(persistentStore);
                                } else {
                                    nodeAVL3 = nodeAVL;
                                    nodeAVL2 = nodeAVL.getLeft(persistentStore);
                                }
                                break block29;
                            }
                            case 41: 
                            case 42: {
                                n5 = this.compareObject(session, rowAVL.getData(), objectArray, nArray, n2, n3);
                                if (n5 < 0) {
                                    nodeAVL2 = nodeAVL.getRight(persistentStore);
                                } else {
                                    nodeAVL3 = nodeAVL;
                                    nodeAVL2 = nodeAVL.getLeft(persistentStore);
                                }
                                break block29;
                            }
                            case 44: {
                                n5 = this.compareObject(session, rowAVL.getData(), objectArray, nArray, n2, n3);
                                if (n5 < 0) {
                                    nodeAVL3 = nodeAVL;
                                    nodeAVL2 = nodeAVL.getRight(persistentStore);
                                } else {
                                    nodeAVL2 = nodeAVL.getLeft(persistentStore);
                                }
                                break block29;
                            }
                            case 45: {
                                n5 = this.compareObject(session, rowAVL.getData(), objectArray, nArray, n2, n3);
                                if (n5 <= 0) {
                                    nodeAVL3 = nodeAVL;
                                    nodeAVL2 = nodeAVL.getRight(persistentStore);
                                } else {
                                    nodeAVL2 = nodeAVL.getLeft(persistentStore);
                                }
                                break block29;
                            }
                            default: {
                                throw Error.runtimeError(201, "Index");
                            }
                        }
                    }
                    if (n5 < 0) {
                        nodeAVL2 = nodeAVL.getRight(persistentStore);
                    } else if (n5 > 0) {
                        nodeAVL2 = nodeAVL.getLeft(persistentStore);
                    }
                }
                if (nodeAVL2 == null) break;
                nodeAVL = nodeAVL2;
            }
            if (session == null) {
                NodeAVL nodeAVL4 = nodeAVL3;
                return nodeAVL4;
            }
            while (nodeAVL3 != null && !persistentStore.canRead(session, rowAVL = nodeAVL3.getRow(persistentStore), n4, this.colIndex)) {
                NodeAVL nodeAVL5 = nodeAVL3 = bl ? this.last(persistentStore, nodeAVL3) : this.next(persistentStore, nodeAVL3);
                if (nodeAVL3 == null) break;
                rowAVL = nodeAVL3.getRow(persistentStore);
                if (n2 <= 0 || this.compareRowNonUnique(session, rowAVL.getData(), objectArray, nArray, n2) == 0) continue;
                nodeAVL3 = null;
                break;
            }
            NodeAVL nodeAVL6 = nodeAVL3;
            return nodeAVL6;
        }
        finally {
            persistentStore.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NodeAVL findDistinctNode(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, int n2, boolean bl) {
        persistentStore.readLock();
        try {
            NodeAVL nodeAVL2 = this.getAccessor(persistentStore);
            NodeAVL nodeAVL3 = null;
            NodeAVL nodeAVL4 = null;
            RowAVL rowAVL = null;
            Object[] objectArray = nodeAVL.getData(persistentStore);
            while (nodeAVL2 != null) {
                rowAVL = nodeAVL2.getRow(persistentStore);
                int n3 = 0;
                n3 = this.compareRowNonUnique(session, rowAVL.getData(), objectArray, this.colIndex, n2);
                if (bl) {
                    if (n3 < 0) {
                        nodeAVL4 = nodeAVL2;
                        nodeAVL3 = nodeAVL2.getRight(persistentStore);
                    } else {
                        nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                    }
                } else if (n3 <= 0) {
                    nodeAVL3 = nodeAVL2.getRight(persistentStore);
                } else {
                    nodeAVL4 = nodeAVL2;
                    nodeAVL3 = nodeAVL2.getLeft(persistentStore);
                }
                if (nodeAVL3 == null) break;
                nodeAVL2 = nodeAVL3;
            }
            if (session == null) {
                NodeAVL nodeAVL5 = nodeAVL4;
                return nodeAVL5;
            }
            while (nodeAVL4 != null && !persistentStore.canRead(session, rowAVL = nodeAVL4.getRow(persistentStore), 0, this.colIndex)) {
                nodeAVL4 = bl ? this.last(persistentStore, nodeAVL4) : this.next(persistentStore, nodeAVL4);
            }
            NodeAVL nodeAVL6 = nodeAVL4;
            return nodeAVL6;
        }
        finally {
            persistentStore.readUnlock();
        }
    }

    void balance(PersistentStore persistentStore, NodeAVL nodeAVL, boolean bl) {
        while (true) {
            int n2 = bl ? 1 : -1;
            switch (nodeAVL.getBalance(persistentStore) * n2) {
                case 1: {
                    nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                    return;
                }
                case 0: {
                    nodeAVL = nodeAVL.setBalance(persistentStore, -n2);
                    break;
                }
                case -1: {
                    NodeAVL nodeAVL2 = nodeAVL.child(persistentStore, bl);
                    if (nodeAVL2.getBalance(persistentStore) == -n2) {
                        nodeAVL.replace(persistentStore, this, nodeAVL2);
                        nodeAVL = nodeAVL.set(persistentStore, bl, nodeAVL2.child(persistentStore, !bl));
                        nodeAVL2 = nodeAVL2.set(persistentStore, !bl, nodeAVL);
                        nodeAVL = nodeAVL.setBalance(persistentStore, 0);
                        nodeAVL2 = nodeAVL2.setBalance(persistentStore, 0);
                    } else {
                        NodeAVL nodeAVL3 = nodeAVL2.child(persistentStore, !bl);
                        nodeAVL.replace(persistentStore, this, nodeAVL3);
                        nodeAVL2 = nodeAVL2.set(persistentStore, !bl, nodeAVL3.child(persistentStore, bl));
                        nodeAVL3 = nodeAVL3.set(persistentStore, bl, nodeAVL2);
                        nodeAVL = nodeAVL.set(persistentStore, bl, nodeAVL3.child(persistentStore, !bl));
                        nodeAVL3 = nodeAVL3.set(persistentStore, !bl, nodeAVL);
                        int n3 = nodeAVL3.getBalance(persistentStore);
                        nodeAVL = nodeAVL.setBalance(persistentStore, n3 == -n2 ? n2 : 0);
                        nodeAVL2 = nodeAVL2.setBalance(persistentStore, n3 == n2 ? -n2 : 0);
                        nodeAVL3 = nodeAVL3.setBalance(persistentStore, 0);
                    }
                    return;
                }
            }
            if (nodeAVL.isRoot(persistentStore)) {
                return;
            }
            bl = nodeAVL.isFromLeft(persistentStore);
            nodeAVL = nodeAVL.getParent(persistentStore);
        }
    }

    NodeAVL getAccessor(PersistentStore persistentStore) {
        NodeAVL nodeAVL = (NodeAVL)persistentStore.getAccessor(this);
        return nodeAVL;
    }

    RowIterator getIterator(Session session, PersistentStore persistentStore, NodeAVL nodeAVL, boolean bl, boolean bl2) {
        if (nodeAVL == null) {
            return RangeIterator.emptyRowIterator;
        }
        IndexRowIterator indexRowIterator = new IndexRowIterator(session, persistentStore, this, nodeAVL, 0, bl, bl2);
        return indexRowIterator;
    }

    public static final class IndexRowIterator
    implements RowIterator {
        final Session session;
        final PersistentStore store;
        final IndexAVL index;
        NodeAVL nextnode;
        Row lastrow;
        int distinctCount;
        boolean single;
        boolean reversed;

        public IndexRowIterator(Session session, PersistentStore persistentStore, IndexAVL indexAVL, NodeAVL nodeAVL, int n2, boolean bl, boolean bl2) {
            this.session = session;
            this.store = persistentStore;
            this.index = indexAVL;
            this.distinctCount = n2;
            this.single = bl;
            this.reversed = bl2;
            if (indexAVL == null) {
                return;
            }
            this.nextnode = nodeAVL;
        }

        @Override
        public Object getField(int n2) {
            if (this.lastrow == null) {
                return null;
            }
            return this.lastrow.getData()[n2];
        }

        @Override
        public boolean next() {
            this.getNextRow();
            return this.lastrow != null;
        }

        @Override
        public Row getCurrentRow() {
            return this.lastrow;
        }

        @Override
        public Object[] getCurrent() {
            if (this.lastrow == null) {
                return null;
            }
            return this.lastrow.getData();
        }

        /*
         * Exception decompiling
         */
        private Row getNextRow() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[DOLOOP]], but top level block is 5[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public void removeCurrent() {
            this.store.delete(this.session, this.lastrow);
            this.store.remove(this.lastrow);
        }

        @Override
        public void release() {
        }

        @Override
        public long getRowId() {
            return this.lastrow.getPos();
        }
    }
}

